/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedList;

public class FileGatheringVisitor
implements FileVisitor<Path> {
    private final LinkedList<File> files = new LinkedList();
    private final String suffix;

    public FileGatheringVisitor(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        if (Files.isRegularFile(file, new LinkOption[0]) && (this.suffix == null || file.toString().endsWith(this.suffix))) {
            this.files.add(file.toFile());
        }
        return FileVisitResult.CONTINUE;
    }

    public static LinkedList<File> getSortedFiles(String dirPath) throws IOException {
        return FileGatheringVisitor.getSortedFiles(dirPath, null);
    }

    public static LinkedList<File> getSortedFiles(String dirPath, String suffix) throws IOException {
        FileGatheringVisitor visitor = new FileGatheringVisitor(suffix);
        Files.walkFileTree(Paths.get(dirPath, new String[0]), visitor);
        LinkedList<File> files = visitor.files;
        Collections.sort(files);
        return files;
    }
}

