/*
 * Decompiled with CFR 0.152.
 */
package io.rivulet;

import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import io.rivulet.org.apache.http.Header;
import io.rivulet.org.apache.http.HttpEntity;
import io.rivulet.org.apache.http.HttpException;
import io.rivulet.org.apache.http.HttpMessage;
import io.rivulet.org.apache.http.HttpRequest;
import io.rivulet.org.apache.http.HttpResponse;
import io.rivulet.org.apache.http.client.entity.DeflateDecompressingEntity;
import io.rivulet.org.apache.http.client.entity.GzipDecompressingEntity;
import io.rivulet.org.apache.http.entity.ContentType;
import io.rivulet.org.apache.http.entity.InputStreamEntity;
import io.rivulet.org.apache.http.impl.entity.StrictContentLengthStrategy;
import io.rivulet.org.apache.http.impl.io.AbstractMessageParser;
import io.rivulet.org.apache.http.impl.io.ChunkedInputStream;
import io.rivulet.org.apache.http.impl.io.ContentLengthInputStream;
import io.rivulet.org.apache.http.impl.io.DefaultHttpRequestParser;
import io.rivulet.org.apache.http.impl.io.DefaultHttpResponseParser;
import io.rivulet.org.apache.http.impl.io.HttpTransportMetricsImpl;
import io.rivulet.org.apache.http.impl.io.IdentityInputStream;
import io.rivulet.org.apache.http.impl.io.SessionInputBufferImpl;
import io.rivulet.org.apache.http.util.EntityUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class BufferedHttpMessageParser<T extends HttpMessage> {
    private static final byte[] CRLF = new byte[]{13, 10};
    private HttpPhase currentPhase;
    private ByteArrayOutputStream byteStream;
    private boolean storedCR;
    private int entityBytesRead = 0;
    private final AbstractMessageParser<T> parser;
    private final SessionInputBufferImpl sessionBuffer;
    private T message;
    private ContentType contentType;
    private long contentLength;
    private ContentEncoding contentEncoding;
    private HttpEntity entity;
    private LinkedHashMap<String, String> trailers;
    private StringBuilder chunkSizeBuilder;
    private long currentChunkSize;
    private final SinglyLinkedList<ParsedMessage<T>> parsedMessageQueue;

    private BufferedHttpMessageParser(AbstractMessageParser<T> parser, SessionInputBufferImpl sessionBuffer) {
        this.parser = parser;
        this.sessionBuffer = sessionBuffer;
        this.parsedMessageQueue = new SinglyLinkedList();
        this.byteStream = new ByteArrayOutputStream();
        this.storedCR = false;
        this.reset();
    }

    private void reset() {
        this.currentPhase = HttpPhase.PRE_START_LINE;
        this.entityBytesRead = 0;
        this.sessionBuffer.clear();
        this.message = null;
        this.contentType = null;
        this.contentLength = 0L;
        this.contentEncoding = null;
        this.entity = null;
        this.trailers = null;
        this.chunkSizeBuilder = new StringBuilder();
        this.currentChunkSize = 0L;
    }

    public void appendBytes(ByteBuffer buffer) throws IOException, HttpException {
        this.appendBytes(buffer, 0, buffer.remaining());
    }

    public void appendBytes(ByteBuffer buffer, int offset, int len) throws IOException, HttpException {
        ByteBuffer shallowCopy = buffer.duplicate();
        byte[] arr = new byte[len];
        shallowCopy.get(arr, offset, len);
        this.appendBytes(arr);
    }

    public void appendBytes(byte[] bytes) throws IOException, HttpException {
        if (bytes.length > 0) {
            boolean trailingCR = bytes[bytes.length - 1] == CRLF[0];
            PushbackInputStream stream = new PushbackInputStream(new ByteArrayInputStream(bytes, 0, trailingCR ? bytes.length - 1 : bytes.length), bytes.length + 1);
            if (this.storedCR) {
                stream.unread(CRLF[0]);
            }
            this.storedCR = trailingCR;
            this.appendBytes(stream);
        }
    }

    private void appendBytes(PushbackInputStream stream) throws IOException, HttpException {
        while (stream.available() > 0) {
            switch (this.currentPhase) {
                case PRE_START_LINE: {
                    if (this.consumeEmptyLines(stream, false)) break;
                    this.currentPhase = HttpPhase.START_LINE;
                    break;
                }
                case START_LINE: 
                case HEADER: {
                    if (this.consumeNonEmpty(stream)) break;
                    this.currentPhase = HttpPhase.PRE_HEADER;
                    break;
                }
                case PRE_HEADER: {
                    if (!this.consumeEmptyLine(stream, true)) {
                        this.currentPhase = HttpPhase.HEADER;
                        break;
                    }
                    this.currentPhase = HttpPhase.PRE_MESSAGE_BODY;
                }
                case PRE_MESSAGE_BODY: {
                    this.parseMessage();
                    this.currentPhase = this.contentLength == -2L ? HttpPhase.CHUNK_SIZE : HttpPhase.IDENTITY_BODY;
                    this.entityBytesRead = 0;
                    if (this.currentPhase != HttpPhase.IDENTITY_BODY) break;
                }
                case IDENTITY_BODY: {
                    if ((long)this.entityBytesRead != this.contentLength && stream.available() > 0) {
                        this.byteStream.write(stream.read());
                        ++this.entityBytesRead;
                    }
                    if (stream.available() == 0 && this.storedCR && (long)(this.entityBytesRead + 1) == this.contentLength) {
                        this.byteStream.write(CRLF[0]);
                        this.storedCR = false;
                        ++this.entityBytesRead;
                    }
                    if ((long)this.entityBytesRead != this.contentLength) break;
                    this.parseEntity();
                    this.parsedMessageQueue.enqueue(new ParsedMessage<T>(this.message, this.entity, this.trailers));
                    this.reset();
                    break;
                }
                case CHUNK_SIZE: {
                    if (this.consumeEmptyLine(stream, true)) {
                        this.currentChunkSize = Long.parseLong(this.chunkSizeBuilder.toString(), 16);
                        this.chunkSizeBuilder = new StringBuilder();
                        this.currentPhase = HttpPhase.CHUNK_DATA;
                        break;
                    }
                    if (this.consumeSemicolon(stream)) {
                        this.currentChunkSize = Long.parseLong(this.chunkSizeBuilder.toString(), 16);
                        this.chunkSizeBuilder = new StringBuilder();
                        this.currentPhase = HttpPhase.CHUNK_EXT;
                        break;
                    }
                    int read = stream.read();
                    this.chunkSizeBuilder.append((char)read);
                    this.byteStream.write(read);
                    break;
                }
                case CHUNK_EXT: {
                    if (this.consumeNonEmpty(stream)) break;
                    this.currentPhase = HttpPhase.CHUNK_DATA;
                    break;
                }
                case CHUNK_DATA: {
                    if (this.currentChunkSize == 0L) {
                        this.entityBytesRead = 0;
                        this.parseEntity();
                        this.currentPhase = HttpPhase.PRE_TRAILER;
                        break;
                    }
                    if ((long)this.entityBytesRead == this.currentChunkSize) {
                        this.entityBytesRead = 0;
                        this.consumeEmptyLine(stream, true);
                        this.currentPhase = HttpPhase.CHUNK_SIZE;
                        break;
                    }
                    this.byteStream.write(stream.read());
                    ++this.entityBytesRead;
                    break;
                }
                case PRE_TRAILER: {
                    if (this.consumeEmptyLine(stream, true)) {
                        this.parseTrailer();
                        this.parsedMessageQueue.enqueue(new ParsedMessage<T>(this.message, this.entity, this.trailers));
                        this.reset();
                        break;
                    }
                    this.currentPhase = HttpPhase.TRAILER;
                    break;
                }
                case TRAILER: {
                    if (this.consumeNonEmpty(stream)) break;
                    this.currentPhase = HttpPhase.PRE_TRAILER;
                }
            }
        }
    }

    private boolean consumeEmptyLine(PushbackInputStream stream, boolean write) throws IOException {
        if (stream.available() > 1) {
            int first = stream.read();
            int second = stream.read();
            if (first == CRLF[0] && second == CRLF[1]) {
                if (write) {
                    this.byteStream.write(first);
                    this.byteStream.write(second);
                }
                return true;
            }
            stream.unread(second);
            stream.unread(first);
            return false;
        }
        return false;
    }

    private boolean consumeSemicolon(PushbackInputStream stream) throws IOException {
        if (stream.available() > 0) {
            int read = stream.read();
            if (read == 59) {
                this.byteStream.write(read);
                return true;
            }
            stream.unread(read);
            return false;
        }
        return false;
    }

    private boolean consumeEmptyLines(PushbackInputStream stream, boolean write) throws IOException {
        while (this.consumeEmptyLine(stream, write)) {
        }
        return stream.available() == 0;
    }

    private boolean consumeNonEmpty(PushbackInputStream stream) throws IOException {
        boolean lastReadCR = false;
        while (stream.available() > 0) {
            int read = stream.read();
            this.byteStream.write(read);
            if (read == CRLF[0]) {
                lastReadCR = true;
                continue;
            }
            if (read != CRLF[1] || !lastReadCR) continue;
            return false;
        }
        return true;
    }

    private void parseMessage() throws IOException, HttpException {
        this.message = null;
        this.sessionBuffer.clear();
        this.sessionBuffer.bind(new ByteArrayInputStream(this.byteStream.toByteArray()));
        this.message = this.parser.parse();
        this.byteStream.reset();
        byte[] remaining = new byte[this.sessionBuffer.length()];
        this.sessionBuffer.read(remaining);
        this.byteStream.write(remaining);
        try {
            this.contentType = ContentType.parse(this.message.getFirstHeader("Content-Type").getValue());
        }
        catch (Exception e) {
            this.contentType = null;
        }
        this.contentLength = StrictContentLengthStrategy.INSTANCE.determineLength((HttpMessage)this.message);
        if (this.contentLength != -2L) {
            try {
                this.contentLength = Long.parseLong(this.message.getFirstHeader("Content-Length").getValue());
            }
            catch (Exception e) {
                this.contentLength = 0L;
            }
        }
        try {
            this.contentEncoding = ContentEncoding.parse(this.message.getFirstHeader("Content-Encoding"));
        }
        catch (Exception e) {
            this.contentEncoding = ContentEncoding.IDENTITY;
        }
    }

    private void parseEntity() {
        this.entity = null;
        this.sessionBuffer.clear();
        this.sessionBuffer.bind(new ByteArrayInputStream(this.byteStream.toByteArray()));
        if (this.contentLength == -2L) {
            this.entity = new InputStreamEntity(new ChunkedInputStream(this.sessionBuffer), -1L, this.contentType);
        } else if (this.contentLength == -1L) {
            this.entity = new InputStreamEntity(new IdentityInputStream(this.sessionBuffer), -1L, this.contentType);
        } else if (this.contentLength > 0L) {
            this.entity = new InputStreamEntity(new ContentLengthInputStream(this.sessionBuffer, this.contentLength), this.contentLength, this.contentType);
        }
        if (this.entity != null) {
            if (this.contentEncoding == ContentEncoding.GZIP) {
                this.entity = new GzipDecompressingEntity(this.entity);
            } else if (this.contentEncoding == ContentEncoding.DEFLATE) {
                this.entity = new DeflateDecompressingEntity(this.entity);
            }
        }
        this.byteStream.reset();
    }

    private void parseTrailer() {
        String trailerString = new String(this.byteStream.toByteArray()).trim();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String trailer : trailerString.split("\r\n")) {
            int splitIndex = trailer.indexOf(":");
            if (splitIndex == -1) continue;
            String name = trailer.substring(0, splitIndex).trim();
            String value = trailer.substring(splitIndex + 1).trim();
            map.put(name, value);
        }
        this.trailers = map;
        this.byteStream.reset();
    }

    public boolean hasParsedMessage() {
        return !this.parsedMessageQueue.isEmpty();
    }

    public ParsedMessage<T> getParsedMessage() {
        return this.parsedMessageQueue.dequeue();
    }

    public static BufferedHttpMessageParser<HttpResponse> getResponseParser(int bufferSize) {
        SessionInputBufferImpl sessionBuffer = new SessionInputBufferImpl(new HttpTransportMetricsImpl(), bufferSize);
        DefaultHttpResponseParser responseParser = new DefaultHttpResponseParser(sessionBuffer);
        return new BufferedHttpMessageParser<HttpResponse>(responseParser, sessionBuffer);
    }

    public static BufferedHttpMessageParser<HttpRequest> getRequestParser(int bufferSize) {
        SessionInputBufferImpl sessionBuffer = new SessionInputBufferImpl(new HttpTransportMetricsImpl(), bufferSize);
        DefaultHttpRequestParser requestParser = new DefaultHttpRequestParser(sessionBuffer);
        return new BufferedHttpMessageParser<HttpRequest>(requestParser, sessionBuffer);
    }

    public static BufferedHttpMessageParser<HttpResponse> getResponseParser() {
        return BufferedHttpMessageParser.getResponseParser(8192);
    }

    public static BufferedHttpMessageParser<HttpRequest> getRequestParser() {
        return BufferedHttpMessageParser.getRequestParser(8192);
    }

    public static class ParsedMessage<T extends HttpMessage> {
        private final T message;
        private final HttpEntity entity;
        private final LinkedHashMap<String, String> trailers;

        ParsedMessage(T message, HttpEntity entity, LinkedHashMap<String, String> trailers) {
            this.message = message;
            this.entity = entity;
            this.trailers = trailers == null ? new LinkedHashMap() : trailers;
        }

        public T getMessage() {
            return this.message;
        }

        public HttpEntity getEntity() {
            return this.entity;
        }

        public String getEntityString() throws IOException {
            try {
                String string = this.entity == null ? null : EntityUtils.toString(this.entity);
                return string;
            }
            finally {
                if (this.entity != null) {
                    EntityUtils.consume(this.entity);
                }
            }
        }

        public Boolean hasHtmlContent() {
            return this.entity != null && (this.entity.getContentType() == null || ContentType.get(this.entity).getMimeType().toLowerCase().equals(ContentType.TEXT_HTML.getMimeType().toLowerCase()));
        }

        public Map<String, String> getTrailers() {
            return this.trailers;
        }
    }

    public static enum ContentEncoding {
        GZIP("gzip"),
        DEFLATE("deflate"),
        IDENTITY("identity");

        private final String headerValue;

        private ContentEncoding(String headerValue) {
            this.headerValue = headerValue;
        }

        public String getHeaderValue() {
            return this.headerValue;
        }

        public static ContentEncoding parse(Header contentEncodingHeader) {
            if (contentEncodingHeader == null) {
                return IDENTITY;
            }
            return ContentEncoding.parse(contentEncodingHeader.getValue());
        }

        public static ContentEncoding parse(String value) {
            if (value == null) {
                return IDENTITY;
            }
            switch (value = value.toLowerCase().trim()) {
                case "gzip": 
                case "x-gzip": {
                    return GZIP;
                }
                case "deflate": {
                    return DEFLATE;
                }
            }
            return IDENTITY;
        }
    }

    public static enum HttpPhase {
        PRE_START_LINE,
        START_LINE,
        PRE_HEADER,
        HEADER,
        PRE_MESSAGE_BODY,
        IDENTITY_BODY,
        CHUNK_SIZE,
        CHUNK_EXT,
        CHUNK_DATA,
        PRE_TRAILER,
        TRAILER;

    }
}

