/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
implements Serializable {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final Map<IdentityWeakReference<K>, V> map = new HashMap<IdentityWeakReference<K>, V>();

    public int size() {
        this.expungeStaleEntries();
        return this.map.size();
    }

    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.expungeStaleEntries();
        return this.map.containsKey(new IdentityWeakReference<Object>(key, this.queue));
    }

    public boolean containsValue(Object value) {
        this.expungeStaleEntries();
        return this.map.containsValue(value);
    }

    public V get(Object key) {
        this.expungeStaleEntries();
        return this.map.get(new IdentityWeakReference<Object>(key, this.queue));
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("WeakIdentityHashMap cannot have null keys");
        }
        this.expungeStaleEntries();
        return this.map.put(new IdentityWeakReference<Object>(key, this.queue), value);
    }

    public V remove(Object key) {
        this.expungeStaleEntries();
        return this.map.remove(new IdentityWeakReference<Object>(key, this.queue));
    }

    public void clear() {
        this.expungeStaleEntries();
        this.map.clear();
    }

    public Set<K> keySet() {
        this.expungeStaleEntries();
        HashSet ret = new HashSet();
        for (IdentityWeakReference<K> ref : this.map.keySet()) {
            Object value = ref.get();
            if (value == null) continue;
            ret.add(value);
        }
        return Collections.unmodifiableSet(ret);
    }

    public Collection<V> values() {
        this.expungeStaleEntries();
        return this.map.values();
    }

    private void expungeStaleEntries() {
        Reference<Object> ref;
        while ((ref = this.queue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    private static class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        IdentityWeakReference(T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeakReference that = (WeakReference)o;
            Object referent = this.get();
            return referent != null && referent == that.get();
        }
    }
}

