/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SinglyLinkedList<E>
implements Iterable<E>,
Serializable {
    private static final long serialVersionUID = -6504649129625066964L;
    private Node<E> head = null;
    private Node<E> tail = null;
    private int size = 0;

    public int size() {
        return this.size;
    }

    public boolean contains(E item) {
        if (this.head == null) {
            return false;
        }
        Node<E> cur = this.head;
        while (cur != null) {
            if (cur.item.equals(item)) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public boolean identityContains(E item) {
        if (this.head == null) {
            return false;
        }
        Node<E> cur = this.head;
        while (cur != null) {
            if (cur.item == item) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public void addLast(E item) {
        Node<E> n = new Node<E>(item);
        ++this.size;
        if (this.tail == null) {
            this.tail = n;
            this.head = this.tail;
        } else {
            this.tail.next = n;
            this.tail = n;
        }
    }

    public void addFirst(E item) {
        Node<E> n = new Node<E>(item, this.head);
        ++this.size;
        if (this.head == null) {
            this.tail = n;
            this.head = this.tail;
        } else {
            this.head = n;
        }
    }

    public boolean addIdentityUnique(E item) {
        if (this.identityContains(item)) {
            return false;
        }
        this.addLast(item);
        return true;
    }

    public boolean addUnique(E item) {
        if (this.contains(item)) {
            return false;
        }
        this.addLast(item);
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public E pop() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        if (this.head == this.tail) {
            Object item = this.head.item;
            this.tail = null;
            this.head = null;
            this.size = 0;
            return item;
        }
        Object item = this.head.item;
        this.head = this.head.next;
        --this.size;
        return item;
    }

    public E peek() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.item;
    }

    public void push(E item) {
        this.addFirst(item);
    }

    public E dequeue() {
        return this.pop();
    }

    public E getFirst() {
        return this.peek();
    }

    public void enqueue(E item) {
        this.addLast(item);
    }

    public Object[] toArray() {
        Object[] arr = new Object[this.size];
        Node<E> cur = this.head;
        for (int i = 0; i < this.size; ++i) {
            arr[i] = cur.item;
            cur = cur.next;
        }
        return arr;
    }

    public E[] toArray(E[] arr) {
        if (arr.length < this.size) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.size);
        }
        Node<E> cur = this.head;
        for (int i = 0; i < this.size; ++i) {
            arr[i] = cur.item;
            cur = cur.next;
        }
        return arr;
    }

    public SinglyLinkedList<E> copy() {
        SinglyLinkedList copy = new SinglyLinkedList();
        Node<E> cur = this.head;
        while (cur != null) {
            copy.addLast(cur.item);
            cur = cur.next;
        }
        return copy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        Node<E> cur = this.head;
        while (cur != null) {
            builder.append(cur.item);
            if (cur.next != null) {
                builder.append(", ");
            }
            cur = cur.next;
        }
        return builder.append("]").toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SinglyLinkedList otherList = (SinglyLinkedList)other;
        if (this.size != otherList.size) {
            return false;
        }
        Node<E> cur1 = this.head;
        Node<E> cur2 = otherList.head;
        while (cur1 != null && cur2 != null) {
            if (!(cur1.item == cur2.item || cur1.item != null && cur1.item.equals(cur2.item))) {
                return false;
            }
            cur1 = cur1.next;
            cur2 = cur2.next;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        Node<E> cur = this.head;
        while (cur != null) {
            result = 31 * result + (cur.item == null ? 0 : cur.item.hashCode());
            cur = cur.next;
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return new SimpleListIterator();
    }

    private class SimpleListIterator
    implements Iterator<E>,
    Serializable {
        private static final long serialVersionUID = 2719802043259437539L;
        Node<E> current;
        Node<E> prev;

        SimpleListIterator() {
            this.current = SinglyLinkedList.this.head;
            this.prev = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public E next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.prev == null && this.current != SinglyLinkedList.this.head) {
                this.prev = SinglyLinkedList.this.head;
            } else if (this.prev != null) {
                this.prev = this.prev.next;
            }
            Object item = this.current.item;
            this.current = this.current.next;
            return item;
        }

        @Override
        public void remove() {
            if (this.prev == null && this.current == SinglyLinkedList.this.head) {
                throw new IllegalStateException();
            }
            if (this.prev == null) {
                SinglyLinkedList.this.pop();
            } else if (this.current == null) {
                SinglyLinkedList.this.tail = this.prev;
                this.prev.next = null;
                SinglyLinkedList.this.size--;
            } else {
                this.prev.next = this.current;
                SinglyLinkedList.this.size--;
            }
        }
    }

    private static class Node<E>
    implements Serializable {
        private static final long serialVersionUID = -4640096704981960035L;
        E item;
        Node<E> next;

        Node(E item) {
            this(item, null);
        }

        Node(E item, Node<E> next) {
            this.item = item;
            this.next = next;
        }
    }
}

