/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SimpleIdentityHashSet<T>
implements Iterable<T>,
Serializable {
    private Entry<T>[] buckets;
    private int size;

    public int size() {
        return this.size;
    }

    public SimpleIdentityHashSet() {
        this(16);
    }

    public SimpleIdentityHashSet(int capacity) {
        this.buckets = new Entry[capacity];
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int hashFunction(int hashCode) {
        int index = hashCode;
        if (index < 0) {
            index = -index;
        }
        return index % this.buckets.length;
    }

    public boolean contains(T element) {
        if (element == null) {
            return false;
        }
        int index = this.hashFunction(System.identityHashCode(element));
        Entry<T> current = this.buckets[index];
        while (current != null) {
            if (current.key == element) {
                return true;
            }
            current = current.next;
        }
        return false;
    }

    public boolean addAll(Iterable<T> col) {
        boolean ret = false;
        for (T o : col) {
            ret |= this.add(o);
        }
        return ret;
    }

    public boolean add(T element) {
        int index = this.hashFunction(System.identityHashCode(element));
        Entry<T> current = this.buckets[index];
        while (current != null) {
            if (current.key == element) {
                return false;
            }
            current = current.next;
        }
        Entry entry = new Entry();
        entry.key = element;
        entry.next = this.buckets[index];
        this.buckets[index] = entry;
        ++this.size;
        return true;
    }

    public boolean remove(T element) {
        int index = this.hashFunction(System.identityHashCode(element));
        Entry<T> current = this.buckets[index];
        Entry<T> previous = null;
        while (current != null) {
            if (current.key == element) {
                if (previous == null) {
                    this.buckets[index] = current.next;
                } else {
                    previous.next = current.next;
                }
                --this.size;
                return true;
            }
            previous = current;
            current = current.next;
        }
        return false;
    }

    public String toString() {
        Entry<T> currentEntry = null;
        StringBuffer sb = new StringBuffer();
        for (int index = 0; index < this.buckets.length; ++index) {
            if (this.buckets[index] == null) continue;
            currentEntry = this.buckets[index];
            sb.append("[" + index + "]");
            sb.append(" " + currentEntry.key.toString());
            while (currentEntry.next != null) {
                currentEntry = currentEntry.next;
                sb.append(" -> " + currentEntry.key.toString());
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleHashSetIterator();
    }

    public Iterator<T> iterator$$PHOSPHORTAGGED(ControlTaintTagStack ctrl) {
        return this.iterator();
    }

    class SimpleHashSetIterator
    implements Iterator {
        private int currentBucket = -1;
        private int previousBucket = -1;
        private Entry<T> currentEntry = null;
        private Entry<T> previousEntry = null;

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null && this.currentEntry.next != null) {
                return true;
            }
            for (int index = this.currentBucket + 1; index < SimpleIdentityHashSet.this.buckets.length; ++index) {
                if (SimpleIdentityHashSet.this.buckets[index] == null) continue;
                return true;
            }
            return false;
        }

        public TaintedBooleanWithObjTag hasNext$$PHOSPHORTAGGED(TaintedBooleanWithObjTag ret) {
            ret.taint = null;
            ret.val = this.hasNext();
            return ret;
        }

        public TaintedBooleanWithObjTag hasNext$$PHOSPHORTAGGED(ControlTaintTagStack ctrl, TaintedBooleanWithObjTag ret) {
            ret.taint = null;
            ret.val = this.hasNext();
            return ret;
        }

        public TaintedBooleanWithIntTag hasNext$$PHOSPHORTAGGED(TaintedBooleanWithIntTag ret) {
            ret.taint = 0;
            ret.val = this.hasNext();
            return ret;
        }

        public T next$$PHOSPHORTAGGED(ControlTaintTagStack ctrl) {
            return this.next();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public T next() {
            this.previousEntry = this.currentEntry;
            this.previousBucket = this.currentBucket;
            if (this.currentEntry == null || this.currentEntry.next == null) {
                ++this.currentBucket;
                while (this.currentBucket < SimpleIdentityHashSet.this.buckets.length && SimpleIdentityHashSet.this.buckets[this.currentBucket] == null) {
                    ++this.currentBucket;
                }
                if (this.currentBucket >= SimpleIdentityHashSet.this.buckets.length) throw new NoSuchElementException();
                this.currentEntry = SimpleIdentityHashSet.this.buckets[this.currentBucket];
                return this.currentEntry.key;
            } else {
                this.currentEntry = this.currentEntry.next;
            }
            return this.currentEntry.key;
        }
    }

    private static class Entry<T>
    implements Serializable {
        T key;
        Entry<T> next;

        private Entry() {
        }
    }
}

