/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SimpleHashSet<T>
implements Iterable<T>,
Serializable {
    public static int DEFAULT_HASHSET_SIZE = 16;
    private Entry<T>[] buckets;
    private int size;

    public int size() {
        return this.size;
    }

    public SimpleHashSet() {
        this(DEFAULT_HASHSET_SIZE);
    }

    public SimpleHashSet(int capacity) {
        this.buckets = new Entry[capacity];
        this.size = 0;
    }

    public SimpleHashSet<T> copy() {
        SimpleHashSet<T> ret = new SimpleHashSet<T>(this.buckets.length);
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i] == null) continue;
            ret.buckets[i] = this.buckets[i].copy();
        }
        ret.size = this.size;
        return ret;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private int hashFunction(int hashCode) {
        int index = hashCode;
        if (index < 0) {
            index = -index;
        }
        return index % this.buckets.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T element) {
        int index;
        if (element == null) {
            return false;
        }
        if (Configuration.IMPLICIT_TRACKING && element instanceof String) {
            SimpleHashSet simpleHashSet = this;
            synchronized (simpleHashSet) {
                index = this.hashFunction(((String)element).hashCode());
            }
        } else {
            index = this.hashFunction(element.hashCode());
        }
        Entry<T> current = this.buckets[index];
        while (current != null) {
            if (current.key.equals(element)) {
                return true;
            }
            current = current.next;
        }
        return false;
    }

    public boolean addAll(Iterable<T> col) {
        boolean ret = false;
        for (T o : col) {
            ret |= this.add(o);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleHashSet that = (SimpleHashSet)o;
        if (this.size != that.size) {
            return false;
        }
        for (T obj : this) {
            if (that.contains(obj)) continue;
            return false;
        }
        for (T obj : that) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.buckets);
        result = 31 * result + this.size;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T element) {
        int index;
        if (Configuration.IMPLICIT_TRACKING && element instanceof String) {
            SimpleHashSet simpleHashSet = this;
            synchronized (simpleHashSet) {
                index = this.hashFunction(((String)element).hashCode());
            }
        } else {
            index = this.hashFunction(element.hashCode());
        }
        Entry<T> current = this.buckets[index];
        while (current != null) {
            if (current.key.equals(element)) {
                return false;
            }
            current = current.next;
        }
        Entry entry = new Entry();
        entry.key = element;
        entry.next = this.buckets[index];
        this.buckets[index] = entry;
        ++this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T element) {
        int index;
        if (Configuration.IMPLICIT_TRACKING && element instanceof String) {
            SimpleHashSet simpleHashSet = this;
            synchronized (simpleHashSet) {
                index = this.hashFunction(((String)element).hashCode());
            }
        } else {
            index = this.hashFunction(element.hashCode());
        }
        Entry<T> current = this.buckets[index];
        Entry<T> previous = null;
        while (current != null) {
            if (current.key.equals(element)) {
                if (previous == null) {
                    this.buckets[index] = current.next;
                } else {
                    previous.next = current.next;
                }
                --this.size;
                return true;
            }
            previous = current;
            current = current.next;
        }
        return false;
    }

    public String toString() {
        Entry<T> currentEntry = null;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (int index = 0; index < this.buckets.length; ++index) {
            if (this.buckets[index] == null) continue;
            currentEntry = this.buckets[index];
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(currentEntry.key.toString());
            while (currentEntry.next != null) {
                currentEntry = currentEntry.next;
                sb.append(", " + currentEntry.key.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new SimpleHashSetIterator();
    }

    public Iterator<T> iterator$$PHOSPHORTAGGED(ControlTaintTagStack ctrl) {
        return this.iterator();
    }

    class SimpleHashSetIterator
    implements Iterator {
        private int currentBucket = -1;
        private int previousBucket = -1;
        private Entry<T> currentEntry = null;
        private Entry<T> previousEntry = null;

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.currentEntry != null && this.currentEntry.next != null) {
                return true;
            }
            for (int index = this.currentBucket + 1; index < SimpleHashSet.this.buckets.length; ++index) {
                if (SimpleHashSet.this.buckets[index] == null) continue;
                return true;
            }
            return false;
        }

        public TaintedBooleanWithObjTag hasNext$$PHOSPHORTAGGED(TaintedBooleanWithObjTag ret) {
            ret.taint = null;
            ret.val = this.hasNext();
            return ret;
        }

        public TaintedBooleanWithObjTag hasNext$$PHOSPHORTAGGED(ControlTaintTagStack ctrl, TaintedBooleanWithObjTag ret) {
            ret.taint = null;
            ret.val = this.hasNext();
            return ret;
        }

        public TaintedBooleanWithIntTag hasNext$$PHOSPHORTAGGED(TaintedBooleanWithIntTag ret) {
            ret.taint = 0;
            ret.val = this.hasNext();
            return ret;
        }

        public T next$$PHOSPHORTAGGED(ControlTaintTagStack ctrl) {
            return this.next();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public T next() {
            this.previousEntry = this.currentEntry;
            this.previousBucket = this.currentBucket;
            if (this.currentEntry == null || this.currentEntry.next == null) {
                ++this.currentBucket;
                while (this.currentBucket < SimpleHashSet.this.buckets.length && SimpleHashSet.this.buckets[this.currentBucket] == null) {
                    ++this.currentBucket;
                }
                if (this.currentBucket >= SimpleHashSet.this.buckets.length) throw new NoSuchElementException();
                this.currentEntry = SimpleHashSet.this.buckets[this.currentBucket];
                return this.currentEntry.key;
            } else {
                this.currentEntry = this.currentEntry.next;
            }
            return this.currentEntry.key;
        }
    }

    private static class Entry<T>
    implements Serializable {
        T key;
        Entry<T> next;

        private Entry() {
        }

        public Entry<T> copy() {
            Entry<T> ret = new Entry<T>();
            ret.key = this.key;
            if (this.next != null) {
                ret.next = this.next.copy();
            }
            return ret;
        }
    }
}

