/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.IntObjectAMT;
import edu.columbia.cs.psl.phosphor.struct.IntSinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import java.lang.ref.WeakReference;
import java.util.Iterator;

public class PowerSetTree {
    private final SetNode root = new SetNode(null, null);
    private IntObjectAMT<SinglyLinkedList<RankReference>> rankMap = new IntObjectAMT();
    private final IntSinglyLinkedList rankQueue = new IntSinglyLinkedList();
    private int nextRank = Integer.MIN_VALUE;

    private PowerSetTree() {
    }

    public synchronized void reset() {
        this.rankMap.clear();
        this.rankQueue.clear();
        this.nextRank = Integer.MIN_VALUE;
        SinglyLinkedList<SetNode> nodeStack = new SinglyLinkedList<SetNode>();
        nodeStack.push(this.root);
        while (!nodeStack.isEmpty()) {
            SetNode node = (SetNode)nodeStack.pop();
            for (SetNode child : node.getChildren()) {
                nodeStack.push(child);
            }
            node.empty();
        }
    }

    private int getAvailableRank() {
        if (!this.rankQueue.isEmpty()) {
            return this.rankQueue.pop();
        }
        return this.nextRank++;
    }

    private synchronized RankedObject getRankedObject(Object object) {
        int hash = object.hashCode();
        if (!this.rankMap.contains(hash)) {
            SinglyLinkedList<RankReference> list = new SinglyLinkedList<RankReference>();
            this.rankMap.put(hash, list);
            RankedObject ret = new RankedObject(object, this.getAvailableRank());
            list.push(new RankReference(ret));
            return ret;
        }
        SinglyLinkedList<RankReference> list = this.rankMap.get(hash);
        Iterator<RankReference> it = list.iterator();
        while (it.hasNext()) {
            RankReference ref = it.next();
            RankedObject ro = (RankedObject)ref.get();
            if (ro == null) {
                it.remove();
                this.rankQueue.push(ref.rank);
                continue;
            }
            if (!object.equals(ro.object)) continue;
            return ro;
        }
        RankedObject ret = new RankedObject(object, this.getAvailableRank());
        list.push(new RankReference(ret));
        return ret;
    }

    public SetNode emptySet() {
        return this.root;
    }

    public SetNode makeSingletonSet(Object element) {
        if (element == null) {
            return this.emptySet();
        }
        return this.root.addChild(this.getRankedObject(element));
    }

    public static PowerSetTree getInstance() {
        return PowerSetTreeSingleton.INSTANCE;
    }

    private static class PowerSetTreeSingleton {
        private static final PowerSetTree INSTANCE = new PowerSetTree();

        private PowerSetTreeSingleton() {
        }
    }

    private static class RankReference
    extends WeakReference<RankedObject> {
        int rank;

        RankReference(RankedObject referent) {
            super(referent);
            this.rank = referent.rank;
        }

        public String toString() {
            return String.format("RankReference: rank: %d | referent: %s", this.rank, this.get());
        }
    }

    private class RankedObject {
        private Object object;
        private int rank;

        private RankedObject(Object object, int rank) {
            this.object = object;
            this.rank = rank;
        }

        public String toString() {
            return String.format("(%s -> %d)", this.object, this.rank);
        }
    }

    public class SetNode {
        private RankedObject key;
        private SetNode parent;
        private IntObjectAMT<WeakReference<SetNode>> children;

        private SetNode(RankedObject key, SetNode parent) {
            this.key = key;
            this.parent = parent;
            this.children = null;
        }

        private synchronized SinglyLinkedList<SetNode> getChildren() {
            SinglyLinkedList<SetNode> list = new SinglyLinkedList<SetNode>();
            if (this.children != null) {
                for (WeakReference<SetNode> ref : this.children.values()) {
                    SetNode node = (SetNode)ref.get();
                    if (node == null) continue;
                    list.enqueue(node);
                }
            }
            return list;
        }

        private synchronized void empty() {
            this.key = null;
            this.parent = null;
            this.children = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SetNode addChild(RankedObject childKey) {
            SetNode setNode = this;
            synchronized (setNode) {
                if (this.children == null) {
                    this.children = new IntObjectAMT();
                }
                if (!this.children.contains(childKey.rank)) {
                    SetNode node = new SetNode(childKey, this);
                    this.children.put(childKey.rank, new WeakReference<SetNode>(node));
                    return node;
                }
                SetNode childNode = (SetNode)this.children.get(childKey.rank).get();
                if (childNode != null) {
                    return childNode;
                }
                SetNode node = new SetNode(childKey, this);
                this.children.put(childKey.rank, new WeakReference<SetNode>(node));
                return node;
            }
        }

        public synchronized boolean isEmpty() {
            return this.parent == null;
        }

        public SetNode union(SetNode other) {
            SetNode result;
            if (other == null) {
                return this;
            }
            SinglyLinkedList<RankedObject> mergedList = new SinglyLinkedList<RankedObject>();
            SetNode cur = this.isEmpty() ? PowerSetTree.this.emptySet() : this;
            SetNode setNode = other = other.isEmpty() ? PowerSetTree.this.emptySet() : other;
            while (!cur.isEmpty() && !other.isEmpty() && cur != other) {
                if (cur.key.rank == other.key.rank) {
                    mergedList.push(cur.key);
                    cur = cur.parent;
                    other = other.parent;
                    continue;
                }
                if (cur.key.rank > other.key.rank) {
                    mergedList.push(cur.key);
                    cur = cur.parent;
                    continue;
                }
                mergedList.push(other.key);
                other = other.parent;
            }
            SetNode setNode2 = result = cur.isEmpty() ? other : cur;
            while (!mergedList.isEmpty()) {
                result = result.addChild((RankedObject)mergedList.pop());
            }
            return result;
        }

        public SetNode add(Object element) {
            SetNode cur;
            if (element == null) {
                return this;
            }
            RankedObject obj = PowerSetTree.this.getRankedObject(element);
            SinglyLinkedList<RankedObject> list = new SinglyLinkedList<RankedObject>();
            SetNode setNode = cur = this.isEmpty() ? PowerSetTree.this.emptySet() : this;
            while (!cur.isEmpty()) {
                if (cur.key.rank == obj.rank) {
                    return this;
                }
                if (cur.key.rank <= obj.rank) break;
                list.push(cur.key);
                cur = cur.parent;
            }
            list.push(obj);
            while (!list.isEmpty()) {
                cur = cur.addChild((RankedObject)list.pop());
            }
            return cur;
        }

        public boolean contains(Object element) {
            if (element == null || this.isEmpty()) {
                return false;
            }
            SetNode cur = this;
            while (!cur.isEmpty()) {
                if (cur.key.object.equals(element)) {
                    return true;
                }
                cur = cur.parent;
            }
            return false;
        }

        public boolean isSuperset(SetNode other) {
            if (other == null) {
                return true;
            }
            SetNode cur = this;
            while (!other.isEmpty()) {
                if (cur.isEmpty()) {
                    return false;
                }
                if (cur == other) {
                    return true;
                }
                if (cur.key.rank == other.key.rank) {
                    cur = cur.parent;
                    other = other.parent;
                    continue;
                }
                if (cur.key.rank > other.key.rank) {
                    cur = cur.parent;
                    continue;
                }
                return false;
            }
            return true;
        }

        public SinglyLinkedList<Object> toList() {
            SinglyLinkedList<Object> list = new SinglyLinkedList<Object>();
            SetNode cur = this;
            while (!cur.isEmpty()) {
                list.push(cur.key.object);
                cur = cur.parent;
            }
            return list;
        }
    }
}

