/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import java.io.Serializable;

public class LinkedList<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5225392158190086269L;
    private Node<T> first;
    private Node<T> last;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public synchronized boolean addUnique(T o) {
        Node i = this.first.next;
        while (i != null) {
            if (i.entry == o) {
                return false;
            }
            i = i.next;
        }
        Node n = new Node();
        n.entry = o;
        this.last.next = n;
        this.last = n;
        return true;
    }

    public int size() {
        Node i = this.first.next;
        int c = 0;
        while (i != null) {
            ++c;
            i = i.next;
        }
        return c;
    }

    public synchronized boolean addUniqueObjEquals(T o) {
        Node i = this.first.next;
        while (i != null) {
            if (i.entry.equals(o)) {
                return false;
            }
            i = i.next;
        }
        Node n = new Node();
        n.entry = o;
        this.last.next = n;
        this.last = n;
        return true;
    }

    public synchronized boolean addAll(LinkedList<T> o) {
        boolean added = false;
        Node<Object> i = o.getFirst();
        while (i != null) {
            if (i.entry != null) {
                added |= this.addUnique(i.entry);
            }
            i = i.next;
        }
        return added;
    }

    public synchronized void addFast(T o) {
        Node n = new Node();
        n.entry = o;
        if (this.first.next == null) {
            this.first.next = n;
            this.last = n;
        } else {
            n.next = this.first.next;
            this.first.next = n;
        }
    }

    public synchronized boolean isEmpty() {
        return this.first.next == null;
    }

    public synchronized boolean add(T o) {
        return this.addUnique(o);
    }

    public Node<T> getFirst() {
        return this.first.next;
    }

    public T pop() {
        Node f = this.first.next;
        if (f == null) {
            return null;
        }
        this.first.next = f.next;
        if (this.first.next == null) {
            this.last = this.first;
        }
        return (T)f.entry;
    }

    public LinkedList() {
        this.clear();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        Node<Object> e = this.getFirst();
        while (e != null) {
            ret.append(e.entry);
            ret.append(",");
            e = e.next;
        }
        ret.append("]");
        return ret.toString();
    }

    public void clear() {
        this.first = new Node();
        this.last = this.first;
    }

    public static class Node<Z>
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -7510843924447531965L;
        public Z entry;
        public Node<Z> next;
    }
}

