/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithObjTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyShortArrayObjTags
extends LazyArrayObjTags {
    private static final long serialVersionUID = -4189650314277328488L;
    public short[] val;

    public LazyShortArrayObjTags(int len) {
        this.val = new short[len];
    }

    public LazyShortArrayObjTags(short[] array, Taint[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyShortArrayObjTags(short[] array) {
        this.val = array;
    }

    public LazyShortArrayObjTags(Taint lenTaint, short[] array) {
        this.val = array;
        this.lengthTaint = lenTaint;
    }

    public Object clone() {
        return new LazyShortArrayObjTags((short[])this.val.clone(), this.taints != null ? (Taint[])this.taints.clone() : null);
    }

    public void set(short[] arr, Taint idxTag, int idx, short val) {
        this.set(arr, idxTag, idx, null, val);
    }

    public void set(short[] l, Taint idxTag, int idx, Taint tag, short val) {
        if (Configuration.derivedTaintListener != null) {
            this.set(l, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, null), val);
        } else if (idxTag == null) {
            this.set(l, idx, tag, val);
        } else if (tag == null) {
            this.set(l, idx, idxTag, val);
        } else {
            this.set(l, idx, new Taint(tag, idxTag), val);
        }
    }

    public void set(short[] arr, int idx, Taint tag, short val) {
        this.val[idx] = val;
        if (this.taints == null && tag != null) {
            this.taints = new Taint[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public void set(short[] arr, Taint idxTag, int idx, Taint tag, short val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTag, idx, ctrl);
        this.set(arr, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, ctrl), val, ctrl);
    }

    public void set(short[] arr, int idx, Taint tag, short val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.set(arr, idx, Taint.combineTags(tag, ctrl), val);
    }

    public TaintedShortWithObjTag get(short[] arr, Taint idxTaint, int idx, TaintedShortWithObjTag ret) {
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, null);
    }

    public TaintedShortWithObjTag get(short[] arr, Taint idxTaint, int idx, TaintedShortWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTaint, idx, ctrl);
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, ctrl);
    }

    public TaintedShortWithObjTag get(short[] arr, int idx, TaintedShortWithObjTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? null : this.taints[idx];
        return ret;
    }

    public TaintedShortWithObjTag get(short[] arr, int idx, TaintedShortWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.get(arr, idx, ret);
        ret.taint = Taint.combineTags(ret.taint, ctrl);
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(short[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (short el : this.val) {
                stream.writeShort(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new short[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readShort();
            }
        }
        this.taints = (Taint[])stream.readObject();
    }
}

