/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithIntTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyShortArrayIntTags
extends LazyArrayIntTags {
    private static final long serialVersionUID = 2765977210252782974L;
    public short[] val;

    public LazyShortArrayIntTags(int len) {
        this.val = new short[len];
    }

    public LazyShortArrayIntTags(short[] array, int[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyShortArrayIntTags(short[] array) {
        this.val = array;
    }

    public Object clone() {
        return new LazyShortArrayIntTags((short[])this.val.clone(), this.taints != null ? (int[])this.taints.clone() : null);
    }

    public void set(short[] g, int idx, int tag, short val) {
        this.val[idx] = val;
        if (this.taints == null && tag != 0) {
            this.taints = new int[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public TaintedShortWithIntTag get(short[] g, int idx, TaintedShortWithIntTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? 0 : this.taints[idx];
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(short[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (short el : this.val) {
                stream.writeShort(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new short[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readShort();
            }
        }
        this.taints = (int[])stream.readObject();
    }
}

