/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithObjTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyIntArrayObjTags
extends LazyArrayObjTags {
    private static final long serialVersionUID = 5106261987550616988L;
    public int[] val;

    public LazyIntArrayObjTags(int len) {
        this.val = new int[len];
    }

    public LazyIntArrayObjTags(int[] array, Taint[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyIntArrayObjTags(int[] array) {
        this.val = array;
    }

    public LazyIntArrayObjTags(Taint lenTaint, int[] array) {
        this.val = array;
        this.lengthTaint = lenTaint;
    }

    public Object clone() {
        return new LazyIntArrayObjTags((int[])this.val.clone(), this.taints != null ? (Taint[])this.taints.clone() : null);
    }

    public void set(int[] arr, Taint idxTag, int idx, int val) {
        this.set(arr, idxTag, idx, null, val);
    }

    public void set(int[] l, Taint idxTag, int idx, Taint tag, int val) {
        if (Configuration.derivedTaintListener != null) {
            this.set(l, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, null), val);
        } else if (idxTag == null) {
            this.set(l, idx, tag, val);
        } else if (tag == null) {
            this.set(l, idx, idxTag, val);
        } else {
            this.set(l, idx, new Taint(tag, idxTag), val);
        }
    }

    public void set(int[] arr, int idx, Taint tag, int val) {
        this.val[idx] = val;
        if (this.taints == null && tag != null) {
            this.taints = new Taint[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public void set(int[] arr, Taint idxTag, int idx, Taint tag, int val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTag, idx, ctrl);
        this.set(arr, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, ctrl), val, ctrl);
    }

    public void set(int[] arr, int idx, Taint tag, int val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.set(arr, idx, Taint.combineTags(tag, ctrl), val);
    }

    public TaintedIntWithObjTag get(int[] arr, Taint idxTaint, int idx, TaintedIntWithObjTag ret) {
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, null);
    }

    public TaintedIntWithObjTag get(int[] arr, Taint idxTaint, int idx, TaintedIntWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTaint, idx, ctrl);
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, ctrl);
    }

    public TaintedIntWithObjTag get(int[] arr, int idx, TaintedIntWithObjTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? null : this.taints[idx];
        return ret;
    }

    public TaintedIntWithObjTag get(int[] arr, int idx, TaintedIntWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.get(arr, idx, ret);
        ret.taint = Taint.combineTags(ret.taint, ctrl);
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(int[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (int el : this.val) {
                stream.writeInt(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new int[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readInt();
            }
        }
        this.taints = (Taint[])stream.readObject();
    }
}

