/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithObjTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyFloatArrayObjTags
extends LazyArrayObjTags {
    private static final long serialVersionUID = 6150577887427835055L;
    public float[] val;

    public LazyFloatArrayObjTags(int len) {
        this.val = new float[len];
    }

    public LazyFloatArrayObjTags(float[] array, Taint[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyFloatArrayObjTags(float[] array) {
        this.val = array;
    }

    public LazyFloatArrayObjTags(Taint lenTaint, float[] array) {
        this.val = array;
        this.lengthTaint = lenTaint;
    }

    public Object clone() {
        return new LazyFloatArrayObjTags((float[])this.val.clone(), this.taints != null ? (Taint[])this.taints.clone() : null);
    }

    public void set(float[] arr, Taint idxTag, int idx, float val) {
        this.set(arr, idxTag, idx, null, val);
    }

    public void set(float[] l, Taint idxTag, int idx, Taint tag, float val) {
        if (Configuration.derivedTaintListener != null) {
            this.set(l, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, null), val);
        } else if (idxTag == null) {
            this.set(l, idx, tag, val);
        } else if (tag == null) {
            this.set(l, idx, idxTag, val);
        } else {
            this.set(l, idx, new Taint(tag, idxTag), val);
        }
    }

    public void set(float[] arr, int idx, Taint tag, float val) {
        this.val[idx] = val;
        if (this.taints == null && tag != null) {
            this.taints = new Taint[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public void set(float[] arr, Taint idxTag, int idx, Taint tag, float val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTag, idx, ctrl);
        this.set(arr, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, ctrl), val, ctrl);
    }

    public void set(float[] arr, int idx, Taint tag, float val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.set(arr, idx, Taint.combineTags(tag, ctrl), val);
    }

    public TaintedFloatWithObjTag get(float[] arr, Taint idxTaint, int idx, TaintedFloatWithObjTag ret) {
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, null);
    }

    public TaintedFloatWithObjTag get(float[] arr, Taint idxTaint, int idx, TaintedFloatWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTaint, idx, ctrl);
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, ctrl);
    }

    public TaintedFloatWithObjTag get(float[] arr, int idx, TaintedFloatWithObjTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? null : this.taints[idx];
        return ret;
    }

    public TaintedFloatWithObjTag get(float[] arr, int idx, TaintedFloatWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.get(arr, idx, ret);
        ret.taint = Taint.combineTags(ret.taint, ctrl);
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(float[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (float el : this.val) {
                stream.writeFloat(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new float[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readFloat();
            }
        }
        this.taints = (Taint[])stream.readObject();
    }
}

