/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithObjTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyDoubleArrayObjTags
extends LazyArrayObjTags {
    private static final long serialVersionUID = -3150902081462512196L;
    public double[] val;

    public LazyDoubleArrayObjTags(int len) {
        this.val = new double[len];
    }

    public LazyDoubleArrayObjTags(double[] array, Taint[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyDoubleArrayObjTags(double[] array) {
        this.val = array;
    }

    public LazyDoubleArrayObjTags(Taint lenTaint, double[] array) {
        this.val = array;
        this.lengthTaint = lenTaint;
    }

    public Object clone() {
        return new LazyDoubleArrayObjTags((double[])this.val.clone(), this.taints != null ? (Taint[])this.taints.clone() : null);
    }

    public void set(double[] arr, Taint idxTag, int idx, double val) {
        this.set(arr, idxTag, idx, null, val);
    }

    public void set(double[] l, Taint idxTag, int idx, Taint tag, double val) {
        if (Configuration.derivedTaintListener != null) {
            this.set(l, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, null), val);
        } else if (idxTag == null) {
            this.set(l, idx, tag, val);
        } else if (tag == null) {
            this.set(l, idx, idxTag, val);
        } else {
            this.set(l, idx, new Taint(tag, idxTag), val);
        }
    }

    public void set(double[] arr, int idx, Taint tag, double val) {
        this.val[idx] = val;
        if (this.taints == null && tag != null) {
            this.taints = new Taint[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public void set(double[] arr, Taint idxTag, int idx, Taint tag, double val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTag, idx, ctrl);
        this.set(arr, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, ctrl), val, ctrl);
    }

    public void set(double[] arr, int idx, Taint tag, double val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.set(arr, idx, Taint.combineTags(tag, ctrl), val);
    }

    public TaintedDoubleWithObjTag get(double[] arr, Taint idxTaint, int idx, TaintedDoubleWithObjTag ret) {
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, null);
    }

    public TaintedDoubleWithObjTag get(double[] arr, Taint idxTaint, int idx, TaintedDoubleWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTaint, idx, ctrl);
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, ctrl);
    }

    public TaintedDoubleWithObjTag get(double[] arr, int idx, TaintedDoubleWithObjTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? null : this.taints[idx];
        return ret;
    }

    public TaintedDoubleWithObjTag get(double[] arr, int idx, TaintedDoubleWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.get(arr, idx, ret);
        ret.taint = Taint.combineTags(ret.taint, ctrl);
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(double[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (double el : this.val) {
                stream.writeDouble(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new double[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readDouble();
            }
        }
        this.taints = (Taint[])stream.readObject();
    }
}

