/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithIntTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyCharArrayIntTags
extends LazyArrayIntTags {
    private static final long serialVersionUID = 2765977210252782974L;
    public char[] val;

    public LazyCharArrayIntTags(int len) {
        this.val = new char[len];
    }

    public LazyCharArrayIntTags(char[] array, int[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyCharArrayIntTags(char[] array) {
        this.val = array;
    }

    public Object clone() {
        return new LazyCharArrayIntTags((char[])this.val.clone(), this.taints != null ? (int[])this.taints.clone() : null);
    }

    public void set(char[] c, int idx, int tag, char val) {
        this.val[idx] = val;
        if (this.taints == null && tag != 0) {
            this.taints = new int[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public TaintedCharWithIntTag get(char[] c, int idx, TaintedCharWithIntTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? 0 : this.taints[idx];
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(char[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (char el : this.val) {
                stream.writeChar(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new char[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readChar();
            }
        }
        this.taints = (int[])stream.readObject();
    }
}

