/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedByteWithIntTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyByteArrayIntTags
extends LazyArrayIntTags {
    private static final long serialVersionUID = 2765977210252782974L;
    public byte[] val;

    public LazyByteArrayIntTags(int len) {
        this.val = new byte[len];
    }

    public LazyByteArrayIntTags(byte[] array, int[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyByteArrayIntTags(byte[] array) {
        this.val = array;
    }

    public Object clone() {
        return new LazyByteArrayIntTags((byte[])this.val.clone(), this.taints != null ? (int[])this.taints.clone() : null);
    }

    public void set(byte[] b, int idx, int tag, byte val) {
        this.val[idx] = val;
        if (this.taints == null && tag != 0) {
            this.taints = new int[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public TaintedByteWithIntTag get(byte[] b, int idx, TaintedByteWithIntTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? 0 : this.taints[idx];
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(byte[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (byte el : this.val) {
                stream.writeByte(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readByte();
            }
        }
        this.taints = (int[])stream.readObject();
    }
}

