/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyBooleanArrayObjTags
extends LazyArrayObjTags {
    private static final long serialVersionUID = -608551807469942060L;
    public boolean[] val;

    public LazyBooleanArrayObjTags(int len) {
        this.val = new boolean[len];
    }

    public LazyBooleanArrayObjTags(boolean[] array, Taint[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyBooleanArrayObjTags(boolean[] array) {
        this.val = array;
    }

    public LazyBooleanArrayObjTags(Taint lenTaint, boolean[] array) {
        this.val = array;
        this.lengthTaint = lenTaint;
    }

    public Object clone() {
        return new LazyBooleanArrayObjTags((boolean[])this.val.clone(), this.taints != null ? (Taint[])this.taints.clone() : null);
    }

    public void set(boolean[] arr, Taint idxTag, int idx, boolean val) {
        this.set(arr, idxTag, idx, null, val);
    }

    public void set(boolean[] l, Taint idxTag, int idx, Taint tag, boolean val) {
        if (Configuration.derivedTaintListener != null) {
            this.set(l, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, null), val);
        } else if (idxTag == null) {
            this.set(l, idx, tag, val);
        } else if (tag == null) {
            this.set(l, idx, idxTag, val);
        } else {
            this.set(l, idx, new Taint(tag, idxTag), val);
        }
    }

    public void set(boolean[] arr, int idx, Taint tag, boolean val) {
        this.val[idx] = val;
        if (this.taints == null && tag != null) {
            this.taints = new Taint[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public void set(boolean[] arr, Taint idxTag, int idx, Taint tag, boolean val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTag, idx, ctrl);
        this.set(arr, idx, Configuration.derivedTaintListener.arraySet(this, idxTag, idx, tag, val, ctrl), val, ctrl);
    }

    public void set(boolean[] arr, int idx, Taint tag, boolean val, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.set(arr, idx, Taint.combineTags(tag, ctrl), val);
    }

    public TaintedBooleanWithObjTag get(boolean[] arr, Taint idxTaint, int idx, TaintedBooleanWithObjTag ret) {
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, null);
    }

    public TaintedBooleanWithObjTag get(boolean[] arr, Taint idxTaint, int idx, TaintedBooleanWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(idxTaint, idx, ctrl);
        return Configuration.derivedTaintListener.arrayGet(this, idxTaint, idx, ret, ctrl);
    }

    public TaintedBooleanWithObjTag get(boolean[] arr, int idx, TaintedBooleanWithObjTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? null : this.taints[idx];
        return ret;
    }

    public TaintedBooleanWithObjTag get(boolean[] arr, int idx, TaintedBooleanWithObjTag ret, ControlTaintTagStack ctrl) {
        this.checkAIOOB(null, idx, ctrl);
        this.get(arr, idx, ret);
        ret.taint = Taint.combineTags(ret.taint, ctrl);
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(boolean[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (boolean el : this.val) {
                stream.writeBoolean(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new boolean[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readBoolean();
            }
        }
        this.taints = (Taint[])stream.readObject();
    }
}

