/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class LazyBooleanArrayIntTags
extends LazyArrayIntTags {
    private static final long serialVersionUID = 2765977210252782974L;
    public boolean[] val;

    public LazyBooleanArrayIntTags(int len) {
        this.val = new boolean[len];
    }

    public LazyBooleanArrayIntTags(boolean[] array, int[] taints) {
        this.taints = taints;
        this.val = array;
    }

    public LazyBooleanArrayIntTags(boolean[] array) {
        this.val = array;
    }

    public Object clone() {
        return new LazyBooleanArrayIntTags((boolean[])this.val.clone(), this.taints != null ? (int[])this.taints.clone() : null);
    }

    public void set(boolean[] b, int idx, int tag, boolean val) {
        this.val[idx] = val;
        if (this.taints == null && tag != 0) {
            this.taints = new int[this.val.length];
        }
        if (this.taints != null) {
            this.taints[idx] = tag;
        }
    }

    public TaintedBooleanWithIntTag get(boolean[] b, int idx, TaintedBooleanWithIntTag ret) {
        ret.val = this.val[idx];
        ret.taint = this.taints == null ? 0 : this.taints[idx];
        return ret;
    }

    @Override
    public int getLength() {
        return this.val.length;
    }

    @Override
    public Object getVal() {
        return this.val;
    }

    public void ensureVal(boolean[] v) {
        if (v != this.val) {
            this.val = v;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this.val == null) {
            stream.writeInt(-1);
        } else {
            stream.writeInt(this.val.length);
            for (boolean el : this.val) {
                stream.writeBoolean(el);
            }
        }
        stream.writeObject(this.taints);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readInt();
        if (len == -1) {
            this.val = null;
        } else {
            this.val = new boolean[len];
            for (int i = 0; i < len; ++i) {
                this.val[i] = stream.readBoolean();
            }
        }
        this.taints = (int[])stream.readObject();
    }
}

