/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntSinglyLinkedList
implements Serializable,
Iterable<Integer> {
    private static final long serialVersionUID = 2804910377808863384L;
    private IntNode head = null;
    private IntNode tail = null;
    private int size = 0;

    public int size() {
        return this.size;
    }

    public boolean contains(int item) {
        if (this.head == null) {
            return false;
        }
        IntNode cur = this.head;
        while (cur != null) {
            if (cur.item == item) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public void addLast(int item) {
        IntNode n = new IntNode(item);
        ++this.size;
        if (this.tail == null) {
            this.head = this.tail = n;
        } else {
            this.tail.next = n;
            this.tail = n;
        }
    }

    public void addFirst(int item) {
        IntNode n = new IntNode(item, this.head);
        ++this.size;
        this.head = this.head == null ? (this.tail = n) : n;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public int pop() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        int item = this.head.item;
        this.head = this.head.next;
        --this.size;
        return item;
    }

    public int peek() {
        if (this.head == null) {
            throw new NoSuchElementException();
        }
        return this.head.item;
    }

    public void push(int item) {
        this.addFirst(item);
    }

    public int dequeue() {
        return this.pop();
    }

    public int getFirst() {
        return this.peek();
    }

    public void enqueue(int item) {
        this.addLast(item);
    }

    public int[] toArray() {
        int[] arr = new int[this.size];
        IntNode cur = this.head;
        for (int i = 0; i < this.size; ++i) {
            arr[i] = cur.item;
            cur = cur.next;
        }
        return arr;
    }

    public Integer[] toObjArray() {
        Integer[] arr = new Integer[this.size];
        IntNode cur = this.head;
        for (int i = 0; i < this.size; ++i) {
            arr[i] = cur.item;
            cur = cur.next;
        }
        return arr;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        IntNode cur = this.head;
        while (cur != null) {
            builder.append(cur.item);
            if (cur.next != null) {
                builder.append(", ");
            }
            cur = cur.next;
        }
        return builder.append("]").toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        IntSinglyLinkedList otherList = (IntSinglyLinkedList)other;
        if (this.size != otherList.size) {
            return false;
        }
        IntNode cur1 = this.head;
        IntNode cur2 = otherList.head;
        while (cur1 != null && cur2 != null) {
            if (cur1.item != cur2.item) {
                return false;
            }
            cur1 = cur1.next;
            cur2 = cur2.next;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        IntNode cur = this.head;
        while (cur != null) {
            result = 31 * result + cur.item;
            cur = cur.next;
        }
        return result;
    }

    public IntListIterator iterator() {
        return new IntListIterator();
    }

    public class IntListIterator
    implements Iterator<Integer>,
    Serializable {
        private static final long serialVersionUID = -3285172228359136604L;
        IntNode current;
        IntNode prev;

        IntListIterator() {
            this.current = IntSinglyLinkedList.this.head;
            this.prev = null;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Integer next() {
            return this.nextInt();
        }

        @Override
        public void remove() {
            if (this.prev == null && this.current == IntSinglyLinkedList.this.head) {
                throw new IllegalStateException();
            }
            if (this.prev == null) {
                IntSinglyLinkedList.this.pop();
            } else if (this.current == null) {
                IntSinglyLinkedList.this.tail = this.prev;
                this.prev.next = null;
                IntSinglyLinkedList.this.size--;
            } else {
                this.prev.next = this.current;
                IntSinglyLinkedList.this.size--;
            }
        }

        public int nextInt() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.prev == null && this.current != IntSinglyLinkedList.this.head) {
                this.prev = IntSinglyLinkedList.this.head;
            } else if (this.prev != null) {
                this.prev = this.prev.next;
            }
            int item = this.current.item;
            this.current = this.current.next;
            return item;
        }
    }

    private static class IntNode
    implements Serializable {
        private static final long serialVersionUID = -4640096704981960035L;
        int item;
        IntNode next;

        IntNode(int item) {
            this(item, null);
        }

        IntNode(int item, IntNode next) {
            this.item = item;
            this.next = next;
        }
    }
}

