/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.IntObjectAMT;
import edu.columbia.cs.psl.phosphor.struct.IntSinglyLinkedList;
import java.lang.ref.WeakReference;

public class IntPowerSetTree {
    private final SetNode root = new SetNode(0, null);

    private IntPowerSetTree() {
    }

    public SetNode emptySet() {
        return this.root;
    }

    public SetNode makeSingletonSet(int element) {
        return this.root.addChild(element);
    }

    public static IntPowerSetTree getInstance() {
        return IntPowerSetTreeSingleton.INSTANCE;
    }

    private static class IntPowerSetTreeSingleton {
        private static final IntPowerSetTree INSTANCE = new IntPowerSetTree();

        private IntPowerSetTreeSingleton() {
        }
    }

    public class SetNode {
        private final int key;
        private final SetNode parent;
        private IntObjectAMT<WeakReference<SetNode>> children;

        private SetNode(int key, SetNode parent) {
            this.key = key;
            this.parent = parent;
            this.children = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SetNode addChild(int childKey) {
            SetNode setNode = this;
            synchronized (setNode) {
                if (this.children == null) {
                    this.children = new IntObjectAMT();
                }
                if (!this.children.contains(childKey)) {
                    SetNode node = new SetNode(childKey, this);
                    this.children.put(childKey, new WeakReference<SetNode>(node));
                    return node;
                }
                SetNode childNode = (SetNode)this.children.get(childKey).get();
                if (childNode != null) {
                    return childNode;
                }
                SetNode node = new SetNode(childKey, this);
                this.children.put(childKey, new WeakReference<SetNode>(node));
                return node;
            }
        }

        public boolean isEmpty() {
            return this == IntPowerSetTree.this.root;
        }

        public SetNode union(SetNode other) {
            SetNode result;
            if (other == null) {
                return this;
            }
            IntSinglyLinkedList mergedList = new IntSinglyLinkedList();
            SetNode cur = this;
            while (!cur.isEmpty() && !other.isEmpty() && cur != other) {
                if (cur.key == other.key) {
                    mergedList.push(cur.key);
                    cur = cur.parent;
                    other = other.parent;
                    continue;
                }
                if (cur.key > other.key) {
                    mergedList.push(cur.key);
                    cur = cur.parent;
                    continue;
                }
                mergedList.push(other.key);
                other = other.parent;
            }
            SetNode setNode = result = cur.isEmpty() ? other : cur;
            while (!mergedList.isEmpty()) {
                result = result.addChild(mergedList.pop());
            }
            return result;
        }

        public SetNode add(int element) {
            IntSinglyLinkedList list = new IntSinglyLinkedList();
            SetNode cur = this;
            while (!cur.isEmpty()) {
                if (cur.key == element) {
                    return this;
                }
                if (cur.key <= element) break;
                list.push(cur.key);
                cur = cur.parent;
            }
            list.push(element);
            while (!list.isEmpty()) {
                cur = cur.addChild(list.pop());
            }
            return cur;
        }

        public boolean contains(int element) {
            SetNode cur = this;
            while (!cur.isEmpty()) {
                if (cur.key == element) {
                    return true;
                }
                cur = cur.parent;
            }
            return false;
        }

        public boolean isSuperset(SetNode other) {
            if (other == null) {
                return true;
            }
            SetNode cur = this;
            while (!other.isEmpty()) {
                if (cur.isEmpty()) {
                    return false;
                }
                if (cur == other) {
                    return true;
                }
                if (cur.key == other.key) {
                    cur = cur.parent;
                    other = other.parent;
                    continue;
                }
                if (cur.key > other.key) {
                    cur = cur.parent;
                    continue;
                }
                return false;
            }
            return true;
        }

        public IntSinglyLinkedList toList() {
            IntSinglyLinkedList list = new IntSinglyLinkedList();
            SetNode cur = this;
            while (!cur.isEmpty()) {
                list.push(cur.key);
                cur = cur.parent;
            }
            return list;
        }
    }
}

