/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;

public class IntObjectAMT<V> {
    private static final int SHIFT_AMOUNT = 5;
    private static final int ARRAY_MAX_SIZE = 32;
    private static final int ARRAY_INIT_SIZE = 4;
    private static final int ARRAY_INDEX_MASK = 31;
    private static final int[] POP_COUNT_MASKS = new int[32];
    private int childrenSize = 0;
    private int bitSet = 0;
    private Object[] children = null;

    public void clear() {
        this.childrenSize = 0;
        this.bitSet = 0;
        this.children = null;
    }

    public boolean isEmpty() {
        return this.childrenSize == 0;
    }

    private int getChildIndex(int index) {
        return Integer.bitCount(this.bitSet & POP_COUNT_MASKS[index]);
    }

    public boolean contains(int key) {
        int index = key & 0x1F;
        if (this.children == null || (this.bitSet & 1 << index) == 0) {
            return false;
        }
        Object child = this.children[this.getChildIndex(index)];
        int childKey = key >>> 5;
        if (child instanceof IntObjectAMT) {
            return ((IntObjectAMT)child).contains(childKey);
        }
        return ((Mapping)child).key == childKey;
    }

    public V get(int key) {
        int index = key & 0x1F;
        if (this.children == null || (this.bitSet & 1 << index) == 0) {
            return null;
        }
        Object child = this.children[this.getChildIndex(index)];
        int childKey = key >>> 5;
        if (child instanceof IntObjectAMT) {
            return ((IntObjectAMT)child).get(childKey);
        }
        Mapping m = (Mapping)child;
        return m.key == childKey ? (V)m.value : null;
    }

    public void put(int key, V value) {
        int index = key & 0x1F;
        int childKey = key >>> 5;
        int childIndex = this.getChildIndex(index);
        if (this.children == null) {
            this.children = new Object[4];
            this.children[this.childrenSize++] = new Mapping(childKey, value);
            this.bitSet |= 1 << index;
        } else if ((this.bitSet & 1 << index) == 0) {
            if (this.childrenSize == this.children.length) {
                Object[] temp = new Object[this.children.length * 2];
                System.arraycopy(this.children, 0, temp, 0, this.childrenSize);
                this.children = temp;
            }
            System.arraycopy(this.children, childIndex, this.children, childIndex + 1, this.childrenSize - childIndex);
            this.children[childIndex] = new Mapping(childKey, value);
            this.bitSet |= 1 << index;
            ++this.childrenSize;
        } else {
            Object child = this.children[childIndex];
            if (child instanceof IntObjectAMT) {
                ((IntObjectAMT)child).put(childKey, value);
            } else if (((Mapping)child).key == childKey) {
                ((Mapping)child).value = value;
            } else {
                Mapping m = (Mapping)child;
                IntObjectAMT<V> map = new IntObjectAMT<V>();
                map.put(m.key, m.value);
                map.put(childKey, value);
                this.children[childIndex] = map;
            }
        }
    }

    private void removeChild(int index, int childIndex) {
        this.bitSet &= ~(1 << index);
        --this.childrenSize;
        System.arraycopy(this.children, childIndex + 1, this.children, childIndex, this.childrenSize - childIndex);
        this.children[this.childrenSize] = null;
    }

    public V remove(int key) {
        int index = key & 0x1F;
        if (this.children == null || (this.bitSet & 1 << index) == 0) {
            return null;
        }
        int childIndex = this.getChildIndex(index);
        Object child = this.children[childIndex];
        int childKey = key >>> 5;
        if (child instanceof IntObjectAMT) {
            V value = ((IntObjectAMT)child).remove(childKey);
            if (((IntObjectAMT)child).isEmpty()) {
                this.removeChild(index, childIndex);
            }
            return value;
        }
        Mapping m = (Mapping)child;
        if (m.key != childKey) {
            return null;
        }
        this.removeChild(index, childIndex);
        return m.value;
    }

    public SinglyLinkedList<V> values() {
        SinglyLinkedList ret = new SinglyLinkedList();
        if (!this.isEmpty()) {
            for (Object child : this.children) {
                if (child instanceof IntObjectAMT) {
                    for (V value : ((IntObjectAMT)child).values()) {
                        ret.enqueue(value);
                    }
                    continue;
                }
                if (child == null) continue;
                ret.enqueue(((Mapping)child).value);
            }
        }
        return ret;
    }

    static {
        int x = 0;
        for (int i = 0; i < POP_COUNT_MASKS.length; ++i) {
            IntObjectAMT.POP_COUNT_MASKS[i] = x;
            x <<= 1;
            ++x;
        }
    }

    private class Mapping {
        int key;
        V value;

        Mapping(int key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

