/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.IntArrayList;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public class GarbageCollectedArrayList<T> {
    T[] array;
    IntArrayList free;
    ArrayListReference[] referents;
    ReferenceQueue referenceQueue = new ReferenceQueue();
    int max = 0;

    public GarbageCollectedArrayList() {
        this.array = new Object[200];
        this.free = new IntArrayList();
        this.referents = new ArrayListReference[200];
    }

    public T get(int i) {
        if (i >= this.array.length) {
            System.out.println("Asking for invalid idx: " + i + " in " + this.array.length);
        }
        return this.array[i];
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.array.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = 0x7FFFFFF7;
        }
        T[] tmp = this.array;
        this.array = new Object[newCapacity];
        System.arraycopy(tmp, 0, this.array, 0, tmp.length);
        ArrayListReference[] referencesTmp = this.referents;
        this.referents = new ArrayListReference[newCapacity];
        System.arraycopy(referencesTmp, 0, this.referents, 0, referencesTmp.length);
    }

    private final int growOrGC(Object referent, T obj) {
        Reference ref;
        int ret = this.max;
        while ((ref = this.referenceQueue.poll()) != null) {
            int freed = ((ArrayListReference)ref).idx;
            this.free.add(freed);
            this.array[freed] = null;
        }
        if (this.free.size() > 0) {
            ret = this.free.pop();
        } else {
            this.grow(this.max + 1);
            ++this.max;
        }
        if (referent != null) {
            this.referents[ret] = new ArrayListReference(referent, ret, this.referenceQueue);
        }
        this.array[ret] = obj;
        return ret;
    }

    private int addSlow(Object referent, T obj) {
        if (this.free.size() > 0) {
            int ret = this.free.pop();
            this.array[ret] = obj;
            if (referent != null) {
                this.referents[ret] = new ArrayListReference(referent, ret, this.referenceQueue);
            }
            return ret;
        }
        return this.growOrGC(referent, obj);
    }

    public int add(Object referent, T obj) {
        if (this.max >= this.array.length - 1) {
            return this.addSlow(referent, obj);
        }
        int ret = this.max;
        this.array[this.max] = obj;
        if (referent != null) {
            this.referents[this.max] = new ArrayListReference(referent, this.max, this.referenceQueue);
        }
        ++this.max;
        return ret;
    }

    public void toArray(T[] dest) {
        System.arraycopy(this.array, 0, dest, 0, this.max);
    }

    static class ArrayListReference
    extends PhantomReference<Object> {
        int idx;

        public ArrayListReference(Object referent, int idx, ReferenceQueue q) {
            super(referent, q);
            this.idx = idx;
        }
    }
}

