/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

public class DoubleLinkedList<T>
implements Cloneable {
    private Node<T> first;
    private Node<T> last;

    public void popLast() {
        Node pp = this.last.prev;
        if (pp.prev == null) {
            this.clear();
        } else {
            this.last = pp;
            this.last.next = null;
        }
    }

    public synchronized boolean addUnique(T o) {
        Node i = this.first.next;
        while (i != null) {
            if (i.entry == o) {
                return false;
            }
            i = i.next;
        }
        Node n = new Node();
        n.entry = o;
        this.last.next = n;
        this.last.prev = i;
        this.last = n;
        return true;
    }

    public synchronized void addAll(DoubleLinkedList<T> o) {
        Node<Object> i = o.getFirst();
        while (i != null) {
            this.addUnique(i.entry);
            i = i.next;
        }
    }

    public synchronized Node<T> add(T o) {
        Node n = new Node();
        n.entry = o;
        Node f = this.first.next;
        this.first.next = n;
        n.prev = this.first;
        n.next = f;
        if (f != null) {
            f.prev = n;
        }
        if (this.last == this.first) {
            this.last = n;
        }
        return n;
    }

    public Node<T> getFirst() {
        return this.first.next;
    }

    public Node<T> getLast() {
        return this.last;
    }

    public DoubleLinkedList() {
        this.clear();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        Node<Object> e = this.getFirst();
        while (e != null) {
            ret.append(e.entry);
            ret.append(",");
            e = e.next;
        }
        ret.append("]");
        return ret.toString();
    }

    public void clear() {
        this.first = new Node();
        this.last = this.first;
    }

    public static class Node<Z>
    implements Cloneable {
        public Z entry;
        public Node<Z> next;
        public Node<Z> prev;
    }
}

