/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.EnqueuedTaint;
import edu.columbia.cs.psl.phosphor.struct.ExceptionalTaintData;
import edu.columbia.cs.psl.phosphor.struct.LinkedList;
import edu.columbia.cs.psl.phosphor.struct.MaybeThrownException;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithObjTag;

public final class ControlTaintTagStack {
    public boolean isDisabled;
    public Taint taint;
    LinkedList<MaybeThrownException> unThrownExceptionStack;
    public LinkedList<MaybeThrownException> influenceExceptions;
    static ControlTaintTagStack instance = new ControlTaintTagStack(true);
    public LinkedList<Taint> prevTaints = new LinkedList();

    public final boolean isEmpty() {
        return this.taint == null || this.isDisabled || this.taint.isEmpty();
    }

    public ControlTaintTagStack(int zz) {
        this();
    }

    public ControlTaintTagStack() {
    }

    public Taint copyTag() {
        if (this.taint == null || this.getTag() == null) {
            return null;
        }
        return this.taint.copy();
    }

    private ControlTaintTagStack(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public static ControlTaintTagStack factory() {
        return instance;
    }

    public final EnqueuedTaint exceptionHandlerStart(Throwable exceptionCaught, EnqueuedTaint eq) {
        Taint t;
        if (exceptionCaught instanceof TaintedWithObjTag && (t = (Taint)((TaintedWithObjTag)((Object)exceptionCaught)).getPHOSPHOR_TAG()) != null) {
            EnqueuedTaint ret = this.push(t, eq);
            return ret;
        }
        return null;
    }

    public final void exceptionHandlerStart(Class<? extends Throwable> exTypeHandled) {
        this.tryBlockEnd(exTypeHandled);
    }

    public final void exceptionHandlerEnd(EnqueuedTaint ex) {
        if (ex != null) {
            this.pop(ex);
        }
    }

    public final void tryBlockEnd(Class<? extends Throwable> exTypeHandled) {
        if (this.influenceExceptions == null) {
            return;
        }
        LinkedList.Node<MaybeThrownException> n = this.influenceExceptions.getFirst();
        LinkedList.Node<MaybeThrownException> prev = null;
        while (n != null) {
            if (exTypeHandled.isAssignableFrom(((MaybeThrownException)n.entry).clazz)) {
                if (prev == null) {
                    this.influenceExceptions.pop();
                } else {
                    prev.next = n.next;
                }
            } else {
                prev = n;
            }
            n = n.next;
        }
    }

    public final void applyPossiblyUnthrownExceptionToTaint(Class<? extends Throwable> t) {
        if (this.unThrownExceptionStack == null) {
            return;
        }
        LinkedList.Node<MaybeThrownException> n = this.unThrownExceptionStack.getFirst();
        LinkedList.Node<MaybeThrownException> prev = null;
        while (n != null) {
            if (t.isAssignableFrom(((MaybeThrownException)n.entry).clazz)) {
                if (prev == null) {
                    this.unThrownExceptionStack.pop();
                } else {
                    prev.next = n.next;
                }
                if (this.influenceExceptions == null) {
                    this.influenceExceptions = new LinkedList();
                }
                this.influenceExceptions.addFast((MaybeThrownException)n.entry);
            } else {
                prev = n;
            }
            n = n.next;
        }
    }

    public final void addUnthrownException(ExceptionalTaintData taints, Class<? extends Throwable> t) {
        if (taints != null && taints.taint != null) {
            if (this.unThrownExceptionStack == null) {
                this.unThrownExceptionStack = new LinkedList();
            }
            LinkedList.Node<MaybeThrownException> i = this.unThrownExceptionStack.getFirst();
            boolean found = false;
            while (i != null) {
                if (i.entry != null && ((MaybeThrownException)i.entry).clazz == t) {
                    found = true;
                    ((MaybeThrownException)i.entry).tag.addDependency(taints.taint);
                    break;
                }
                i = i.next;
            }
            if (!found) {
                MaybeThrownException ex = new MaybeThrownException(t, taints.taint.copy());
                this.unThrownExceptionStack.addFast(ex);
            }
        }
    }

    public final int[] push(Taint tag, int[] prev, int i, int maxSize, ExceptionalTaintData curMethod) {
        if (tag == null) {
            return prev;
        }
        return this._push(tag, prev, i, maxSize, curMethod);
    }

    public final int[] push(Taint tag, int[] prev, int i, int maxSize) {
        if (tag == null || tag == this.taint) {
            return prev;
        }
        return this._push(tag, prev, i, maxSize, null);
    }

    public final int[] push(Object obj, int[] prev, int i, int maxSize, ExceptionalTaintData curMethod) {
        Taint tag = null;
        if (obj instanceof TaintedWithObjTag) {
            tag = (Taint)((TaintedWithObjTag)obj).getPHOSPHOR_TAG();
        }
        if (tag == null || tag == this.taint) {
            return prev;
        }
        return this._push(tag, prev, i, maxSize, curMethod);
    }

    public final int[] push(Object obj, int[] prev, int i, int maxSize) {
        Taint tag = null;
        if (obj instanceof TaintedWithObjTag) {
            tag = (Taint)((TaintedWithObjTag)obj).getPHOSPHOR_TAG();
        }
        if (tag == null || tag == this.taint) {
            return prev;
        }
        return this._push(tag, prev, i, maxSize, null);
    }

    public final int[] _push(Taint tag, int[] invocationCountPerBranch, int indexOfBranchInMethod, int maxSize, ExceptionalTaintData exceptionData) {
        if (this.isDisabled) {
            return invocationCountPerBranch;
        }
        if (invocationCountPerBranch == null) {
            invocationCountPerBranch = new int[maxSize];
        }
        int n = indexOfBranchInMethod;
        invocationCountPerBranch[n] = invocationCountPerBranch[n] + 1;
        if (invocationCountPerBranch[indexOfBranchInMethod] == 1) {
            this.prevTaints.addFast(this.taint);
            if (exceptionData != null) {
                exceptionData.push(tag);
            }
            if (this.taint == null) {
                this.taint = new Taint(tag);
            } else {
                Taint prevTaint = this.taint;
                this.taint = prevTaint.copy();
                this.taint.addDependency(tag);
            }
        }
        return invocationCountPerBranch;
    }

    public final EnqueuedTaint push(Taint tag, EnqueuedTaint prev) {
        if (tag == null || tag == this.taint || this.isDisabled) {
            return null;
        }
        EnqueuedTaint ret = prev == null ? new EnqueuedTaint() : prev;
        ++ret.activeCount;
        this.prevTaints.addFast(this.taint);
        if (this.taint == null) {
            this.taint = new Taint(tag);
        } else {
            Taint prevTaint = this.taint;
            this.taint = prevTaint.copy();
            this.taint.addDependency(tag);
        }
        return ret;
    }

    public final void pop(int[] enq, int i, ExceptionalTaintData curMethod) {
        if (enq == null || enq[i] == 0) {
            return;
        }
        curMethod.pop(enq[i]);
        this.pop(enq, i);
    }

    public final void pop(int[] enq, int i) {
        if (enq == null || enq[i] == 0) {
            return;
        }
        this._pop(enq, i);
    }

    private final void _pop(int[] enq, int i) {
        if (enq[i] > 0) {
            this.taint = this.prevTaints.pop();
        }
        while (enq[i] > 0) {
            int n = i;
            enq[n] = enq[n] - 1;
        }
    }

    public final void pop(int[] enq, ExceptionalTaintData curMethod) {
        if (enq == null) {
            return;
        }
        for (int i = 0; i < enq.length; ++i) {
            if (enq[i] == 0) continue;
            curMethod.pop(enq[i]);
            while (enq[i] > 0) {
                this.taint = this.prevTaints.pop();
                int n = i;
                enq[n] = enq[n] - 1;
            }
        }
    }

    private final void _pop(int[] enq) {
        for (int i = 0; i < enq.length; ++i) {
            if (enq[i] == 0) continue;
            if (enq[i] > 0) {
                this.taint = this.prevTaints.pop();
            }
            while (enq[i] > 0) {
                int n = i;
                enq[n] = enq[n] - 1;
            }
        }
    }

    public final void pop(int[] enq) {
        if (enq == null) {
            return;
        }
        this._pop(enq);
    }

    public final void pop(EnqueuedTaint enq) {
        if (enq == null) {
            return;
        }
        while (enq.activeCount > 0) {
            this.taint = this.prevTaints.pop();
            --enq.activeCount;
        }
    }

    public Taint copyTagExceptions() {
        if ((this.taint == null || this.taint.isEmpty()) && (this.influenceExceptions == null || this.influenceExceptions.isEmpty())) {
            return null;
        }
        Taint ret = this.taint;
        if (this.influenceExceptions == null || this.influenceExceptions.isEmpty()) {
            return ret.copy();
        }
        ret = ret == null ? new Taint() : ret.copy();
        LinkedList.Node<MaybeThrownException> n = this.influenceExceptions.getFirst();
        while (n != null) {
            if (n.entry != null && ((MaybeThrownException)n.entry).tag != null) {
                ret.addDependency(((MaybeThrownException)n.entry).tag);
            }
            n = n.next;
        }
        return ret;
    }

    public Taint getTag() {
        if (this.taint == null || this.isDisabled || this.taint.isEmpty()) {
            return null;
        }
        return this.taint;
    }

    public void reset() {
        this.prevTaints = new LinkedList();
        this.taint = null;
        if (Configuration.IMPLICIT_EXCEPTION_FLOW) {
            this.unThrownExceptionStack = new LinkedList();
            this.influenceExceptions = new LinkedList();
        }
    }
}

