/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.MethodInformation;
import edu.columbia.cs.psl.phosphor.struct.MiniClassNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class CallGraph
implements Serializable {
    private static final long serialVersionUID = 7871097822917675195L;
    HashMap<String, MethodInformation> graph = new HashMap();
    HashMap<String, MiniClassNode> classInfo = new HashMap();

    public void addAll(CallGraph other) {
        this.graph.putAll(other.graph);
        this.classInfo.putAll(other.classInfo);
    }

    public MiniClassNode getClassNode(String name) {
        if (!this.classInfo.containsKey(name)) {
            MiniClassNode n = new MiniClassNode();
            n.name = name;
            this.classInfo.put(name, n);
        }
        return this.classInfo.get(name);
    }

    public MethodInformation getMethodNode(String owner, String name, String desc) {
        if (!this.graph.containsKey(owner + "." + name + desc)) {
            this.graph.put(owner + "." + name + desc, new MethodInformation(owner, name, desc));
        }
        return this.graph.get(owner + "." + name + desc);
    }

    public MethodInformation getMethodNodeIfExists(String owner, String name, String desc) {
        return this.graph.get(owner + "." + name + desc);
    }

    public void addEdge(String callerOwner, String callerName, String callerDesc, String calleeOwner, String calleeName, String calleeDesc) {
        this.getMethodNode((String)callerOwner, (String)callerName, (String)callerDesc).methodsCalled.add(this.getMethodNode(calleeOwner, calleeName, calleeDesc));
    }

    public Collection<MethodInformation> getMethods() {
        return this.graph.values();
    }

    public MethodInformation getMethodNodeIfExistsInHierarchy(String owner, String name, String desc) {
        return this.getMethodNodeIfExistsInHierarchy(owner, name, desc, new HashSet<String>());
    }

    public MethodInformation getMethodNodeIfExistsInHierarchy(String owner, String name, String desc, HashSet<String> tried) {
        MethodInformation ret;
        if (tried.contains(owner)) {
            return null;
        }
        tried.add(owner);
        if (owner.startsWith("[")) {
            owner = "java/lang/Object";
        }
        if ((ret = this.getMethodNodeIfExists(owner, name, desc)) != null && ret.isVisited()) {
            return ret;
        }
        MiniClassNode cn = this.classInfo.get(owner);
        if (cn == null) {
            return null;
        }
        if (cn.superName != null && (ret = this.getMethodNodeIfExistsInHierarchy(cn.superName, name, desc, tried)) != null) {
            return ret;
        }
        if (cn.interfaces != null) {
            for (String s : cn.interfaces) {
                ret = this.getMethodNodeIfExistsInHierarchy(s, name, desc, tried);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    public boolean containsClass(String className) {
        return this.classInfo.containsKey(className);
    }
}

