/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;

public class BitSet {
    private static final int SHIFT_AMOUNT = 6;
    private static final int BITS_PER_PACKET = 64;
    private long[] packets;

    public BitSet(int maxElements) {
        this.packets = new long[maxElements / 64 + (maxElements % 64 == 0 ? 0 : 1)];
    }

    public BitSet(long[] packets) {
        this.packets = packets;
    }

    public BitSet(BitSet set) {
        this.packets = (long[])set.packets.clone();
    }

    public long[] getPackets() {
        return this.packets;
    }

    public BitSet copy() {
        return new BitSet(this);
    }

    private static int getPacketIndex(int bitIndex) {
        return bitIndex >>> 6;
    }

    private static long getBitMask(int bitIndex) {
        return 1L << bitIndex;
    }

    public void add(int bitIndex) {
        int n = BitSet.getPacketIndex(bitIndex);
        this.packets[n] = this.packets[n] | BitSet.getBitMask(bitIndex);
    }

    public boolean contains(int bitIndex) {
        return (this.packets[BitSet.getPacketIndex(bitIndex)] & BitSet.getBitMask(bitIndex)) != 0L;
    }

    public void union(BitSet other) {
        block3: {
            block2: {
                if (other == null || other.packets.length <= this.packets.length) break block2;
                long[] temp = this.packets;
                this.packets = (long[])other.packets.clone();
                for (int i = 0; i < temp.length; ++i) {
                    int n = i;
                    this.packets[n] = this.packets[n] | temp[i];
                }
                break block3;
            }
            if (other == null) break block3;
            for (int i = 0; i < other.packets.length; ++i) {
                int n = i;
                this.packets[n] = this.packets[n] | other.packets[i];
            }
        }
    }

    public boolean isEmpty() {
        for (long packet : this.packets) {
            if (packet == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isSuperset(BitSet other) {
        int i;
        if (other == null) {
            return true;
        }
        if (this.packets.length >= other.packets.length) {
            for (int i2 = 0; i2 < other.packets.length; ++i2) {
                if ((this.packets[i2] | other.packets[i2]) == this.packets[i2]) continue;
                return false;
            }
            return true;
        }
        for (i = 0; i < this.packets.length; ++i) {
            if ((this.packets[i] | other.packets[i]) == this.packets[i]) continue;
            return false;
        }
        for (i = this.packets.length; i < other.packets.length; ++i) {
            if (other.packets[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public SinglyLinkedList<Integer> toList() {
        SinglyLinkedList<Integer> list = new SinglyLinkedList<Integer>();
        for (int i = 0; i < this.packets.length; ++i) {
            int packetOffset = i * 64;
            int shifts = 0;
            for (long packetValue = this.packets[i]; packetValue != 0L; packetValue >>>= 1) {
                if ((packetValue & 1L) != 0L) {
                    list.enqueue(packetOffset + shifts);
                }
                ++shifts;
            }
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BitSet)) {
            return false;
        }
        BitSet bitSet = (BitSet)obj;
        if (bitSet.packets.length != this.packets.length) {
            return false;
        }
        for (int i = 0; i < this.packets.length; ++i) {
            if (bitSet.packets[i] == this.packets[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (long packet : this.packets) {
            int packetHash = (int)(packet ^ packet >>> 32);
            result = 31 * result + packetHash;
        }
        return result;
    }

    public static BitSet union(BitSet set1, BitSet set2) {
        if (set1 == null && set2 == null) {
            return null;
        }
        if (set1 == null) {
            return set2.copy();
        }
        if (set2 == null) {
            return set1.copy();
        }
        if (set1.packets.length > set2.packets.length) {
            BitSet result = new BitSet(set1);
            result.union(set2);
            return result;
        }
        BitSet result = new BitSet(set2);
        result.union(set1);
        return result;
    }
}

