/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.struct;

import java.io.Serializable;
import java.util.Iterator;

public class ArrayList<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 8055343953798858075L;
    private static final int MAX_CAPACITY = 0x7FFFFFF7;
    private static final int INITIAL_CAPACITY = 200;
    private T[] elements;
    private int size;

    public ArrayList() {
        this.elements = new Object[200];
        this.size = 0;
    }

    public ArrayList(int capacity) {
        this.elements = new Object[capacity];
        this.size = 0;
    }

    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[index];
    }

    public int size() {
        return this.size;
    }

    public int getCapacity() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void ensureCapacity(int minCapacity) {
        int newCapacity = this.elements.length + (this.elements.length >> 1);
        newCapacity = newCapacity - minCapacity < 0 ? minCapacity : newCapacity;
        newCapacity = newCapacity - 0x7FFFFFF7 > 0 ? 0x7FFFFFF7 : newCapacity;
        T[] temp = this.elements;
        this.elements = new Object[newCapacity];
        System.arraycopy(temp, 0, this.elements, 0, this.size);
    }

    public void add(T obj) {
        if (this.size >= this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = obj;
    }

    public void replace(int index, T obj) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.elements[index] = obj;
    }

    public void toArray(T[] dest) {
        System.arraycopy(this.elements, 0, dest, 0, this.size);
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayListIterator();
    }

    private class ArrayListIterator
    implements Iterator<T> {
        int index = 0;

        ArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayList.this.size;
        }

        @Override
        public T next() {
            return ArrayList.this.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

