/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.runtime;

import edu.columbia.cs.psl.phosphor.runtime.AutoTaintLabel;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.runtime.TaintSinkError;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.SimpleHashSet;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithObjTag;
import java.lang.reflect.Array;

public class TaintSourceWrapper<T extends AutoTaintLabel> {
    public boolean shouldInstrumentMethodForImplicitLightTracking(String className, String methodName, String methodDescriptor) {
        return className.equals("edu/columbia/cs/psl/test/phosphor/SelectiveLightImplicitObjTagITCase") && methodName.equals("hasImplicitTracking");
    }

    public void combineTaintsOnArray(Object inputArray, Taint tag) {
        block6: {
            block5: {
                if (!(inputArray instanceof LazyArrayObjTags)) break block5;
                LazyArrayObjTags array = (LazyArrayObjTags)inputArray;
                if (array.taints == null) {
                    array.taints = new Taint[array.getLength()];
                }
                for (int i = 0; i < array.getLength(); ++i) {
                    if (array.taints[i] == null) {
                        array.taints[i] = tag.copy();
                        continue;
                    }
                    array.taints[i].addDependency(tag);
                }
                break block6;
            }
            if (!(inputArray instanceof Object[])) break block6;
            for (int i = 0; i < ((Object[])inputArray).length; ++i) {
                Object o = ((Object[])inputArray)[i];
                if (!(o instanceof TaintedWithObjTag)) continue;
                Taint existing = (Taint)((TaintedWithObjTag)o).getPHOSPHOR_TAG();
                if (existing != null) {
                    existing.addDependency(tag);
                    continue;
                }
                ((TaintedWithObjTag)o).setPHOSPHOR_TAG(tag.copy());
            }
        }
    }

    public void combineTaintsOnArray(Object obj, int tag) {
        if (obj instanceof LazyArrayIntTags) {
            ((LazyArrayIntTags)obj).setTaints(tag);
        } else if (obj instanceof Object[]) {
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                if (!(((Object[])obj)[i] instanceof TaintedWithIntTag)) continue;
                ((TaintedWithIntTag)((Object[])obj)[i]).setPHOSPHOR_TAG(tag);
            }
        }
    }

    public void addTaint(Object obj, Taint<? extends AutoTaintLabel> tag) {
        if (tag == null || obj == null) {
            return;
        }
        if (obj instanceof LazyArrayObjTags) {
            this.combineTaintsOnArray(obj, tag);
        } else if (obj instanceof TaintedWithObjTag) {
            TaintedWithObjTag tainted = (TaintedWithObjTag)obj;
            Taint prevTag = (Taint)tainted.getPHOSPHOR_TAG();
            if (prevTag != null) {
                prevTag.addDependency(tag);
            } else {
                tainted.setPHOSPHOR_TAG(tag);
            }
        } else if (obj instanceof TaintedPrimitiveWithObjTag) {
            TaintedPrimitiveWithObjTag tainted = (TaintedPrimitiveWithObjTag)obj;
            if (tainted.taint != null) {
                tainted.taint.addDependency(tag);
            } else {
                tainted.taint = tag;
            }
            this.autoTaint((TaintedPrimitiveWithObjTag)obj, tag);
        } else if (obj.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                this.addTaint(Array.get(obj, i), tag);
            }
        }
    }

    public static void autoTaint(Object obj, int tag) {
        if (obj instanceof LazyArrayIntTags) {
            ((LazyArrayIntTags)obj).setTaints(tag);
        } else if (obj instanceof Object[]) {
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                TaintSourceWrapper.autoTaint(((Object[])obj)[i], tag);
            }
        } else if (obj instanceof TaintedWithIntTag) {
            ((TaintedWithIntTag)obj).setPHOSPHOR_TAG(tag);
        } else if (obj instanceof TaintedPrimitiveWithIntTag) {
            ((TaintedPrimitiveWithIntTag)obj).taint = tag;
        }
    }

    public Taint<AutoTaintLabel> generateTaint(String source) {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        StackTraceElement[] s = new StackTraceElement[st.length - 3];
        System.arraycopy(st, 3, s, 0, s.length);
        return new Taint<AutoTaintLabel>(new AutoTaintLabel(source, s));
    }

    public Object autoTaint(Object obj, String baseSource, String actualSource, int argIdx) {
        return this.autoTaint(obj, this.generateTaint(baseSource));
    }

    public Object autoTaint(Object obj, Taint<? extends AutoTaintLabel> tag) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LazyArrayObjTags) {
            return this.autoTaint((LazyArrayObjTags)obj, tag);
        }
        if (obj instanceof TaintedWithObjTag) {
            return this.autoTaint((TaintedWithObjTag)obj, tag);
        }
        if (obj instanceof TaintedPrimitiveWithObjTag) {
            return this.autoTaint((TaintedPrimitiveWithObjTag)obj, tag);
        }
        if (obj.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Array.set(obj, i, this.autoTaint(Array.get(obj, i), tag));
            }
            return obj;
        }
        return obj;
    }

    public TaintedWithObjTag autoTaint(TaintedWithObjTag ret, Taint<? extends AutoTaintLabel> tag) {
        Taint prevTag = (Taint)ret.getPHOSPHOR_TAG();
        if (prevTag != null) {
            prevTag.addDependency(tag);
        } else {
            ret.setPHOSPHOR_TAG(tag);
        }
        return ret;
    }

    public LazyArrayObjTags autoTaint(LazyArrayObjTags ret, Taint<? extends AutoTaintLabel> tag) {
        Taint[] taintArray = ret.taints;
        if (taintArray != null) {
            for (int i = 0; i < taintArray.length; ++i) {
                if (taintArray[i] == null) {
                    taintArray[i] = tag.copy();
                    continue;
                }
                taintArray[i].addDependency(tag);
            }
        } else {
            ret.setTaints(tag);
        }
        return ret;
    }

    public TaintedPrimitiveWithObjTag autoTaint(TaintedPrimitiveWithObjTag ret, Taint<? extends AutoTaintLabel> tag) {
        if (ret.taint != null) {
            ret.taint.addDependency(tag);
        } else {
            ret.taint = tag;
        }
        return ret;
    }

    public static void setStringValueTag(String str, LazyCharArrayObjTags tags) {
        if (str != null) {
            str.valuePHOSPHOR_TAG = tags;
        }
    }

    public static LazyCharArrayObjTags getStringValueTag(String str) {
        if (str == null) {
            return null;
        }
        return str.valuePHOSPHOR_TAG;
    }

    public static Taint[] getStringValueTaints(String str) {
        return TaintSourceWrapper.getStringValueTag((String)str).taints;
    }

    public void checkTaint(Object self, Object[] arguments, String baseSink, String actualSink) {
        if (arguments != null) {
            for (Object argument : arguments) {
                this.checkTaint(argument, baseSink, actualSink);
            }
        }
    }

    public void checkTaint(Object obj, String baseSink, String actualSink) {
        if (obj instanceof String) {
            Taint[] taints = TaintSourceWrapper.getStringValueTaints((String)obj);
            if (taints != null) {
                SimpleHashSet<String> reported = new SimpleHashSet<String>();
                for (Taint t : taints) {
                    String _t;
                    if (t == null || !reported.add(_t = new String(t.toString().getBytes()))) continue;
                    this.taintViolation(t, obj, baseSink, actualSink);
                }
            }
        } else if (obj instanceof TaintedWithIntTag) {
            this.checkTaint(((TaintedWithIntTag)obj).getPHOSPHOR_TAG(), actualSink);
        } else if (obj instanceof TaintedWithObjTag) {
            if (((TaintedWithObjTag)obj).getPHOSPHOR_TAG() != null) {
                this.taintViolation((Taint)((TaintedWithObjTag)obj).getPHOSPHOR_TAG(), obj, baseSink, actualSink);
            }
        } else if (obj instanceof LazyArrayIntTags) {
            this.checkTaints(((LazyArrayIntTags)obj).taints, actualSink);
        } else if (obj instanceof LazyArrayObjTags) {
            LazyArrayObjTags tags = (LazyArrayObjTags)obj;
            if (tags.taints != null) {
                for (Taint i : tags.taints) {
                    if (i == null) continue;
                    this.taintViolation(i, obj, baseSink, actualSink);
                }
            }
        } else if (obj instanceof Object[]) {
            for (Object o : (Object[])obj) {
                this.checkTaint(o, baseSink, actualSink);
            }
        } else if (obj instanceof ControlTaintTagStack) {
            ControlTaintTagStack ctrl = (ControlTaintTagStack)obj;
            if (ctrl.taint != null && !ctrl.isEmpty()) {
                this.taintViolation(ctrl.taint, obj, baseSink, actualSink);
            }
        } else if (obj instanceof TaintedPrimitiveWithObjTag) {
            if (((TaintedPrimitiveWithObjTag)obj).taint != null) {
                this.taintViolation(((TaintedPrimitiveWithObjTag)obj).taint, ((TaintedPrimitiveWithObjTag)obj).getValue(), baseSink, actualSink);
            }
        } else if (obj instanceof TaintedPrimitiveWithIntTag) {
            this.checkTaint(((TaintedPrimitiveWithIntTag)obj).taint, actualSink);
        }
    }

    public void taintViolation(Taint<T> tag, Object obj, String baseSink, String actualSink) {
        throw new TaintSinkError(tag, obj);
    }

    public void checkTaint(int tag, String actualSink) {
        if (tag != 0) {
            throw new IllegalAccessError("Argument carries taint " + tag + " at " + actualSink);
        }
    }

    public void checkTaints(int[] tags, String actualSink) {
        if (tags != null) {
            for (int tag : tags) {
                this.checkTaint(tag, actualSink);
            }
        }
    }

    public void exitingSink(String baseSink, String actualSink) {
    }

    public void enteringSink(String baseSink, String actualSink) {
    }
}

