/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.runtime;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.runtime.MultiTainter;
import edu.columbia.cs.psl.phosphor.struct.BitSet;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyLongArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.PowerSetTree;
import edu.columbia.cs.psl.phosphor.struct.SimpleHashSet;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithObjTag;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class Taint<T>
implements Serializable {
    private static final long serialVersionUID = -2367127733023881176L;
    public static boolean IGNORE_TAINTING = false;
    private static final PowerSetTree setTree = PowerSetTree.getInstance();
    private transient PowerSetTree.SetNode labelSet = null;
    public static int BIT_SET_CAPACITY = -1;
    private transient BitSet labelBitSet = null;
    private transient T singleLabelModeLabel;

    public Taint() {
        if (BIT_SET_CAPACITY <= 0) {
            this.labelSet = setTree.emptySet();
        }
    }

    public Taint(T initialLabel) {
        if (BIT_SET_CAPACITY > 0) {
            if (initialLabel instanceof Integer) {
                this.labelBitSet = new BitSet(BIT_SET_CAPACITY);
                this.labelBitSet.add((Integer)initialLabel);
            }
        } else if (Configuration.SINGLE_TAINT_LABEL) {
            this.singleLabelModeLabel = initialLabel;
        } else {
            this.labelSet = initialLabel == null ? setTree.emptySet() : setTree.makeSingletonSet(initialLabel);
        }
    }

    public Taint(int initialLabel) {
        if (BIT_SET_CAPACITY > 0) {
            this.labelBitSet = new BitSet(BIT_SET_CAPACITY);
            this.labelBitSet.add(initialLabel);
        } else {
            this.labelSet = setTree.makeSingletonSet(initialLabel);
        }
    }

    public Taint(Taint<T> t1) {
        if (Configuration.SINGLE_TAINT_LABEL) {
            if (t1 != null) {
                this.singleLabelModeLabel = t1.singleLabelModeLabel;
            }
        } else if (BIT_SET_CAPACITY > 0) {
            if (t1 != null && t1.labelBitSet != null) {
                this.labelBitSet = t1.labelBitSet.copy();
            }
        } else {
            PowerSetTree.SetNode setNode = this.labelSet = t1 == null ? setTree.emptySet() : t1.labelSet;
        }
        if (Configuration.derivedTaintListener != null) {
            Configuration.derivedTaintListener.singleDepCreated(t1, this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Taint(Taint<T> t1, Taint<T> t2) {
        if (Configuration.SINGLE_TAINT_LABEL) {
            if (t1 == null && t2 == null) {
                this.singleLabelModeLabel = null;
            } else if (t2 == null || t2.singleLabelModeLabel == null) {
                this.singleLabelModeLabel = t1.singleLabelModeLabel;
            } else {
                if (t1 != null && t1.singleLabelModeLabel != null) throw new IllegalStateException("Attempted to combine two taint tags, but in single taint label mode!");
                this.singleLabelModeLabel = t2.singleLabelModeLabel;
            }
        } else if (BIT_SET_CAPACITY > 0) {
            if (t1 != null && t2 != null) {
                this.labelBitSet = BitSet.union(t1.labelBitSet, t2.labelBitSet);
            } else if (t1 != null && t1.labelBitSet != null) {
                this.labelBitSet = t1.labelBitSet.copy();
            } else if (t2 != null && t2.labelBitSet != null) {
                this.labelBitSet = t2.labelBitSet.copy();
            }
        } else {
            this.labelSet = t1 == null ? setTree.emptySet() : t1.labelSet;
            PowerSetTree.SetNode setNode = this.labelSet = t2 == null ? this.labelSet : this.labelSet.union(t2.labelSet);
        }
        if (Configuration.derivedTaintListener == null) return;
        Configuration.derivedTaintListener.doubleDepCreated(t1, t2, this);
    }

    public Taint<T> copy() {
        if (IGNORE_TAINTING) {
            return this;
        }
        return new Taint<T>(this);
    }

    public String toString() {
        if (this.labelSet != null) {
            return "Taint [Labels = [" + this.labelSet.toList() + "]";
        }
        if (this.labelBitSet != null) {
            return "Taint [Label indices = [" + this.labelBitSet.toList() + "]";
        }
        return "Taint []";
    }

    public T getSingleLabel() {
        return this.singleLabelModeLabel;
    }

    public void setSingleLabel(T singleLabelModeLabel) {
        this.singleLabelModeLabel = singleLabelModeLabel;
    }

    public Object[] getLabels() {
        if (this.labelSet != null) {
            return this.labelSet.toList().toArray();
        }
        if (this.labelBitSet != null) {
            return this.labelBitSet.toList().toArray();
        }
        return null;
    }

    public Object[] getLabels$$PHOSPHORTAGGED() {
        return this.getLabels();
    }

    public T[] getLabels(T[] arr) {
        Object[] labels = this.getLabels();
        if (labels == null) {
            return null;
        }
        if (arr.length < labels.length) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), labels.length);
        }
        int i = 0;
        for (Object label : labels) {
            arr[i++] = label;
        }
        return arr;
    }

    public T[] getLabels$$PHOSPHORTAGGED(T[] arr) {
        return this.getLabels(arr);
    }

    public boolean addDependency(Taint<T> other) {
        if (other == null) {
            return false;
        }
        if (BIT_SET_CAPACITY > 0) {
            if (this.labelBitSet == null && other.labelBitSet != null) {
                this.labelBitSet = other.labelBitSet.copy();
                return true;
            }
            if (this.labelBitSet != null && !this.labelBitSet.isSuperset(other.labelBitSet)) {
                this.labelBitSet.union(other.labelBitSet);
                return true;
            }
            return false;
        }
        PowerSetTree.SetNode union = this.labelSet.union(other.labelSet);
        boolean changed = this.labelSet != union;
        this.labelSet = union;
        return changed;
    }

    public boolean isEmpty() {
        if (this.labelSet != null) {
            return this.labelSet.isEmpty();
        }
        return this.labelBitSet == null;
    }

    public TaintedBooleanWithObjTag isEmpty$$PHOSPHORTAGGED(TaintedBooleanWithObjTag ret) {
        ret.val = this.isEmpty();
        ret.taint = null;
        return ret;
    }

    public TaintedBooleanWithObjTag isEmpty$$PHOSPHORTAGGED(ControlTaintTagStack ctrl, TaintedBooleanWithObjTag ret) {
        ret.val = this.isEmpty();
        ret.taint = null;
        return ret;
    }

    public static <T> void combineTagsOnArrayInPlace(Object[] ar, Taint<T>[] t1, int dims) {
        Taint.combineTagsInPlace(ar, t1[dims - 1]);
        if (dims == 1) {
            for (Object o : ar) {
                Taint.combineTagsInPlace(o, t1[dims - 1]);
            }
        } else {
            for (Object o : ar) {
                Taint.combineTagsOnArrayInPlace((Object[])o, t1, dims - 1);
            }
        }
    }

    public static <T> void combineTagsInPlace(Object obj, Taint<T> t1) {
        if (obj != null && t1 != null && !IGNORE_TAINTING) {
            Taint._combineTagsInPlace(obj, t1);
        }
    }

    public static <T> void _combineTagsInPlace(Object obj, Taint<T> t1) {
        Taint t = TaintUtils.getTaintObj(obj);
        if (t == null && t1 != null) {
            MultiTainter.taintedObject(obj, t1.copy());
        } else if (t != null && t1 != null) {
            t.addDependency(t1);
        }
    }

    public static <T> Taint<T> combineTags(Taint<T> t1, Taint<T> t2) {
        if (t1 == null && t2 == null) {
            return null;
        }
        if (t2 == null || t2.isEmpty()) {
            return t1;
        }
        if (t1 == null || t1.isEmpty()) {
            return t2;
        }
        if (t1.equals(t2) || IGNORE_TAINTING) {
            return t1;
        }
        if (t1.contains(t2)) {
            return t1;
        }
        if (t2.contains(t1)) {
            return t2;
        }
        Taint<T> r = t1.copy();
        r.addDependency(t2);
        if (Configuration.derivedTaintListener != null) {
            Configuration.derivedTaintListener.doubleDepCreated(t1, t2, r);
        }
        return r;
    }

    public boolean contains(Taint<T> that) {
        if (that == null) {
            return true;
        }
        if (BIT_SET_CAPACITY > 0) {
            return that.labelBitSet == null || this.labelBitSet != null && this.labelBitSet.isSuperset(that.labelBitSet);
        }
        return that.labelSet == null || this.labelSet != null && this.labelSet.isSuperset(that.labelSet);
    }

    public TaintedBooleanWithObjTag contains$$PHOSPHORTAGGED(Taint<T> that, TaintedBooleanWithObjTag ret) {
        ret.taint = null;
        ret.val = this.contains(that);
        return ret;
    }

    public TaintedBooleanWithIntTag contains$$PHOSPHORTAGGED(Taint<T> that, TaintedBooleanWithIntTag ret) {
        ret.taint = 0;
        ret.val = this.contains(that);
        return ret;
    }

    public TaintedBooleanWithObjTag contains$$PHOSPHORTAGGED(Taint<T> that, TaintedBooleanWithObjTag ret, ControlTaintTagStack ctrl) {
        ret.taint = null;
        ret.val = this.contains(that);
        return ret;
    }

    public boolean containsOnlyLabels(Object[] labels) {
        if (labels.length != this.getLabels().length) {
            return false;
        }
        for (Object label : labels) {
            if (this.containsLabel(label)) continue;
            return false;
        }
        return true;
    }

    public TaintedBooleanWithObjTag containsOnlyLabels$$PHOSPHORTAGGED(Object[] labels, TaintedBooleanWithObjTag ret) {
        ret.taint = null;
        ret.val = this.containsOnlyLabels(labels);
        return ret;
    }

    public TaintedBooleanWithIntTag containsOnlyLabels$$PHOSPHORTAGGED(Object[] labels, TaintedBooleanWithIntTag ret) {
        ret.taint = 0;
        ret.val = this.containsOnlyLabels(labels);
        return ret;
    }

    public TaintedBooleanWithObjTag containsOnlyLabels$$PHOSPHORTAGGED(Object[] labels, TaintedBooleanWithObjTag ret, ControlTaintTagStack ctrl) {
        ret.taint = null;
        ret.val = this.containsOnlyLabels(labels);
        return ret;
    }

    public boolean containsLabel(Object label) {
        if (label == null) {
            return true;
        }
        if (BIT_SET_CAPACITY > 0) {
            return label instanceof Integer && this.labelBitSet != null && this.labelBitSet.contains((Integer)label);
        }
        return this.labelSet != null && this.labelSet.contains(label);
    }

    public TaintedBooleanWithObjTag containsLabel$$PHOSPHORTAGGED(Object label, TaintedBooleanWithObjTag ret) {
        ret.taint = null;
        ret.val = this.containsLabel(label);
        return ret;
    }

    public TaintedBooleanWithIntTag containsLabel$$PHOSPHORTAGGED(Object label, TaintedBooleanWithIntTag ret) {
        ret.taint = 0;
        ret.val = this.containsLabel(label);
        return ret;
    }

    public TaintedBooleanWithObjTag containsLabel$$PHOSPHORTAGGED(Object label, TaintedBooleanWithObjTag ret, ControlTaintTagStack ctrl) {
        ret.taint = null;
        ret.val = this.containsLabel(label);
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Taint taint = (Taint)o;
        return taint.labelSet == this.labelSet && (this.labelBitSet == null && taint.labelBitSet == null || this.labelBitSet != null && this.labelBitSet.equals(taint.labelBitSet));
    }

    public int hashCode() {
        int result = this.labelSet == null ? 0 : this.labelSet.hashCode();
        result = 31 * result + (this.labelBitSet == null ? 0 : this.labelBitSet.hashCode());
        return result;
    }

    public static <T> Taint<T> copyTaint(Taint<T> in) {
        return in == null ? null : in.copy();
    }

    public static <T> Taint<T> _combineTagsInternal(Taint<T> t1, ControlTaintTagStack tags) {
        Taint tagsTaint;
        if (t1 == null && tags.taint == null && (!Configuration.IMPLICIT_EXCEPTION_FLOW || tags.influenceExceptions == null || tags.influenceExceptions.isEmpty())) {
            return null;
        }
        if (Configuration.IMPLICIT_EXCEPTION_FLOW) {
            if (tags.influenceExceptions == null || tags.influenceExceptions.isEmpty()) {
                if (tags.getTag() == null) {
                    return t1;
                }
                if (t1 == null) {
                    return tags.copyTag();
                }
                if (t1.contains(tags.getTag())) {
                    return t1;
                }
                if (tags.getTag().contains(t1)) {
                    return tags.copyTag();
                }
            }
            tagsTaint = tags.copyTagExceptions();
        } else {
            tagsTaint = tags.copyTag();
        }
        if (t1 == null || t1.isEmpty()) {
            return tagsTaint;
        }
        if (tagsTaint == null || tagsTaint.isEmpty()) {
            return t1;
        }
        if (t1 == tagsTaint) {
            return t1;
        }
        if (IGNORE_TAINTING) {
            return t1;
        }
        tagsTaint.addDependency(t1);
        return tagsTaint;
    }

    public static <T> Taint<T> combineTags(Taint<T> t1, ControlTaintTagStack tags) {
        if (t1 == null && tags.taint == null && (tags.influenceExceptions == null || tags.influenceExceptions.isEmpty())) {
            return null;
        }
        return Taint._combineTagsInternal(t1, tags);
    }

    public static <T> Taint<T> combineTaintArray(Taint<T>[] taints) {
        if (taints == null) {
            return null;
        }
        if (BIT_SET_CAPACITY > 0) {
            Taint<T> result = new Taint<T>();
            for (Taint<T> taint : taints) {
                result.addDependency(taint);
            }
            return result;
        }
        Taint<T> result = new Taint<T>();
        PowerSetTree.SetNode prevLabelSet = setTree.emptySet();
        for (Taint<T> taint : taints) {
            if (taint == null || taint.labelSet == prevLabelSet) continue;
            result.labelSet = result.labelSet.union(taint.labelSet);
            prevLabelSet = taint.labelSet;
        }
        return result;
    }

    public static void combineTagsOnObject(Object o, ControlTaintTagStack tags) {
        if ((tags.isEmpty() || IGNORE_TAINTING) && (!Configuration.IMPLICIT_EXCEPTION_FLOW || tags.influenceExceptions == null || tags.influenceExceptions.isEmpty())) {
            return;
        }
        if (Configuration.derivedTaintListener != null) {
            Configuration.derivedTaintListener.controlApplied(o, tags);
        }
        if (o instanceof String) {
            Taint.combineTagsOnString((String)o, tags);
        } else if (o instanceof TaintedWithObjTag) {
            ((TaintedWithObjTag)o).setPHOSPHOR_TAG(Taint.combineTags((Taint)((TaintedWithObjTag)o).getPHOSPHOR_TAG(), tags));
        }
    }

    private static void combineTagsOnString(String str, ControlTaintTagStack ctrl) {
        Taint existing = str.PHOSPHOR_TAG;
        str.PHOSPHOR_TAG = Taint.combineTags(existing, ctrl);
        LazyCharArrayObjTags tags = str.valuePHOSPHOR_TAG;
        if (tags == null) {
            tags = str.valuePHOSPHOR_TAG = new LazyCharArrayObjTags(str.value);
        }
        if (tags.taints == null) {
            tags.taints = new Taint[str.length()];
        }
        if (BIT_SET_CAPACITY > 0) {
            for (int i = 0; i < tags.taints.length; ++i) {
                tags.taints[i] = Taint.combineTags(tags.taints[i], ctrl);
            }
        } else {
            Taint originalPreviousTaint = null;
            for (int i = 0; i < tags.taints.length; ++i) {
                if (originalPreviousTaint != null && originalPreviousTaint.equals(tags.taints[i])) {
                    tags.taints[i].labelSet = tags.taints[i - 1].labelSet;
                    continue;
                }
                originalPreviousTaint = tags.taints[i];
                tags.taints[i] = Taint.combineTags(tags.taints[i], ctrl);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.labelSet != null) {
            out.writeObject(this.labelSet.toList());
        } else if (this.labelBitSet != null) {
            out.writeObject(this.labelBitSet.toList());
        } else {
            out.writeObject(new SimpleHashSet());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block3: {
            block2: {
                in.defaultReadObject();
                if (BIT_SET_CAPACITY <= 0) break block2;
                SinglyLinkedList list = (SinglyLinkedList)in.readObject();
                if (list.size() <= 0) break block3;
                this.labelBitSet = new BitSet(BIT_SET_CAPACITY);
                for (Object obj : list) {
                    if (!(obj instanceof Integer)) continue;
                    this.labelBitSet.add((Integer)obj);
                }
                break block3;
            }
            this.labelSet = setTree.emptySet();
            SinglyLinkedList list = (SinglyLinkedList)in.readObject();
            for (Object obj : list) {
                this.labelSet = this.labelSet.add(obj);
            }
        }
    }

    @Deprecated
    public T getLabel() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.getLabels(new Object[0])[0];
    }

    @Deprecated
    public SimpleHashSet<T> getDependencies() {
        SimpleHashSet<Object> set = new SimpleHashSet<Object>();
        Object[] labels = this.getLabels(new Object[0]);
        for (int i = 1; i < labels.length; ++i) {
            set.add(labels[i]);
        }
        return set;
    }

    @Deprecated
    public SimpleHashSet<T> getDependencies$$PHOSPHORTAGGED() {
        return this.getDependencies();
    }

    @Deprecated
    public boolean hasNoDependencies() {
        return this.isEmpty() || this.getLabels().length == 1;
    }

    @Deprecated
    public TaintedBooleanWithObjTag hasNoDependencies$$PHOSPHORTAGGED(TaintedBooleanWithObjTag ret) {
        ret.val = this.hasNoDependencies();
        ret.taint = null;
        return ret;
    }

    @Deprecated
    public TaintedBooleanWithObjTag hasNoDependencies$$PHOSPHORTAGGED(ControlTaintTagStack ctrl, TaintedBooleanWithObjTag ret) {
        ret.val = this.hasNoDependencies();
        ret.taint = null;
        return ret;
    }

    @Deprecated
    public void setBit(int bitIndex) {
        if (BIT_SET_CAPACITY > 0) {
            if (this.labelBitSet == null) {
                this.labelBitSet = new BitSet(BIT_SET_CAPACITY);
            }
            this.labelBitSet.add(bitIndex);
        }
    }

    @Deprecated
    public boolean hasBitSet(int bitIndex) {
        return this.labelBitSet != null && this.labelBitSet.contains(bitIndex);
    }

    @Deprecated
    public void setBits(long[] otherPackets) {
        if (BIT_SET_CAPACITY > 0) {
            if (this.labelBitSet == null) {
                this.labelBitSet = new BitSet(otherPackets);
            } else {
                this.labelBitSet.union(new BitSet(otherPackets));
            }
        }
    }

    @Deprecated
    public void setBits(BitSet other) {
        if (BIT_SET_CAPACITY > 0) {
            if (this.labelBitSet == null && other != null) {
                this.labelBitSet = other.copy();
            } else if (this.labelBitSet != null) {
                this.labelBitSet.union(other);
            }
        }
    }

    @Deprecated
    public long[] getTags() {
        return this.labelBitSet == null ? null : this.labelBitSet.getPackets();
    }

    @Deprecated
    public LazyLongArrayObjTags getTags$$PHOSPHORTAGGED() {
        return this.labelBitSet == null ? null : new LazyLongArrayObjTags(this.labelBitSet.getPackets());
    }

    @Deprecated
    public LazyLongArrayObjTags getTags$$PHOSPHORTAGGED(ControlTaintTagStack ctrl) {
        return this.labelBitSet == null ? null : new LazyLongArrayObjTags(this.labelBitSet.getPackets());
    }
}

