/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.runtime;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyBooleanArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyByteArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyCharArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyDoubleArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyFloatArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyIntArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyLongArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.LazyShortArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedByteWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedByteWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedLongWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedLongWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import sun.misc.Unsafe;

public class RuntimeUnsafePropagator {
    private static SinglyLinkedList<OffsetPair> getOffsetPairs(Unsafe unsafe, Class<?> targetClazz) {
        SinglyLinkedList<OffsetPair> list = new SinglyLinkedList<OffsetPair>();
        for (Class<?> clazz = targetClazz; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    Field taintField2;
                    long tagOffset;
                    long fieldOffset;
                    Class<?> fieldClazz = field.getType();
                    if (!Modifier.isStatic(fieldClazz.getModifiers()) && fieldClazz.isPrimitive()) {
                        fieldOffset = unsafe.objectFieldOffset(field);
                        tagOffset = -1L;
                        try {
                            taintField2 = clazz.getField(field.getName() + "PHOSPHOR_TAG");
                            if (Configuration.MULTI_TAINTING && taintField2.getType().equals(Configuration.TAINT_TAG_OBJ_CLASS)) {
                                tagOffset = unsafe.objectFieldOffset(taintField2);
                            } else if (!Configuration.MULTI_TAINTING && taintField2.getType().equals(Integer.TYPE)) {
                                tagOffset = unsafe.objectFieldOffset(taintField2);
                            }
                        }
                        catch (Exception taintField2) {
                            // empty catch block
                        }
                        list.enqueue(new OffsetPair(fieldOffset, tagOffset));
                        continue;
                    }
                    if (Modifier.isStatic(fieldClazz.getModifiers()) || !fieldClazz.isArray() || !fieldClazz.getComponentType().isPrimitive()) continue;
                    fieldOffset = unsafe.objectFieldOffset(field);
                    tagOffset = -1L;
                    try {
                        taintField2 = clazz.getField(field.getName() + "PHOSPHOR_TAG");
                        Class<?> taintClazz = taintField2.getType();
                        if (Configuration.MULTI_TAINTING && taintClazz != null && LazyArrayObjTags.class.isAssignableFrom(taintClazz)) {
                            tagOffset = unsafe.objectFieldOffset(taintField2);
                        } else if (!Configuration.MULTI_TAINTING && taintClazz != null && LazyArrayIntTags.class.isAssignableFrom(taintClazz)) {
                            tagOffset = unsafe.objectFieldOffset(taintField2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    list.enqueue(new OffsetPair(fieldOffset, tagOffset));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public static OffsetPair getOffsetPair(Unsafe unsafe, Object o, long offset) {
        try {
            if (o != null && o.getClass() != null) {
                if (o.getClass().$$PHOSPHOR_OFFSET_CACHE == null) {
                    o.getClass().$$PHOSPHOR_OFFSET_CACHE = RuntimeUnsafePropagator.getOffsetPairs(unsafe, o.getClass());
                }
                for (OffsetPair pair : o.getClass().$$PHOSPHOR_OFFSET_CACHE) {
                    if (pair.origFieldOffset != offset) continue;
                    return pair;
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getTag(Unsafe unsafe, Object obj, long offset, Object prealloc, SpecialAccessPolicy policy) {
        if (prealloc instanceof TaintedPrimitiveWithObjTag) {
            Object result;
            Object object = result = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getObjectVolatile(obj, offset) : unsafe.getObject(obj, offset);
            if (result instanceof Taint) {
                ((TaintedPrimitiveWithObjTag)prealloc).taint = (Taint)result;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedPrimitiveWithIntTag) {
            ((TaintedPrimitiveWithIntTag)prealloc).taint = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getIntVolatile(obj, offset) : unsafe.getInt(obj, offset);
            return prealloc;
        }
        return policy == SpecialAccessPolicy.VOLATILE ? unsafe.getObjectVolatile(obj, offset) : unsafe.getObject(obj, offset);
    }

    private static Object getValue(Unsafe unsafe, Object obj, long offset, Object prealloc, SpecialAccessPolicy policy) {
        if (prealloc instanceof TaintedByteWithObjTag || prealloc instanceof TaintedByteWithIntTag) {
            byte val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getByteVolatile(obj, offset) : unsafe.getByte(obj, offset);
            if (prealloc instanceof TaintedByteWithObjTag) {
                ((TaintedByteWithObjTag)prealloc).val = val;
            } else {
                ((TaintedByteWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedBooleanWithObjTag || prealloc instanceof TaintedBooleanWithIntTag) {
            boolean val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getBooleanVolatile(obj, offset) : unsafe.getBoolean(obj, offset);
            if (prealloc instanceof TaintedBooleanWithObjTag) {
                ((TaintedBooleanWithObjTag)prealloc).val = val;
            } else {
                ((TaintedBooleanWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedCharWithObjTag || prealloc instanceof TaintedCharWithIntTag) {
            char val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getCharVolatile(obj, offset) : unsafe.getChar(obj, offset);
            if (prealloc instanceof TaintedCharWithObjTag) {
                ((TaintedCharWithObjTag)prealloc).val = val;
            } else {
                ((TaintedCharWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedDoubleWithObjTag || prealloc instanceof TaintedDoubleWithIntTag) {
            double val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getDoubleVolatile(obj, offset) : unsafe.getDouble(obj, offset);
            if (prealloc instanceof TaintedDoubleWithObjTag) {
                ((TaintedDoubleWithObjTag)prealloc).val = val;
            } else {
                ((TaintedDoubleWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedFloatWithObjTag || prealloc instanceof TaintedFloatWithIntTag) {
            float val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getFloatVolatile(obj, offset) : unsafe.getFloat(obj, offset);
            if (prealloc instanceof TaintedFloatWithObjTag) {
                ((TaintedFloatWithObjTag)prealloc).val = val;
            } else {
                ((TaintedFloatWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedIntWithObjTag || prealloc instanceof TaintedIntWithIntTag) {
            int val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getIntVolatile(obj, offset) : unsafe.getInt(obj, offset);
            if (prealloc instanceof TaintedIntWithObjTag) {
                ((TaintedIntWithObjTag)prealloc).val = val;
            } else {
                ((TaintedIntWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedLongWithObjTag || prealloc instanceof TaintedLongWithIntTag) {
            long val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getLongVolatile(obj, offset) : unsafe.getLong(obj, offset);
            if (prealloc instanceof TaintedLongWithObjTag) {
                ((TaintedLongWithObjTag)prealloc).val = val;
            } else {
                ((TaintedLongWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        if (prealloc instanceof TaintedShortWithObjTag || prealloc instanceof TaintedShortWithIntTag) {
            short val = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getShortVolatile(obj, offset) : unsafe.getShort(obj, offset);
            if (prealloc instanceof TaintedShortWithObjTag) {
                ((TaintedShortWithObjTag)prealloc).val = val;
            } else {
                ((TaintedShortWithIntTag)prealloc).val = val;
            }
            return prealloc;
        }
        prealloc = policy == SpecialAccessPolicy.VOLATILE ? unsafe.getObjectVolatile(obj, offset) : unsafe.getObject(obj, offset);
        return MultiDTaintedArray.boxOnly1D(prealloc);
    }

    private static void putTag(Unsafe unsafe, Object obj, long offset, Object value, SpecialAccessPolicy policy) {
        if (value instanceof TaintedPrimitiveWithObjTag || value instanceof LazyArrayIntTags || value instanceof LazyArrayObjTags || value == null) {
            Object tag = value instanceof TaintedPrimitiveWithObjTag ? ((TaintedPrimitiveWithObjTag)value).taint : value;
            switch (policy) {
                case ORDERED: {
                    unsafe.putOrderedObject(obj, offset, tag);
                    break;
                }
                case VOLATILE: {
                    unsafe.putObjectVolatile(obj, offset, tag);
                    break;
                }
                default: {
                    unsafe.putObject(obj, offset, tag);
                    break;
                }
            }
        } else if (value instanceof TaintedPrimitiveWithIntTag) {
            int tag = ((TaintedPrimitiveWithIntTag)value).taint;
            switch (policy) {
                case ORDERED: {
                    unsafe.putOrderedInt(obj, offset, tag);
                    break;
                }
                case VOLATILE: {
                    unsafe.putIntVolatile(obj, offset, tag);
                    break;
                }
                default: {
                    unsafe.putInt(obj, offset, tag);
                }
            }
        }
    }

    private static void putValue(Unsafe unsafe, Object obj, long offset, Object value, SpecialAccessPolicy policy) {
        if (value instanceof TaintedByteWithObjTag || value instanceof TaintedByteWithIntTag) {
            byte val;
            byte by = val = value instanceof TaintedByteWithObjTag ? ((TaintedByteWithObjTag)value).val : ((TaintedByteWithIntTag)value).val;
            if (policy == SpecialAccessPolicy.VOLATILE) {
                unsafe.putByteVolatile(obj, offset, val);
            } else {
                unsafe.putByte(obj, offset, val);
            }
        } else if (value instanceof TaintedBooleanWithObjTag || value instanceof TaintedBooleanWithIntTag) {
            boolean val;
            boolean bl = val = value instanceof TaintedBooleanWithObjTag ? ((TaintedBooleanWithObjTag)value).val : ((TaintedBooleanWithIntTag)value).val;
            if (policy == SpecialAccessPolicy.VOLATILE) {
                unsafe.putBooleanVolatile(obj, offset, val);
            } else {
                unsafe.putBoolean(obj, offset, val);
            }
        } else if (value instanceof TaintedCharWithObjTag || value instanceof TaintedCharWithIntTag) {
            char val;
            char c = val = value instanceof TaintedCharWithObjTag ? ((TaintedCharWithObjTag)value).val : ((TaintedCharWithIntTag)value).val;
            if (policy == SpecialAccessPolicy.VOLATILE) {
                unsafe.putCharVolatile(obj, offset, val);
            } else {
                unsafe.putChar(obj, offset, val);
            }
        } else if (value instanceof TaintedDoubleWithObjTag || value instanceof TaintedDoubleWithIntTag) {
            double val;
            double d = val = value instanceof TaintedDoubleWithObjTag ? ((TaintedDoubleWithObjTag)value).val : ((TaintedDoubleWithIntTag)value).val;
            if (policy == SpecialAccessPolicy.VOLATILE) {
                unsafe.putDoubleVolatile(obj, offset, val);
            } else {
                unsafe.putDouble(obj, offset, val);
            }
        } else if (value instanceof TaintedFloatWithObjTag || value instanceof TaintedFloatWithIntTag) {
            float val;
            float f = val = value instanceof TaintedFloatWithObjTag ? ((TaintedFloatWithObjTag)value).val : ((TaintedFloatWithIntTag)value).val;
            if (policy == SpecialAccessPolicy.VOLATILE) {
                unsafe.putFloatVolatile(obj, offset, val);
            } else {
                unsafe.putFloat(obj, offset, val);
            }
        } else if (value instanceof TaintedIntWithObjTag || value instanceof TaintedIntWithIntTag) {
            int val = value instanceof TaintedIntWithObjTag ? ((TaintedIntWithObjTag)value).val : ((TaintedIntWithIntTag)value).val;
            switch (policy) {
                case ORDERED: {
                    unsafe.putOrderedInt(obj, offset, val);
                    break;
                }
                case VOLATILE: {
                    unsafe.putIntVolatile(obj, offset, val);
                    break;
                }
                default: {
                    unsafe.putInt(obj, offset, val);
                    break;
                }
            }
        } else if (value instanceof TaintedLongWithObjTag || value instanceof TaintedLongWithIntTag) {
            long val = value instanceof TaintedLongWithObjTag ? ((TaintedLongWithObjTag)value).val : ((TaintedLongWithIntTag)value).val;
            switch (policy) {
                case ORDERED: {
                    unsafe.putOrderedLong(obj, offset, val);
                    break;
                }
                case VOLATILE: {
                    unsafe.putLongVolatile(obj, offset, val);
                    break;
                }
                default: {
                    unsafe.putLong(obj, offset, val);
                    break;
                }
            }
        } else if (value instanceof TaintedShortWithObjTag || value instanceof TaintedShortWithIntTag) {
            short val;
            short s = val = value instanceof TaintedShortWithObjTag ? ((TaintedShortWithObjTag)value).val : ((TaintedShortWithIntTag)value).val;
            if (policy == SpecialAccessPolicy.VOLATILE) {
                unsafe.putShortVolatile(obj, offset, val);
            } else {
                unsafe.putShort(obj, offset, val);
            }
        } else if (value instanceof LazyArrayObjTags || value instanceof LazyArrayIntTags) {
            Object val = value instanceof LazyArrayObjTags ? ((LazyArrayObjTags)value).getVal() : ((LazyArrayIntTags)value).getVal();
            switch (policy) {
                case ORDERED: {
                    unsafe.putOrderedObject(obj, offset, val);
                    break;
                }
                case VOLATILE: {
                    unsafe.putObjectVolatile(obj, offset, val);
                    break;
                }
                default: {
                    unsafe.putObject(obj, offset, val);
                    break;
                }
            }
        } else {
            switch (policy) {
                case ORDERED: {
                    unsafe.putOrderedObject(obj, offset, value);
                    break;
                }
                case VOLATILE: {
                    unsafe.putObjectVolatile(obj, offset, value);
                    break;
                }
                default: {
                    unsafe.putObject(obj, offset, value);
                }
            }
        }
    }

    private static boolean putArrayElement(Unsafe unsafe, LazyArrayObjTags tags, long offset, TaintedPrimitiveWithObjTag value) {
        if (tags.getVal() != null && tags.getVal().getClass().isArray()) {
            Class<?> clazz = tags.getVal().getClass();
            long baseOffset = unsafe.arrayBaseOffset(clazz);
            long scale = unsafe.arrayIndexScale(clazz);
            int index = (int)((offset - baseOffset) / scale);
            if (tags instanceof LazyBooleanArrayObjTags && value instanceof TaintedBooleanWithObjTag) {
                ((LazyBooleanArrayObjTags)tags).set(null, index, value.taint, ((TaintedBooleanWithObjTag)value).val);
            } else if (tags instanceof LazyByteArrayObjTags && value instanceof TaintedByteWithObjTag) {
                ((LazyByteArrayObjTags)tags).set(null, index, value.taint, ((TaintedByteWithObjTag)value).val);
            } else if (tags instanceof LazyCharArrayObjTags && value instanceof TaintedCharWithObjTag) {
                ((LazyCharArrayObjTags)tags).set(null, index, value.taint, ((TaintedCharWithObjTag)value).val);
            } else if (tags instanceof LazyDoubleArrayObjTags && value instanceof TaintedDoubleWithObjTag) {
                ((LazyDoubleArrayObjTags)tags).set(null, index, value.taint, ((TaintedDoubleWithObjTag)value).val);
            } else if (tags instanceof LazyFloatArrayObjTags && value instanceof TaintedFloatWithObjTag) {
                ((LazyFloatArrayObjTags)tags).set(null, index, value.taint, ((TaintedFloatWithObjTag)value).val);
            } else if (tags instanceof LazyIntArrayObjTags && value instanceof TaintedIntWithObjTag) {
                ((LazyIntArrayObjTags)tags).set(null, index, value.taint, ((TaintedIntWithObjTag)value).val);
            } else if (tags instanceof LazyLongArrayObjTags && value instanceof TaintedLongWithObjTag) {
                ((LazyLongArrayObjTags)tags).set(null, index, value.taint, ((TaintedLongWithObjTag)value).val);
            } else if (tags instanceof LazyShortArrayObjTags && value instanceof TaintedShortWithObjTag) {
                ((LazyShortArrayObjTags)tags).set(null, index, value.taint, ((TaintedShortWithObjTag)value).val);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean getArrayElement(Unsafe unsafe, LazyArrayObjTags tags, long offset, TaintedPrimitiveWithObjTag prealloc) {
        if (tags.getVal() != null && tags.getVal().getClass().isArray()) {
            Class<?> clazz = tags.getVal().getClass();
            long baseOffset = unsafe.arrayBaseOffset(clazz);
            long scale = unsafe.arrayIndexScale(clazz);
            int index = (int)((offset - baseOffset) / scale);
            if (tags instanceof LazyBooleanArrayObjTags && prealloc instanceof TaintedBooleanWithObjTag) {
                ((LazyBooleanArrayObjTags)tags).get(null, index, (TaintedBooleanWithObjTag)prealloc);
            } else if (tags instanceof LazyByteArrayObjTags && prealloc instanceof TaintedByteWithObjTag) {
                ((LazyByteArrayObjTags)tags).get(null, index, (TaintedByteWithObjTag)prealloc);
            } else if (tags instanceof LazyCharArrayObjTags && prealloc instanceof TaintedCharWithObjTag) {
                ((LazyCharArrayObjTags)tags).get(null, index, (TaintedCharWithObjTag)prealloc);
            } else if (tags instanceof LazyDoubleArrayObjTags && prealloc instanceof TaintedDoubleWithObjTag) {
                ((LazyDoubleArrayObjTags)tags).get(null, index, (TaintedDoubleWithObjTag)prealloc);
            } else if (tags instanceof LazyFloatArrayObjTags && prealloc instanceof TaintedFloatWithObjTag) {
                ((LazyFloatArrayObjTags)tags).get(null, index, (TaintedFloatWithObjTag)prealloc);
            } else if (tags instanceof LazyIntArrayObjTags && prealloc instanceof TaintedIntWithObjTag) {
                ((LazyIntArrayObjTags)tags).get(null, index, (TaintedIntWithObjTag)prealloc);
            } else if (tags instanceof LazyLongArrayObjTags && prealloc instanceof TaintedLongWithObjTag) {
                ((LazyLongArrayObjTags)tags).get(null, index, (TaintedLongWithObjTag)prealloc);
            } else if (tags instanceof LazyShortArrayObjTags && prealloc instanceof TaintedShortWithObjTag) {
                ((LazyShortArrayObjTags)tags).get(null, index, (TaintedShortWithObjTag)prealloc);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    private static void put(Unsafe unsafe, Object obj, long offset, Object value, SpecialAccessPolicy policy) {
        if (obj instanceof LazyArrayObjTags && value instanceof TaintedPrimitiveWithObjTag && RuntimeUnsafePropagator.putArrayElement(unsafe, (LazyArrayObjTags)obj, offset, (TaintedPrimitiveWithObjTag)value)) {
            return;
        }
        if (value instanceof TaintedPrimitiveWithObjTag || value instanceof TaintedPrimitiveWithIntTag) {
            obj = MultiDTaintedArray.unbox1D(obj);
        }
        if (obj != null && (value == null || value instanceof TaintedPrimitiveWithObjTag || value instanceof TaintedPrimitiveWithIntTag || value instanceof LazyArrayObjTags || value instanceof LazyArrayIntTags)) {
            OffsetPair pair = RuntimeUnsafePropagator.getOffsetPair(unsafe, obj, offset);
            if (pair == null && (value instanceof LazyArrayObjTags || value instanceof LazyArrayIntTags)) {
                RuntimeUnsafePropagator.putTag(unsafe, obj, offset, value, policy);
            } else if (pair == null) {
                RuntimeUnsafePropagator.putValue(unsafe, obj, offset, value, policy);
            } else {
                if (pair.origFieldOffset != -1L && offset != pair.tagFieldOffset) {
                    RuntimeUnsafePropagator.putValue(unsafe, obj, pair.origFieldOffset, value, policy);
                }
                if (pair.tagFieldOffset != -1L) {
                    RuntimeUnsafePropagator.putTag(unsafe, obj, pair.tagFieldOffset, value, policy);
                }
            }
        } else {
            RuntimeUnsafePropagator.putValue(unsafe, obj, offset, value, policy);
        }
    }

    private static Object get(Unsafe unsafe, Object obj, long offset, Object prealloc, SpecialAccessPolicy policy) {
        if (obj instanceof LazyArrayObjTags && prealloc instanceof TaintedPrimitiveWithObjTag && RuntimeUnsafePropagator.getArrayElement(unsafe, (LazyArrayObjTags)obj, offset, (TaintedPrimitiveWithObjTag)prealloc)) {
            return prealloc;
        }
        if (prealloc instanceof TaintedPrimitiveWithObjTag || prealloc instanceof TaintedPrimitiveWithIntTag) {
            obj = MultiDTaintedArray.unbox1D(obj);
        }
        if (obj == null) {
            return RuntimeUnsafePropagator.getValue(unsafe, null, offset, prealloc, policy);
        }
        OffsetPair pair = RuntimeUnsafePropagator.getOffsetPair(unsafe, obj, offset);
        if (pair == null) {
            return RuntimeUnsafePropagator.getValue(unsafe, obj, offset, prealloc, policy);
        }
        if (pair.origFieldOffset != -1L) {
            prealloc = RuntimeUnsafePropagator.getValue(unsafe, obj, pair.origFieldOffset, prealloc, policy);
        }
        if (pair.tagFieldOffset != -1L) {
            prealloc = RuntimeUnsafePropagator.getTag(unsafe, obj, pair.tagFieldOffset, prealloc, policy);
        }
        return prealloc;
    }

    public static void put(Unsafe unsafe, Object obj, long offset, Object value) {
        RuntimeUnsafePropagator.put(unsafe, obj, offset, value, SpecialAccessPolicy.NONE);
    }

    public static void putVolatile(Unsafe unsafe, Object obj, long offset, Object value) {
        RuntimeUnsafePropagator.put(unsafe, obj, offset, value, SpecialAccessPolicy.VOLATILE);
    }

    public static void putOrdered(Unsafe unsafe, Object obj, long offset, Object value) {
        RuntimeUnsafePropagator.put(unsafe, obj, offset, value, SpecialAccessPolicy.ORDERED);
    }

    public static Object get(Unsafe unsafe, Object obj, long offset, Object prealloc) {
        return RuntimeUnsafePropagator.get(unsafe, obj, offset, prealloc, SpecialAccessPolicy.NONE);
    }

    public static Object getVolatile(Unsafe unsafe, Object obj, long offset, Object prealloc) {
        return RuntimeUnsafePropagator.get(unsafe, obj, offset, prealloc, SpecialAccessPolicy.VOLATILE);
    }

    private static void swapArrayElementTag(Unsafe unsafe, LazyArrayObjTags tags, long offset, TaintedPrimitiveWithObjTag value) {
        if (tags.getVal() != null && tags.getVal().getClass().isArray()) {
            Class<?> clazz = tags.getVal().getClass();
            long baseOffset = unsafe.arrayBaseOffset(clazz);
            long scale = unsafe.arrayIndexScale(clazz);
            int index = (int)((offset - baseOffset) / scale);
            if (tags instanceof LazyIntArrayObjTags && value instanceof TaintedIntWithObjTag) {
                LazyIntArrayObjTags intTags = (LazyIntArrayObjTags)tags;
                if (intTags.taints == null && value.taint != null) {
                    intTags.taints = new Taint[intTags.getLength()];
                }
                if (intTags.taints != null) {
                    intTags.taints[index] = value.taint;
                }
            } else if (tags instanceof LazyLongArrayObjTags && value instanceof TaintedLongWithObjTag) {
                LazyLongArrayObjTags longTags = (LazyLongArrayObjTags)tags;
                if (longTags.taints == null && value.taint != null) {
                    longTags.taints = new Taint[longTags.getLength()];
                }
                if (longTags.taints != null) {
                    longTags.taints[index] = value.taint;
                }
            }
        }
    }

    public static boolean compareAndSwap(Unsafe unsafe, Object obj, long offset, Object expected, Object value) {
        boolean result;
        LazyArrayObjTags lazyArr = null;
        if (obj instanceof LazyArrayObjTags && value instanceof TaintedPrimitiveWithObjTag) {
            lazyArr = (LazyArrayObjTags)obj;
        }
        if (value instanceof TaintedPrimitiveWithObjTag || value instanceof TaintedPrimitiveWithIntTag) {
            obj = MultiDTaintedArray.unbox1D(obj);
        }
        OffsetPair pair = null;
        if (obj != null && (value == null || value instanceof TaintedPrimitiveWithObjTag || value instanceof TaintedPrimitiveWithIntTag || value instanceof LazyArrayObjTags || value instanceof LazyArrayIntTags)) {
            pair = RuntimeUnsafePropagator.getOffsetPair(unsafe, obj, offset);
        }
        if ((result = pair == null && (value instanceof LazyArrayObjTags || value instanceof LazyArrayIntTags) ? unsafe.compareAndSwapObject(obj, offset, expected, value) : (expected instanceof TaintedIntWithObjTag && value instanceof TaintedIntWithObjTag ? unsafe.compareAndSwapInt(MultiDTaintedArray.unbox1D(obj), offset, ((TaintedIntWithObjTag)expected).val, ((TaintedIntWithObjTag)value).val) : (expected instanceof TaintedIntWithIntTag && value instanceof TaintedIntWithIntTag ? unsafe.compareAndSwapInt(MultiDTaintedArray.unbox1D(obj), offset, ((TaintedIntWithIntTag)expected).val, ((TaintedIntWithIntTag)value).val) : (expected instanceof TaintedLongWithObjTag && value instanceof TaintedLongWithObjTag ? unsafe.compareAndSwapLong(MultiDTaintedArray.unbox1D(obj), offset, ((TaintedLongWithObjTag)expected).val, ((TaintedLongWithObjTag)value).val) : (expected instanceof TaintedLongWithIntTag && value instanceof TaintedLongWithIntTag ? unsafe.compareAndSwapLong(MultiDTaintedArray.unbox1D(obj), offset, ((TaintedLongWithIntTag)expected).val, ((TaintedLongWithIntTag)value).val) : unsafe.compareAndSwapObject(obj, offset, MultiDTaintedArray.unbox1D(expected), MultiDTaintedArray.unbox1D(value))))))) && pair != null && pair.tagFieldOffset != -1L) {
            RuntimeUnsafePropagator.putTag(unsafe, obj, pair.tagFieldOffset, value, SpecialAccessPolicy.VOLATILE);
        } else if (result && lazyArr != null) {
            RuntimeUnsafePropagator.swapArrayElementTag(unsafe, lazyArr, offset, (TaintedPrimitiveWithObjTag)value);
        }
        return result;
    }

    private static enum SpecialAccessPolicy {
        VOLATILE,
        ORDERED,
        NONE;

    }

    public static class OffsetPair {
        public final long origFieldOffset;
        public final long tagFieldOffset;

        public OffsetPair(long origFieldOffset, long tagFieldOffset) {
            this.origFieldOffset = origFieldOffset;
            this.tagFieldOffset = tagFieldOffset;
        }

        public boolean equals(Object other) {
            return other instanceof OffsetPair && this.origFieldOffset == ((OffsetPair)other).origFieldOffset;
        }

        public int hashCode() {
            return (int)(this.origFieldOffset ^ this.origFieldOffset >>> 32);
        }

        public String toString() {
            return String.format("{field @ %d -> tag @ %d}", this.origFieldOffset, this.tagFieldOffset);
        }
    }
}

