/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.runtime;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.runtime.BoxedPrimitiveStoreWithIntTags;
import edu.columbia.cs.psl.phosphor.runtime.MultiTainter;
import edu.columbia.cs.psl.phosphor.runtime.RuntimeUnsafePropagator;
import edu.columbia.cs.psl.phosphor.runtime.Taint;
import edu.columbia.cs.psl.phosphor.runtime.TaintSentinel;
import edu.columbia.cs.psl.phosphor.runtime.UninstrumentedTaintSentinel;
import edu.columbia.cs.psl.phosphor.struct.ArrayList;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.MethodInvoke;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedByteWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedByteWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedCharWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedDoubleWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedFloatWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedIntWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedLongWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedLongWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedShortWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArrayWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArrayWithObjTag;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

public class ReflectionMasker {
    private static final boolean IS_KAFFE = false;
    static boolean isSelectiveInstManagerInit;
    private static final String multiDDescriptor = "edu.columbia.cs.psl.phosphor.struct.Lazy";
    private static final int multiDDescriptorLength;
    private static final char[] SET_TAG_METHOD_CHARS;
    private static final int SET_TAG_METHOD_LEN;
    private static final char[] METHOD_SUFFIX_CHARS;
    private static final int METHOD_SUFFIX_LEN;
    private static final char[] METHOD_SUFFIX_UNINST_CHARS;
    private static final char[] FIELD_SUFFIX_CHARS;
    private static final int FIELD_METHOD_SUFFIX_LEN;
    private static ReflectionFactory reflectionFactory;

    public static Object getObject$$PHOSPHORTAGGED(Unsafe u, Object obj, Taint tag, long offset, ControlTaintTagStack ctrl) {
        return ReflectionMasker.getObject$$PHOSPHORTAGGED(u, obj, null, offset);
    }

    public static Object getObject$$PHOSPHORTAGGED(Unsafe u, Object obj, int tag, long offset) {
        return ReflectionMasker.getObject$$PHOSPHORTAGGED(u, obj, null, offset);
    }

    public static Object getObject$$PHOSPHORTAGGED(Unsafe u, Object obj, Taint tag, long offset) {
        return RuntimeUnsafePropagator.get(u, obj, offset, null);
    }

    public static void putObject$$PHOSPHORTAGGED(Unsafe u, Object obj, Taint tag, long fieldOffset, Object val, ControlTaintTagStack ctrl) {
        ReflectionMasker.putObject$$PHOSPHORTAGGED(u, obj, tag, fieldOffset, val);
    }

    public static void putObject$$PHOSPHORTAGGED(Unsafe u, Object obj, int tag, long fieldOffset, Object val) {
        if (val instanceof LazyArrayIntTags) {
            try {
                RuntimeUnsafePropagator.OffsetPair pair = RuntimeUnsafePropagator.getOffsetPair(u, obj, fieldOffset);
                if (pair != null) {
                    if (pair.origFieldOffset != -1L) {
                        u.putObject(obj, pair.origFieldOffset, MultiDTaintedArray.unbox1D(val));
                    }
                    if (pair.tagFieldOffset != -1L) {
                        u.putObject(obj, pair.tagFieldOffset, val);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        u.putObject(obj, fieldOffset, val);
    }

    public static void putObject$$PHOSPHORTAGGED(Unsafe u, Object obj, Taint<?> tag, long fieldOffset, Object val) {
        if (val instanceof LazyArrayObjTags) {
            try {
                RuntimeUnsafePropagator.OffsetPair pair = RuntimeUnsafePropagator.getOffsetPair(u, obj, fieldOffset);
                if (pair != null) {
                    if (pair.origFieldOffset != -1L) {
                        u.putObject(obj, pair.origFieldOffset, MultiDTaintedArray.unbox1D(val));
                    }
                    if (pair.tagFieldOffset != -1L) {
                        u.putObject(obj, pair.tagFieldOffset, val);
                    }
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        u.putObject(obj, fieldOffset, val);
    }

    public static TaintedBooleanWithIntTag isInstance(Class<?> c1, Object o, TaintedBooleanWithIntTag ret) {
        ret.taint = 0;
        ret.val = o instanceof LazyArrayIntTags && !LazyArrayIntTags.class.isAssignableFrom(c1) ? c1.isInstance(MultiDTaintedArrayWithIntTag.unboxRaw(o)) : c1.isInstance(o);
        return ret;
    }

    public static TaintedBooleanWithObjTag isInstance(Class<?> c1, Object o, ControlTaintTagStack ctrl, TaintedBooleanWithObjTag ret) {
        return ReflectionMasker.isInstance(c1, o, ret);
    }

    public static TaintedBooleanWithObjTag isInstance(Class<?> c1, Object o, TaintedBooleanWithObjTag ret) {
        ret.taint = null;
        ret.val = o instanceof LazyArrayObjTags && !LazyArrayObjTags.class.isAssignableFrom(c1) ? c1.isInstance(MultiDTaintedArrayWithObjTag.unboxRaw(o)) : c1.isInstance(o);
        return ret;
    }

    public static String getPropertyHideBootClasspath(String prop) {
        if (prop.equals("sun.boot.class.path")) {
            return null;
        }
        if (prop.equals("os.name")) {
            return "linux";
        }
        return System.getProperty(prop);
    }

    public static Method getTaintMethodControlTrack(Method m) {
        if (m.getDeclaringClass().isAnnotation()) {
            return m;
        }
        char[] chars = m.getName().toCharArray();
        if (chars.length > METHOD_SUFFIX_LEN) {
            int i;
            boolean isEq = true;
            int x = 0;
            for (i = chars.length - METHOD_SUFFIX_LEN; i < chars.length; ++i) {
                if (chars[i] != METHOD_SUFFIX_CHARS[x]) {
                    isEq = false;
                }
                ++x;
            }
            if (isEq) {
                m.PHOSPHOR_TAGmarked = true;
                return m;
            }
            x = 0;
            if (Configuration.GENERATE_UNINST_STUBS && chars.length > METHOD_SUFFIX_LEN + 2) {
                for (i = chars.length - METHOD_SUFFIX_LEN - 2; i < chars.length; ++i) {
                    if (chars[i] != METHOD_SUFFIX_UNINST_CHARS[x]) {
                        isEq = false;
                    }
                    ++x;
                }
            }
            if (isEq) {
                m.PHOSPHOR_TAGmarked = true;
                return m;
            }
        }
        if (ReflectionMasker.declaredInIgnoredClass(m)) {
            return m;
        }
        ArrayList<Class> newArgs = new ArrayList<Class>();
        boolean madeChange = false;
        for (Class<?> c : m.getParameterTypes()) {
            if (c.isArray()) {
                if (c.getComponentType().isPrimitive()) {
                    madeChange = true;
                    try {
                        newArgs.add(Class.forName(MultiDTaintedArrayWithObjTag.getTypeForType(Type.getType(c)).getInternalName().replace('/', '.')));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    newArgs.add(c);
                    continue;
                }
                Class<?> elementType = c.getComponentType();
                while (elementType.isArray()) {
                    elementType = c.getComponentType();
                }
                if (elementType.isPrimitive()) {
                    madeChange = true;
                    try {
                        newArgs.add(Class.forName(MultiDTaintedArrayWithObjTag.getTypeForType(Type.getType(c)).getInternalName().replace('/', '.')));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                newArgs.add(c);
                continue;
            }
            if (c.isPrimitive()) {
                madeChange = true;
                newArgs.add(Configuration.TAINT_TAG_OBJ_CLASS);
                newArgs.add(c);
                continue;
            }
            newArgs.add(c);
        }
        madeChange = true;
        newArgs.add(ControlTaintTagStack.class);
        Class<?> returnType = m.getReturnType();
        if (returnType.isPrimitive() && returnType != Void.TYPE) {
            if (returnType == Integer.TYPE) {
                newArgs.add(TaintedIntWithObjTag.class);
            } else if (returnType == Short.TYPE) {
                newArgs.add(TaintedShortWithObjTag.class);
            } else if (returnType == Float.TYPE) {
                newArgs.add(TaintedFloatWithObjTag.class);
            } else if (returnType == Double.TYPE) {
                newArgs.add(TaintedDoubleWithObjTag.class);
            } else if (returnType == Long.TYPE) {
                newArgs.add(TaintedLongWithObjTag.class);
            } else if (returnType == Character.TYPE) {
                newArgs.add(TaintedCharWithObjTag.class);
            } else if (returnType == Byte.TYPE) {
                newArgs.add(TaintedByteWithObjTag.class);
            } else if (returnType == Boolean.TYPE) {
                newArgs.add(TaintedBooleanWithObjTag.class);
            }
            madeChange = true;
        }
        if (madeChange) {
            Class[] args = new Class[newArgs.size()];
            newArgs.toArray(args);
            Method ret = null;
            try {
                ret = m.getDeclaringClass().getDeclaredMethod(m.getName() + "$$PHOSPHORTAGGED", args);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            return ret;
        }
        return m;
    }

    public static Method getTaintMethod(Method m, boolean isObjTags) {
        if (m.PHOSPHOR_TAGmarked && m.PHOSPHOR_TAGmethod != null) {
            return m;
        }
        if (!m.PHOSPHOR_TAGmarked && m.PHOSPHOR_TAGmethod != null) {
            return m.PHOSPHOR_TAGmethod;
        }
        if (m.getDeclaringClass().isAnnotation()) {
            return m;
        }
        char[] chars = m.getName().toCharArray();
        if (chars.length > METHOD_SUFFIX_LEN) {
            int i;
            boolean isEq = true;
            int x = 0;
            for (i = chars.length - METHOD_SUFFIX_LEN; i < chars.length; ++i) {
                if (chars[i] != METHOD_SUFFIX_CHARS[x]) {
                    isEq = false;
                }
                ++x;
            }
            if (isEq) {
                m.PHOSPHOR_TAGmarked = true;
                return m;
            }
            x = 0;
            if (Configuration.GENERATE_UNINST_STUBS && chars.length > METHOD_SUFFIX_LEN + 2) {
                for (i = chars.length - METHOD_SUFFIX_LEN - 2; i < chars.length; ++i) {
                    if (chars[i] != METHOD_SUFFIX_UNINST_CHARS[x]) {
                        isEq = false;
                    }
                    ++x;
                }
            }
            if (isEq) {
                m.PHOSPHOR_TAGmarked = true;
                return m;
            }
        }
        ArrayList<Class> newArgs = new ArrayList<Class>();
        boolean madeChange = false;
        for (Class<?> c : m.getParameterTypes()) {
            if (c.isArray()) {
                if (c.getComponentType().isPrimitive()) {
                    madeChange = true;
                    newArgs.add(MultiDTaintedArray.getUnderlyingBoxClassForUnderlyingClass(c));
                    newArgs.add(c);
                    continue;
                }
                Class<?> elementType = c.getComponentType();
                while (elementType.isArray()) {
                    elementType = elementType.getComponentType();
                }
                if (elementType.isPrimitive()) {
                    madeChange = true;
                    try {
                        if (isObjTags) {
                            newArgs.add(Class.forName(MultiDTaintedArrayWithObjTag.getTypeForType(Type.getType(c)).getInternalName()));
                            continue;
                        }
                        newArgs.add(Class.forName(MultiDTaintedArrayWithIntTag.getTypeForType(Type.getType(c)).getInternalName()));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                newArgs.add(c);
                continue;
            }
            if (c.isPrimitive()) {
                madeChange = true;
                if (isObjTags) {
                    newArgs.add(Configuration.TAINT_TAG_OBJ_CLASS);
                } else {
                    newArgs.add(Integer.TYPE);
                }
                newArgs.add(c);
                continue;
            }
            newArgs.add(c);
        }
        Class<?> returnType = m.getReturnType();
        if (!isObjTags) {
            if (!returnType.isArray() && returnType.isPrimitive() && returnType != Void.TYPE) {
                if (returnType == Integer.TYPE) {
                    newArgs.add(TaintedIntWithIntTag.class);
                } else if (returnType == Short.TYPE) {
                    newArgs.add(TaintedShortWithIntTag.class);
                } else if (returnType == Float.TYPE) {
                    newArgs.add(TaintedFloatWithIntTag.class);
                } else if (returnType == Double.TYPE) {
                    newArgs.add(TaintedDoubleWithIntTag.class);
                } else if (returnType == Long.TYPE) {
                    newArgs.add(TaintedLongWithIntTag.class);
                } else if (returnType == Character.TYPE) {
                    newArgs.add(TaintedCharWithIntTag.class);
                } else if (returnType == Byte.TYPE) {
                    newArgs.add(TaintedByteWithIntTag.class);
                } else if (returnType == Boolean.TYPE) {
                    newArgs.add(TaintedBooleanWithIntTag.class);
                }
                madeChange = true;
            }
        } else if (!returnType.isArray() && returnType.isPrimitive() && returnType != Void.TYPE) {
            if (returnType == Integer.TYPE) {
                newArgs.add(TaintedIntWithObjTag.class);
            } else if (returnType == Short.TYPE) {
                newArgs.add(TaintedShortWithObjTag.class);
            } else if (returnType == Float.TYPE) {
                newArgs.add(TaintedFloatWithObjTag.class);
            } else if (returnType == Double.TYPE) {
                newArgs.add(TaintedDoubleWithObjTag.class);
            } else if (returnType == Long.TYPE) {
                newArgs.add(TaintedLongWithObjTag.class);
            } else if (returnType == Character.TYPE) {
                newArgs.add(TaintedCharWithObjTag.class);
            } else if (returnType == Byte.TYPE) {
                newArgs.add(TaintedByteWithObjTag.class);
            } else if (returnType == Boolean.TYPE) {
                newArgs.add(TaintedBooleanWithObjTag.class);
            }
            madeChange = true;
        }
        if (madeChange) {
            Class[] args = new Class[newArgs.size()];
            newArgs.toArray(args);
            Method ret = null;
            try {
                ret = m.getDeclaringClass().getDeclaredMethod(m.getName() + "$$PHOSPHORTAGGED", args);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            ret.PHOSPHOR_TAGmarked = true;
            m.PHOSPHOR_TAGmethod = ret;
            ret.PHOSPHOR_TAGmethod = m;
            return ret;
        }
        m.PHOSPHOR_TAGmarked = false;
        m.PHOSPHOR_TAGmethod = m;
        return m;
    }

    public static Method getUnTaintMethod(Method m, boolean isObjTags) {
        if (m.getDeclaringClass().isAnnotation()) {
            return m;
        }
        char[] chars = m.getName().toCharArray();
        if (chars.length > METHOD_SUFFIX_LEN + 2) {
            boolean isEq = true;
            int x = 0;
            for (int i = chars.length - METHOD_SUFFIX_LEN - 2; i < chars.length; ++i) {
                if (chars[i] != METHOD_SUFFIX_UNINST_CHARS[x]) {
                    isEq = false;
                }
                ++x;
            }
            if (isEq) {
                return m;
            }
        }
        ArrayList<Class> newArgs = new ArrayList<Class>();
        boolean madeChange = false;
        for (Class<?> c : m.getParameterTypes()) {
            if (c.isArray()) {
                if (c.getComponentType().isPrimitive()) {
                    newArgs.add(c);
                    continue;
                }
                Class<?> elementType = c.getComponentType();
                String s = "";
                while (elementType.isArray()) {
                    elementType = elementType.getComponentType();
                }
                if (elementType.isPrimitive()) {
                    madeChange = true;
                    if (isObjTags) {
                        newArgs.add(MultiDTaintedArrayWithObjTag.getUnderlyingBoxClassForUnderlyingClass(c));
                        continue;
                    }
                    newArgs.add(MultiDTaintedArrayWithIntTag.getUnderlyingBoxClassForUnderlyingClass(c));
                    continue;
                }
                newArgs.add(c);
                continue;
            }
            if (c.isPrimitive()) {
                newArgs.add(c);
                continue;
            }
            newArgs.add(c);
        }
        if (madeChange) {
            Class[] args = new Class[newArgs.size()];
            newArgs.toArray(args);
            Method ret = null;
            try {
                ret = m.getDeclaringClass().getDeclaredMethod(m.getName() + "$$PHOSPHORUNTAGGED", args);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            return ret;
        }
        return m;
    }

    public static Method getOrigMethod(Method m, boolean isObjTracking) {
        block5: {
            if (Configuration.GENERATE_UNINST_STUBS && m.getName().endsWith("$$PHOSPHORUNTAGGED")) {
                String origName = m.getName().replace("$$PHOSPHORUNTAGGED", "");
                try {
                    return m.getDeclaringClass().getDeclaredMethod(origName, m.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    break block5;
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                    break block5;
                }
            }
            if (m.PHOSPHOR_TAGmethod != null && m.PHOSPHOR_TAGmarked) {
                return m.PHOSPHOR_TAGmethod;
            }
        }
        return m;
    }

    private static SinglyLinkedList<Class<?>> getOriginalParamTypes(Class<?>[] taintedParamTypes) {
        SinglyLinkedList originalParamTypes = new SinglyLinkedList();
        for (int i = 0; i < taintedParamTypes.length; ++i) {
            Class<?> paramType = taintedParamTypes[i];
            if (paramType.equals(Taint.class) || paramType.equals(Integer.TYPE)) {
                originalParamTypes.enqueue(taintedParamTypes[++i]);
                continue;
            }
            if (LazyArrayObjTags.class.isAssignableFrom(paramType) || LazyArrayIntTags.class.isAssignableFrom(paramType)) {
                originalParamTypes.enqueue(taintedParamTypes[++i]);
                continue;
            }
            if (paramType.getName().contains(multiDDescriptor)) {
                originalParamTypes.enqueue(TaintUtils.getUnwrappedClass(paramType));
                continue;
            }
            if (paramType.equals(TaintSentinel.class) || paramType.equals(ControlTaintTagStack.class) || TaintedPrimitiveWithObjTag.class.isAssignableFrom(paramType) || TaintedPrimitiveWithIntTag.class.isAssignableFrom(paramType)) continue;
            originalParamTypes.enqueue(paramType);
        }
        return originalParamTypes;
    }

    public static Constructor<?> getOrigMethod(Constructor<?> cons, boolean isObjTags) {
        if (ReflectionMasker.declaredInIgnoredClass(cons)) {
            return cons;
        }
        boolean hasSentinel = false;
        for (Class<?> clazz : cons.getParameterTypes()) {
            if (!clazz.equals(TaintSentinel.class)) continue;
            hasSentinel = true;
            break;
        }
        if (hasSentinel) {
            Class[] origParams = ReflectionMasker.getOriginalParamTypes(cons.getParameterTypes()).toArray(new Class[0]);
            try {
                return cons.getDeclaringClass().getDeclaredConstructor(origParams);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return cons;
            }
        }
        return cons;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class<?>[] addTypeParams(Class<?> clazz, Class<?>[] params, boolean implicitTracking, boolean isObjTags) {
        if (ReflectionMasker.isIgnoredClass(clazz) || params == null) {
            return params;
        }
        boolean needsChange = false;
        for (Class<?> c : params) {
            if (c == null || !c.isPrimitive() && (!c.isArray() || !ReflectionMasker.isPrimitiveArray(c))) continue;
            needsChange = true;
        }
        if (implicitTracking) {
            needsChange = true;
        }
        if (!needsChange) {
            return params;
        }
        ArrayList<Class> newParams = new ArrayList<Class>();
        for (Class<?> c : params) {
            block13: {
                Type t;
                block14: {
                    t = Type.getType(c);
                    if (t.getSort() != 9) break block14;
                    if (t.getElementType().getSort() == 10) break block13;
                    if (t.getDimensions() == 1) {
                        newParams.add(MultiDTaintedArray.getUnderlyingBoxClassForUnderlyingClass(c));
                        break block13;
                    } else {
                        Type newType = null;
                        newType = isObjTags ? MultiDTaintedArrayWithObjTag.getTypeForType(t) : MultiDTaintedArrayWithIntTag.getTypeForType(t);
                        try {
                            newParams.add(Class.forName(newType.getInternalName().replace("/", ".")));
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                            break block13;
                        }
                    }
                }
                if (t.getSort() != 10) {
                    if (isObjTags) {
                        newParams.add(Configuration.TAINT_TAG_OBJ_CLASS);
                    } else {
                        newParams.add(Integer.TYPE);
                    }
                }
            }
            newParams.add(c);
        }
        if (implicitTracking) {
            newParams.add(ControlTaintTagStack.class);
        }
        newParams.add(TaintSentinel.class);
        Class[] ret = new Class[newParams.size()];
        newParams.toArray(ret);
        return ret;
    }

    public static Method getDeclaredMethod(Class<?> czz, String name, Class<?>[] params, boolean isObjTags) throws NoSuchMethodException {
        return ReflectionMasker.checkForSyntheticObjectMethod(czz.getDeclaredMethod(name, params), true);
    }

    public static Method getDeclaredMethod$$PHOSPHORTAGGED(Class<?> czz, String name, Class<?>[] params, ControlTaintTagStack ctrl) throws NoSuchMethodException {
        return ReflectionMasker.checkForSyntheticObjectMethod(czz.getDeclaredMethod(name, params), true);
    }

    public static Method getMethod$$PHOSPHORTAGGED(Class<?> czz, String name, Class<?>[] params, ControlTaintTagStack ctrl) throws NoSuchMethodException {
        return ReflectionMasker.checkForSyntheticObjectMethod(czz.getMethod(name, params), false);
    }

    public static Method getMethod(Class<?> czz, String name, Class<?>[] params, boolean isObjTags) throws NoSuchMethodException {
        return ReflectionMasker.checkForSyntheticObjectMethod(czz.getMethod(name, params), false);
    }

    private static Method checkForSyntheticObjectMethod(Method m, boolean declaredOnly) throws NoSuchMethodException {
        if (m.isSynthetic()) {
            if ("equals".equals(m.getName())) {
                if (declaredOnly) {
                    throw new NoSuchMethodException();
                }
                return ObjectMethods.EQUALS.method;
            }
            if ("hashCode".equals(m.getName())) {
                if (declaredOnly) {
                    throw new NoSuchMethodException();
                }
                return ObjectMethods.HASH_CODE.method;
            }
        }
        return m;
    }

    private static boolean declaredInIgnoredClass(Member member) {
        return member != null && member.getDeclaringClass() != null && ReflectionMasker.isIgnoredClass(member.getDeclaringClass());
    }

    private static boolean isIgnoredClass(Class<?> clazz) {
        return clazz != null && (Instrumenter.isIgnoredClass(clazz.getName().replace('.', '/')) || Object.class.equals(clazz));
    }

    static boolean isPrimitiveArray(Class<?> c) {
        return c.isArray() ? ReflectionMasker.isPrimitiveArray(c.getComponentType()) : c.isPrimitive();
    }

    public static Class[] removeTaintedInterface(Class[] in) {
        if (in == null) {
            return null;
        }
        boolean found = false;
        for (int i = 0; i < in.length; ++i) {
            if (!in[i].equals(TaintedWithIntTag.class) && !in[i].equals(TaintedWithObjTag.class)) continue;
            found = true;
        }
        if (!found) {
            return in;
        }
        Class[] ret = new Class[in.length - 1];
        int idx = 0;
        for (int i = 0; i < in.length; ++i) {
            if (in[i].equals(TaintedWithIntTag.class) || in[i].equals(TaintedWithObjTag.class)) continue;
            ret[idx] = in[i];
            ++idx;
        }
        return ret;
    }

    public static StackTraceElement[] removeExtraStackTraceElements(StackTraceElement[] in, Class clazz) {
        int depthToCut = 0;
        String toFind = clazz.getName();
        if (clazz == null || in == null) {
            return in;
        }
        for (int i = 0; i < in.length; ++i) {
            if (!in[i].getClassName().equals(toFind) || i + 1 < in.length && in[i + 1].getClassName().equals(toFind)) continue;
            depthToCut = i + 1;
            break;
        }
        StackTraceElement[] ret = new StackTraceElement[in.length - depthToCut];
        System.arraycopy(in, depthToCut, ret, 0, ret.length);
        return ret;
    }

    public static Object[] fixAllArgs(Object[] in, Constructor<?> c, boolean isObjTags) {
        return ReflectionMasker.fixAllArgs(in, c, false, null);
    }

    public static Object[] fixAllArgs(Object[] in, Constructor c, ControlTaintTagStack ctrl) {
        return ReflectionMasker.fixAllArgs(in, c, true, ctrl);
    }

    private static Object[] fixAllArgs(Object[] in, Constructor<?> c, boolean implicitTracking, ControlTaintTagStack ctrl) {
        if (ReflectionMasker.declaredInIgnoredClass(c)) {
            return ReflectionMasker.getOriginalParams(c.getParameterTypes(), in);
        }
        if (c == null) {
            return in;
        }
        if (in != null && c.getParameterTypes().length != in.length) {
            Object[] ret = new Object[c.getParameterTypes().length];
            ReflectionMasker.fillInParams(ret, in, c.getParameterTypes());
            if (implicitTracking) {
                ret[ret.length - 2] = ctrl;
            }
            return ret;
        }
        if (in == null && c.getParameterTypes().length == 1) {
            Object[] ret = new Object[]{null};
            return ret;
        }
        if (in == null && c.getParameterTypes().length == 2) {
            Object[] ret = new Object[]{implicitTracking ? ctrl : new ControlTaintTagStack(), null};
            return ret;
        }
        return in;
    }

    private static Object[] getOriginalParams(Class<?>[] types, Object[] taintedParams) {
        Object[] originalParams = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Object obj;
            if (types[i].isPrimitive()) {
                if (taintedParams[i] instanceof TaintedPrimitiveWithObjTag) {
                    originalParams[i] = ((TaintedPrimitiveWithObjTag)taintedParams[i]).toPrimitiveType();
                    continue;
                }
                if (taintedParams[i] instanceof TaintedPrimitiveWithIntTag) {
                    originalParams[i] = ((TaintedPrimitiveWithIntTag)taintedParams[i]).toPrimitiveType();
                    continue;
                }
                originalParams[i] = taintedParams[i];
                continue;
            }
            originalParams[i] = types[i].isArray() ? (obj = MultiDTaintedArray.maybeUnbox(taintedParams[i])) : taintedParams[i];
        }
        return originalParams;
    }

    public static Object[] fixAllArgsFast(Method m, Object[] in, boolean isObjTags) {
        System.out.println("Making fast call to  " + m);
        Object[] ret = in;
        m.setAccessible(true);
        int j = 0;
        if (in != null && m.getParameterTypes().length != in.length) {
            ret = new Object[m.getParameterTypes().length];
            for (int i = 0; i < in.length; ++i) {
                if (m.getParameterTypes()[j].isPrimitive()) {
                    ret[j] = in[i] instanceof TaintedWithIntTag ? Integer.valueOf(((TaintedWithIntTag)in[i]).getPHOSPHOR_TAG()) : (in[i] instanceof TaintedWithObjTag ? ((TaintedWithObjTag)in[i]).getPHOSPHOR_TAG() : Integer.valueOf(0));
                    ++j;
                } else if (m.getParameterTypes()[j].isArray() && m.getParameterTypes()[j].getComponentType().isPrimitive()) {
                    Serializable arr;
                    if (!isObjTags) {
                        arr = (LazyArrayIntTags)in[i];
                        ret[j] = ((LazyArrayIntTags)arr).taints;
                        ret[++j] = ((LazyArrayIntTags)arr).getVal();
                        ++j;
                        continue;
                    }
                    arr = (LazyArrayObjTags)in[i];
                    ret[j] = ((LazyArrayObjTags)arr).taints;
                    ret[++j] = ((LazyArrayObjTags)arr).getVal();
                    ++j;
                    continue;
                }
                ret[j] = in[i];
                ++j;
            }
        }
        if (in == null && m.getParameterTypes().length == 1 || in != null && j != in.length - 1) {
            Class<?> returnType;
            if (in == null) {
                ret = new Object[1];
            }
            if (TaintedPrimitiveWithIntTag.class.isAssignableFrom(returnType = m.getReturnType()) || TaintedPrimitiveWithObjTag.class.isAssignableFrom(returnType)) {
                try {
                    ret[j] = returnType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static Object[] fixAllArgsUninst(Object[] in, Constructor c, boolean isObjTags) {
        Class<?>[] params = c.getParameterTypes();
        if (params.length == 0) {
            return in;
        }
        if (params[params.length - 1] == UninstrumentedTaintSentinel.class) {
            Object[] ret = new Object[in.length + 1];
            System.arraycopy(in, 0, ret, 0, in.length);
            return ret;
        }
        if (params[params.length - 1] == TaintSentinel.class) {
            return ReflectionMasker.fixAllArgs(in, c, isObjTags);
        }
        return in;
    }

    public static Object[] fixAllArgsUninst(Object[] in, Constructor c, ControlTaintTagStack ctrl) {
        return in;
    }

    public static MethodInvoke fixAllArgsUninst(Method m, Object owner, Object[] in, boolean isObjTags) {
        MethodInvoke ret = new MethodInvoke();
        if (m == null) {
            ret.a = in;
            ret.o = owner;
            ret.m = m;
            return ret;
        }
        if (Configuration.WITH_SELECTIVE_INST) {
            ret.m = ReflectionMasker.getOrigMethod(m, isObjTags);
            ret.o = owner;
            ret.a = in;
            if (ret.a != null && ret.a.getClass().isArray() && ret.a.getClass().getComponentType() == Object.class) {
                for (int i = 0; i < ret.a.length; ++i) {
                    if (ret.a[i] instanceof LazyArrayIntTags) {
                        ret.a[i] = ((LazyArrayIntTags)ret.a[i]).getVal();
                        continue;
                    }
                    if (!(ret.a[i] instanceof MultiDTaintedArrayWithObjTag)) continue;
                    ret.a[i] = ((MultiDTaintedArrayWithObjTag)ret.a[i]).getVal();
                }
            }
        } else {
            ret = ReflectionMasker.fixAllArgs(m, owner, in, isObjTags);
        }
        return ret;
    }

    public static MethodInvoke fixAllArgsUninst(Method m, Object owner, Object[] in, ControlTaintTagStack ctrl) {
        MethodInvoke ret = new MethodInvoke();
        if (m == null) {
            ret.a = in;
            ret.o = owner;
            ret.m = m;
            return ret;
        }
        ret.m = ReflectionMasker.getOrigMethod(m, true);
        ret.o = owner;
        ret.a = in;
        for (int i = 0; i < ret.a.length; ++i) {
            if (ret.a[i] instanceof LazyArrayIntTags) {
                ret.a[i] = ((LazyArrayIntTags)ret.a[i]).getVal();
                continue;
            }
            if (!(ret.a[i] instanceof MultiDTaintedArrayWithObjTag)) continue;
            ret.a[i] = ((MultiDTaintedArrayWithObjTag)ret.a[i]).getVal();
        }
        return ret;
    }

    public static MethodInvoke fixAllArgs(Method m, Object owner, Object[] in, boolean isObjTags) {
        MethodInvoke ret = new MethodInvoke();
        if (m == null || ReflectionMasker.declaredInIgnoredClass(m)) {
            ret.a = in;
            ret.o = owner;
            ret.m = m;
            return ret;
        }
        m.setAccessible(true);
        if (!m.PHOSPHOR_TAGmarked && !"java.lang.Object".equals(m.getDeclaringClass().getName())) {
            m = ReflectionMasker.getTaintMethod(m, isObjTags);
        }
        m.setAccessible(true);
        ret.o = owner;
        ret.m = m;
        ret.a = in != null && m.getParameterTypes().length != in.length ? new Object[ret.m.getParameterTypes().length] : in;
        int j = ReflectionMasker.fillInParams(ret.a, in, ret.m.getParameterTypes());
        if (in == null && m.getParameterTypes().length == 1 || in != null && j != in.length - 1) {
            ret.a = in != null ? ret.a : new Object[1];
            Class<?> returnType = m.getReturnType();
            if (TaintedPrimitiveWithIntTag.class.isAssignableFrom(returnType) || TaintedPrimitiveWithObjTag.class.isAssignableFrom(returnType)) {
                try {
                    ret.a[j] = returnType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static MethodInvoke fixAllArgs(Method m, Object owner, Object[] in, ControlTaintTagStack ctrl) {
        MethodInvoke ret = new MethodInvoke();
        m.setAccessible(true);
        if (ReflectionMasker.declaredInIgnoredClass(m)) {
            ret.a = in;
            ret.o = owner;
            ret.m = m;
            return ret;
        }
        if (!m.PHOSPHOR_TAGmarked) {
            m = ReflectionMasker.getTaintMethodControlTrack(m);
        }
        m.setAccessible(true);
        ret.o = owner;
        ret.m = m;
        ret.a = in != null && m.getParameterTypes().length != in.length ? new Object[ret.m.getParameterTypes().length] : in;
        int j = ReflectionMasker.fillInParams(ret.a, in, ret.m.getParameterTypes());
        if (ret.a != null && ret.a.length > j) {
            ret.a[j++] = ctrl;
        }
        if (in == null && m.getParameterTypes().length == 1) {
            ret.a = new Object[1];
            ret.a[0] = ctrl;
        } else if (in == null && m.getParameterTypes().length == 2 || in != null && j != in.length - 1) {
            Class<?> returnType;
            if (in == null) {
                ret.a = new Object[2];
                ret.a[0] = ctrl;
                ++j;
            }
            if (TaintedPrimitiveWithIntTag.class.isAssignableFrom(returnType = m.getReturnType()) || TaintedPrimitiveWithObjTag.class.isAssignableFrom(returnType)) {
                try {
                    ret.a[j] = returnType.newInstance();
                    if (ret.a[j].getClass().equals(Boolean.class)) {
                        System.exit(-1);
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private static int fillInParams(Object[] targetArgs, Object[] providedArgs, Class<?>[] paramTypes) {
        int targetParamIndex = 0;
        if (providedArgs != null && paramTypes.length != providedArgs.length) {
            for (Object providedArg : providedArgs) {
                Serializable arr;
                Class<?> targetParamClass = paramTypes[targetParamIndex];
                if (targetParamClass.equals(Configuration.TAINT_TAG_OBJ_CLASS)) {
                    targetArgs[targetParamIndex++] = MultiTainter.getTaint(providedArg);
                    targetArgs[targetParamIndex++] = providedArg;
                    continue;
                }
                if (targetParamClass.equals(Integer.TYPE)) {
                    targetArgs[targetParamIndex++] = providedArg instanceof TaintedWithObjTag ? ((TaintedWithObjTag)providedArg).getPHOSPHOR_TAG() : (providedArg instanceof Boolean ? Integer.valueOf(BoxedPrimitiveStoreWithIntTags.booleanValue((Boolean)((Boolean)providedArg)).taint) : (providedArg instanceof Byte ? Integer.valueOf(BoxedPrimitiveStoreWithIntTags.byteValue((Byte)((Byte)providedArg)).taint) : (providedArg instanceof Short ? Integer.valueOf(BoxedPrimitiveStoreWithIntTags.shortValue((Short)((Short)providedArg)).taint) : (providedArg instanceof Character ? Integer.valueOf(BoxedPrimitiveStoreWithIntTags.charValue((Character)((Character)providedArg)).taint) : Integer.valueOf(0)))));
                    targetArgs[targetParamIndex++] = providedArg;
                    continue;
                }
                if (LazyArrayIntTags.class.isAssignableFrom(targetParamClass)) {
                    arr = (LazyArrayIntTags)providedArg;
                    targetArgs[targetParamIndex++] = arr;
                    targetArgs[targetParamIndex++] = arr == null ? null : ((LazyArrayIntTags)arr).getVal();
                    continue;
                }
                if (LazyArrayObjTags.class.isAssignableFrom(targetParamClass)) {
                    arr = (LazyArrayObjTags)providedArg;
                    targetArgs[targetParamIndex++] = arr;
                    targetArgs[targetParamIndex++] = arr == null ? null : ((LazyArrayObjTags)arr).getVal();
                    continue;
                }
                targetArgs[targetParamIndex++] = providedArg;
            }
        }
        return targetParamIndex;
    }

    public static Class<?> removeTaintClass(Class<?> clazz) {
        if (clazz.PHOSPHOR_TAGclass != null) {
            return clazz.PHOSPHOR_TAGclass;
        }
        if (clazz.isArray()) {
            String cmp = null;
            Class<?> c = clazz.getComponentType();
            while (c.isArray()) {
                c = c.getComponentType();
            }
            cmp = c.getName();
            if (cmp.length() >= multiDDescriptorLength && cmp.subSequence(0, multiDDescriptorLength).equals(multiDDescriptor)) {
                Type t = Type.getType(clazz);
                String innerType = MultiDTaintedArray.getPrimitiveTypeForWrapper(clazz);
                String newName = "[";
                for (int i = 0; i < t.getDimensions(); ++i) {
                    newName = newName + "[";
                }
                try {
                    Class<?> ret;
                    clazz.PHOSPHOR_TAGclass = ret = Class.forName(newName + innerType);
                    ret.PHOSPHOR_TAGclass = ret;
                    return ret;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            clazz.PHOSPHOR_TAGclass = clazz;
            return clazz;
        }
        String cmp = clazz.getName();
        if (cmp.length() >= multiDDescriptorLength && cmp.subSequence(0, multiDDescriptorLength).equals(multiDDescriptor)) {
            String innerType = MultiDTaintedArray.getPrimitiveTypeForWrapper(clazz);
            try {
                Class<?> ret;
                clazz.PHOSPHOR_TAGclass = ret = Class.forName("[" + innerType);
                ret.PHOSPHOR_TAGclass = ret;
                return ret;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        clazz.PHOSPHOR_TAGclass = clazz;
        return clazz;
    }

    public static Class<?> getClassOOS(Object o) {
        if (o instanceof LazyArrayObjTags && ((LazyArrayObjTags)o).taints != null) {
            return o.getClass();
        }
        if (o instanceof LazyArrayIntTags && ((LazyArrayIntTags)o).taints != null) {
            return o.getClass();
        }
        return ReflectionMasker.removeTaintClass(o.getClass());
    }

    public static Field[] removeTaintFields(Field[] in) {
        SinglyLinkedList<Field> ret = new SinglyLinkedList<Field>();
        boolean removeSVUIDField = ReflectionMasker.containsSVUIDSentinelField(in);
        for (Field f : in) {
            if (f.getName().equals("taint") || f.getName().endsWith("PHOSPHOR_TAG") || f.getName().startsWith("$$PHOSPHOR_") || removeSVUIDField && f.getName().equals("serialVersionUID")) continue;
            ret.enqueue(f);
        }
        return ret.toArray(new Field[ret.size()]);
    }

    private static boolean containsSVUIDSentinelField(Field[] in) {
        for (Field f : in) {
            if (!f.getName().equals("$$PHOSPHOR_REMOVE_SVUID")) continue;
            return true;
        }
        return false;
    }

    public static Method[] removeTaintMethods(Method[] in, boolean declaredOnly) {
        SinglyLinkedList<Method> ret = new SinglyLinkedList<Method>();
        block0: for (Method f : in) {
            char[] chars = f.getName().toCharArray();
            boolean match = false;
            if (chars.length == SET_TAG_METHOD_LEN) {
                match = true;
                for (int i = 3; i < SET_TAG_METHOD_LEN; ++i) {
                    if (chars[i] == SET_TAG_METHOD_CHARS[i]) continue;
                    match = false;
                    break;
                }
            }
            if (!match && chars.length > METHOD_SUFFIX_LEN) {
                int i;
                int x = 0;
                boolean matched = true;
                for (i = chars.length - METHOD_SUFFIX_LEN; i < chars.length; ++i) {
                    if (chars[i] != METHOD_SUFFIX_CHARS[x]) {
                        matched = false;
                        break;
                    }
                    ++x;
                }
                x = 0;
                if (!matched && Configuration.GENERATE_UNINST_STUBS && chars.length > METHOD_SUFFIX_LEN + 2) {
                    for (i = chars.length - METHOD_SUFFIX_LEN - 2; i < chars.length; ++i) {
                        if (chars[i] != METHOD_SUFFIX_UNINST_CHARS[x]) {
                            ret.enqueue(f);
                            continue block0;
                        }
                        ++x;
                    }
                    continue;
                }
                if (matched) continue;
                ret.enqueue(f);
                continue;
            }
            if (match) continue;
            if (f.isSynthetic()) {
                if (chars.length == 6 && chars[0] == 'e' && chars[1] == 'q' && chars[2] == 'u' && chars[3] == 'a' && chars[4] == 'l' && chars[5] == 's') {
                    if (declaredOnly) continue;
                    ret.enqueue(ObjectMethods.EQUALS.method);
                    continue;
                }
                if (chars.length == 8 && chars[0] == 'h' && chars[1] == 'a' && chars[2] == 's' && chars[3] == 'h' && chars[4] == 'C' && chars[5] == 'o' && chars[6] == 'd' && chars[7] == 'e') {
                    if (declaredOnly) continue;
                    ret.enqueue(ObjectMethods.HASH_CODE.method);
                    continue;
                }
            }
            ret.enqueue(f);
        }
        return ret.toArray(new Method[ret.size()]);
    }

    public static Constructor<?>[] removeTaintConstructors(Constructor<?>[] in) {
        SinglyLinkedList<Constructor> ret = new SinglyLinkedList<Constructor>();
        for (Constructor<?> f : in) {
            Class<?>[] params = f.getParameterTypes();
            if (params.length != 0 && TaintUtils.isTaintSentinel(params[params.length - 1])) continue;
            ret.enqueue(f);
        }
        return ret.toArray(new Constructor[ret.size()]);
    }

    private static ReflectionFactory getReflectionFactory() {
        if (reflectionFactory == null) {
            reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        return reflectionFactory;
    }

    public static Method[] copyMethods(Method[] arg) {
        return arg;
    }

    public static Constructor<?>[] copyConstructors(Constructor<?>[] arg) {
        return arg;
    }

    public static Field[] copyFields(Field[] arg) {
        return arg;
    }

    static {
        System.setSecurityManager(null);
        isSelectiveInstManagerInit = false;
        multiDDescriptorLength = multiDDescriptor.length();
        SET_TAG_METHOD_CHARS = "setPHOSPHOR_TAG".toCharArray();
        SET_TAG_METHOD_LEN = SET_TAG_METHOD_CHARS.length;
        METHOD_SUFFIX_CHARS = "$$PHOSPHORTAGGED".toCharArray();
        METHOD_SUFFIX_LEN = METHOD_SUFFIX_CHARS.length;
        METHOD_SUFFIX_UNINST_CHARS = "$$PHOSPHORUNTAGGED".toCharArray();
        FIELD_SUFFIX_CHARS = "PHOSPHOR_TAG".toCharArray();
        FIELD_METHOD_SUFFIX_LEN = FIELD_SUFFIX_CHARS.length;
    }

    private static enum ObjectMethods {
        EQUALS("equals", Object.class),
        HASH_CODE("hashCode", new Class[0]);

        public Method method;

        private ObjectMethods(String name, Class<?> ... parameterTypes) {
            try {
                this.method = Object.class.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }
}

