/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter.analyzer;

import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.BasicArrayValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.AbstractInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LineNumberNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.BasicValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.util.Printer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class SinkableArrayValue
extends BasicValue {
    public static final BasicValue NULL_VALUE = new BasicArrayValue(Type.getType("Lnull;"));
    public boolean flowsToInstMethodCall;
    public HashSet<SinkableArrayValue> reverseDeps;
    public HashSet<SinkableArrayValue> deps;
    private AbstractInsnNode src;
    public AbstractInsnNode oldSrc;
    public AbstractInsnNode sink;
    public boolean isNewArray;
    public SinkableArrayValue copyOf;
    public boolean dontPropogateToDeps;
    public boolean flowsToPrim;
    public boolean okToPropogateToDeps;
    public boolean[] leaveDupOnAt = new boolean[4];
    public LinkedList<SinkableArrayValue> otherDups = new LinkedList();
    public boolean isBottomDup;
    public boolean resolved;
    public SinkableArrayValue masterDup;
    public boolean isConstant;
    public SinkableArrayValue disabledFor;

    public void disable() {
        if (this.src != null) {
            this.oldSrc = this.src;
            this.src = null;
        }
    }

    public int getLine() {
        for (AbstractInsnNode aa = this.getSrc(); aa != null; aa = aa.getPrevious()) {
            if (!(aa instanceof LineNumberNode)) continue;
            return ((LineNumberNode)aa).line;
        }
        return -1;
    }

    public void addDepCopy(SinkableArrayValue d) {
        if (d != null && this.deps == null) {
            this.deps = new HashSet();
        }
        if (this.deps.add(d) && d.isNewArray) {
            this.isNewArray = true;
        }
        this.copyOf = d;
        if (d.reverseDeps == null) {
            d.reverseDeps = new HashSet();
        }
        d.reverseDeps.add(this);
    }

    public void addDep(SinkableArrayValue d) {
        if (d != null && this.deps == null) {
            this.deps = new HashSet();
        }
        this.deps.add(d);
        if (d.reverseDeps == null) {
            d.reverseDeps = new HashSet();
        }
        d.reverseDeps.add(this);
    }

    public HashSet<SinkableArrayValue> getAllDepsFlat() {
        HashSet<SinkableArrayValue> ret = new HashSet<SinkableArrayValue>();
        if (this.deps != null) {
            for (SinkableArrayValue r : this.deps) {
                if (!ret.add(r)) continue;
                r.getAllDepsFlat(ret);
            }
        }
        return ret;
    }

    private void getAllDepsFlat(HashSet<SinkableArrayValue> ret) {
        if (this.deps != null) {
            for (SinkableArrayValue r : this.deps) {
                if (!ret.add(r)) continue;
                r.getAllDepsFlat(ret);
            }
        }
    }

    public SinkableArrayValue getOriginalValue() {
        if (this.masterDup != null) {
            return this.masterDup.getOriginalValue();
        }
        if (this.isBottomDup) {
            for (SinkableArrayValue d : this.deps) {
                if (d.getSrc().getOpcode() != 188) continue;
                return d;
            }
            throw new UnsupportedOperationException();
        }
        return this;
    }

    public AbstractInsnNode getOriginalSource() {
        if (this.masterDup != null) {
            return this.masterDup.getOriginalSource();
        }
        if (this.isBottomDup) {
            for (SinkableArrayValue d : this.deps) {
                if (d.getSrc().getOpcode() == 188) {
                    return d.getSrc();
                }
                if (!d.isBottomDup && d.masterDup == null) continue;
                return d.getOriginalSource();
            }
            throw new UnsupportedOperationException();
        }
        return this.getSrc();
    }

    public SinkableArrayValue(Type type) {
        super(type);
    }

    @Override
    public String toString() {
        if (this.disabledFor != null) {
            return "[" + (this.flowsToInstMethodCall ? "T" : "F") + this.formatDesc() + ", disabled for: " + this.disabledFor + "]";
        }
        if (this == NULL_VALUE) {
            return "N";
        }
        return (this.flowsToInstMethodCall ? "T" : "F") + "<" + this.formatDesc() + "> " + (this.dontPropogateToDeps ? "T" : "F") + (this.src != null && this.src.getOpcode() > 0 ? Printer.OPCODES[this.src.getOpcode()] : "????") + (this.src != null ? "@" + this.getLine() : "");
    }

    private String formatDesc() {
        if (this.getType() == null) {
            return "N";
        }
        if (this == UNINITIALIZED_VALUE) {
            return ".";
        }
        if (this == RETURNADDRESS_VALUE) {
            return "A";
        }
        if (this == REFERENCE_VALUE) {
            return "R";
        }
        return this.getType().getDescriptor();
    }

    public Collection<SinkableArrayValue> tag(AbstractInsnNode sink) {
        LinkedList<SinkableArrayValue> queue = new LinkedList<SinkableArrayValue>();
        queue.add(this);
        LinkedList<SinkableArrayValue> ret = new LinkedList<SinkableArrayValue>();
        LinkedList<SinkableArrayValue> processed = new LinkedList<SinkableArrayValue>();
        if (this.getType() != null && this.getType().getSort() == 9 && this.getType().getDimensions() > 1) {
            return ret;
        }
        while (!queue.isEmpty()) {
            SinkableArrayValue v = (SinkableArrayValue)queue.pop();
            while (v.disabledFor != null) {
                v = v.disabledFor;
            }
            processed.add(v);
            if (v.flowsToInstMethodCall) continue;
            v.flowsToInstMethodCall = true;
            ret.add(v);
            v.sink = sink;
            if (v.deps == null || v.dontPropogateToDeps) continue;
            queue.addAll(v.deps);
        }
        return ret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.flowsToInstMethodCall ? 1231 : 1237);
        result = 31 * result + (this.getSrc() == null ? 0 : this.getSrc().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean deepEquals(SinkableArrayValue obj) {
        if (this == obj) {
            return true;
        }
        if (this.getType() == null && obj.getType() != null) {
            return false;
        }
        if (this.getType() != null && obj.getType() == null) {
            return false;
        }
        if (this.getType() == null && obj.getType() == null || this.getType().equals(obj.getType())) {
            if (this.src != null && obj.src == null || this.src == null && obj.src != null) {
                return false;
            }
            if (this.dontPropogateToDeps == obj.dontPropogateToDeps && (this.src == null && obj.src == null || this.src.equals(obj.getSrc()))) {
                if (this.deps != null && obj.deps == null || this.deps == null && obj.deps != null) {
                    return false;
                }
                if (this.deps == null && obj.deps == null || this.deps.equals(obj.deps)) {
                    return true;
                }
            }
        }
        return false;
    }

    public AbstractInsnNode getSrc() {
        return this.src;
    }

    public void setSrc(AbstractInsnNode src) {
        this.src = src;
    }
}

