/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter.analyzer;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.TaggedValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Handle;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NeverNullArgAnalyzerAdapter
extends MethodVisitor {
    public List<Object> locals;
    public List<Object> stack;
    public List<Object> stackTagStatus;
    public List<Object> stackConstantVals;
    public boolean isFollowedByFrame;
    private List<Label> labels;
    public Map<Object, Object> uninitializedTypes;
    private int maxStack;
    private int maxLocals;
    private String owner;
    public String name;
    private List<Object> args;
    private List<Object> argsFormattedForFrame;
    boolean noInsnsSinceListFrame = false;
    public List<Object> frameLocals;

    public NeverNullArgAnalyzerAdapter(String owner, int access, String name, String desc, MethodVisitor mv) {
        this(Configuration.ASM_VERSION, owner, access, name, desc, mv);
        this.name = name;
    }

    protected NeverNullArgAnalyzerAdapter(int api, String owner, int access, String name, String desc, MethodVisitor mv) {
        super(api, mv);
        this.owner = owner;
        this.locals = new ArrayList<Object>();
        this.frameLocals = new ArrayList<Object>();
        this.stack = new ArrayList<Object>();
        this.stackTagStatus = new ArrayList<Object>();
        this.stackConstantVals = new ArrayList<Object>();
        this.uninitializedTypes = new HashMap<Object, Object>();
        this.args = new ArrayList<Object>();
        this.argsFormattedForFrame = new ArrayList<Object>();
        if ((access & 8) == 0) {
            if ("<init>".equals(name)) {
                this.locals.add(Opcodes.UNINITIALIZED_THIS);
            } else {
                this.locals.add(owner);
            }
            this.args.add(owner);
            this.argsFormattedForFrame.add(owner);
        }
        Type[] types = Type.getArgumentTypes(desc);
        block7: for (int i = 0; i < types.length; ++i) {
            Type type = types[i];
            switch (type.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.locals.add(Opcodes.INTEGER);
                    this.args.add(Opcodes.INTEGER);
                    this.argsFormattedForFrame.add(Opcodes.INTEGER);
                    continue block7;
                }
                case 6: {
                    this.locals.add(Opcodes.FLOAT);
                    this.args.add(Opcodes.FLOAT);
                    this.argsFormattedForFrame.add(Opcodes.FLOAT);
                    continue block7;
                }
                case 7: {
                    this.locals.add(Opcodes.LONG);
                    this.locals.add(Opcodes.TOP);
                    this.args.add(Opcodes.LONG);
                    this.args.add(Opcodes.TOP);
                    this.argsFormattedForFrame.add(Opcodes.LONG);
                    continue block7;
                }
                case 8: {
                    this.locals.add(Opcodes.DOUBLE);
                    this.locals.add(Opcodes.TOP);
                    this.args.add(Opcodes.LONG);
                    this.args.add(Opcodes.TOP);
                    this.argsFormattedForFrame.add(Opcodes.DOUBLE);
                    continue block7;
                }
                case 9: {
                    this.locals.add(types[i].getDescriptor());
                    this.args.add(types[i].getDescriptor());
                    this.argsFormattedForFrame.add(types[i].getDescriptor());
                    continue block7;
                }
                default: {
                    this.locals.add(types[i].getInternalName());
                    this.args.add(types[i].getInternalName());
                    this.argsFormattedForFrame.add(types[i].getInternalName());
                }
            }
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (type != -1 && type != 201) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (this.noInsnsSinceListFrame && this.locals != null) {
            return;
        }
        if (this.argsFormattedForFrame != null && this.argsFormattedForFrame.size() > nLocal) {
            int i;
            Object[] oldLocals = local;
            local = new Object[this.argsFormattedForFrame.size()];
            for (i = 0; i < nLocal; ++i) {
                local[i] = oldLocals[i];
            }
            for (i = nLocal; i < this.argsFormattedForFrame.size(); ++i) {
                local[i] = Opcodes.TOP;
            }
            nLocal = this.argsFormattedForFrame.size();
        }
        this.isFollowedByFrame = false;
        this.noInsnsSinceListFrame = true;
        if (this.mv != null) {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
        }
        if (this.locals != null) {
            this.frameLocals.clear();
            this.locals.clear();
            this.stack.clear();
            this.stackConstantVals.clear();
            this.stackTagStatus.clear();
        } else {
            this.frameLocals = new ArrayList<Object>();
            this.locals = new ArrayList<Object>();
            this.stack = new ArrayList<Object>();
            this.stackTagStatus = new ArrayList<Object>();
            this.stackConstantVals = new ArrayList<Object>(nStack);
        }
        NeverNullArgAnalyzerAdapter.visitFrameTypes(nLocal, local, this.frameLocals);
        NeverNullArgAnalyzerAdapter.visitFrameTypes(nLocal, local, this.locals);
        NeverNullArgAnalyzerAdapter.visitFrameTypes(nStack, stack, this.stack);
        for (int i = 0; i < this.stack.size(); ++i) {
            this.stackTagStatus.add(this.stack.get(i));
            if (!(this.stack.get(i) instanceof TaggedValue)) continue;
            this.stack.set(i, ((TaggedValue)this.stack.get((int)i)).v);
        }
        while (this.stack.size() > this.stackConstantVals.size()) {
            this.stackConstantVals.add(null);
        }
        this.maxStack = Math.max(this.maxStack, this.stack.size());
    }

    private static void visitFrameTypes(int n, Object[] types, List<Object> result) {
        for (int i = 0; i < n; ++i) {
            Object type = types[i];
            if (type.equals("java/lang/Object;")) {
                throw new IllegalArgumentException("Got " + type + " IN" + Arrays.toString(types));
            }
            result.add(type);
            if (type instanceof TaggedValue) {
                type = ((TaggedValue)type).v;
            }
            if (type != Opcodes.LONG && type != Opcodes.DOUBLE) continue;
            result.add(Opcodes.TOP);
        }
    }

    public boolean isTopOfStackTagged() {
        if (this.stackTagStatus.get(this.stackTagStatus.size() - 1) == Opcodes.TOP) {
            return this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
        }
        return this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
    }

    public void setTopOfStackTagged() {
        if (this.stackTagStatus.get(this.stackTagStatus.size() - 1) == Opcodes.TOP) {
            this.stackTagStatus.set(this.stackTagStatus.size() - 2, new TaggedValue(this.stackTagStatus.get(this.stackTagStatus.size() - 2)));
        } else {
            this.stackTagStatus.set(this.stackTagStatus.size() - 1, new TaggedValue(this.stackTagStatus.get(this.stackTagStatus.size() - 1)));
        }
    }

    public void clearTopOfStackTagged() {
        if (this.stackTagStatus.get(this.stackTagStatus.size() - 1) == Opcodes.TOP) {
            this.stackTagStatus.set(this.stackTagStatus.size() - 2, this.stack.get(this.stack.size() - 2));
        } else {
            this.stackTagStatus.set(this.stackTagStatus.size() - 1, this.stack.get(this.stack.size() - 1));
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.mv != null) {
            this.mv.visitInsn(opcode);
        }
        this.noInsnsSinceListFrame = false;
        this.isFollowedByFrame = opcode == 217;
        if (opcode > 200) {
            return;
        }
        this.execute(opcode, 0, null);
        if (opcode >= 172 && opcode <= 177 || opcode == 191) {
            this.locals = null;
            this.stack = null;
            this.stackConstantVals = null;
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (this.mv != null) {
            this.mv.visitIntInsn(opcode, operand);
        }
        this.execute(opcode, operand, null);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (this.mv != null) {
            this.mv.visitVarInsn(opcode, var);
        }
        this.execute(opcode, var, null);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187) {
            if (this.labels == null) {
                Label l = new Label();
                this.labels = new ArrayList<Label>(3);
                this.labels.add(l);
                if (this.mv != null) {
                    this.mv.visitLabel(l);
                }
            }
            for (int i = 0; i < this.labels.size(); ++i) {
                this.uninitializedTypes.put(this.labels.get(i), type);
            }
        }
        if (this.mv != null) {
            this.mv.visitTypeInsn(opcode, type);
        }
        if (opcode > 200) {
            return;
        }
        this.execute(opcode, 0, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.mv != null) {
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }
        this.execute(opcode, 0, desc);
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        throw new IllegalArgumentException();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        }
        this.noInsnsSinceListFrame = false;
        this.isFollowedByFrame = false;
        if (this.locals == null) {
            this.labels = null;
            return;
        }
        this.pop(desc);
        if (opcode != 184) {
            Object t = this.pop();
            if (opcode == 183 && name.charAt(0) == '<') {
                int i;
                Object u = t == Opcodes.UNINITIALIZED_THIS ? this.owner : this.uninitializedTypes.get(t);
                for (i = 0; i < this.locals.size(); ++i) {
                    if (this.locals.get(i) != t) continue;
                    this.locals.set(i, u);
                }
                for (i = 0; i < this.stack.size(); ++i) {
                    if (this.stack.get(i) != t) continue;
                    this.stack.set(i, u);
                    this.stackTagStatus.set(i, u);
                    this.stackConstantVals.set(i, null);
                }
            }
        }
        this.pushDesc(desc);
        this.labels = null;
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.noInsnsSinceListFrame = false;
        if (this.mv != null) {
            this.mv.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }
        this.isFollowedByFrame = false;
        if (this.locals == null) {
            this.labels = null;
            return;
        }
        this.pop(desc);
        this.pushDesc(desc);
        this.labels = null;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.noInsnsSinceListFrame = false;
        if (this.mv != null) {
            this.mv.visitJumpInsn(opcode, label);
        }
        this.isFollowedByFrame = false;
        this.execute(opcode, 0, null);
        if (opcode == 167) {
            this.locals = null;
            this.stack = null;
            this.stackConstantVals = null;
        }
    }

    @Override
    public void visitLabel(Label label) {
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
        if (this.labels == null) {
            this.labels = new ArrayList<Label>(3);
        }
        this.labels.add(label);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitLdcInsn(Object cst) {
        if (this.mv != null) {
            this.mv.visitLdcInsn(cst);
        }
        this.noInsnsSinceListFrame = false;
        this.isFollowedByFrame = false;
        if (this.locals == null) {
            this.labels = null;
            return;
        }
        if (cst instanceof Integer) {
            this.push(Opcodes.INTEGER, cst, false);
        } else if (cst instanceof Long) {
            this.push(Opcodes.LONG, cst, false);
            this.push(Opcodes.TOP);
        } else if (cst instanceof Float) {
            this.push(Opcodes.FLOAT, cst, false);
        } else if (cst instanceof Double) {
            this.push(Opcodes.DOUBLE, cst, false);
            this.push(Opcodes.TOP);
        } else if (cst instanceof String) {
            this.push("java/lang/String", cst, false);
        } else if (cst instanceof Type) {
            int sort = ((Type)cst).getSort();
            if (sort == 10 || sort == 9) {
                this.push("java/lang/Class", cst, false);
            } else {
                if (sort != 11) throw new IllegalArgumentException();
                this.push("java/lang/invoke/MethodType", cst, false);
            }
        } else {
            if (!(cst instanceof Handle)) throw new IllegalArgumentException();
            this.push("java/lang/invoke/MethodHandle", cst, false);
        }
        this.labels = null;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        if (this.mv != null) {
            this.mv.visitIincInsn(var, increment);
        }
        this.execute(132, var, null);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(min, max, dflt, labels);
        }
        this.execute(170, 0, null);
        this.locals = null;
        this.stack = null;
        this.stackConstantVals = null;
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(dflt, keys, labels);
        }
        this.execute(171, 0, null);
        this.locals = null;
        this.stack = null;
        this.stackConstantVals = null;
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(desc, dims);
        }
        this.execute(197, dims, desc);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.mv != null) {
            this.maxStack = Math.max(this.maxStack, maxStack);
            this.maxLocals = Math.max(this.maxLocals, maxLocals);
            this.mv.visitMaxs(this.maxStack, this.maxLocals);
        }
    }

    private Object get(int local) {
        this.maxLocals = Math.max(this.maxLocals, local);
        return local < this.locals.size() ? this.locals.get(local) : Opcodes.TOP;
    }

    private void set(int local, Object type) {
        if (type.equals("java/lang/Object;")) {
            throw new IllegalArgumentException("Got " + type);
        }
        this.maxLocals = Math.max(this.maxLocals, local);
        while (local >= this.locals.size()) {
            this.locals.add(Opcodes.TOP);
        }
        if (type == Opcodes.NULL && local < this.args.size()) {
            this.locals.set(local, this.args.get(local));
        } else {
            this.locals.set(local, type);
        }
    }

    private void setTopNolongerConstant() {
        if (!this.stackConstantVals.isEmpty()) {
            this.stackConstantVals.set(this.stackConstantVals.size() - 1, null);
        }
    }

    private void push(Object type, Object val, Object tag) {
        if (type.equals("java/lang/Object;")) {
            throw new IllegalArgumentException("Got " + type);
        }
        if (type instanceof TaggedValue) {
            type = ((TaggedValue)type).v;
        }
        this.stack.add(type);
        this.stackConstantVals.add(val);
        this.stackTagStatus.add(tag instanceof Boolean ? type : tag);
        this.maxStack = Math.max(this.maxStack, this.stack.size());
    }

    private void push(Object type) {
        this.push(type, null, type);
    }

    private void pushDesc(String desc) {
        int index = desc.charAt(0) == '(' ? desc.indexOf(41) + 1 : 0;
        switch (desc.charAt(index)) {
            case 'V': {
                return;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                this.push(Opcodes.INTEGER);
                return;
            }
            case 'F': {
                this.push(Opcodes.FLOAT);
                return;
            }
            case 'J': {
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                return;
            }
            case 'D': {
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                return;
            }
            case '[': {
                if (index == 0) {
                    this.push(desc);
                    break;
                }
                this.push(desc.substring(index, desc.length()));
                break;
            }
            default: {
                if (index == 0) {
                    this.push(desc.substring(1, desc.length() - 1));
                    break;
                }
                this.push(desc.substring(index + 1, desc.length() - 1));
            }
        }
    }

    private Object pop() {
        this.stackConstantVals.remove(this.stackConstantVals.size() - 1);
        this.stackTagStatus.remove(this.stackTagStatus.size() - 1);
        return this.stack.remove(this.stack.size() - 1);
    }

    private void pop(int n) {
        int size = this.stack.size();
        int end = size - n;
        for (int i = size - 1; i >= end; --i) {
            this.stack.remove(i);
            this.stackConstantVals.remove(i);
            this.stackTagStatus.remove(i);
        }
    }

    private void pop(String desc) {
        char c = desc.charAt(0);
        if (c == '(') {
            int n = 0;
            Type[] types = Type.getArgumentTypes(desc);
            for (int i = 0; i < types.length; ++i) {
                n += types[i].getSize();
            }
            this.pop(n);
        } else if (c == 'J' || c == 'D') {
            this.pop(2);
        } else {
            this.pop(1);
        }
    }

    private void execute(int opcode, int iarg, String sarg) {
        this.noInsnsSinceListFrame = false;
        this.isFollowedByFrame = false;
        if (this.locals == null) {
            this.labels = null;
            return;
        }
        block0 : switch (opcode) {
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 145: 
            case 146: 
            case 147: {
                this.setTopNolongerConstant();
            }
            case 0: 
            case 167: 
            case 177: {
                break;
            }
            case 1: {
                this.push(Opcodes.NULL);
                break;
            }
            case 2: {
                this.push(Opcodes.INTEGER, -1, false);
                break;
            }
            case 3: {
                this.push(Opcodes.INTEGER, 0, false);
                break;
            }
            case 4: {
                this.push(Opcodes.INTEGER, 1, false);
                break;
            }
            case 5: {
                this.push(Opcodes.INTEGER, 2, false);
                break;
            }
            case 6: {
                this.push(Opcodes.INTEGER, 3, false);
                break;
            }
            case 7: {
                this.push(Opcodes.INTEGER, 4, false);
                break;
            }
            case 8: {
                this.push(Opcodes.INTEGER, 5, false);
                break;
            }
            case 16: 
            case 17: {
                this.push(Opcodes.INTEGER, iarg, false);
                break;
            }
            case 9: {
                this.push(Opcodes.LONG, 0L, false);
                this.push(Opcodes.TOP);
                break;
            }
            case 10: {
                this.push(Opcodes.LONG, 1L, false);
                this.push(Opcodes.TOP);
                break;
            }
            case 11: {
                this.push(Opcodes.FLOAT, Float.valueOf(0.0f), false);
                break;
            }
            case 12: {
                this.push(Opcodes.FLOAT, Float.valueOf(1.0f), false);
                break;
            }
            case 13: {
                this.push(Opcodes.FLOAT, Float.valueOf(2.0f), false);
                break;
            }
            case 14: {
                this.push(Opcodes.DOUBLE, 0.0, false);
                this.push(Opcodes.TOP);
                break;
            }
            case 15: {
                this.push(Opcodes.DOUBLE, 1.0, false);
                this.push(Opcodes.TOP);
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                this.push(this.get(iarg), null, false);
                break;
            }
            case 22: 
            case 24: {
                this.push(this.get(iarg), null, false);
                this.push(Opcodes.TOP);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.pop(2);
                this.push(Opcodes.INTEGER);
                break;
            }
            case 47: {
                this.pop(2);
                this.push(Opcodes.LONG);
                this.push(Opcodes.TOP);
                break;
            }
            case 143: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(2);
                this.push(Opcodes.LONG, null, isTagged ? new TaggedValue(Opcodes.LONG) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 48: {
                this.pop(2);
                this.push(Opcodes.FLOAT);
                break;
            }
            case 49: {
                this.pop(2);
                this.push(Opcodes.DOUBLE);
                this.push(Opcodes.TOP);
                break;
            }
            case 138: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(2);
                this.push(Opcodes.DOUBLE, null, isTagged ? new TaggedValue(Opcodes.DOUBLE) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 50: {
                this.pop(1);
                Object t1 = this.pop();
                if (t1 instanceof String) {
                    this.pushDesc(((String)t1).substring(1));
                    break;
                }
                this.push("java/lang/Object");
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                Object t2;
                Object t1 = this.pop();
                this.set(iarg, t1);
                if (iarg <= 0 || (t2 = this.get(iarg - 1)) != Opcodes.LONG && t2 != Opcodes.DOUBLE) break;
                this.set(iarg - 1, Opcodes.TOP);
                break;
            }
            case 55: 
            case 57: {
                Object t2;
                this.pop(1);
                Object t1 = this.pop();
                this.set(iarg, t1);
                this.set(iarg + 1, Opcodes.TOP);
                if (iarg <= 0 || (t2 = this.get(iarg - 1)) != Opcodes.LONG && t2 != Opcodes.DOUBLE) break;
                this.set(iarg - 1, Opcodes.TOP);
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.pop(4);
                break;
            }
            case 87: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 176: 
            case 191: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                this.pop(1);
                break;
            }
            case 88: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 173: 
            case 175: {
                this.pop(2);
                break;
            }
            case 89: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z2 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                this.push(t1, z, z2);
                this.push(t1, z, z2);
                break;
            }
            case 90: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z3 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                Object z2 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z4 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t2 = this.pop();
                this.push(t1, z, z3);
                this.push(t2, z2, z4);
                this.push(t1, z, z3);
                break;
            }
            case 91: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z4 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                Object z2 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z5 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t2 = this.pop();
                Object z3 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z6 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t3 = this.pop();
                this.push(t1, z, z4);
                this.push(t3, z3, z6);
                this.push(t2, z2, z5);
                this.push(t1, z, z4);
                break;
            }
            case 92: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z3 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                Object z2 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z4 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t2 = this.pop();
                this.push(t2, z2, z4);
                this.push(t1, z, z3);
                this.push(t2, z2, z4);
                this.push(t1, z, z3);
                break;
            }
            case 93: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z4 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                Object z2 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z5 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t2 = this.pop();
                Object z3 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z6 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t3 = this.pop();
                this.push(t2, z2, z5);
                this.push(t1, z, z4);
                this.push(t3, z3, z6);
                this.push(t2, z2, z5);
                this.push(t1, z, z4);
                break;
            }
            case 94: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z5 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                Object z2 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z6 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t2 = this.pop();
                Object z3 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z7 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t3 = this.pop();
                Object z4 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z8 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t4 = this.pop();
                this.push(t2, z2, z6);
                this.push(t1, z, z5);
                this.push(t4, z4, z8);
                this.push(t3, z3, z7);
                this.push(t2, z2, z6);
                this.push(t1, z, z5);
                break;
            }
            case 95: {
                Object z = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z3 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t1 = this.pop();
                Object z2 = this.stackConstantVals.get(this.stackConstantVals.size() - 1);
                Object z4 = this.stackTagStatus.get(this.stackTagStatus.size() - 1);
                Object t2 = this.pop();
                this.push(t1, z, z3);
                this.push(t2, z2, z4);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 149: 
            case 150: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
                this.pop(2);
                this.push(Opcodes.INTEGER, null, isTagged ? new TaggedValue(Opcodes.INTEGER) : Boolean.valueOf(false));
                break;
            }
            case 136: 
            case 142: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(2);
                this.push(Opcodes.INTEGER, null, isTagged ? new TaggedValue(Opcodes.INTEGER) : Boolean.valueOf(false));
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(4);
                this.push(Opcodes.LONG, null, isTagged ? new TaggedValue(Opcodes.LONG) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
                this.pop(2);
                this.push(Opcodes.FLOAT, null, isTagged ? new TaggedValue(Opcodes.FLOAT) : Boolean.valueOf(false));
                break;
            }
            case 137: 
            case 144: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(2);
                this.push(Opcodes.FLOAT, null, isTagged ? new TaggedValue(Opcodes.FLOAT) : Boolean.valueOf(false));
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(4);
                this.push(Opcodes.DOUBLE, null, isTagged ? new TaggedValue(Opcodes.DOUBLE) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(3);
                this.push(Opcodes.LONG, null, isTagged ? new TaggedValue(Opcodes.LONG) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 132: {
                this.set(iarg, Opcodes.INTEGER);
                this.setTopNolongerConstant();
                break;
            }
            case 133: 
            case 140: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
                this.pop(1);
                this.push(Opcodes.LONG, null, isTagged ? new TaggedValue(Opcodes.LONG) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 134: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
                this.pop(1);
                this.push(Opcodes.FLOAT, null, isTagged ? new TaggedValue(Opcodes.FLOAT) : Boolean.valueOf(false));
                break;
            }
            case 135: 
            case 141: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
                this.pop(1);
                this.push(Opcodes.DOUBLE, null, isTagged ? new TaggedValue(Opcodes.DOUBLE) : Boolean.valueOf(false));
                this.push(Opcodes.TOP);
                break;
            }
            case 139: 
            case 190: 
            case 193: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 1) instanceof TaggedValue;
                this.pop(1);
                this.push(Opcodes.INTEGER, null, isTagged ? new TaggedValue(Opcodes.INTEGER) : Boolean.valueOf(false));
                break;
            }
            case 148: 
            case 151: 
            case 152: {
                boolean isTagged = this.stackTagStatus.get(this.stackTagStatus.size() - 2) instanceof TaggedValue;
                this.pop(4);
                this.push(Opcodes.INTEGER, null, isTagged ? new TaggedValue(Opcodes.INTEGER) : Boolean.valueOf(false));
                break;
            }
            case 168: 
            case 169: {
                throw new RuntimeException("JSR/RET are not supported");
            }
            case 178: {
                this.pushDesc(sarg);
                break;
            }
            case 179: {
                this.pop(sarg);
                break;
            }
            case 180: {
                this.pop(1);
                this.pushDesc(sarg);
                break;
            }
            case 181: {
                this.pop(sarg);
                this.pop();
                break;
            }
            case 187: {
                this.push(this.labels.get(0));
                break;
            }
            case 188: {
                this.pop();
                switch (iarg) {
                    case 4: {
                        this.pushDesc("[Z");
                        break block0;
                    }
                    case 5: {
                        this.pushDesc("[C");
                        break block0;
                    }
                    case 8: {
                        this.pushDesc("[B");
                        break block0;
                    }
                    case 9: {
                        this.pushDesc("[S");
                        break block0;
                    }
                    case 10: {
                        this.pushDesc("[I");
                        break block0;
                    }
                    case 6: {
                        this.pushDesc("[F");
                        break block0;
                    }
                    case 7: {
                        this.pushDesc("[D");
                        break block0;
                    }
                }
                this.pushDesc("[J");
                break;
            }
            case 189: {
                this.pop();
                this.pushDesc("[" + Type.getObjectType(sarg));
                break;
            }
            case 192: {
                this.pop();
                this.pushDesc(Type.getObjectType(sarg).getDescriptor());
                break;
            }
            default: {
                this.pop(iarg);
                this.pushDesc(sarg);
            }
        }
        this.labels = null;
    }

    public void clearLabels() {
        this.labels = null;
    }
}

