/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter.analyzer;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.BasicArrayValue;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.SinkableArrayValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Handle;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.AbstractInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FieldInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.IntInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LdcInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.TypeInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.AnalyzerException;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.BasicInterpreter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.BasicValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.Value;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.util.Printer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class InstMethodSinkInterpreter
extends BasicInterpreter {
    LinkedList<SinkableArrayValue> relevant;
    HashMap<AbstractInsnNode, SinkableArrayValue> executed = new HashMap();

    public InstMethodSinkInterpreter(LinkedList<SinkableArrayValue> relevantValues, HashMap<AbstractInsnNode, Value> liveValues) {
        super(Configuration.ASM_VERSION);
        this.relevant = relevantValues;
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2, BasicValue value3) throws AnalyzerException {
        if (value1 instanceof SinkableArrayValue && value3 instanceof SinkableArrayValue) {
            SinkableArrayValue arr = (SinkableArrayValue)value1;
            arr.addDep((SinkableArrayValue)value3);
            if (((SinkableArrayValue)value1).isNewArray && !((SinkableArrayValue)value3).isConstant) {
                SinkableArrayValue v = (SinkableArrayValue)value1;
                while (v != null && v.isNewArray) {
                    v.isNewArray = false;
                    if (v.reverseDeps != null) {
                        for (SinkableArrayValue x : v.reverseDeps) {
                            if (!x.isNewArray) continue;
                            x.isNewArray = false;
                            if (x.reverseDeps == null) continue;
                            for (SinkableArrayValue y : x.reverseDeps) {
                                y.isNewArray = false;
                            }
                        }
                    }
                    v = v.copyOf;
                }
            }
        }
        return super.ternaryOperation(insn, value1, value2, value3);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue _v) throws AnalyzerException {
        if (_v instanceof SinkableArrayValue) {
            SinkableArrayValue ret = new SinkableArrayValue(_v.getType());
            ret.addDepCopy((SinkableArrayValue)_v);
            ret.setSrc(insn);
            return ret;
        }
        SinkableArrayValue old = this.executed.put(insn, null);
        if (old != null) {
            old.disable();
        }
        return super.copyOperation(insn, _v);
    }

    public BasicValue copyOperationIgnoreOld(AbstractInsnNode insn, BasicValue _v) throws AnalyzerException {
        if (_v instanceof SinkableArrayValue) {
            SinkableArrayValue ret = new SinkableArrayValue(_v.getType());
            ret.addDepCopy((SinkableArrayValue)_v);
            ret.setSrc(insn);
            return ret;
        }
        return super.copyOperation(insn, _v);
    }

    public BasicValue copyOperation(AbstractInsnNode insn, SinkableArrayValue underlying, SinkableArrayValue existing) throws AnalyzerException {
        BasicValue ret = this.copyOperationIgnoreOld(insn, underlying);
        if (ret instanceof SinkableArrayValue) {
            ((SinkableArrayValue)ret).masterDup = existing;
            existing.isBottomDup = true;
            existing.otherDups.add((SinkableArrayValue)ret);
        }
        return ret;
    }

    private BasicValue _unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: 
            case 132: 
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                SinkableArrayValue ret = new SinkableArrayValue(Type.INT_TYPE);
                ret.addDep((SinkableArrayValue)value);
                return ret;
            }
            case 118: 
            case 134: 
            case 137: 
            case 144: {
                SinkableArrayValue ret = new SinkableArrayValue(Type.FLOAT_TYPE);
                ret.addDep((SinkableArrayValue)value);
                return ret;
            }
            case 117: 
            case 133: 
            case 140: 
            case 143: {
                SinkableArrayValue ret = new SinkableArrayValue(Type.LONG_TYPE);
                ret.addDep((SinkableArrayValue)value);
                return ret;
            }
            case 119: 
            case 135: 
            case 138: 
            case 141: {
                SinkableArrayValue ret = new SinkableArrayValue(Type.DOUBLE_TYPE);
                ret.addDep((SinkableArrayValue)value);
                return ret;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: {
                return null;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 179: {
                return null;
            }
            case 180: {
                return this.newValue(Type.getType(((FieldInsnNode)insn).desc));
            }
            case 188: {
                SinkableArrayValue ret = null;
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[Z"));
                        break;
                    }
                    case 5: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[C"));
                        break;
                    }
                    case 8: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[B"));
                        break;
                    }
                    case 9: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[S"));
                        break;
                    }
                    case 10: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[I"));
                        break;
                    }
                    case 6: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[F"));
                        break;
                    }
                    case 7: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[D"));
                        break;
                    }
                    case 11: {
                        ret = (SinkableArrayValue)this.newValue(Type.getType("[J"));
                        break;
                    }
                    default: {
                        throw new AnalyzerException(insn, "Invalid array type");
                    }
                }
                if (Configuration.ARRAY_LENGTH_TRACKING) {
                    ret.addDep((SinkableArrayValue)value);
                }
                ret.isNewArray = true;
                return ret;
            }
            case 189: {
                String desc = ((TypeInsnNode)insn).desc;
                return this.newValue(Type.getType("[" + Type.getObjectType(desc)));
            }
            case 190: {
                SinkableArrayValue ret = (SinkableArrayValue)this.newValue(Type.INT_TYPE);
                if (value instanceof SinkableArrayValue && value.getType() != null && TaintUtils.isPrimitiveArrayType(value.getType())) {
                    ret.addDep((SinkableArrayValue)value);
                }
                return ret;
            }
            case 191: {
                return null;
            }
            case 192: {
                String desc = ((TypeInsnNode)insn).desc;
                BasicValue _ret = this.newValue(Type.getObjectType(desc));
                if (value instanceof SinkableArrayValue && _ret instanceof SinkableArrayValue) {
                    ((SinkableArrayValue)_ret).addDep((SinkableArrayValue)value);
                }
                return _ret;
            }
            case 193: {
                return this.newValue(Type.INT_TYPE);
            }
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                return null;
            }
        }
        throw new Error("Internal error.");
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        BasicValue v = this._unaryOperation(insn, value);
        if (v instanceof SinkableArrayValue) {
            ((SinkableArrayValue)v).setSrc(insn);
        }
        return v;
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        SinkableArrayValue ret = null;
        switch (insn.getOpcode()) {
            case 46: {
                ret = (SinkableArrayValue)this.newValue(Type.INT_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 51: {
                ret = (SinkableArrayValue)this.newValue(Type.BYTE_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 52: {
                ret = (SinkableArrayValue)this.newValue(Type.CHAR_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 53: {
                ret = (SinkableArrayValue)this.newValue(Type.SHORT_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 49: {
                ret = (SinkableArrayValue)this.newValue(Type.DOUBLE_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 47: {
                ret = (SinkableArrayValue)this.newValue(Type.LONG_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 48: {
                ret = (SinkableArrayValue)this.newValue(Type.FLOAT_TYPE);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)value1);
                return ret;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                SinkableArrayValue v1 = (SinkableArrayValue)value1;
                SinkableArrayValue v2 = (SinkableArrayValue)value2;
                SinkableArrayValue v3 = new SinkableArrayValue(v1.getType());
                v3.addDep(v1);
                v3.addDep(v2);
                return v3;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                SinkableArrayValue v1 = (SinkableArrayValue)value1;
                SinkableArrayValue v2 = (SinkableArrayValue)value2;
                SinkableArrayValue v3 = new SinkableArrayValue(Type.INT_TYPE);
                v3.addDep(v1);
                v3.addDep(v2);
                return v3;
            }
            case 50: {
                if (value1.getType() == null) {
                    ret = new SinkableArrayValue(null);
                    ret.setSrc(insn);
                    return ret;
                }
                if (value1 == BasicValue.REFERENCE_VALUE) {
                    return super.binaryOperation(insn, value1, value2);
                }
                Type t = Type.getType(value1.getType().getDescriptor().substring(1));
                if (TaintUtils.isPrimitiveArrayType(t)) {
                    ret = new SinkableArrayValue(t);
                    ret.setSrc(insn);
                    return ret;
                }
                if (t.getSort() == 9) {
                    ret = new SinkableArrayValue(t);
                    ret.setSrc(insn);
                    return ret;
                }
                return super.binaryOperation(insn, value1, value2);
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return null;
            }
            case 181: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Internal error.");
    }

    @Override
    public BasicValue merge(BasicValue v, BasicValue w) {
        BasicValue r;
        if (v == BasicValue.UNINITIALIZED_VALUE && w == BasicValue.UNINITIALIZED_VALUE) {
            return v;
        }
        if (!(v instanceof SinkableArrayValue) && !(w instanceof SinkableArrayValue)) {
            return super.merge(v, w);
        }
        if (v.equals(w)) {
            return v;
        }
        if (v instanceof SinkableArrayValue && w instanceof SinkableArrayValue) {
            SinkableArrayValue sv = (SinkableArrayValue)v;
            SinkableArrayValue sw = (SinkableArrayValue)w;
            if (sv.deepEquals(sw)) {
                if (sw.reverseDeps != null) {
                    for (SinkableArrayValue r2 : sw.reverseDeps) {
                        r2.deps.remove(sw);
                        r2.addDep(sv);
                    }
                }
                if (sw.deps != null) {
                    if (sv.deps == null) {
                        sv.deps = new HashSet();
                    }
                    sv.deps.addAll(sw.deps);
                }
                sw.disable();
                return sv;
            }
            if (sv.getSrc() != null && sw.getSrc() != null && sv.getSrc().equals(sw.getSrc()) && sv.getSrc().getOpcode() != 192 && (sv.getType() == null && sw.getType() == null || sv.getType() != null && sw.getType() != null && sv.getType().equals(sw.getType()))) {
                if (sv.reverseDeps == null && sw.reverseDeps != null) {
                    sv.reverseDeps = new HashSet();
                }
                if (sw.reverseDeps != null) {
                    for (SinkableArrayValue r3 : sw.reverseDeps) {
                        r3.deps.remove(sw);
                        r3.addDep(sv);
                        sv.reverseDeps.add(r3);
                    }
                }
                if (sw.deps != null) {
                    if (sv.deps == null) {
                        sv.deps = new HashSet();
                    }
                    sv.deps.addAll(sw.deps);
                }
                sw.disable();
                return sv;
            }
            if ((v.getType() == null || v.getType().getDescriptor().equals("Lnull;")) && (w.getType() == null || w.getType().getDescriptor().equals("Lnull;"))) {
                if (sv.getSrc() != null && sw.oldSrc != null && sv.getSrc().equals(sw.oldSrc)) {
                    return sv;
                }
                if (sw.getSrc() != null && sv.deps != null && sw != null && sv.deps.contains(sw) || sw.getSrc() == null && sw.deps != null && sv.deps != null && sv.deps.containsAll(sw.deps)) {
                    return v;
                }
                if (sv.deps != null && sw != null && sv.deps.contains(sw)) {
                    return v;
                }
                if (sw.getSrc() != null && sv.oldSrc != null && sw.getSrc().equals(sv.oldSrc)) {
                    return sw;
                }
                if (sv.getSrc() == null && sw.getSrc() == null) {
                    sv.addDep(sw);
                    return v;
                }
                if (sw.deps != null && sv != null && sw.deps.contains(sv)) {
                    return w;
                }
                if (sv.getSrc() != null) {
                    sv.addDep(sw);
                    return v;
                }
                if (sw.getSrc() != null) {
                    sw.addDep(sv);
                    return w;
                }
                sv.addDep(sw);
                return v;
            }
            if (v.getType() == null || v.getType().getDescriptor().equals("Lnull;")) {
                if (w.getType().getSort() == 9) {
                    sw.addDep(sv);
                    if (sv.oldSrc != null) {
                        sv.setSrc(sv.oldSrc);
                        sv.oldSrc = null;
                        sv.dontPropogateToDeps = false;
                        sv.flowsToPrim = true;
                    }
                }
                return w;
            }
            if (w.getType() == null || w.getType().getDescriptor().equals("Lnull;")) {
                if (v.getType().getSort() == 9) {
                    sv.addDep(sw);
                    if (sw.oldSrc != null) {
                        sw.setSrc(sw.oldSrc);
                        sw.oldSrc = null;
                        sw.dontPropogateToDeps = false;
                        sw.flowsToPrim = true;
                    }
                    if (sv.getSrc() != null && sv.getSrc().getOpcode() == 192 && sw.getSrc() != null && sw.getSrc().getOpcode() == 1) {
                        sv.okToPropogateToDeps = true;
                    }
                }
                return v;
            }
            if (TaintUtils.isPrimitiveOrPrimitiveArrayType(v.getType()) && TaintUtils.isPrimitiveOrPrimitiveArrayType(w.getType()) && v.getType().equals(w.getType())) {
                if (sv.flowsToInstMethodCall && !sw.flowsToInstMethodCall) {
                    return v;
                }
                if (sw.flowsToInstMethodCall && !sv.flowsToInstMethodCall) {
                    return v;
                }
                if (sw.getSrc() != null && sv.getSrc() != null && sw.getSrc().getOpcode() == 192 && sv.getSrc().getOpcode() == 192 && (sv.deps == null || sw.deps == null)) {
                    if (sv.deps != null && sv.deps.size() == 1 && sw.deps == null) {
                        if (!sv.okToPropogateToDeps) {
                            sv.dontPropogateToDeps = true;
                        }
                    } else if (sw.deps != null && sw.deps.size() == 1 && sv.deps == null && !sv.okToPropogateToDeps) {
                        sv.dontPropogateToDeps = true;
                    }
                }
                sv.addDep(sw);
                return v;
            }
        }
        if (v.getType() == null || v.getType().getDescriptor().equals("Lnull;")) {
            if (v instanceof SinkableArrayValue && ((SinkableArrayValue)v).getSrc() != null && !((SinkableArrayValue)v).flowsToPrim) {
                ((SinkableArrayValue)v).disable();
                ((SinkableArrayValue)v).dontPropogateToDeps = true;
            }
            return w;
        }
        if (w.getType() == null || w.getType().getDescriptor().equals("Lnull;")) {
            if (!(!(w instanceof SinkableArrayValue) || ((SinkableArrayValue)w).getSrc() == null || ((SinkableArrayValue)w).flowsToPrim || v.getType() != null && v.getType().getInternalName().equals("java/lang/Object"))) {
                ((SinkableArrayValue)w).disable();
                ((SinkableArrayValue)w).dontPropogateToDeps = true;
            }
            return v;
        }
        if (v.getType().getDescriptor().equals("Ljava/lang/Object;")) {
            return v;
        }
        if (v.getType().getSort() == 9 && v.getType().getDimensions() > 1) {
            return v;
        }
        if (v.getType().equals(w.getType()) || v.getType().getDescriptor().length() == 1 && w.getType().getDescriptor().length() == 1) {
            r = new SinkableArrayValue(v.getType());
            r.addDep((SinkableArrayValue)w);
            r.addDep((SinkableArrayValue)v);
            return r;
        }
        r = new BasicArrayValue(Type.getType(Object.class));
        return r;
    }

    private static String toStringSrcs(Collection<SinkableArrayValue> c) {
        String r = "[";
        if (c != null) {
            for (SinkableArrayValue s : c) {
                if (s.getSrc() == null) continue;
                r = r + Printer.OPCODES[s.getSrc().getOpcode()] + ", ";
            }
        }
        return r + "]";
    }

    private BasicValue _newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return this.newValue(Type.getObjectType("null"));
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.newValue(Type.INT_TYPE);
            }
            case 9: 
            case 10: {
                return this.newValue(Type.LONG_TYPE);
            }
            case 11: 
            case 12: 
            case 13: {
                return this.newValue(Type.FLOAT_TYPE);
            }
            case 14: 
            case 15: {
                return this.newValue(Type.DOUBLE_TYPE);
            }
            case 16: 
            case 17: {
                return this.newValue(Type.INT_TYPE);
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                if (cst instanceof Integer) {
                    return this.newValue(Type.INT_TYPE);
                }
                if (cst instanceof Float) {
                    return this.newValue(Type.FLOAT_TYPE);
                }
                if (cst instanceof Long) {
                    return this.newValue(Type.LONG_TYPE);
                }
                if (cst instanceof Double) {
                    return this.newValue(Type.DOUBLE_TYPE);
                }
                if (cst instanceof String) {
                    return this.newValue(Type.getObjectType("java/lang/String"));
                }
                if (cst instanceof Type) {
                    int sort = ((Type)cst).getSort();
                    if (sort == 10 || sort == 9) {
                        return this.newValue(Type.getObjectType("java/lang/Class"));
                    }
                    if (sort == 11) {
                        return this.newValue(Type.getObjectType("java/lang/invoke/MethodType"));
                    }
                    throw new IllegalArgumentException("Illegal LDC constant " + cst);
                }
                if (cst instanceof Handle) {
                    return this.newValue(Type.getObjectType("java/lang/invoke/MethodHandle"));
                }
                throw new IllegalArgumentException("Illegal LDC constant " + cst);
            }
            case 168: {
                return BasicValue.RETURNADDRESS_VALUE;
            }
            case 178: {
                return this.newValue(Type.getType(((FieldInsnNode)insn).desc));
            }
            case 187: {
                return this.newValue(Type.getObjectType(((TypeInsnNode)insn).desc));
            }
        }
        throw new Error("Internal error.");
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        BasicValue ret = this._newOperation(insn);
        if (ret instanceof SinkableArrayValue) {
            ((SinkableArrayValue)ret).setSrc(insn);
        }
        return ret;
    }

    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return new SinkableArrayValue(null);
        }
        if (TaintUtils.isPrimitiveOrPrimitiveArrayType(type)) {
            SinkableArrayValue ret = new SinkableArrayValue(type);
            return ret;
        }
        if (type.getSort() == 9 && type.getElementType().getSort() != 10) {
            BasicArrayValue ret = new BasicArrayValue(type);
            return ret;
        }
        if (type.getDescriptor().equals("Lnull;")) {
            return new SinkableArrayValue(null);
        }
        BasicValue ret = super.newValue(type);
        return ret;
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        if (insn instanceof MethodInsnNode) {
            MethodInsnNode min = (MethodInsnNode)insn;
            Type retType = Type.getReturnType(min.desc);
            if (TaintUtils.isPrimitiveOrPrimitiveArrayType(retType)) {
                SinkableArrayValue ret = new SinkableArrayValue(retType);
                ret.setSrc(insn);
                return ret;
            }
            if (min.name.equals("clone") && min.desc.equals("()Ljava/lang/Object;") && values.get(0) instanceof SinkableArrayValue) {
                SinkableArrayValue ret = new SinkableArrayValue(retType);
                ret.setSrc(insn);
                ret.addDep((SinkableArrayValue)values.get(0));
                return ret;
            }
        } else if (insn instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode min = (InvokeDynamicInsnNode)insn;
            Type retType = Type.getReturnType(min.desc);
            if (TaintUtils.isPrimitiveOrPrimitiveArrayType(retType)) {
                SinkableArrayValue ret = new SinkableArrayValue(retType);
                ret.setSrc(insn);
                return ret;
            }
        }
        return super.naryOperation(insn, values);
    }
}

