/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter.analyzer;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.BasicArrayValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.AbstractInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FieldInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.TypeInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.VarInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.AnalyzerException;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.BasicInterpreter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.BasicValue;
import edu.columbia.cs.psl.phosphor.struct.Field;
import java.util.List;
import java.util.Objects;

public class BasicArrayInterpreter
extends BasicInterpreter {
    private boolean isStaticMethod;
    private boolean isImplicitLightTracking;
    public static final BasicValue THIS_VALUE = new BasicValue(Type.getType("Ljava/lang/Object;"));

    public BasicArrayInterpreter(boolean isStaticMethod, boolean isImplicitLightTracking) {
        super(Configuration.ASM_VERSION);
        this.isStaticMethod = isStaticMethod;
        this.isImplicitLightTracking = isImplicitLightTracking;
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        if (insn.getOpcode() == 1) {
            return BasicArrayValue.NULL_VALUE;
        }
        if (Configuration.IMPLICIT_TRACKING || this.isImplicitLightTracking) {
            String t = null;
            if (insn.getOpcode() == 187) {
                t = ((TypeInsnNode)insn).desc;
            }
            if (t != null && (t.contains("Exception") || t.contains("Error"))) {
                return new BasicValue(Type.getObjectType(t));
            }
        }
        if (insn.getOpcode() == 178) {
            FieldInsnNode fin = (FieldInsnNode)insn;
            return new BasicThisFieldValue(Type.getType(fin.desc), new Field(true, fin.owner, fin.name, fin.desc));
        }
        return super.newOperation(insn);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (!this.isStaticMethod && insn.getOpcode() == 25 && ((VarInsnNode)insn).var == 0) {
            return THIS_VALUE;
        }
        return super.copyOperation(insn, value);
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn.getOpcode() == 180 && value == THIS_VALUE) {
            FieldInsnNode fin = (FieldInsnNode)insn;
            return new BasicThisFieldValue(Type.getType(fin.desc), new Field(false, fin.owner, fin.name, fin.desc));
        }
        return super.unaryOperation(insn, value);
    }

    @Override
    public BasicValue merge(BasicValue v, BasicValue w) {
        if (v == BasicValue.UNINITIALIZED_VALUE || w == BasicValue.UNINITIALIZED_VALUE) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (v instanceof BasicThisFieldValue && !(w instanceof BasicThisFieldValue) || w instanceof BasicThisFieldValue && !(v instanceof BasicThisFieldValue)) {
            if (v.getType().equals(w.getType())) {
                if (v.getType().getSort() == 10 || v.getType().getSort() == 9) {
                    return BasicValue.REFERENCE_VALUE;
                }
                return this.newValue(v.getType());
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (v instanceof BasicThisFieldValue && w instanceof BasicThisFieldValue) {
            if (v.equals(w)) {
                return v;
            }
            return BasicValue.UNINITIALIZED_VALUE;
        }
        return super.merge(v, w);
    }

    @Override
    public BasicValue naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        Type typ;
        String t = null;
        if (insn.getType() == 5 && (typ = Type.getReturnType(((MethodInsnNode)insn).desc)).getSort() == 10) {
            t = typ.getInternalName();
        }
        if (t != null && (t.contains("Exception") || t.contains("Error"))) {
            return new BasicValue(Type.getObjectType(t));
        }
        return super.naryOperation(insn, values);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        if (insn.getOpcode() == 50) {
            return value1;
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        if (type.getSort() == 9) {
            if (type.getDimensions() > 1) {
                return new BasicArrayValue(type);
            }
            switch (type.getElementType().getSort()) {
                case 1: {
                    return BasicArrayValue.BOOLEAN_ARRAY;
                }
                case 3: {
                    return BasicArrayValue.BYTE_ARRAY;
                }
                case 2: {
                    return BasicArrayValue.CHAR_ARRAY;
                }
                case 8: {
                    return BasicArrayValue.DOUBLE_ARRAY;
                }
                case 6: {
                    return BasicArrayValue.FLOAT_ARRAY;
                }
                case 5: {
                    return BasicArrayValue.INT_ARRAY;
                }
                case 7: {
                    return BasicArrayValue.LONG_ARRAY;
                }
                case 10: {
                    return BasicArrayValue.REFERENCE_VALUE;
                }
                case 4: {
                    return BasicArrayValue.SHORT_ARRAY;
                }
            }
            throw new IllegalArgumentException();
        }
        if (type.equals("Lnull;")) {
            return BasicArrayValue.NULL_VALUE;
        }
        if (Configuration.IMPLICIT_EXCEPTION_FLOW && (type.getDescriptor().contains("Error") || type.getDescriptor().contains("Exception"))) {
            return new BasicArrayValue(type);
        }
        return super.newValue(type);
    }

    public class BasicThisFieldValue
    extends BasicValue {
        private Field field;

        public Field getField() {
            return this.field;
        }

        @Override
        public String toString() {
            return "BasicThisFieldValue{field=" + this.field + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BasicThisFieldValue that = (BasicThisFieldValue)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.field);
        }

        public BasicThisFieldValue(Type t, Field f) {
            super(t);
            this.field = f;
        }
    }
}

