/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.instrumenter.LocalVariableManager;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.runtime.ArrayReflectionMasker;
import edu.columbia.cs.psl.phosphor.runtime.ReflectionMasker;
import edu.columbia.cs.psl.phosphor.runtime.RuntimeReflectionPropogator;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.MethodInvoke;

public class UninstrumentedReflectionHidingMV
extends MethodVisitor
implements Opcodes {
    private String className;
    private LocalVariableManager lvs;

    public UninstrumentedReflectionHidingMV(MethodVisitor mv, String className) {
        super(Configuration.ASM_VERSION, mv);
        this.className = className;
    }

    public void setLvs(LocalVariableManager lvs) {
        this.lvs = lvs;
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        int lv1;
        Type[] args = Type.getArgumentTypes(desc);
        if (owner.equals("java/lang/reflect/Field") && opcode == 182 && (name.equals("get") || name.equals("set"))) {
            owner = Type.getInternalName(RuntimeReflectionPropogator.class);
            opcode = 184;
            name = name + "UNINST";
            desc = "(Ljava/lang/reflect/Field;" + desc.substring(1);
        }
        if ((owner.equals("java/lang/reflect/Method") || owner.equals("java/lang/reflect/Constructor")) && (name.startsWith("invoke") || name.startsWith("newInstance"))) {
            if (owner.equals("java/lang/reflect/Method")) {
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgsUninst", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;" + Type.getDescriptor(ControlTaintTagStack.class) + ")" + Type.getDescriptor(MethodInvoke.class), false);
                } else {
                    super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                    super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgsUninst", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;Z)" + Type.getDescriptor(MethodInvoke.class), false);
                }
                super.visitInsn(89);
                super.visitFieldInsn(180, Type.getInternalName(MethodInvoke.class), "m", "Ljava/lang/reflect/Method;");
                super.visitInsn(95);
                super.visitInsn(89);
                super.visitFieldInsn(180, Type.getInternalName(MethodInvoke.class), "o", "Ljava/lang/Object;");
                super.visitInsn(95);
                super.visitFieldInsn(180, Type.getInternalName(MethodInvoke.class), "a", "[Ljava/lang/Object;");
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
                }
            } else if (Configuration.IMPLICIT_TRACKING) {
                super.visitInsn(87);
                super.visitInsn(95);
                super.visitInsn(90);
                super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgsUninst", "([Ljava/lang/Object;Ljava/lang/reflect/Constructor;" + Type.getDescriptor(ControlTaintTagStack.class) + ")[Ljava/lang/Object;", false);
                super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
            } else {
                super.visitInsn(95);
                super.visitInsn(90);
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgsUninst", "([Ljava/lang/Object;Ljava/lang/reflect/Constructor;Z)[Ljava/lang/Object;", false);
            }
        } else if (owner.equals("java/lang/reflect/Method") && name.startsWith("get") && !this.className.equals(owner) && !this.className.startsWith("sun/reflect") && !this.className.startsWith("java/lang/Class")) {
            if (args.length == 0) {
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", "(Ljava/lang/reflect/Method;Z)Ljava/lang/reflect/Method;", false);
            } else if (args.length == 1) {
                super.visitInsn(95);
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", "(Ljava/lang/reflect/Method;Z)Ljava/lang/reflect/Method;", false);
                super.visitInsn(95);
            } else if (args.length == 2) {
                lv1 = this.lvs.getTmpLV();
                super.visitVarInsn(58, lv1);
                int lv2 = this.lvs.getTmpLV();
                super.visitVarInsn(58, lv2);
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", "(Ljava/lang/reflect/Method;Z)Ljava/lang/reflect/Method;", false);
                super.visitVarInsn(25, lv2);
                super.visitVarInsn(25, lv1);
                this.lvs.freeTmpLV(lv1);
                this.lvs.freeTmpLV(lv2);
            }
        } else if (owner.equals("java/lang/reflect/Constructor") && name.startsWith("get") && !this.className.equals(owner) && !this.className.startsWith("sun/reflect") && !this.className.equals("java/lang/Class")) {
            if (args.length == 0) {
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", "(Ljava/lang/reflect/Constructor;Z)Ljava/lang/reflect/Constructor;", false);
            } else if (args.length == 1) {
                super.visitInsn(95);
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", "(Ljava/lang/reflect/Constructor;Z)Ljava/lang/reflect/Constructor;", false);
                super.visitInsn(95);
            } else if (args.length == 2) {
                lv1 = this.lvs.getTmpLV();
                super.visitVarInsn(58, lv1);
                int lv2 = this.lvs.getTmpLV();
                super.visitVarInsn(58, lv2);
                super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", "(Ljava/lang/reflect/Constructor;Z)Ljava/lang/reflect/Constructor;", false);
                super.visitVarInsn(25, lv2);
                super.visitVarInsn(25, lv1);
                this.lvs.freeTmpLV(lv1);
                this.lvs.freeTmpLV(lv2);
            }
        } else if (owner.equals("java/lang/reflect/Array") && !owner.equals(this.className)) {
            owner = Type.getInternalName(ArrayReflectionMasker.class);
            if (Configuration.MULTI_TAINTING) {
                desc = desc.replace(Configuration.TAINT_TAG_DESC, "Ljava/lang/Object;");
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itfc);
        if (owner.equals("java/lang/Class") && desc.equals("()[Ljava/lang/reflect/Field;")) {
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintFields", "([Ljava/lang/reflect/Field;)[Ljava/lang/reflect/Field;", false);
        } else if (owner.equals("java/lang/Class") && desc.equals("()[Ljava/lang/reflect/Method;")) {
            super.visitInsn("getMethods".equals(name) ? 3 : 4);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintMethods", "([Ljava/lang/reflect/Method;Z)[Ljava/lang/reflect/Method;", false);
        } else if (owner.equals("java/lang/Class") && desc.equals("()[Ljava/lang/reflect/Constructor;")) {
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintConstructors", "([Ljava/lang/reflect/Constructor;)[Ljava/lang/reflect/Constructor;", false);
        } else if (owner.equals("java/lang/Class") && name.equals("getInterfaces")) {
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintedInterface", "([Ljava/lang/Class;)[Ljava/lang/Class;", false);
        } else if (owner.equals("java/lang/Throwable") && (name.equals("getOurStackTrace") || name.equals("getStackTrace")) && desc.equals("()[" + Type.getDescriptor(StackTraceElement.class))) {
            String stackTraceElDesc = "[" + Type.getDescriptor(StackTraceElement.class);
            if (this.className.equals("java/lang/Throwable")) {
                super.visitVarInsn(25, 0);
                super.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            } else {
                super.visitLdcInsn(Type.getObjectType(this.className));
            }
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeExtraStackTraceElements", "(" + stackTraceElDesc + "Ljava/lang/Class;)" + stackTraceElDesc, false);
        } else if (owner.equals("java/lang/Object") && name.equals("getClass")) {
            super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintClass", "(Ljava/lang/Class;Z)Ljava/lang/Class;", false);
        }
    }
}

