/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LocalVariableNode;
import edu.columbia.cs.psl.phosphor.runtime.UninstrumentedTaintSentinel;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArrayWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArrayWithObjTag;

public class UninstrumentedCompatMV
extends TaintAdapter {
    private NeverNullArgAnalyzerAdapter analyzer;
    private boolean skipFrames;
    private Type returnType;
    private Type originalReturnType;

    public UninstrumentedCompatMV(int access, String className, String name, String desc, Type originalReturnType, String signature, String[] exceptions, MethodVisitor mv, NeverNullArgAnalyzerAdapter analyzer, boolean skipFrames) {
        super(access, className, name, desc, signature, exceptions, mv, analyzer);
        this.analyzer = analyzer;
        this.skipFrames = skipFrames;
        this.returnType = Type.getReturnType(desc);
        this.originalReturnType = originalReturnType;
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        Type t;
        int i;
        Object[] newLocal = new Object[local.length];
        Object[] newStack = new Object[stack.length];
        for (i = 0; i < local.length; ++i) {
            if (local[i] instanceof String) {
                t = Type.getObjectType((String)local[i]);
                if (t.getSort() == 9 && t.getElementType().getSort() != 10 && t.getDimensions() > 1) {
                    newLocal[i] = MultiDTaintedArray.getTypeForType(t).getInternalName();
                    continue;
                }
                newLocal[i] = local[i];
                continue;
            }
            newLocal[i] = local[i];
        }
        for (i = 0; i < stack.length; ++i) {
            if (stack[i] instanceof String) {
                t = Type.getObjectType((String)stack[i]);
                if (t.getSort() == 9 && t.getElementType().getSort() != 10 && t.getDimensions() > 1) {
                    newStack[i] = MultiDTaintedArray.getTypeForType(t).getInternalName();
                    continue;
                }
                newStack[i] = stack[i];
                continue;
            }
            newStack[i] = stack[i];
        }
        super.visitFrame(type, nLocal, newLocal, nStack, newStack);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Type t = Type.getType(desc);
        if (t.getSort() == 9 && t.getDimensions() > 1 && t.getElementType().getSort() != 10) {
            desc = MultiDTaintedArray.getTypeForType(t).getDescriptor();
        }
        switch (opcode) {
            case 178: 
            case 180: {
                super.visitFieldInsn(opcode, owner, name, desc);
                break;
            }
            case 179: 
            case 181: {
                if (t.getSort() == 9 && t.getDimensions() == 1 && t.getElementType().getSort() != 10) {
                    String taintFieldType = TaintUtils.getShadowTaintType(desc);
                    FrameNode fn = this.getCurrentFrameNode();
                    fn.type = -1;
                    super.visitInsn(89);
                    Label ok = new Label();
                    super.visitJumpInsn(198, ok);
                    if (opcode == 181) {
                        super.visitInsn(92);
                    } else {
                        super.visitInsn(89);
                    }
                    super.visitTypeInsn(187, Type.getType(taintFieldType).getInternalName());
                    super.visitInsn(90);
                    super.visitInsn(90);
                    super.visitInsn(87);
                    super.visitMethodInsn(183, Type.getType(taintFieldType).getInternalName(), "<init>", "(" + desc + ")V", false);
                    super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", taintFieldType);
                    super.visitLabel(ok);
                    if (!this.skipFrames) {
                        fn.accept(this);
                    }
                }
                super.visitFieldInsn(opcode, owner, name, desc);
            }
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        Type arrayType;
        Type origType = arrayType = Type.getType(desc);
        boolean needToHackDims = false;
        int tmp = 0;
        if (arrayType.getElementType().getSort() != 10) {
            if (dims == arrayType.getDimensions()) {
                needToHackDims = true;
                --dims;
                tmp = this.lvs.getTmpLV(Type.INT_TYPE);
                super.visitVarInsn(54, tmp);
            }
            arrayType = MultiDTaintedArray.getTypeForType(arrayType);
            desc = arrayType.getInternalName();
        }
        if (dims == 1) {
            super.visitTypeInsn(189, arrayType.getElementType().getInternalName());
        } else {
            super.visitMultiANewArrayInsn(desc, dims);
        }
        if (needToHackDims) {
            super.visitInsn(89);
            super.visitVarInsn(21, tmp);
            this.lvs.freeTmpLV(tmp);
            super.visitIntInsn(16, origType.getElementType().getSort());
            super.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "initLastDim", "([Ljava/lang/Object;II)V", false);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 192) {
            Type t;
            if (!this.analyzer.stack.isEmpty() && "java/lang/Object".equals(this.analyzer.stack.get(this.analyzer.stack.size() - 1)) && type.startsWith("[") && type.length() == 2) {
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "maybeUnbox", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            }
            if ((t = Type.getObjectType(type)).getSort() == 9 && t.getDimensions() > 1 && t.getElementType().getSort() != 10) {
                type = MultiDTaintedArray.getTypeForType(t).getInternalName();
            }
        } else if (opcode == 189) {
            Type t = Type.getObjectType(type);
            if (t.getSort() == 9 && t.getElementType().getDescriptor().length() == 1) {
                type = MultiDTaintedArray.getTypeForType(t).getInternalName();
            }
        } else if (opcode == 193) {
            Type t = Type.getObjectType(type);
            if (t.getSort() == 9 && t.getDimensions() > 1 && t.getElementType().getSort() != 10) {
                type = MultiDTaintedArray.getTypeForType(t).getDescriptor();
            } else if (t.getSort() == 9 && t.getDimensions() == 1 && t.getElementType().getSort() != 10 && this.getTopOfStackObject().equals("java/lang/Object")) {
                type = MultiDTaintedArray.getTypeForType(t).getInternalName();
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 83: {
                Object arType = this.analyzer.stack.get(this.analyzer.stack.size() - 3);
                Type elType = this.getTopOfStackType();
                if (arType.equals("[Ljava/lang/Object;") && (elType.getSort() == 9 && elType.getElementType().getSort() != 10 || elType.getDescriptor().equals("Ljava/lang/Object;"))) {
                    super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                } else if (arType instanceof String && ((String)arType).contains("[Ledu/columbia/cs/psl/phosphor/struct/multid/MultiDTainted")) {
                    super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                }
                super.visitInsn(opcode);
                break;
            }
            case 50: {
                Object arrayType = this.analyzer.stack.get(this.analyzer.stack.size() - 2);
                Type t = UninstrumentedCompatMV.getTypeForStackType(arrayType);
                if (t.getDimensions() == 1 && t.getElementType().getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/multid/MultiDTainted")) {
                    super.visitInsn(opcode);
                    try {
                        super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unbox1D", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        super.visitTypeInsn(192, "[" + MultiDTaintedArray.getPrimitiveTypeForWrapper(Class.forName(t.getElementType().getInternalName().replace("/", "."))));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                super.visitInsn(opcode);
                break;
            }
            case 194: 
            case 195: {
                if (this.getTopOfStackObject().equals("java/lang/Object")) {
                    super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unbox1D", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                }
                super.visitInsn(opcode);
                break;
            }
            case 190: {
                Type underlying;
                Type onStack = this.getTopOfStackType();
                if (onStack.getSort() == 10 && (underlying = MultiDTaintedArray.getPrimitiveTypeForWrapper(onStack.getInternalName())) != null) {
                    super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unbox1D", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                    super.visitTypeInsn(192, "[" + underlying.getDescriptor());
                }
                super.visitInsn(opcode);
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                int lv = this.lvs.getPreAllocedReturnTypeVar(this.returnType);
                super.visitVarInsn(25, lv);
                super.visitInsn(89);
                super.visitInsn(Configuration.NULL_TAINT_LOAD_OPCODE);
                super.visitFieldInsn(181, this.returnType.getInternalName(), "taint", Configuration.TAINT_TAG_DESC);
                super.visitInsn(95);
                super.visitFieldInsn(181, this.returnType.getInternalName(), "val", this.originalReturnType.getDescriptor());
                super.visitVarInsn(25, lv);
                super.visitInsn(176);
                break;
            }
            default: {
                super.visitInsn(opcode);
            }
        }
    }

    void ensureBoxedAt(int n, Type t) {
        switch (n) {
            case 0: {
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                super.visitTypeInsn(192, t.getInternalName());
                break;
            }
            case 1: {
                Object top = this.analyzer.stack.get(this.analyzer.stack.size() - 1);
                if (top == Opcodes.LONG || top == Opcodes.DOUBLE || top == Opcodes.TOP) {
                    super.visitInsn(93);
                    super.visitInsn(88);
                    super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                    super.visitTypeInsn(192, t.getInternalName());
                    super.visitInsn(91);
                    super.visitInsn(87);
                    break;
                }
                super.visitInsn(95);
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                super.visitTypeInsn(192, t.getInternalName());
                super.visitInsn(95);
                break;
            }
            default: {
                LocalVariableNode[] d = this.storeToLocals(n);
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                super.visitTypeInsn(192, t.getInternalName());
                for (int i = n - 1; i >= 0; --i) {
                    this.loadLV(i, d);
                }
                this.freeLVs(d);
            }
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        if (Configuration.WITH_UNBOX_ACMPEQ && (opcode == 165 || opcode == 166)) {
            this.mv.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "ensureUnboxed", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            this.mv.visitInsn(95);
            this.mv.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "ensureUnboxed", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
            this.mv.visitInsn(95);
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (Instrumenter.isIgnoredClass(owner)) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Type ownerType = Type.getObjectType(owner);
        if (opcode == 182 && ownerType.getSort() == 9 && ownerType.getElementType().getSort() != 10 && ownerType.getDimensions() > 1) {
            owner = MultiDTaintedArray.getTypeForType(ownerType).getInternalName();
        }
        Type origReturnType = Type.getReturnType(desc);
        boolean isCalledOnArrayType = false;
        if ((owner.equals("java/lang/System") || owner.equals("java/lang/VMSystem") || owner.equals("java/lang/VMMemoryManager")) && name.equals("arraycopy") && !desc.equals("(Ljava/lang/Object;ILjava/lang/Object;IILjava/lang/DCompMarker;)V")) {
            owner = Type.getInternalName(TaintUtils.class);
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (Instrumenter.isIgnoredClass(owner) || Instrumenter.isIgnoredMethod(owner, name, desc)) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        if (!(opcode != 182 && opcode != 183 || this.analyzer.stack.isEmpty())) {
            int argsize = 0;
            for (Type t : Type.getArgumentTypes(desc)) {
                argsize += t.getSize();
            }
            Object calledOn = this.analyzer.stack.get(this.analyzer.stack.size() - argsize - 1);
            if (calledOn instanceof String && ((String)calledOn).startsWith("[")) {
                isCalledOnArrayType = true;
            }
        }
        if (!isCalledOnArrayType && Configuration.WITH_SELECTIVE_INST && !owner.startsWith("[") && Instrumenter.isIgnoredMethodFromOurAnalysis(owner, name, desc)) {
            if (name.equals("<init>")) {
                super.visitInsn(1);
                desc = desc.substring(0, desc.indexOf(41)) + Type.getDescriptor(UninstrumentedTaintSentinel.class) + ")" + desc.substring(desc.indexOf(41) + 1);
            } else {
                name = name + "$$PHOSPHORUNTAGGED";
            }
            desc = TaintUtils.remapMethodDescForUninst(desc);
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        } else if (!(Instrumenter.isIgnoredClass(owner) || owner.startsWith("[") || isCalledOnArrayType)) {
            Type newReturnType = TaintUtils.getContainerReturnType(origReturnType);
            boolean hasWrappedReturnType = origReturnType.getSort() != 9 && !newReturnType.equals(origReturnType);
            Type[] args = Type.getArgumentTypes(desc);
            boolean k = false;
            boolean hasArgsToBox = false;
            int offset = 0;
            for (int i = args.length - 1; i >= 0; --i) {
                Type onStack = TaintAdapter.getTypeForStackType(this.analyzer.stack.get(this.analyzer.stack.size() - (offset += args[i].getSize())));
                if (!args[i].getDescriptor().equals("Ljava/lang/Object;") || !onStack.getDescriptor().equals("Ljava/lang/Object;") && !TaintUtils.isPrimitiveArrayType(onStack)) continue;
                hasArgsToBox = true;
            }
            if (hasArgsToBox) {
                int argsSize = 0;
                for (int i = 0; i < args.length; ++i) {
                    argsSize += args[args.length - i - 1].getSize();
                    if (!args[args.length - i - 1].getDescriptor().endsWith("java/lang/Object;")) continue;
                    this.ensureBoxedAt(i, args[args.length - i - 1]);
                }
            } else if (hasArgsToBox) {
                String newDesc = TaintUtils.remapMethodDesc(desc);
                int[] argStorage = new int[args.length];
                for (int i = 0; i < args.length; ++i) {
                    Type t = args[args.length - i - 1];
                    int lv = this.lvs.getTmpLV(t);
                    super.visitVarInsn(t.getOpcode(54), lv);
                    argStorage[args.length - i - 1] = lv;
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        } else {
            if (!name.equals("clone") && !name.equals("equals")) {
                System.out.println("Call UNTOUCHED" + owner + name + desc);
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

