/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import java.util.ArrayList;

public class UninstTaintSentinalArgFixer
extends MethodVisitor {
    int originalLastArgIdx;
    int[] oldArgMappings;
    int newArgOffset;
    boolean isStatic;
    int origNumArgs;
    String name;
    String desc;
    boolean hasTaintSentinalAddedToDesc = false;
    ArrayList<Type> oldArgTypesList;
    Type[] oldArgTypes;
    Type[] firstFrameLocals;
    int idxOfReturnPrealloc;
    boolean hasPreAllocedReturnAddr;
    Type newReturnType;
    ArrayList<Type> oldTypesDoublesAreOne;
    int nLVTaintsCounted = 0;
    boolean returnLVVisited = false;

    public UninstTaintSentinalArgFixer(MethodVisitor mv, int access, String name, String desc, String originalDesc) {
        super(Configuration.ASM_VERSION, mv);
        this.name = name;
        this.desc = desc;
        this.oldArgTypes = Type.getArgumentTypes(originalDesc);
        this.origNumArgs = this.oldArgTypes.length;
        this.isStatic = (8 & access) != 0;
        for (Type t : this.oldArgTypes) {
            this.originalLastArgIdx += t.getSize();
        }
        if (!this.isStatic) {
            ++this.originalLastArgIdx;
        }
        if (!this.isStatic) {
            ++this.origNumArgs;
        }
        this.newArgOffset = 0;
        this.oldArgTypesList = new ArrayList();
        this.oldTypesDoublesAreOne = new ArrayList();
        if (!this.isStatic) {
            this.oldArgTypesList.add(Type.getType("Lthis;"));
            this.oldTypesDoublesAreOne.add(Type.getType("Lthis;"));
        }
        for (Type t : Type.getArgumentTypes(originalDesc)) {
            this.oldArgTypesList.add(t);
            this.oldTypesDoublesAreOne.add(t);
            if (t.getSize() != 2) continue;
            this.oldArgTypesList.add(Type.getType("LTOP;"));
        }
        if (name.equals("<init>")) {
            this.hasTaintSentinalAddedToDesc = true;
            ++this.newArgOffset;
        }
    }

    public int getNewArgOffset() {
        return this.newArgOffset;
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (!this.isStatic && index == 0) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
        } else if (index < this.originalLastArgIdx) {
            super.visitLocalVariable(name, desc, signature, start, end, index);
            if (index == this.originalLastArgIdx - 1 && this.name.equals("<init>") && this.hasTaintSentinalAddedToDesc) {
                super.visitLocalVariable("TAINT_STUFF_TO_IGNORE_HAHA", "Ljava/lang/Object;", null, start, end, this.originalLastArgIdx + (Configuration.IMPLICIT_TRACKING ? 2 : 1));
            }
        } else {
            super.visitLocalVariable(name, desc, signature, start, end, index + this.newArgOffset);
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        Object[] remappedLocals = new Object[local.length + this.newArgOffset + 1];
        int newIdx = 0;
        int origNLocal = nLocal;
        if (type == 0 || type == -1) {
            int numLocalsToIterateOverForArgs = this.origNumArgs;
            boolean idxToUseForArgs = false;
            boolean lastWasTop2Words = false;
            for (int i = 0; i < origNLocal; ++i) {
                if (i == this.origNumArgs && this.hasTaintSentinalAddedToDesc) {
                    remappedLocals[newIdx] = Opcodes.TOP;
                    ++newIdx;
                    ++nLocal;
                }
                remappedLocals[newIdx] = local[i];
                ++newIdx;
            }
        } else {
            remappedLocals = local;
        }
        super.visitFrame(type, nLocal, remappedLocals, nStack, stack);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        int origVar = var;
        if (!this.isStatic && var == 0) {
            var = 0;
        } else if (var >= this.originalLastArgIdx) {
            var += this.newArgOffset;
        }
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        super.visitMethodInsn(opcode, owner, name, desc, itfc);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode == 215 || opcode == 214) {
            super.visitVarInsn(opcode, var);
            return;
        }
        int origVar = var;
        if (!this.isStatic && var == 0) {
            var = 0;
        } else if (var >= this.originalLastArgIdx) {
            var += this.newArgOffset;
        }
        super.visitVarInsn(opcode, var);
    }
}

