/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.InstOrUninstChoosingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.LocalVariableManager;
import edu.columbia.cs.psl.phosphor.instrumenter.MethodArgReindexer;
import edu.columbia.cs.psl.phosphor.instrumenter.PrimitiveArrayAnalyzer;
import edu.columbia.cs.psl.phosphor.instrumenter.PrimitiveBoxingFixer;
import edu.columbia.cs.psl.phosphor.instrumenter.ReflectionHidingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.SpecialOpcodeRemovingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.StringTaintVerifyingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintLoadCoercer;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintPassingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintTagFieldCastMV;
import edu.columbia.cs.psl.phosphor.instrumenter.UninstTaintSentinalArgFixer;
import edu.columbia.cs.psl.phosphor.instrumenter.UninstrumentedCompatMV;
import edu.columbia.cs.psl.phosphor.instrumenter.UninstrumentedReflectionHidingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.AnnotationVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.FieldVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.commons.GeneratorAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.AnnotationNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.ClassNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FieldNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LabelNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LocalVariableNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.ParameterNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.TypeAnnotationNode;
import edu.columbia.cs.psl.phosphor.runtime.ControlTaintTagStackPool;
import edu.columbia.cs.psl.phosphor.runtime.NativeHelper;
import edu.columbia.cs.psl.phosphor.runtime.TaintInstrumented;
import edu.columbia.cs.psl.phosphor.runtime.TaintSentinel;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import edu.columbia.cs.psl.phosphor.runtime.UninstrumentedTaintSentinel;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayIntTags;
import edu.columbia.cs.psl.phosphor.struct.LazyArrayObjTags;
import edu.columbia.cs.psl.phosphor.struct.TaintedObjectWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedObjectWithObjCtrlTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedObjectWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArrayWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArrayWithObjTag;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TaintTrackingClassVisitor
extends ClassVisitor {
    public static boolean IS_RUNTIME_INST = true;
    public static boolean FIELDS_ONLY = false;
    public static boolean GEN_HAS_TAINTS_METHOD = false;
    public static final boolean NATIVE_BOX_UNBOX = true;
    static boolean DO_OPT = false;
    List<FieldNode> fields;
    private boolean ignoreFrames;
    private boolean generateExtraLVDebug;
    private LinkedList<MethodNode> methodsToMakeUninstWrappersAround = new LinkedList();
    private HashMap<MethodNode, Type> methodsToAddWrappersForWithReturnType = new HashMap();
    private LinkedList<MethodNode> methodsToAddWrappersFor = new LinkedList();
    private LinkedList<MethodNode> methodsToAddNameOnlyWrappersFor = new LinkedList();
    private LinkedList<MethodNode> methodsToAddUnWrappersFor = new LinkedList();
    private HashSet<MethodNode> methodsToAddLambdaUnWrappersFor = new HashSet();
    private String className;
    private boolean isNormalClass;
    private boolean isInterface;
    private boolean addTaintMethod;
    private boolean isAnnotation;
    private boolean isAbstractClass;
    private boolean implementsComparable;
    private boolean implementsSerializable;
    private boolean fixLdcClass;
    private boolean isEnum;
    private String classSource;
    private String classDebug;
    private boolean aggressivelyReduceMethodSize;
    private String superName;
    private boolean isLambda;
    boolean generateHashCode = false;
    boolean generateEquals = false;
    boolean isProxyClass = false;
    private HashMap<String, Method> superMethodsToOverride = new HashMap();
    private HashSet<MethodNode> wrapperMethodsToAdd = new HashSet();
    HashMap<MethodNode, MethodNode> forMore = new HashMap();
    private LinkedList<FieldNode> extraFieldsToVisit = new LinkedList();
    private LinkedList<FieldNode> myFields = new LinkedList();
    private LinkedList<MethodNode> myMethods = new LinkedList();
    boolean hasSerialUID = false;
    boolean addTaintField = false;

    public TaintTrackingClassVisitor(ClassVisitor cv, boolean skipFrames, List<FieldNode> fields) {
        super(Configuration.ASM_VERSION, cv);
        DO_OPT = DO_OPT && !IS_RUNTIME_INST;
        this.ignoreFrames = skipFrames;
        this.fields = fields;
    }

    public TaintTrackingClassVisitor(ClassVisitor cv, boolean skipFrames, List<FieldNode> fields, boolean aggressivelyReduceMethodSize) {
        this(cv, skipFrames, fields);
        this.aggressivelyReduceMethodSize = aggressivelyReduceMethodSize;
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.classSource = source;
        this.classDebug = debug;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.addTaintField = true;
        this.addTaintMethod = true;
        this.generateExtraLVDebug = name.equals("java/lang/invoke/MethodType");
        boolean bl = this.fixLdcClass = (version & 0xFFFF) < 49;
        if (Instrumenter.IS_KAFFE_INST && name.endsWith("java/lang/VMSystem")) {
            access |= 1;
        } else if (Instrumenter.IS_HARMONY_INST && name.endsWith("java/lang/VMMemoryManager")) {
            access &= 0xFFFFFFFD;
            access |= 1;
        }
        if ((access & 0x400) != 0) {
            this.isAbstractClass = true;
        }
        if ((access & 0x200) != 0) {
            this.addTaintField = false;
            this.isInterface = true;
        }
        if ((access & 0x4000) != 0) {
            this.isEnum = true;
            this.addTaintField = false;
        }
        if ((access & 0x2000) != 0) {
            this.isAnnotation = true;
        }
        if (!superName.equals("java/lang/Object") && !Instrumenter.isIgnoredClass(superName)) {
            this.addTaintField = false;
            this.addTaintMethod = true;
        }
        if (name.equals("java/awt/image/BufferedImage") || name.equals("java/awt/image/Image")) {
            this.addTaintField = false;
        }
        if (this.addTaintField) {
            this.addTaintMethod = true;
        }
        if ((superName.equals("java/lang/Object") || Instrumenter.isIgnoredClass(superName)) && !this.isInterface && !this.isAnnotation) {
            this.generateEquals = true;
            this.generateHashCode = true;
        }
        this.isLambda = name.contains("$$Lambda$");
        boolean bl2 = this.isNormalClass = (access & 0x4000) == 0 && (access & 0x200) == 0;
        if ((this.isEnum || name.equals("java/lang/Enum")) && Configuration.WITH_ENUM_BY_VAL) {
            boolean alreadyHas = false;
            String[] stringArray = interfaces;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                if (!s.equals("java/lang/Cloneable")) continue;
                alreadyHas = true;
            }
            if (!alreadyHas) {
                String[] newIntfcs = new String[interfaces.length + 1];
                System.arraycopy(interfaces, 0, newIntfcs, 0, interfaces.length);
                newIntfcs[interfaces.length] = "java/lang/Cloneable";
                interfaces = newIntfcs;
                if (signature != null) {
                    signature = signature + "Ljava/lang/Cloneable;";
                }
            }
        }
        if (this.isNormalClass && !Instrumenter.isIgnoredClass(name) && !FIELDS_ONLY) {
            String[] newIntfcs = new String[interfaces.length + 1];
            System.arraycopy(interfaces, 0, newIntfcs, 0, interfaces.length);
            newIntfcs[interfaces.length] = Type.getInternalName(Configuration.MULTI_TAINTING ? TaintedWithObjTag.class : TaintedWithIntTag.class);
            interfaces = newIntfcs;
            if (signature != null) {
                signature = signature + Type.getDescriptor(Configuration.MULTI_TAINTING ? TaintedWithObjTag.class : TaintedWithIntTag.class);
            }
            if (this.generateEquals && Configuration.WITH_HEAVY_OBJ_EQUALS_HASHCODE) {
                newIntfcs = new String[interfaces.length + 1];
                System.arraycopy(interfaces, 0, newIntfcs, 0, interfaces.length);
                Class iface = null;
                iface = Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING ? TaintedObjectWithObjCtrlTag.class : (Configuration.MULTI_TAINTING ? TaintedObjectWithObjTag.class : TaintedObjectWithIntTag.class);
                newIntfcs[interfaces.length] = Type.getInternalName(iface);
                interfaces = newIntfcs;
                if (signature != null) {
                    signature = signature + Type.getDescriptor(iface);
                }
            }
        }
        for (String s : interfaces) {
            if (s.equals(Type.getInternalName(Comparable.class))) {
                this.implementsComparable = true;
                continue;
            }
            if (!s.equals(Type.getInternalName(Serializable.class))) continue;
            this.implementsSerializable = true;
        }
        super.visit(version, access, name, signature, superName, interfaces);
        this.visitAnnotation(Type.getDescriptor(TaintInstrumented.class), false);
        if (Instrumenter.isIgnoredClass(superName)) {
            try {
                Class<?> c = Class.forName(superName.replace("/", "."));
                for (Method m : c.getMethods()) {
                    this.superMethodsToOverride.put(m.getName() + Type.getMethodDescriptor(m), m);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.className = name;
        this.superName = superName;
    }

    private void collectUninstrumentedInterfaceMethods(String[] interfaces) {
        if (interfaces != null) {
            String[] stringArray = interfaces;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String itfc;
                String superToCheck = itfc = stringArray[i];
                try {
                    Class<?>[] in;
                    ClassNode cn = Instrumenter.classes.get(superToCheck);
                    if (cn != null) {
                        String[] s = new String[cn.interfaces.size()];
                        s = cn.interfaces.toArray(s);
                        this.collectUninstrumentedInterfaceMethods(s);
                        continue;
                    }
                    Class<?> c = Class.forName(superToCheck.replace("/", "."), false, Instrumenter.loader);
                    if (Instrumenter.isIgnoredClass(superToCheck)) {
                        for (Method m : c.getDeclaredMethods()) {
                            if (Modifier.isPrivate(m.getModifiers())) continue;
                            this.superMethodsToOverride.put(m.getName() + Type.getMethodDescriptor(m), m);
                        }
                    }
                    if ((in = c.getInterfaces()) == null || in.length <= 0) continue;
                    String[] s = new String[in.length];
                    for (int i2 = 0; i2 < in.length; ++i2) {
                        s[i2] = Type.getInternalName(in[i2]);
                    }
                    this.collectUninstrumentedInterfaceMethods(s);
                    continue;
                }
                catch (Exception ex) {
                    break;
                }
            }
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("hashCode") && desc.equals("()I")) {
            this.generateHashCode = false;
        }
        if (name.equals("equals") && desc.equals("(Ljava/lang/Object;)Z")) {
            this.generateEquals = false;
        }
        this.superMethodsToOverride.remove(name + desc);
        if (name.equals("compareTo")) {
            this.implementsComparable = false;
        }
        if (name.equals("hasAnyTaints")) {
            this.isProxyClass = true;
        }
        boolean isImplicitLightTrackingMethod = Configuration.autoTainter.shouldInstrumentMethodForImplicitLightTracking(this.className, name, desc);
        if ((this.className.equals("java/lang/Integer") || this.className.equals("java/lang/Long")) && name.equals("toUnsignedString")) {
            access = access & 0xFFFFFFFD | 1;
        }
        if (name.contains("$$PHOSPHORTAGGED") || Type.getReturnType(desc).getSort() == 0 && desc.contains("phosphor/struct/Tainted")) {
            if (this.isLambda) {
                this.methodsToAddUnWrappersFor.add(new MethodNode(access, name, desc, signature, exceptions));
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            return new MethodVisitor(Configuration.ASM_VERSION){};
        }
        if (Configuration.WITH_SELECTIVE_INST && Instrumenter.isIgnoredMethodFromOurAnalysis(this.className, name, desc)) {
            String newName = name;
            String newDesc = desc;
            if (!name.contains("<") && 0 == (access & 0x100)) {
                newName = name + "$$PHOSPHORUNTAGGED";
            } else if (name.equals("<init>")) {
                newDesc = desc.substring(0, desc.indexOf(41)) + Type.getDescriptor(UninstrumentedTaintSentinel.class) + ")" + desc.substring(desc.indexOf(41) + 1);
            }
            newDesc = TaintUtils.remapMethodDescForUninst(newDesc);
            MethodVisitor mv = super.visitMethod(access, newName, newDesc, signature, exceptions);
            mv = new UninstTaintSentinalArgFixer(mv, access, newName, newDesc, desc);
            SpecialOpcodeRemovingMV somv = new SpecialOpcodeRemovingMV(mv, this.ignoreFrames, access, this.className, newDesc, this.fixLdcClass);
            MethodVisitor _mv = mv = somv;
            NeverNullArgAnalyzerAdapter analyzer = new NeverNullArgAnalyzerAdapter(this.className, access, name, newDesc, mv);
            mv = new UninstrumentedReflectionHidingMV(analyzer, this.className);
            mv = new UninstrumentedCompatMV(access, this.className, name, newDesc, null, signature, exceptions, mv, analyzer, this.ignoreFrames);
            LocalVariableManager lvs = new LocalVariableManager(access, newDesc, mv, analyzer, _mv, this.generateExtraLVDebug);
            ((UninstrumentedCompatMV)mv).setLocalVariableSorter(lvs);
            final PrimitiveArrayAnalyzer primArrayAnalyzer = new PrimitiveArrayAnalyzer(this.className, access, name, desc, signature, exceptions, null, false);
            lvs.setPrimitiveArrayAnalyzer(primArrayAnalyzer);
            lvs.disable();
            mv = lvs;
            somv.setLVS(lvs);
            final MethodVisitor cmv = mv;
            MethodNode wrapper = new MethodNode(Configuration.ASM_VERSION, this.isInterface ? access : access & 0xFFFFFBFF, name, desc, signature, exceptions){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    this.accept(cmv);
                }

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    Type returnType;
                    Type newReturnType;
                    if (!(Configuration.WITH_SELECTIVE_INST && Instrumenter.isIgnoredMethod(owner, name, desc) || (newReturnType = TaintUtils.getContainerReturnType(returnType = Type.getReturnType(desc))) == returnType || returnType.getSort() == 9)) {
                        primArrayAnalyzer.wrapperTypesToPreAlloc.add(newReturnType);
                    }
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            };
            if (!name.equals("<clinit>")) {
                this.methodsToMakeUninstWrappersAround.add(wrapper);
            }
            return wrapper;
        }
        if (Configuration.WITH_ENUM_BY_VAL && this.className.equals("java/lang/Enum") && name.equals("clone")) {
            return null;
        }
        if (Instrumenter.IS_KAFFE_INST && this.className.equals("java/lang/VMSystem")) {
            access |= 1;
        } else if (Instrumenter.IS_HARMONY_INST && this.className.endsWith("java/lang/VMMemoryManager")) {
            access &= 0xFFFFFFFD;
            access |= 1;
        } else if ((this.className.equals("java/lang/Integer") || this.className.equals("java/lang/Long")) && name.equals("getChars")) {
            access |= 1;
        }
        String originalName = name;
        if (FIELDS_ONLY) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (originalName.contains("$$INVIVO")) {
            name = name + "_orig";
        }
        Type[] argTypes = Type.getArgumentTypes(desc);
        LinkedList<Type> newArgTypes = new LinkedList<Type>();
        boolean isRewrittenDesc = false;
        boolean addSentinel = false;
        boolean addControlTaintTagStack = true;
        if (this.isLambda) {
            for (Type t : argTypes) {
                if (t.getSort() == 9) {
                    if (t.getElementType().getSort() != 10) {
                        addSentinel = true;
                    }
                } else if (t.getSort() != 10) {
                    addSentinel = true;
                }
                newArgTypes.add(t);
                if (!t.getDescriptor().contains("ControlTaintTagStack") && !t.getDescriptor().contains("edu/columbia/cs/psl/phosphor/struct") && !t.getDescriptor().contains("Ledu/columbia/cs/psl/phosphor/runtime/Taint") && !TaintUtils.isPrimitiveType(t)) continue;
                final MethodVisitor cmv = super.visitMethod(access, name, desc, signature, exceptions);
                MethodNode fullMethod = new MethodNode(Configuration.ASM_VERSION, access, name, desc, signature, exceptions){

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        this.accept(cmv);
                    }
                };
                this.methodsToAddNameOnlyWrappersFor.add(fullMethod);
                return fullMethod;
            }
        } else {
            for (Type t : argTypes) {
                if (t.getSort() == 9) {
                    if (t.getElementType().getSort() != 10) {
                        if (t.getDimensions() > 1) {
                            newArgTypes.add(MultiDTaintedArray.getTypeForType(t));
                            isRewrittenDesc = true;
                            continue;
                        }
                        newArgTypes.add(MultiDTaintedArray.getTypeForType(t));
                        isRewrittenDesc = true;
                    }
                } else if (t.getSort() != 10) {
                    isRewrittenDesc = true;
                    newArgTypes.add(Type.getType(Configuration.TAINT_TAG_DESC));
                }
                newArgTypes.add(t);
            }
        }
        if ((Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING) && !name.equals("<clinit>") && addControlTaintTagStack) {
            isRewrittenDesc = true;
            newArgTypes.add(Type.getType(ControlTaintTagStack.class));
        }
        if (isRewrittenDesc && name.equals("<init>")) {
            newArgTypes.add(Type.getType(TaintSentinel.class));
        }
        Type oldReturnType = Type.getReturnType(desc);
        Type newReturnType = TaintUtils.getContainerReturnType(Type.getReturnType(desc));
        if (oldReturnType.getSort() != 0 && oldReturnType.getSort() != 10 && oldReturnType.getSort() != 9) {
            newArgTypes.add(newReturnType);
        }
        Type[] newArgs = new Type[newArgTypes.size()];
        newArgs = newArgTypes.toArray(newArgs);
        boolean requiresNoChange = !isRewrittenDesc && newReturnType.equals(Type.getReturnType(desc));
        MethodNode wrapper = new MethodNode(access, name, desc, signature, exceptions);
        if (!(requiresNoChange || name.equals("<clinit>") || name.equals("<init>") && !isRewrittenDesc)) {
            this.methodsToAddWrappersFor.add(wrapper);
        }
        String newDesc = Type.getMethodDescriptor(newReturnType, newArgs);
        if ((access & 0x100) == 0) {
            NeverNullArgAnalyzerAdapter preAnalyzer;
            LinkedList<String> addToSig = new LinkedList<String>();
            if (Configuration.IMPLICIT_TRACKING) {
                addToSig.add(Type.getInternalName(ControlTaintTagStack.class));
            }
            if (name.equals("<init>") && isRewrittenDesc) {
                addToSig.add(Type.getInternalName(TaintSentinel.class));
            }
            if (oldReturnType.getSort() != 0 && oldReturnType.getSort() != 10 && oldReturnType.getSort() != 9) {
                addToSig.add(newReturnType.getInternalName());
            }
            signature = TaintUtils.remapSignature(signature, addToSig);
            if (!name.contains("<") && !requiresNoChange) {
                name = name + "$$PHOSPHORTAGGED";
            }
            MethodVisitor mv = super.visitMethod(access, name, newDesc, signature, exceptions);
            MethodVisitor rootmV = mv = new TaintTagFieldCastMV(mv, name);
            MethodVisitor optimizer = mv;
            SpecialOpcodeRemovingMV somv = new SpecialOpcodeRemovingMV(optimizer, this.ignoreFrames, access, this.className, newDesc, this.fixLdcClass);
            mv = somv;
            NeverNullArgAnalyzerAdapter analyzer = new NeverNullArgAnalyzerAdapter(this.className, access, name, newDesc, mv);
            mv = new StringTaintVerifyingMV(analyzer, this.implementsSerializable || this.className.startsWith("java/nio/") || this.className.startsWith("java/io/BUfferedInputStream") || this.className.startsWith("sun/nio"), analyzer);
            ReflectionHidingMV reflectionMasker = new ReflectionHidingMV(mv, this.className, name, analyzer);
            PrimitiveBoxingFixer boxFixer = new PrimitiveBoxingFixer(access, this.className, name, desc, signature, exceptions, reflectionMasker, analyzer);
            TaintPassingMV tmv = new TaintPassingMV(boxFixer, access, this.className, name, newDesc, signature, exceptions, desc, analyzer, rootmV, this.wrapperMethodsToAdd, isImplicitLightTrackingMethod);
            tmv.setFields(this.fields);
            Object custom = null;
            UninstrumentedCompatMV umv = new UninstrumentedCompatMV(access, this.className, name, newDesc, oldReturnType, signature, exceptions, boxFixer, analyzer, this.ignoreFrames);
            InstOrUninstChoosingMV instOrUninstChoosingMV = new InstOrUninstChoosingMV(tmv, umv);
            LocalVariableManager lvs = new LocalVariableManager(access, newDesc, instOrUninstChoosingMV, analyzer, mv, this.generateExtraLVDebug);
            umv.setLocalVariableSorter(lvs);
            LocalVariableManager nextMV = lvs;
            boolean isDisabled = Configuration.ignoredMethods.contains(this.className + "." + originalName + desc);
            somv.setLVS(lvs);
            MethodArgReindexer mar = new MethodArgReindexer(nextMV, access, name, newDesc, desc, wrapper, this.isLambda);
            TaintLoadCoercer tlc = new TaintLoadCoercer(this.className, access, name, desc, signature, exceptions, mar, this.ignoreFrames, instOrUninstChoosingMV, this.aggressivelyReduceMethodSize | isDisabled, isImplicitLightTrackingMethod);
            PrimitiveArrayAnalyzer primitiveArrayFixer = new PrimitiveArrayAnalyzer(this.className, access, name, desc, signature, exceptions, tlc, isImplicitLightTrackingMethod);
            NeverNullArgAnalyzerAdapter mvNext = preAnalyzer = new NeverNullArgAnalyzerAdapter(this.className, access, name, desc, primitiveArrayFixer);
            mvNext = preAnalyzer;
            primitiveArrayFixer.setAnalyzer(preAnalyzer);
            boxFixer.setLocalVariableSorter(lvs);
            tmv.setArrayAnalyzer(primitiveArrayFixer);
            tmv.setLVOffset(mar.getNewArgOffset());
            tmv.setLocalVariableSorter(lvs);
            lvs.setPrimitiveArrayAnalyzer(primitiveArrayFixer);
            reflectionMasker.setLvs(lvs);
            final NeverNullArgAnalyzerAdapter prev = mvNext;
            MethodNode rawMethod = new MethodNode(Configuration.ASM_VERSION, access, name, desc, signature, exceptions){

                @Override
                protected LabelNode getLabelNode(Label l) {
                    if (!Configuration.READ_AND_SAVE_BCI) {
                        return super.getLabelNode(l);
                    }
                    if (!(l.info instanceof LabelNode)) {
                        l.info = new LabelNode(l);
                    }
                    return (LabelNode)l.info;
                }

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    this.accept(prev);
                }

                @Override
                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                    if (TaintTrackingClassVisitor.this.className.equals("com/sleepycat/je/log/FileManager$LogEndFileDescriptor") && this.name.startsWith("enqueueWrite1") && local.length > 6 && "java/lang/Object".equals(local[6])) {
                        local[6] = "[B";
                    }
                    super.visitFrame(type, nLocal, local, nStack, stack);
                }
            };
            if (!this.isInterface && !originalName.contains("$$INVIVO")) {
                this.myMethods.add(rawMethod);
            }
            this.forMore.put(wrapper, rawMethod);
            if (Configuration.extensionMethodVisitor != null) {
                try {
                    TaintAdapter custom2 = Configuration.extensionMethodVisitor.getConstructor(Integer.TYPE, String.class, String.class, String.class, String.class, String[].class, MethodVisitor.class, NeverNullArgAnalyzerAdapter.class, String.class, String.class).newInstance(access, this.className, name, desc, signature, exceptions, rawMethod, null, this.classSource, this.classDebug);
                    custom2.setFields(this.fields);
                    custom2.setSuperName(this.superName);
                    return custom2;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            return rawMethod;
        }
        final MethodVisitor prev = super.visitMethod(access, name, desc, signature, exceptions);
        MethodNode rawMethod = new MethodNode(Configuration.ASM_VERSION, access, name, desc, signature, exceptions){

            @Override
            public void visitEnd() {
                super.visitEnd();
                this.accept(prev);
            }
        };
        this.forMore.put(wrapper, rawMethod);
        return rawMethod;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.shouldMakeFieldPublic(this.className, name, desc)) {
            access &= 0xFFFFFFFD;
            access &= 0xFFFFFFFB;
            access |= 1;
        }
        Type fieldType = Type.getType(desc);
        if (TaintUtils.getShadowTaintType(desc) != null) {
            if (TaintAdapter.canRawTaintAccess(this.className)) {
                this.extraFieldsToVisit.add(new FieldNode(access, name + "PHOSPHOR_TAG", TaintUtils.getShadowTaintType(desc), null, null));
            } else {
                this.extraFieldsToVisit.add(new FieldNode(access, name + "PHOSPHOR_TAG", "I", null, null));
            }
        } else if (!FIELDS_ONLY && fieldType.getSort() == 9 && fieldType.getElementType().getSort() != 10 && fieldType.getDimensions() > 1) {
            desc = MultiDTaintedArray.getTypeForType(fieldType).getDescriptor();
        }
        if (!this.hasSerialUID && name.equals("serialVersionUID")) {
            this.hasSerialUID = true;
        }
        if ((access & 8) == 0) {
            this.myFields.add(new FieldNode(access, name, desc, signature, value));
        }
        return super.visitField(access, name, desc, signature, value);
    }

    private boolean shouldMakeFieldPublic(String className, String name, String desc) {
        return className.equals("java/lang/String") && name.equals("value");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitEnd() {
        String[] exceptions;
        Label end;
        for (MethodNode methodNode : this.wrapperMethodsToAdd) {
            methodNode.accept(this);
        }
        if ((this.isEnum || this.className.equals("java/lang/Enum")) && Configuration.WITH_ENUM_BY_VAL) {
            MethodVisitor mv3 = super.visitMethod(1, "clone", "()Ljava/lang/Object;", null, new String[]{"java/lang/CloneNotSupportedException"});
            mv3.visitCode();
            mv3.visitVarInsn(25, 0);
            mv3.visitMethodInsn(183, "java/lang/Object", "clone", "()Ljava/lang/Object;", false);
            mv3.visitInsn(176);
            mv3.visitEnd();
            mv3.visitMaxs(0, 0);
        }
        boolean goLightOnGeneratedStuff = this.className.equals("java/lang/Byte");
        if (!(this.hasSerialUID || this.isInterface || goLightOnGeneratedStuff)) {
            if (!Configuration.MULTI_TAINTING) {
                super.visitField(9, "serialVersionUIDPHOSPHOR_TAG", Configuration.TAINT_TAG_DESC, null, 0);
            } else {
                super.visitField(9, "serialVersionUIDPHOSPHOR_TAG", Configuration.TAINT_TAG_DESC, null, null);
            }
        }
        if (this.addTaintField && !goLightOnGeneratedStuff) {
            if (!Configuration.MULTI_TAINTING) {
                super.visitField(1, "PHOSPHOR_TAG", "I", null, 0);
            } else {
                super.visitField(1, "PHOSPHOR_TAG", TaintAdapter.getTagType(this.className).getDescriptor(), null, null);
            }
            super.visitField(1, "$$PHOSPHOR_MARK", "I", null, Integer.MIN_VALUE);
        }
        if (this.className.equals("java/lang/reflect/Method")) {
            super.visitField(1, "PHOSPHOR_TAGmarked", "Z", null, 0);
            super.visitField(1, "PHOSPHOR_TAGmethod", "Ljava/lang/reflect/Method;", null, 0);
        } else if (this.className.equals("java/lang/Class")) {
            super.visitField(1, "PHOSPHOR_TAGmarked", "Z", null, 0);
            super.visitField(1, "PHOSPHOR_TAGclass", "Ljava/lang/Class;", null, 0);
            super.visitField(1, "$$PHOSPHOR_OFFSET_CACHE", "Ledu/columbia/cs/psl/phosphor/struct/SinglyLinkedList;", null, 0);
        }
        for (FieldNode fieldNode : this.extraFieldsToVisit) {
            if (this.className.equals("java/lang/Byte") && !fieldNode.name.startsWith("value")) continue;
            if (this.isNormalClass) {
                fieldNode.access &= 0xFFFFFFEF;
                fieldNode.access &= 0xFFFFFFFD;
                fieldNode.access &= 0xFFFFFFFB;
                fieldNode.access |= 1;
            }
            if ((fieldNode.access & 8) != 0) {
                if (fieldNode.desc.equals("I")) {
                    super.visitField(fieldNode.access, fieldNode.name, fieldNode.desc, fieldNode.signature, 0);
                    continue;
                }
                super.visitField(fieldNode.access, fieldNode.name, fieldNode.desc, fieldNode.signature, null);
                continue;
            }
            super.visitField(fieldNode.access, fieldNode.name, fieldNode.desc, fieldNode.signature, null);
        }
        if (FIELDS_ONLY) {
            return;
        }
        if ((this.isAbstractClass || this.isInterface) && this.implementsComparable && !goLightOnGeneratedStuff) {
            if (Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING) {
                super.visitMethod(1025, "compareTo$$PHOSPHORTAGGED", "(Ljava/lang/Object;" + Type.getDescriptor(ControlTaintTagStack.class) + Configuration.TAINTED_INT_DESC + ")" + Configuration.TAINTED_INT_DESC, null, null);
            } else {
                super.visitMethod(1025, "compareTo$$PHOSPHORTAGGED", "(Ljava/lang/Object;" + Configuration.TAINTED_INT_DESC + ")" + Configuration.TAINTED_INT_DESC, null, null);
            }
            if (Configuration.GENERATE_UNINST_STUBS) {
                super.visitMethod(1025, "compareTo$$PHOSPHORUNTAGGED", "(Ljava/lang/Object;)I", null, null);
            }
        }
        if (this.generateEquals && !goLightOnGeneratedStuff) {
            this.superMethodsToOverride.remove("equals(Ljava/lang/Object;)Z");
            this.methodsToAddWrappersFor.add(new MethodNode(257, "equals", "(Ljava/lang/Object;)Z", null, null));
            MethodVisitor methodVisitor = super.visitMethod(4097, "equals", "(Ljava/lang/Object;)Z", null, null);
            methodVisitor.visitCode();
            Label label = new Label();
            end = new Label();
            methodVisitor.visitLabel(label);
            if (this.isLambda) {
                int retVar = Configuration.IMPLICIT_TRACKING ? 3 : 2;
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                Label label2 = new Label();
                methodVisitor.visitJumpInsn(165, label2);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(172);
                methodVisitor.visitLabel(label2);
                methodVisitor.visitFrame(-1, 2, new Object[]{this.className, "java/lang/Object"}, 0, new Object[0]);
                methodVisitor.visitInsn(4);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitMethodInsn(183, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z", false);
            }
            methodVisitor.visitLabel(end);
            methodVisitor.visitInsn(172);
            methodVisitor.visitLocalVariable("this", "L" + this.className + ";", null, label, end, 0);
            methodVisitor.visitLocalVariable("other", "Ljava/lang/Object;", null, label, end, 1);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        if (this.generateHashCode && !goLightOnGeneratedStuff) {
            this.superMethodsToOverride.remove("hashCode()I");
            this.methodsToAddWrappersFor.add(new MethodNode(257, "hashCode", "()I", null, null));
            MethodVisitor methodVisitor = super.visitMethod(4097, "hashCode", "()I", null, null);
            methodVisitor.visitCode();
            Label label = new Label();
            end = new Label();
            methodVisitor.visitLabel(label);
            if (this.isLambda) {
                methodVisitor.visitInsn(3);
            } else {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitMethodInsn(183, "java/lang/Object", "hashCode", "()I", false);
            }
            methodVisitor.visitLabel(end);
            methodVisitor.visitInsn(172);
            methodVisitor.visitLocalVariable("this", "L" + this.className + ";", null, label, end, 0);
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        if (this.addTaintMethod) {
            if (this.isInterface) {
                super.visitMethod(1025, "getPHOSPHOR_TAG", "()" + (Configuration.MULTI_TAINTING ? "Ljava/lang/Object;" : "I"), null, null);
                if (GEN_HAS_TAINTS_METHOD) {
                    super.visitMethod(1025, "hasAnyTaints", "()Z", null, null);
                }
                super.visitMethod(1025, "setPHOSPHOR_TAG", "(" + (Configuration.MULTI_TAINTING ? "Ljava/lang/Object;" : "I") + ")V", null, null);
            } else if (!Configuration.MULTI_TAINTING) {
                MethodVisitor methodVisitor = super.visitMethod(1, "getPHOSPHOR_TAG", "()" + (Configuration.MULTI_TAINTING ? "Ljava/lang/Object;" : "I"), null, null);
                methodVisitor.visitCode();
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, this.className, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                methodVisitor.visitInsn(172);
                methodVisitor.visitMaxs(0, 0);
                methodVisitor.visitEnd();
                MethodVisitor methodVisitor2 = super.visitMethod(1, "setPHOSPHOR_TAG", "(" + (Configuration.MULTI_TAINTING ? "Ljava/lang/Object;" : "I") + ")V", null, null);
                methodVisitor2.visitCode();
                Configuration.taintTagFactory.generateSetTag(methodVisitor2, this.className);
                if (this.className.equals("java/lang/String")) {
                    Type type = MultiDTaintedArray.getTypeForType(Type.getType(char[].class));
                    methodVisitor2.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
                    methodVisitor2.visitVarInsn(25, 0);
                    methodVisitor2.visitInsn(89);
                    methodVisitor2.visitFieldInsn(180, this.className, "value", "[C");
                    methodVisitor2.visitTypeInsn(187, type.getInternalName());
                    methodVisitor2.visitInsn(90);
                    methodVisitor2.visitInsn(95);
                    methodVisitor2.visitMethodInsn(183, type.getInternalName(), "<init>", "([C)V", false);
                    methodVisitor2.visitInsn(90);
                    methodVisitor2.visitFieldInsn(181, this.className, "valuePHOSPHOR_TAG", type.getDescriptor());
                    methodVisitor2.visitVarInsn(21, 1);
                    methodVisitor2.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "combineTaintsOnArray", "(Ljava/lang/Object;" + Configuration.TAINT_TAG_DESC + ")V", false);
                } else if (this.className.equals("java/lang/Integer") || this.className.equals("java/lang/Long") || this.className.equals("java/lang/Float") || this.className.equals("java/lang/Double")) {
                    methodVisitor2.visitVarInsn(25, 0);
                    methodVisitor2.visitVarInsn(21, 1);
                    methodVisitor2.visitFieldInsn(181, this.className, "valuePHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                }
                methodVisitor2.visitInsn(177);
                methodVisitor2.visitMaxs(0, 0);
                methodVisitor2.visitEnd();
            } else {
                MethodVisitor methodVisitor = super.visitMethod(1, "getPHOSPHOR_TAG", "()" + (Configuration.MULTI_TAINTING ? "Ljava/lang/Object;" : "I"), null, null);
                TaintTagFieldCastMV taintTagFieldCastMV = new TaintTagFieldCastMV(methodVisitor, "getPHOSPHOR_TAG");
                taintTagFieldCastMV.visitCode();
                taintTagFieldCastMV.visitVarInsn(25, 0);
                ((MethodVisitor)taintTagFieldCastMV).visitFieldInsn(180, this.className, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                taintTagFieldCastMV.visitInsn(176);
                taintTagFieldCastMV.visitMaxs(0, 0);
                taintTagFieldCastMV.visitEnd();
                MethodVisitor methodVisitor3 = super.visitMethod(1, "setPHOSPHOR_TAG", "(" + (Configuration.MULTI_TAINTING ? "Ljava/lang/Object;" : "I") + ")V", null, null);
                TaintTagFieldCastMV taintTagFieldCastMV2 = new TaintTagFieldCastMV(methodVisitor3, "setPHOSPHOR_TAG");
                taintTagFieldCastMV2.visitCode();
                Configuration.taintTagFactory.generateSetTag(taintTagFieldCastMV2, this.className);
                if (this.className.equals("java/lang/String")) {
                    Type type = MultiDTaintedArray.getTypeForType(Type.getType(char[].class));
                    ((MethodVisitor)taintTagFieldCastMV2).visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
                    taintTagFieldCastMV2.visitVarInsn(25, 0);
                    taintTagFieldCastMV2.visitInsn(89);
                    ((MethodVisitor)taintTagFieldCastMV2).visitFieldInsn(180, this.className, "value", "[C");
                    taintTagFieldCastMV2.visitTypeInsn(187, type.getInternalName());
                    taintTagFieldCastMV2.visitInsn(90);
                    taintTagFieldCastMV2.visitInsn(95);
                    taintTagFieldCastMV2.visitMethodInsn(183, type.getInternalName(), "<init>", "([C)V", false);
                    taintTagFieldCastMV2.visitInsn(90);
                    ((MethodVisitor)taintTagFieldCastMV2).visitFieldInsn(181, this.className, "valuePHOSPHOR_TAG", type.getDescriptor());
                    taintTagFieldCastMV2.visitVarInsn(25, 1);
                    taintTagFieldCastMV2.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "combineTaintsOnArray", "(Ljava/lang/Object;" + Configuration.TAINT_TAG_DESC + ")V", false);
                } else if (this.className.equals("java/lang/Integer") || this.className.equals("java/lang/Long") || this.className.equals("java/lang/Float") || this.className.equals("java/lang/Double")) {
                    taintTagFieldCastMV2.visitVarInsn(25, 0);
                    taintTagFieldCastMV2.visitVarInsn(25, 1);
                    ((MethodVisitor)taintTagFieldCastMV2).visitFieldInsn(181, this.className, "valuePHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                }
                taintTagFieldCastMV2.visitInsn(177);
                taintTagFieldCastMV2.visitMaxs(0, 0);
                taintTagFieldCastMV2.visitEnd();
            }
        }
        for (MethodNode methodNode : this.methodsToAddNameOnlyWrappersFor) {
            if ((methodNode.access & 0x400) != 0 || methodNode.name.contains("<")) continue;
            exceptions = new String[methodNode.exceptions.size()];
            exceptions = methodNode.exceptions.toArray(exceptions);
            MethodVisitor mv4 = super.visitMethod(methodNode.access, methodNode.name + "$$PHOSPHORTAGGED", methodNode.desc, methodNode.signature, exceptions);
            GeneratorAdapter generatorAdapter = new GeneratorAdapter(mv4, methodNode.access, methodNode.name + "$$PHOSPHORTAGGED", methodNode.desc);
            methodNode.accept(generatorAdapter);
        }
        for (MethodNode methodNode : this.methodsToAddUnWrappersFor) {
            void var9_102;
            Type type;
            if ((methodNode.access & 0x400) == 0 && !methodNode.name.contains("<")) {
                void var9_98;
                exceptions = new String[methodNode.exceptions.size()];
                exceptions = methodNode.exceptions.toArray(exceptions);
                LinkedList<Type> newArgs = new LinkedList<Type>();
                for (Type type2 : Type.getArgumentTypes(methodNode.desc)) {
                    if (TaintUtils.isPrimitiveOrPrimitiveArrayType(type2)) {
                        newArgs.removeLast();
                    }
                    if (type2.getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Lazy")) {
                        newArgs.add(MultiDTaintedArray.getPrimitiveTypeForWrapper(type2.getInternalName()));
                        continue;
                    }
                    newArgs.add(type2);
                }
                Type type3 = Type.getReturnType(methodNode.desc);
                String t = type3.getDescriptor();
                Type origReturnType = type3;
                Object var9_96 = null;
                if (type3.getSort() == 0 && !newArgs.isEmpty() && ((Type)newArgs.getLast()).getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Tainted")) {
                    Type type4 = (Type)newArgs.removeLast();
                }
                if (type3.getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Tainted")) {
                    newArgs.removeLast();
                    if (type3.getDescriptor().contains("edu/columbia/cs/psl/phosphor/struct/Tainted")) {
                        t = type3.getDescriptor().replace("Ledu/columbia/cs/psl/phosphor/struct/Tainted", "");
                        t = t.replace("WithIntTag", "");
                        t = t.replace("WithObjTag", "");
                    }
                    t = t.replace(";", "").replace("Int", "I").replace("Byte", "B").replace("Short", "S").replace("Long", "J").replace("Boolean", "Z").replace("Float", "F").replace("Double", "D");
                    origReturnType = Type.getType(t);
                }
                if (Configuration.IMPLICIT_TRACKING && newArgs.size() > 0) {
                    newArgs.removeLast();
                }
                Object newDesc = "(";
                for (Type type5 : newArgs) {
                    newDesc = (String)newDesc + type5.getDescriptor();
                }
                newDesc = (String)newDesc + ")";
                newDesc = (String)newDesc + t;
                MethodNode methodNode2 = new MethodNode(methodNode.access | 0x8000, methodNode.name.replace("$$PHOSPHORTAGGED", ""), (String)newDesc, methodNode.signature, exceptions);
                this.methodsToAddWrappersFor.add(methodNode2);
                this.methodsToAddLambdaUnWrappersFor.add(methodNode2);
                if (var9_98 != null) {
                    this.methodsToAddWrappersForWithReturnType.put(methodNode2, (Type)var9_98);
                }
            }
            if ((methodNode.access & 0x400) != 0 || methodNode.name.contains("<")) continue;
            exceptions = new String[methodNode.exceptions.size()];
            exceptions = methodNode.exceptions.toArray(exceptions);
            LinkedList<Type> newArgs = new LinkedList<Type>();
            for (Type type6 : Type.getArgumentTypes(methodNode.desc)) {
                if (TaintUtils.isPrimitiveOrPrimitiveArrayType(type6)) {
                    newArgs.removeLast();
                }
                if (type6.getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Lazy")) {
                    newArgs.add(MultiDTaintedArray.getPrimitiveTypeForWrapper(type6.getInternalName()));
                    continue;
                }
                newArgs.add(type6);
            }
            Type origReturnType = type = Type.getReturnType(methodNode.desc);
            String t3 = type.getDescriptor();
            if (type.getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Tainted")) {
                newArgs.removeLast();
                if (type.getDescriptor().contains("edu/columbia/cs/psl/phosphor/struct/Tainted")) {
                    t3 = type.getDescriptor().replace("Ledu/columbia/cs/psl/phosphor/struct/Tainted", "");
                    t3 = t3.replace("WithIntTag", "");
                    t3 = t3.replace("WithObjTag", "");
                }
                t3 = t3.replace(";", "").replace("Int", "I").replace("Byte", "B").replace("Short", "S").replace("Long", "J").replace("Boolean", "Z").replace("Float", "F").replace("Double", "D");
                origReturnType = Type.getType(t3);
            }
            if (type.getSort() == 0 && !newArgs.isEmpty() && ((Type)newArgs.getLast()).getDescriptor().startsWith("Ledu/columbia/cs/psl/phosphor/struct/Tainted")) {
                newArgs.removeLast();
            }
            if (Configuration.IMPLICIT_TRACKING && newArgs.size() > 0) {
                newArgs.removeLast();
            }
            String string = "(";
            for (Type type7 : newArgs) {
                String string2 = (String)var9_102 + type7.getDescriptor();
            }
            String string5 = (String)var9_102 + ")";
            string5 = string5 + t3;
            string5 = TaintUtils.remapMethodDescAndIncludeReturnHolder(string5);
            if (string5.equals(methodNode.desc)) continue;
            MethodVisitor mv5 = super.visitMethod(methodNode.access, methodNode.name, string5, methodNode.signature, exceptions);
            GeneratorAdapter generatorAdapter = new GeneratorAdapter(mv5, methodNode.access, methodNode.name, string5);
            Label label = new Label();
            generatorAdapter.visitCode();
            generatorAdapter.visitLabel(label);
            generatorAdapter.visitLineNumber(0, label);
            switch (type.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    generatorAdapter.visitInsn(3);
                    break;
                }
                case 9: 
                case 10: {
                    generatorAdapter.visitInsn(1);
                    break;
                }
                case 7: {
                    generatorAdapter.visitInsn(9);
                    break;
                }
                case 8: {
                    generatorAdapter.visitInsn(14);
                    break;
                }
                case 6: {
                    generatorAdapter.visitInsn(11);
                }
            }
            Label endLabel = new Label();
            generatorAdapter.visitLabel(endLabel);
            generatorAdapter.returnValue();
            Iterator<LocalVariableNode> iterator = methodNode.localVariables.iterator();
            while (iterator.hasNext()) {
                LocalVariableNode o;
                LocalVariableNode n = o = iterator.next();
                generatorAdapter.visitLocalVariable(n.name, n.desc, n.signature, label, endLabel, n.index);
            }
            generatorAdapter.visitMaxs(0, 0);
            generatorAdapter.visitEnd();
        }
        if (!goLightOnGeneratedStuff) {
            for (MethodNode methodNode : this.methodsToAddWrappersFor) {
                MethodNode fullMethod;
                if (this.className.equals("java/lang/String") && (methodNode.name.equals("hashCode") && methodNode.desc.equals("()I") || methodNode.name.equals("equals") && methodNode.desc.equals("(Ljava/lang/Object;)Z"))) {
                    fullMethod = this.forMore.get(methodNode);
                    MethodVisitor mv6 = super.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, null);
                    fullMethod.accept(mv6);
                    continue;
                }
                if ((methodNode.access & 0x100) == 0) {
                    if ((methodNode.access & 0x400) == 0) {
                        fullMethod = this.forMore.get(methodNode);
                        Type origReturn = Type.getReturnType(methodNode.desc);
                        Type type = TaintUtils.getContainerReturnType(origReturn);
                        Type returnTypeToHackOnLambda = this.methodsToAddWrappersForWithReturnType.get(methodNode);
                        boolean needToPrealloc = TaintUtils.isPreAllocReturnType(methodNode.desc) || returnTypeToHackOnLambda != null;
                        boolean bl = !TaintUtils.remapMethodDescAndIncludeReturnHolder(methodNode.desc).equals(methodNode.desc) || Type.getReturnType(methodNode.desc).getDescriptor().equals("Ljava/lang/Object;") || this.methodsToAddLambdaUnWrappersFor.contains(methodNode);
                        String[] exceptions2 = new String[methodNode.exceptions.size()];
                        exceptions2 = methodNode.exceptions.toArray(exceptions2);
                        boolean bl2 = (methodNode.access & 0x8000) != 0 || this.isLambda && (methodNode.access & 8) == 0;
                        methodNode.access &= 0xFFFF7FFF;
                        MethodVisitor methodVisitor = super.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, exceptions2);
                        TaintTagFieldCastMV taintTagFieldCastMV = new TaintTagFieldCastMV(methodVisitor, methodNode.name);
                        if (fullMethod != null) {
                            this.visitAnnotations(taintTagFieldCastMV, fullMethod);
                        }
                        SpecialOpcodeRemovingMV soc = new SpecialOpcodeRemovingMV(taintTagFieldCastMV, this.ignoreFrames, methodNode.access, this.className, methodNode.desc, this.fixLdcClass);
                        NeverNullArgAnalyzerAdapter an = new NeverNullArgAnalyzerAdapter(this.className, methodNode.access, methodNode.name, methodNode.desc, soc);
                        LocalVariableManager lvs = new LocalVariableManager(methodNode.access, methodNode.desc, an, an, taintTagFieldCastMV, this.generateExtraLVDebug);
                        lvs.setPrimitiveArrayAnalyzer(new PrimitiveArrayAnalyzer(returnTypeToHackOnLambda == null ? type : returnTypeToHackOnLambda));
                        GeneratorAdapter ga = new GeneratorAdapter(lvs, methodNode.access, methodNode.name, methodNode.desc);
                        Label startLabel = new Label();
                        ga.visitCode();
                        ga.visitLabel(startLabel);
                        ga.visitLineNumber(0, startLabel);
                        Type[] argTypes = Type.getArgumentTypes(methodNode.desc);
                        int idx = 0;
                        if ((methodNode.access & 8) == 0) {
                            ga.visitVarInsn(25, 0);
                            ++idx;
                        }
                        String newDesc = "(";
                        for (Type t : argTypes) {
                            int loaded = 0;
                            boolean needToBoxMultiD = false;
                            if (t.getSort() == 9) {
                                if (t.getElementType().getSort() != 10) {
                                    if (t.getDimensions() == 1) {
                                        newDesc = newDesc + TaintUtils.getShadowTaintType(t.getDescriptor());
                                        ga.visitVarInsn(25, idx);
                                        TaintAdapter.createNewTaintArray(t.getDescriptor(), an, lvs, lvs);
                                        loaded = 1;
                                    } else {
                                        newDesc = newDesc + MultiDTaintedArray.getTypeForType(t).getDescriptor();
                                        needToBoxMultiD = true;
                                    }
                                }
                            } else if (t.getSort() != 10) {
                                newDesc = newDesc + Configuration.TAINT_TAG_DESC;
                                Configuration.taintTagFactory.generateEmptyTaint(ga);
                            }
                            if (loaded == 0) {
                                ga.visitVarInsn(t.getOpcode(21), idx);
                            }
                            if (t.getSort() == 10 && Instrumenter.isCollection(t.getInternalName())) {
                                ga.visitMethodInsn(184, Type.getInternalName(NativeHelper.class), "ensureIsBoxed" + (Configuration.MULTI_TAINTING ? "ObjTags" : ""), "(Ljava/util/Collection;)Ljava/util/Collection;", false);
                                ga.visitTypeInsn(192, t.getInternalName());
                            }
                            if (t.getDescriptor().endsWith("java/lang/Object;") && !this.className.contains("MethodAccessorImpl") && !methodNode.name.startsWith("invoke") && !this.className.contains("ConstructorAccessorImpl")) {
                                ga.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                                ga.visitTypeInsn(192, t.getInternalName());
                            }
                            if (!needToBoxMultiD) {
                                newDesc = newDesc + t.getDescriptor();
                            } else {
                                Label isDone = new Label();
                                ga.visitInsn(89);
                                ga.visitJumpInsn(198, isDone);
                                ga.visitIntInsn(16, t.getElementType().getSort());
                                ga.visitIntInsn(16, t.getDimensions());
                                ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "initWithEmptyTaints", "([Ljava/lang/Object;II)Ljava/lang/Object;", false);
                                FrameNode fn = TaintAdapter.getCurrentFrameNode(an);
                                fn.stack.set(fn.stack.size() - 1, "java/lang/Object");
                                ga.visitLabel(isDone);
                                TaintAdapter.acceptFn(fn, lvs);
                                ga.visitTypeInsn(192, MultiDTaintedArray.getTypeForType(t).getDescriptor());
                            }
                            idx += t.getSize();
                        }
                        int tempControlFlowIdx = -1;
                        if (Configuration.IMPLICIT_TRACKING) {
                            newDesc = newDesc + Type.getDescriptor(ControlTaintTagStack.class);
                            ga.visitMethodInsn(184, Type.getInternalName(ControlTaintTagStackPool.class), "instance", "()" + Type.getDescriptor(ControlTaintTagStack.class), false);
                        } else if (Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
                            newDesc = newDesc + Type.getDescriptor(ControlTaintTagStack.class);
                            ga.visitMethodInsn(184, Type.getInternalName(ControlTaintTagStack.class), "factory", "()" + Type.getDescriptor(ControlTaintTagStack.class), false);
                        }
                        if (methodNode.name.equals("<init>")) {
                            newDesc = newDesc + Type.getDescriptor(TaintSentinel.class);
                            ga.visitInsn(1);
                        }
                        if (needToPrealloc) {
                            newDesc = newDesc + (returnTypeToHackOnLambda == null ? type.getDescriptor() : returnTypeToHackOnLambda.getDescriptor());
                            an.visitVarInsn(25, lvs.getPreAllocedReturnTypeVar(returnTypeToHackOnLambda == null ? type : returnTypeToHackOnLambda));
                        }
                        newDesc = newDesc + ")" + type.getDescriptor();
                        int opcode = bl2 ? 182 : ((methodNode.access & 8) == 0 ? 183 : 184);
                        if (methodNode.name.equals("<init>")) {
                            ga.visitMethodInsn(183, this.className, methodNode.name, newDesc, false);
                        } else {
                            ga.visitMethodInsn(opcode, this.className, methodNode.name + (bl ? "$$PHOSPHORTAGGED" : ""), newDesc, false);
                        }
                        idx = 0;
                        if ((methodNode.access & 8) == 0) {
                            ++idx;
                        }
                        for (Type t : argTypes) {
                            if (t.getSort() == 10 && Instrumenter.isCollection(t.getInternalName())) {
                                ga.visitVarInsn(t.getOpcode(21), idx);
                                ga.visitMethodInsn(184, Type.getInternalName(NativeHelper.class), "ensureIsUnBoxed" + (Configuration.MULTI_TAINTING ? "ObjTags" : ""), "(Ljava/util/Collection;)Ljava/util/Collection;", false);
                                ga.visitInsn(87);
                            }
                            idx += t.getSize();
                        }
                        if (origReturn != type) {
                            String taintType = TaintUtils.getShadowTaintType(origReturn.getDescriptor());
                            if (taintType != null) {
                                if (origReturn.getSort() == 9) {
                                    FrameNode fn2 = TaintAdapter.getCurrentFrameNode(an);
                                    Label isNull = new Label();
                                    ga.visitInsn(89);
                                    Label isDone = new Label();
                                    ga.visitJumpInsn(198, isNull);
                                    ga.visitFieldInsn(180, type.getInternalName(), "val", origReturn.getDescriptor());
                                    FrameNode fn = TaintAdapter.getCurrentFrameNode(an);
                                    ga.visitJumpInsn(167, isDone);
                                    fn.type = -1;
                                    fn2.type = -1;
                                    ga.visitLabel(isNull);
                                    TaintAdapter.acceptFn(fn2, ga);
                                    ga.visitInsn(87);
                                    ga.visitInsn(1);
                                    ga.visitLabel(isDone);
                                    TaintAdapter.acceptFn(fn, ga);
                                } else {
                                    ga.visitFieldInsn(180, type.getInternalName(), "val", origReturn.getDescriptor());
                                }
                            } else {
                                Label isDone = new Label();
                                ga.visitInsn(89);
                                ga.visitJumpInsn(198, isDone);
                                ga.visitIntInsn(16, origReturn.getElementType().getSort());
                                ga.visitIntInsn(16, origReturn.getDimensions() - 1);
                                ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "unboxVal", "(Ljava/lang/Object;II)Ljava/lang/Object;", false);
                                FrameNode fn = TaintAdapter.getCurrentFrameNode(an);
                                fn.stack.set(fn.stack.size() - 1, "java/lang/Object");
                                ga.visitLabel(isDone);
                                TaintAdapter.acceptFn(fn, lvs);
                                ga.visitTypeInsn(192, origReturn.getInternalName());
                            }
                        }
                        Label endLabel = new Label();
                        ga.visitLabel(endLabel);
                        ga.returnValue();
                        Iterator<LocalVariableNode> iterator = methodNode.localVariables.iterator();
                        while (iterator.hasNext()) {
                            LocalVariableNode o;
                            LocalVariableNode n = o = iterator.next();
                            ga.visitLocalVariable(n.name, n.desc, n.signature, startLabel, endLabel, n.index);
                        }
                        if (methodNode.name.equals("<init>")) {
                            // empty if block
                        }
                        ga.visitMaxs(0, 0);
                        ga.visitEnd();
                        continue;
                    }
                    exceptions = new String[methodNode.exceptions.size()];
                    exceptions = methodNode.exceptions.toArray(exceptions);
                    MethodNode fullMethod2 = this.forMore.get(methodNode);
                    MethodVisitor methodVisitor = super.visitMethod(methodNode.access, methodNode.name, methodNode.desc, methodNode.signature, exceptions);
                    this.visitAnnotations(methodVisitor, fullMethod2);
                    methodNode.accept(methodVisitor);
                    continue;
                }
                this.generateNativeWrapper(methodNode, methodNode.name, false);
                if (!this.className.equals("sun/misc/Unsafe")) continue;
                this.generateNativeWrapper(methodNode, methodNode.name, true);
            }
        }
        this.superMethodsToOverride.remove("wait(JI)V");
        this.superMethodsToOverride.remove("wait(J)V");
        this.superMethodsToOverride.remove("wait()V");
        this.superMethodsToOverride.remove("notify()V");
        this.superMethodsToOverride.remove("notifyAll()V");
        for (Method method : this.superMethodsToOverride.values()) {
            int opcode;
            int acc = 1;
            if (Modifier.isProtected(method.getModifiers()) && this.isInterface || Modifier.isPrivate(method.getModifiers())) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                acc |= 8;
            }
            acc = this.isInterface ? (acc |= 0x400) : (acc &= 0xFFFFFBFF);
            MethodNode mn = new MethodNode(Configuration.ASM_VERSION, acc, method.getName(), Type.getMethodDescriptor(method), null, null);
            this.generateNativeWrapper(mn, mn.name, false);
            if (!Configuration.GENERATE_UNINST_STUBS) continue;
            MethodVisitor methodVisitor = super.visitMethod(this.isInterface ? mn.access : mn.access & 0xFFFFFBFF, mn.name + "$$PHOSPHORUNTAGGED", mn.desc, mn.signature, mn.exceptions.toArray(new String[0]));
            GeneratorAdapter ga = new GeneratorAdapter(methodVisitor, mn.access, mn.name, mn.desc);
            this.visitAnnotations(methodVisitor, mn);
            if (this.isInterface) continue;
            methodVisitor.visitCode();
            if ((mn.access & 8) == 0) {
                ga.loadThis();
                opcode = 183;
            } else {
                opcode = 184;
            }
            ga.loadArgs();
            ga.visitMethodInsn(opcode, this.className, mn.name, mn.desc, false);
            ga.returnValue();
            methodVisitor.visitMaxs(0, 0);
            methodVisitor.visitEnd();
        }
        if (Configuration.WITH_SELECTIVE_INST) {
            for (MethodNode methodNode : this.methodsToMakeUninstWrappersAround) {
                this.generateNativeWrapper(methodNode, methodNode.name + "$$PHOSPHORUNTAGGED", false);
                String mName = methodNode.name;
                String mToCall = methodNode.name;
                String string = methodNode.desc;
                boolean isInit = false;
                String mDesc = methodNode.desc;
                if ((0x100 & methodNode.access) != 0) {
                    mName = mName + "$$PHOSPHORUNTAGGED";
                    methodNode.access &= 0xFFFFFEFF;
                    mDesc = TaintUtils.remapMethodDescForUninst(mDesc);
                } else if (methodNode.name.equals("<init>")) {
                    isInit = true;
                    String string7 = mDesc.substring(0, methodNode.desc.indexOf(41)) + Type.getDescriptor(UninstrumentedTaintSentinel.class) + ")" + mDesc.substring(mDesc.indexOf(41) + 1);
                    string7 = TaintUtils.remapMethodDescForUninst(string7);
                } else {
                    mToCall = mToCall + "$$PHOSPHORUNTAGGED";
                    String string8 = TaintUtils.remapMethodDescForUninst(string);
                }
                MethodVisitor methodVisitor = super.visitMethod(methodNode.access, mName, mDesc, methodNode.signature, methodNode.exceptions.toArray(new String[0]));
                this.visitAnnotations(methodVisitor, methodNode);
                if (!this.isInterface) {
                    void var6_76;
                    int n;
                    GeneratorAdapter ga = new GeneratorAdapter(methodVisitor, methodNode.access, methodNode.name, mDesc);
                    methodVisitor.visitCode();
                    if ((methodNode.access & 8) == 0) {
                        ga.loadThis();
                        n = 183;
                    } else {
                        n = 184;
                    }
                    Type[] typeArray = Type.getArgumentTypes(methodNode.desc);
                    Type[] newArgs = Type.getArgumentTypes((String)var6_76);
                    for (int i = 0; i < typeArray.length; ++i) {
                        ga.loadArg(i);
                        if (typeArray[i].getSort() != 9 || typeArray[i].getElementType().getSort() == 10 || typeArray[i].getDimensions() <= 1) continue;
                        ga.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        ga.visitTypeInsn(192, newArgs[i].getInternalName());
                    }
                    if (isInit) {
                        ga.visitInsn(1);
                    }
                    Type retType = Type.getReturnType(methodNode.desc);
                    ga.visitMethodInsn(n, this.className, mToCall, (String)var6_76, false);
                    if (retType.getSort() == 9 && retType.getDimensions() > 1 && retType.getElementType().getSort() != 10) {
                        ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        ga.checkCast(retType);
                    }
                    ga.returnValue();
                    methodVisitor.visitMaxs(0, 0);
                }
                methodVisitor.visitEnd();
            }
        }
        if (Configuration.GENERATE_UNINST_STUBS) {
            for (Map.Entry<MethodNode, MethodNode> entry : this.forMore.entrySet()) {
                void var6_80;
                MethodNode mn = entry.getKey();
                if (mn.name.equals("<clinit>")) continue;
                String mName = mn.name;
                String string = TaintUtils.remapMethodDescForUninst(mn.desc);
                if (mName.equals("<init>")) {
                    String string9 = string.substring(0, string.indexOf(41)) + Type.getDescriptor(UninstrumentedTaintSentinel.class) + ")" + string.substring(string.indexOf(41) + 1);
                } else {
                    mName = mName + "$$PHOSPHORUNTAGGED";
                }
                MethodVisitor mv9 = super.visitMethod(mn.access & 0xFFFFFEFF, mName, (String)var6_80, mn.signature, mn.exceptions.toArray(new String[0]));
                MethodNode meth = entry.getValue();
                if ((mn.access & 0x100) != 0) {
                    void var12_135;
                    int opcode;
                    GeneratorAdapter generatorAdapter = new GeneratorAdapter(mv9, mn.access, mn.name, mn.desc);
                    this.visitAnnotations(mv9, mn);
                    mv9.visitCode();
                    if ((mn.access & 8) == 0) {
                        generatorAdapter.loadThis();
                        opcode = 183;
                    } else {
                        opcode = 184;
                    }
                    Type[] typeArray = Type.getArgumentTypes(mn.desc);
                    boolean bl = false;
                    while (var12_135 < typeArray.length) {
                        generatorAdapter.loadArg((int)var12_135);
                        if (typeArray[var12_135].getSort() == 9 && typeArray[var12_135].getDimensions() > 1 && typeArray[var12_135].getElementType().getSort() != 10) {
                            generatorAdapter.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                            generatorAdapter.visitTypeInsn(192, typeArray[var12_135].getInternalName());
                        }
                        ++var12_135;
                    }
                    generatorAdapter.visitMethodInsn(opcode, this.className, mn.name, mn.desc, false);
                    generatorAdapter.returnValue();
                    mv9.visitMaxs(0, 0);
                    mv9.visitEnd();
                    continue;
                }
                mv9 = new SpecialOpcodeRemovingMV(mv9, this.ignoreFrames, mn.access, this.className, (String)var6_80, this.fixLdcClass);
                NeverNullArgAnalyzerAdapter neverNullArgAnalyzerAdapter = new NeverNullArgAnalyzerAdapter(this.className, mn.access, mn.name, (String)var6_80, mv9);
                mv9 = neverNullArgAnalyzerAdapter;
                mv9 = new UninstrumentedReflectionHidingMV(mv9, this.className);
                UninstrumentedReflectionHidingMV ta = (UninstrumentedReflectionHidingMV)mv9;
                mv9 = new UninstrumentedCompatMV(mn.access, this.className, mn.name, mn.desc, Type.getReturnType(mn.desc), mn.signature, mn.exceptions.toArray(new String[0]), mv9, neverNullArgAnalyzerAdapter, this.ignoreFrames);
                LocalVariableManager localVariableManager = new LocalVariableManager(mn.access, mn.desc, mv9, neverNullArgAnalyzerAdapter, neverNullArgAnalyzerAdapter, this.generateExtraLVDebug);
                final PrimitiveArrayAnalyzer primitiveArrayAnalyzer = new PrimitiveArrayAnalyzer(this.className, mn.access, mn.name, mn.desc, null, null, null, false);
                localVariableManager.disable();
                localVariableManager.setPrimitiveArrayAnalyzer(primitiveArrayAnalyzer);
                ((UninstrumentedCompatMV)mv9).setLocalVariableSorter(localVariableManager);
                ta.setLvs(localVariableManager);
                mv9 = localVariableManager;
                meth.accept(new MethodVisitor(Configuration.ASM_VERSION){

                    @Override
                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        Type returnType;
                        Type newReturnType;
                        if (!(Configuration.WITH_SELECTIVE_INST && Instrumenter.isIgnoredMethodFromOurAnalysis(owner, name, desc) || (newReturnType = TaintUtils.getContainerReturnType(returnType = Type.getReturnType(desc))) == returnType || returnType.getSort() == 9)) {
                            primitiveArrayAnalyzer.wrapperTypesToPreAlloc.add(newReturnType);
                        }
                    }
                });
                meth.accept(mv9);
            }
        }
        super.visitEnd();
    }

    private void visitAnnotations(MethodVisitor mv, MethodNode fullMethod) {
        AnnotationNode an;
        AnnotationNode o;
        AnnotationNode an2;
        Iterator<Object> av;
        if (fullMethod.annotationDefault != null) {
            av = mv.visitAnnotationDefault();
            TaintTrackingClassVisitor.acceptAnnotationRaw((AnnotationVisitor)((Object)av), null, fullMethod.annotationDefault);
            ((AnnotationVisitor)((Object)av)).visitEnd();
        }
        if (fullMethod.visibleAnnotations != null) {
            av = fullMethod.visibleAnnotations.iterator();
            while (av.hasNext()) {
                AnnotationNode iterator;
                AnnotationNode an22 = iterator = av.next();
                an22.accept(mv.visitAnnotation(an22.desc, true));
            }
        }
        if (fullMethod.invisibleAnnotations != null) {
            av = fullMethod.invisibleAnnotations.iterator();
            while (av.hasNext()) {
                AnnotationNode annotationNode;
                an2 = annotationNode = av.next();
                an2.accept(mv.visitAnnotation(an2.desc, false));
            }
        }
        if (fullMethod.visibleTypeAnnotations != null) {
            for (AnnotationNode annotationNode : fullMethod.visibleTypeAnnotations) {
                an2 = (TypeAnnotationNode)annotationNode;
                an2.accept(mv.visitTypeAnnotation(((TypeAnnotationNode)an2).typeRef, ((TypeAnnotationNode)an2).typePath, ((TypeAnnotationNode)an2).desc, true));
            }
        }
        if (fullMethod.invisibleTypeAnnotations != null) {
            for (Object object : fullMethod.invisibleTypeAnnotations) {
                an2 = (TypeAnnotationNode)object;
                an2.accept(mv.visitTypeAnnotation(((TypeAnnotationNode)an2).typeRef, ((TypeAnnotationNode)an2).typePath, ((TypeAnnotationNode)an2).desc, false));
            }
        }
        if (fullMethod.parameters != null) {
            for (Object object : fullMethod.parameters) {
                ParameterNode pn = (ParameterNode)object;
                pn.accept(mv);
            }
        }
        if (fullMethod.visibleParameterAnnotations != null) {
            for (int i = 0; i < fullMethod.visibleParameterAnnotations.length; ++i) {
                if (fullMethod.visibleParameterAnnotations[i] == null) continue;
                Iterator<AnnotationNode> iterator = fullMethod.visibleParameterAnnotations[i].iterator();
                while (iterator.hasNext()) {
                    an = o = iterator.next();
                    an.accept(mv.visitParameterAnnotation(i, an.desc, true));
                }
            }
        }
        if (fullMethod.invisibleParameterAnnotations != null) {
            for (int i = 0; i < fullMethod.invisibleParameterAnnotations.length; ++i) {
                if (fullMethod.invisibleParameterAnnotations[i] == null) continue;
                Iterator<AnnotationNode> iterator = fullMethod.invisibleParameterAnnotations[i].iterator();
                while (iterator.hasNext()) {
                    an = o = iterator.next();
                    an.accept(mv.visitParameterAnnotation(i, an.desc, false));
                }
            }
        }
    }

    static void acceptAnnotationRaw(AnnotationVisitor av, String name, Object value) {
        if (av != null) {
            if (value instanceof String[]) {
                String[] typeconst = (String[])value;
                av.visitEnum(name, typeconst[0], typeconst[1]);
            } else if (value instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)value;
                an.accept(av.visitAnnotation(name, an.desc));
            } else if (value instanceof List) {
                AnnotationVisitor v = av.visitArray(name);
                List array = (List)value;
                for (int j = 0; j < array.size(); ++j) {
                    TaintTrackingClassVisitor.acceptAnnotationRaw(v, null, array.get(j));
                }
                v.visitEnd();
            } else {
                av.visit(name, value);
            }
        }
    }

    private void generateNativeWrapper(MethodNode m, String methodNameToCall, boolean skipUnboxing) {
        String[] exceptions = new String[m.exceptions.size()];
        exceptions = m.exceptions.toArray(exceptions);
        Type[] argTypes = Type.getArgumentTypes(m.desc);
        boolean isPreAllocReturnType = TaintUtils.isPreAllocReturnType(m.desc);
        String newDesc = "(";
        LinkedList<LocalVariableNode> lvsToVisit = new LinkedList<LocalVariableNode>();
        LabelNode start = new LabelNode(new Label());
        LabelNode end = new LabelNode(new Label());
        for (Type t : argTypes) {
            if (t.getSort() == 9) {
                if (t.getElementType().getSort() != 10 && t.getDimensions() == 1) {
                    newDesc = newDesc + TaintUtils.getShadowTaintType(t.getDescriptor());
                }
            } else if (t.getSort() != 10) {
                newDesc = newDesc + Configuration.TAINT_TAG_DESC;
            }
            newDesc = t.getSort() == 9 && t.getElementType().getSort() != 10 && t.getDimensions() > 1 ? newDesc + MultiDTaintedArray.getTypeForType(t).getDescriptor() : newDesc + t.getDescriptor();
        }
        Type origReturn = Type.getReturnType(m.desc);
        Type newReturn = TaintUtils.getContainerReturnType(origReturn);
        if (Configuration.IMPLICIT_HEADERS_NO_TRACKING || Configuration.IMPLICIT_TRACKING) {
            newDesc = newDesc + Type.getDescriptor(ControlTaintTagStack.class);
        }
        if (m.name.equals("<init>")) {
            newDesc = newDesc + Type.getDescriptor(TaintSentinel.class);
        }
        if (isPreAllocReturnType) {
            newDesc = newDesc + newReturn.getDescriptor();
        }
        newDesc = newDesc + ")" + newReturn.getDescriptor();
        MethodVisitor mv = m.name.equals("<init>") ? super.visitMethod(m.access & 0xFFFFFEFF, m.name, newDesc, m.signature, exceptions) : super.visitMethod(m.access & 0xFFFFFEFF, m.name + "$$PHOSPHORTAGGED" + (skipUnboxing ? "$$NOUNBOX" : ""), newDesc, m.signature, exceptions);
        NeverNullArgAnalyzerAdapter an = new NeverNullArgAnalyzerAdapter(this.className, m.access, m.name, newDesc, mv);
        SpecialOpcodeRemovingMV soc = new SpecialOpcodeRemovingMV(an, this.ignoreFrames, m.access, this.className, newDesc, this.fixLdcClass);
        LocalVariableManager lvs = new LocalVariableManager(m.access, newDesc, soc, an, mv, this.generateExtraLVDebug);
        lvs.setPrimitiveArrayAnalyzer(new PrimitiveArrayAnalyzer(newReturn));
        GeneratorAdapter ga = new GeneratorAdapter(lvs, m.access, m.name + "$$PHOSPHORTAGGED", newDesc);
        if (this.isInterface) {
            ga.visitEnd();
            return;
        }
        ga.visitCode();
        ga.visitLabel(start.getLabel());
        if (this.isLambda) {
            if (m.name.equals("equals")) {
                int retVar = Configuration.IMPLICIT_TRACKING ? 3 : 2;
                ga.visitVarInsn(25, retVar);
                ga.visitInsn(Configuration.NULL_TAINT_LOAD_OPCODE);
                ga.visitFieldInsn(181, newReturn.getInternalName(), "taint", Configuration.TAINT_TAG_DESC);
                ga.visitVarInsn(25, 0);
                ga.visitVarInsn(25, 1);
                Label eq = new Label();
                ga.visitJumpInsn(165, eq);
                ga.visitVarInsn(25, retVar);
                ga.visitInsn(89);
                ga.visitInsn(3);
                ga.visitFieldInsn(181, newReturn.getInternalName(), "val", "Z");
                ga.visitInsn(176);
                ga.visitLabel(eq);
                if (Configuration.IMPLICIT_TRACKING) {
                    ga.visitFrame(-1, 4, new Object[]{this.className, "java/lang/Object", Type.getInternalName(ControlTaintTagStack.class), newReturn.getInternalName()}, 0, new Object[0]);
                } else {
                    ga.visitFrame(-1, 3, new Object[]{this.className, "java/lang/Object", newReturn.getInternalName()}, 0, new Object[0]);
                }
                ga.visitVarInsn(25, retVar);
                ga.visitInsn(89);
                ga.visitInsn(4);
                ga.visitFieldInsn(181, newReturn.getInternalName(), "val", "Z");
            } else if (m.name.equals("hashCode")) {
                int retVar = Configuration.IMPLICIT_TRACKING ? 2 : 1;
                ga.visitVarInsn(25, retVar);
                ga.visitInsn(89);
                ga.visitInsn(89);
                ga.visitInsn(Configuration.NULL_TAINT_LOAD_OPCODE);
                ga.visitFieldInsn(181, newReturn.getInternalName(), "taint", Configuration.TAINT_TAG_DESC);
                ga.visitInsn(3);
                ga.visitFieldInsn(181, newReturn.getInternalName(), "val", "I");
            } else {
                switch (Type.getReturnType(newDesc).getSort()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ga.visitInsn(3);
                        break;
                    }
                    case 9: 
                    case 10: {
                        ga.visitInsn(1);
                        break;
                    }
                    case 7: {
                        ga.visitInsn(9);
                        break;
                    }
                    case 8: {
                        ga.visitInsn(14);
                        break;
                    }
                    case 6: {
                        ga.visitInsn(11);
                    }
                }
            }
        } else {
            String descToCall = m.desc;
            boolean isUntaggedCall = false;
            if (methodNameToCall.contains("$$PHOSPHORUNTAGGED")) {
                descToCall = TaintUtils.remapMethodDescForUninst(descToCall);
                isUntaggedCall = true;
            }
            int idx = 0;
            if ((m.access & 8) == 0) {
                ga.visitVarInsn(25, 0);
                lvsToVisit.add(new LocalVariableNode("this", "L" + this.className + ";", null, start, end, idx));
                ++idx;
            }
            for (Type t : argTypes) {
                if (t.getSort() == 9) {
                    if (t.getElementType().getSort() != 10 && t.getDimensions() == 1) {
                        lvsToVisit.add(new LocalVariableNode("phosphorNativeWrapArg" + idx, TaintUtils.getShadowTaintType(t.getDescriptor()), null, start, end, idx));
                        ++idx;
                    }
                } else if (t.getSort() != 10) {
                    lvsToVisit.add(new LocalVariableNode("phosphorNativeWrapArg" + idx, Configuration.TAINT_TAG_DESC, null, start, end, idx));
                    ++idx;
                }
                ga.visitVarInsn(t.getOpcode(21), idx);
                lvsToVisit.add(new LocalVariableNode("phosphorNativeWrapArg" + idx, t.getDescriptor(), null, start, end, idx));
                if (!skipUnboxing) {
                    if (t.getDescriptor().equals("[Lsun/security/pkcs11/wrapper/CK_ATTRIBUTE;")) {
                        ga.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unboxCK_ATTRIBUTE", "([Lsun/security/pkcs11/wrapper/CK_ATTRIBUTE;)[Lsun/security/pkcs11/wrapper/CK_ATTRIBUTE;", false);
                    } else if (t.getDescriptor().equals("Ljava/lang/Object;") || t.getSort() == 9 && t.getElementType().getDescriptor().equals("Ljava/lang/Object;")) {
                        ga.visitInsn(89);
                        ga.visitInsn(89);
                        Label isOK = new Label();
                        ga.visitTypeInsn(193, "[" + Type.getDescriptor(!Configuration.MULTI_TAINTING ? LazyArrayIntTags.class : LazyArrayObjTags.class));
                        ga.visitInsn(95);
                        ga.visitTypeInsn(193, Type.getInternalName(!Configuration.MULTI_TAINTING ? LazyArrayIntTags.class : LazyArrayObjTags.class));
                        ga.visitInsn(128);
                        ga.visitJumpInsn(153, isOK);
                        if (isUntaggedCall) {
                            ga.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unbox1D", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        } else if (this.className.equals("sun/misc/Unsafe")) {
                            ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "unboxRawOnly1D", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        } else if (this.className.equals("sun/reflect/NativeMethodAccessorImpl") && "invoke0".equals(methodNameToCall) && Type.getType(Object.class).equals(t)) {
                            ga.loadArg(0);
                            ga.visitInsn(95);
                            ga.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unboxMethodReceiverIfNecessary", "(Ljava/lang/reflect/Method;Ljava/lang/Object;)Ljava/lang/Object;", false);
                        } else {
                            ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        }
                        if (t.getSort() == 9) {
                            ga.visitTypeInsn(192, t.getInternalName());
                        }
                        FrameNode fn = TaintAdapter.getCurrentFrameNode(an);
                        ga.visitLabel(isOK);
                        TaintAdapter.acceptFn(fn, lvs);
                    } else if (!isUntaggedCall && t.getSort() == 9 && t.getDimensions() > 1 && t.getElementType().getSort() != 10) {
                        ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                        ga.visitTypeInsn(192, t.getInternalName());
                    }
                }
                idx += t.getSize();
            }
            int opcode = (m.access & 8) == 0 ? 183 : 184;
            if (m.name.equals("<init>") && methodNameToCall.contains("$$PHOSPHORUNTAGGED")) {
                descToCall = descToCall.substring(0, descToCall.indexOf(41)) + Type.getDescriptor(UninstrumentedTaintSentinel.class) + ")" + descToCall.substring(descToCall.indexOf(41) + 1);
                ga.visitInsn(1);
                ga.visitMethodInsn(opcode, this.className, m.name, descToCall, false);
            } else {
                ga.visitMethodInsn(opcode, this.className, methodNameToCall, descToCall, false);
            }
            if (origReturn != newReturn) {
                int retIdx;
                if (origReturn.getSort() == 9) {
                    if (origReturn.getDimensions() > 1) {
                        Label isOK = new Label();
                        ga.visitInsn(89);
                        ga.visitJumpInsn(198, isOK);
                        ga.visitTypeInsn(192, "[Ljava/lang/Object;");
                        ga.visitIntInsn(16, origReturn.getElementType().getSort());
                        ga.visitIntInsn(16, origReturn.getDimensions());
                        ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "initWithEmptyTaints", "([Ljava/lang/Object;II)Ljava/lang/Object;", false);
                        FrameNode fn = TaintAdapter.getCurrentFrameNode(an);
                        fn.stack.set(fn.stack.size() - 1, "java/lang/Object");
                        ga.visitLabel(isOK);
                        TaintAdapter.acceptFn(fn, lvs);
                        ga.visitTypeInsn(192, newReturn.getDescriptor());
                    } else {
                        TaintAdapter.createNewTaintArray(origReturn.getDescriptor(), an, lvs, lvs);
                        ga.visitInsn(95);
                    }
                } else if (origReturn.getSize() == 1) {
                    retIdx = lvs.getPreAllocedReturnTypeVar(newReturn);
                    an.visitVarInsn(25, retIdx);
                    ga.visitInsn(95);
                    ga.visitFieldInsn(181, newReturn.getInternalName(), "val", origReturn.getDescriptor());
                    an.visitVarInsn(25, retIdx);
                    Configuration.taintTagFactory.generateEmptyTaint(ga);
                    Configuration.taintTagFactory.propogateTagNative(this.className, m.access, m.name, m.desc, mv);
                    ga.visitFieldInsn(181, newReturn.getInternalName(), "taint", Configuration.TAINT_TAG_DESC);
                    an.visitVarInsn(25, retIdx);
                } else {
                    retIdx = lvs.getPreAllocedReturnTypeVar(newReturn);
                    an.visitVarInsn(25, retIdx);
                    ga.visitInsn(91);
                    ga.visitInsn(87);
                    ga.visitFieldInsn(181, newReturn.getInternalName(), "val", origReturn.getDescriptor());
                    an.visitVarInsn(25, retIdx);
                    Configuration.taintTagFactory.generateEmptyTaint(ga);
                    Configuration.taintTagFactory.propogateTagNative(this.className, m.access, m.name, m.desc, mv);
                    ga.visitFieldInsn(181, newReturn.getInternalName(), "taint", Configuration.TAINT_TAG_DESC);
                    an.visitVarInsn(25, retIdx);
                }
            } else if (origReturn.getSort() != 0 && (origReturn.getDescriptor().equals("Ljava/lang/Object;") || origReturn.getDescriptor().equals("[Ljava/lang/Object;")) && !isUntaggedCall) {
                ga.visitMethodInsn(184, Type.getInternalName(Configuration.MULTI_TAINTING ? MultiDTaintedArrayWithObjTag.class : MultiDTaintedArrayWithIntTag.class), "boxIfNecessary", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                if (origReturn.getSort() == 9) {
                    ga.visitTypeInsn(192, "[Ljava/lang/Object;");
                }
            }
        }
        ga.visitLabel(end.getLabel());
        ga.returnValue();
        if (isPreAllocReturnType) {
            lvsToVisit.add(new LocalVariableNode("phosphorReturnHolder", newReturn.getDescriptor(), null, start, end, lvs.getPreAllocedReturnTypeVar(newReturn)));
        }
        for (LocalVariableNode n : lvsToVisit) {
            n.accept(ga);
        }
        ga.visitMaxs(0, 0);
        ga.visitEnd();
    }

    static {
        if (!DO_OPT && !IS_RUNTIME_INST) {
            System.err.println("WARN: OPT DISABLED");
        }
    }
}

