/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.SourceSinkManager;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithObjTag;

public class TaintThroughTaintingMV
extends MethodVisitor
implements Opcodes {
    private final String owner;
    private final String desc;
    private final Type origReturnType;
    private final boolean isStatic;

    public TaintThroughTaintingMV(MethodVisitor mv, int access, String owner, String name, String desc) {
        super(Configuration.ASM_VERSION, mv);
        this.owner = owner;
        this.desc = desc;
        this.origReturnType = Type.getReturnType(SourceSinkManager.remapMethodDescToRemoveTaints(desc));
        this.isStatic = (access & 8) != 0;
    }

    @Override
    public void visitCode() {
        super.visitCode();
        if (Configuration.MULTI_TAINTING) {
            this.taintArguments();
        }
    }

    private void taintArguments() {
        Type[] args = Type.getArgumentTypes(this.desc);
        int idx = this.isStatic ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getDescriptor().equals(Configuration.TAINT_TAG_DESC) && args[i].getSort() == 10 || args[i].getSort() == 9 && args[i].getElementType().getSort() == 10) {
                super.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
                super.visitVarInsn(25, idx);
                super.visitVarInsn(25, 0);
                super.visitFieldInsn(180, this.owner, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                super.visitMethodInsn(184, Configuration.TAINT_TAG_INTERNAL_NAME, "copyTaint", "(" + Configuration.TAINT_TAG_DESC + ")" + Configuration.TAINT_TAG_DESC, false);
                super.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "addTaint", "(Ljava/lang/Object;" + Configuration.TAINT_TAG_DESC + ")V", false);
            }
            idx += args[i].getSize();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (Configuration.MULTI_TAINTING) {
            if (TaintUtils.isReturnOpcode(opcode)) {
                this.taintArguments();
            }
            if (opcode == 176) {
                if (this.origReturnType.getSort() == 10 || this.origReturnType.getSort() == 9) {
                    super.visitInsn(89);
                    super.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
                    super.visitInsn(95);
                    super.visitVarInsn(25, 0);
                    super.visitFieldInsn(180, this.owner, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                    super.visitMethodInsn(184, Configuration.TAINT_TAG_INTERNAL_NAME, "copyTaint", "(" + Configuration.TAINT_TAG_DESC + ")" + Configuration.TAINT_TAG_DESC, false);
                    super.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "addTaint", "(Ljava/lang/Object;" + Configuration.TAINT_TAG_DESC + ")V", false);
                } else if (this.origReturnType.getSort() != 0) {
                    super.visitInsn(89);
                    super.visitInsn(89);
                    super.visitFieldInsn(180, Type.getInternalName(TaintedPrimitiveWithObjTag.class), "taint", Configuration.TAINT_TAG_DESC);
                    super.visitVarInsn(25, 0);
                    super.visitFieldInsn(180, this.owner, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                    super.visitMethodInsn(184, Configuration.TAINT_TAG_INTERNAL_NAME, "combineTags", "(" + Configuration.TAINT_TAG_DESC + Configuration.TAINT_TAG_DESC + ")" + Configuration.TAINT_TAG_DESC, false);
                    super.visitMethodInsn(184, Configuration.TAINT_TAG_INTERNAL_NAME, "copyTaint", "(" + Configuration.TAINT_TAG_DESC + ")" + Configuration.TAINT_TAG_DESC, false);
                    super.visitFieldInsn(181, Type.getInternalName(TaintedPrimitiveWithObjTag.class), "taint", Configuration.TAINT_TAG_DESC);
                }
            }
        }
        super.visitInsn(opcode);
    }
}

