/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.DataAndControlFlowTagFactory;
import edu.columbia.cs.psl.phosphor.instrumenter.LocalVariableManager;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintTagFactory;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.TaggedValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FieldNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LabelNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LocalVariableNode;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;
import java.util.ArrayList;
import java.util.List;

public class TaintAdapter
extends MethodVisitor
implements Opcodes {
    protected LocalVariableManager lvs;
    protected NeverNullArgAnalyzerAdapter analyzer;
    protected String className;
    static final Type taintTagType = Type.getType(Configuration.TAINT_TAG_DESC);
    public List<FieldNode> fields;
    protected String classSource;
    protected String classDebug;
    protected String superName;

    public LocalVariableManager getLvs() {
        return this.lvs;
    }

    public static final Type getTagType(String internalName) {
        if (TaintAdapter.canRawTaintAccess(internalName)) {
            return taintTagType;
        }
        return Type.INT_TYPE;
    }

    public static final boolean canRawTaintAccess(String internalName) {
        return !Configuration.MULTI_TAINTING || !internalName.equals("java/lang/Float") && !internalName.equals("java/lang/Character") && !internalName.equals("java/lang/Double") && !internalName.equals("java/lang/Integer") && !internalName.equals("java/lang/Long") && !internalName.equals("java/lang/StackTraceElement");
    }

    private TaintAdapter(MethodVisitor mv) {
        super(Configuration.ASM_VERSION, mv);
    }

    private TaintAdapter(int api, MethodVisitor mv) {
        super(api, mv);
    }

    public TaintAdapter(int access, String className, String name, String desc, String signature, String[] exceptions, MethodVisitor mv, NeverNullArgAnalyzerAdapter analyzer) {
        super(Configuration.ASM_VERSION, mv);
        this.analyzer = analyzer;
        this.className = className;
    }

    public void setFields(List<FieldNode> fields) {
        this.fields = fields;
    }

    public void setSuperName(String parentName) {
        this.superName = parentName;
    }

    public TaintAdapter(int access, String className, String name, String desc, String signature, String[] exceptions, MethodVisitor mv, NeverNullArgAnalyzerAdapter analyzer, String classSource, String classDebug) {
        super(Configuration.ASM_VERSION, mv);
        this.analyzer = analyzer;
        this.className = className;
        this.classSource = classSource;
        this.classDebug = classDebug;
    }

    void ensureUnBoxedAt(int n, Type t) {
        switch (n) {
            case 0: {
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                super.visitTypeInsn(192, t.getInternalName());
                break;
            }
            case 1: {
                Object top = this.analyzer.stack.get(this.analyzer.stack.size() - 1);
                if (top == Opcodes.LONG || top == Opcodes.DOUBLE || top == Opcodes.TOP) {
                    super.visitInsn(93);
                    super.visitInsn(88);
                    super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                    super.visitTypeInsn(192, t.getInternalName());
                    super.visitInsn(91);
                    super.visitInsn(87);
                    break;
                }
                super.visitInsn(95);
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                super.visitTypeInsn(192, t.getInternalName());
                super.visitInsn(95);
                break;
            }
            default: {
                LocalVariableNode[] d = this.storeToLocals(n);
                super.visitMethodInsn(184, Type.getInternalName(MultiDTaintedArray.class), "unboxRaw", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                super.visitTypeInsn(192, t.getInternalName());
                for (int i = n - 1; i >= 0; --i) {
                    this.loadLV(i, d);
                }
                this.freeLVs(d);
            }
        }
    }

    public boolean topHas0Taint() {
        if (this.getTopOfStackObject() == Opcodes.TOP) {
            return Integer.valueOf(0).equals(this.analyzer.stackConstantVals.get(this.analyzer.stackConstantVals.size() - 3));
        }
        return Integer.valueOf(0).equals(this.analyzer.stackConstantVals.get(this.analyzer.stackConstantVals.size() - 2));
    }

    public boolean secondHas0Taint() {
        int offset = 2;
        if (this.getTopOfStackObject() == Opcodes.TOP) {
            ++offset;
        }
        if (TaintAdapter.getStackElementSize(offset) == Opcodes.TOP) {
            ++offset;
        }
        return Integer.valueOf(0).equals(this.analyzer.stackConstantVals.get(this.analyzer.stackConstantVals.size() - ++offset));
    }

    protected void getTaintFieldOfBoxedType(String owner) {
        super.visitFieldInsn(180, owner, "taint", Configuration.TAINT_TAG_DESC);
    }

    public void setLocalVariableSorter(LocalVariableManager lvs) {
        this.lvs = lvs;
    }

    public boolean topOfStackIsNull() {
        return this.stackElIsNull(0);
    }

    public Type getTopOfStackType() {
        if (this.analyzer.stack == null) {
            throw new NullPointerException();
        }
        if (this.analyzer.stack.get(this.analyzer.stack.size() - 1) == Opcodes.TOP) {
            return this.getStackTypeAtOffset(1);
        }
        return this.getStackTypeAtOffset(0);
    }

    public Object getTopOfStackObject() {
        return this.analyzer.stack.get(this.analyzer.stack.size() - 1);
    }

    public Type getStackTypeAtOffset(int n) {
        return TaintAdapter.getTypeForStackType(this.analyzer.stack.get(this.analyzer.stack.size() - 1 - n));
    }

    public boolean stackElIsNull(int n) {
        return this.analyzer.stack.get(this.analyzer.stack.size() - 1 - n) == Opcodes.NULL;
    }

    public NeverNullArgAnalyzerAdapter getAnalyzer() {
        return this.analyzer;
    }

    public void retrieveTopOfStackTaintArray() {
        Type onStack = this.getTopOfStackType();
        this.generateEmptyTaintArray(onStack.getDescriptor());
    }

    public void unconditionallyRetrieveTopOfStackTaintArray(boolean leaveOnStack) {
        if (leaveOnStack) {
            super.visitInsn(89);
        }
        super.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "getTaintArray", "(Ljava/lang/Object;)I", false);
    }

    public boolean topCarriesTaint() {
        Object t = this.analyzer.stackTagStatus.get(this.analyzer.stackTagStatus.size() - 1);
        if (t == Opcodes.TOP) {
            t = this.analyzer.stackTagStatus.get(this.analyzer.stackTagStatus.size() - 2);
        }
        return t instanceof TaggedValue;
    }

    @Deprecated
    public boolean topStackElCarriesTaints() {
        Object o = this.analyzer.stack.get(this.analyzer.stack.size() - 1);
        return TaintAdapter.isPrimitiveStackType(o);
    }

    public boolean topStackElIsNull() {
        Object o = this.analyzer.stack.get(this.analyzer.stack.size() - 1);
        return o == Opcodes.NULL;
    }

    protected void safelyFetchObjectTaint() {
        if (this.className.equals("java/util/HashMap")) {
            super.visitInsn(87);
            Configuration.taintTagFactory.generateEmptyTaint(this.mv);
        } else {
            super.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "getTaint", "(Ljava/lang/Object;)I", false);
        }
    }

    protected void generateUnconstrainedTaint(int reason) {
        Configuration.taintTagFactory.generateEmptyTaint(this.mv);
    }

    protected void generateEmptyTaintArray(String arrayDesc) {
        Type arrayType = Type.getType(arrayDesc);
        Label isNull = new Label();
        Label done = new Label();
        if (arrayType.getDimensions() == 2) {
            FrameNode fn = this.getCurrentFrameNode();
            super.visitInsn(89);
            super.visitInsn(203);
            super.visitJumpInsn(198, isNull);
            super.visitInsn(203);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitInsn(190);
            super.visitMultiANewArrayInsn("[[I", 1);
            super.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create2DTaintArray", "(Ljava/lang/Object;[[I)[[I", false);
            if (!(Configuration.taintTagFactory instanceof DataAndControlFlowTagFactory)) {
                super.visitInsn(89);
                super.visitInsn(5);
                super.visitMethodInsn(185, Type.getInternalName(TaintTagFactory.class), "generateEmptyTaintArray", "([Ljava/lang/Object;I)V", false);
            }
            super.visitInsn(95);
            FrameNode fn2 = this.getCurrentFrameNode();
            super.visitJumpInsn(167, done);
            super.visitLabel(isNull);
            this.acceptFn(fn);
            super.visitInsn(1);
            super.visitInsn(95);
            super.visitLabel(done);
            this.acceptFn(fn2);
        } else if (arrayType.getDimensions() == 3) {
            FrameNode fn = this.getCurrentFrameNode();
            super.visitInsn(89);
            super.visitInsn(203);
            super.visitJumpInsn(198, isNull);
            super.visitInsn(203);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitInsn(190);
            super.visitMultiANewArrayInsn("[[[I", 1);
            super.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create3DTaintArray", "(Ljava/lang/Object;[[[I)[[[I", false);
            if (!(Configuration.taintTagFactory instanceof DataAndControlFlowTagFactory)) {
                super.visitInsn(89);
                super.visitInsn(6);
                super.visitMethodInsn(185, Type.getInternalName(TaintTagFactory.class), "generateEmptyTaintArray", "([Ljava/lang/Object;I)V", false);
            }
            super.visitInsn(95);
            FrameNode fn2 = this.getCurrentFrameNode();
            super.visitJumpInsn(167, done);
            super.visitLabel(isNull);
            this.acceptFn(fn);
            super.visitInsn(1);
            super.visitInsn(95);
            super.visitLabel(done);
            this.acceptFn(fn2);
        } else if (arrayType.getDimensions() == 1) {
            FrameNode fn = this.getCurrentFrameNode();
            super.visitInsn(89);
            super.visitInsn(203);
            super.visitJumpInsn(198, isNull);
            super.visitInsn(203);
            Type wrapType = MultiDTaintedArray.getTypeForType(arrayType);
            super.visitInsn(89);
            super.visitTypeInsn(187, wrapType.getInternalName());
            super.visitInsn(90);
            super.visitInsn(95);
            super.visitMethodInsn(183, wrapType.getInternalName(), "<init>", "(" + arrayType.getDescriptor() + ")V", false);
            super.visitInsn(95);
            FrameNode fn2 = this.getCurrentFrameNode();
            super.visitJumpInsn(167, done);
            super.visitLabel(isNull);
            this.acceptFn(fn);
            super.visitInsn(1);
            super.visitInsn(95);
            super.visitLabel(done);
            this.acceptFn(fn2);
        } else {
            throw new IllegalStateException("Can't handle casts to multi-d array type of dimension " + arrayType.getDimensions());
        }
    }

    public static Object[] removeLongsDoubleTopVal(List<Object> in) {
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean lastWas2Word = false;
        for (Object n : in) {
            if (n != Opcodes.TOP && (!(n instanceof TaggedValue) || ((TaggedValue)n).v != Opcodes.TOP) || !lastWas2Word) {
                ret.add(n);
            }
            if (n == Opcodes.DOUBLE || n == Opcodes.LONG || n instanceof TaggedValue && (((TaggedValue)n).v == Opcodes.DOUBLE || ((TaggedValue)n).v == Opcodes.LONG)) {
                lastWas2Word = true;
                continue;
            }
            lastWas2Word = false;
        }
        return ret.toArray();
    }

    static int[][][] foo(int[][][] in) {
        int[][][] ret = new int[in.length][][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new int[in[i].length][];
            for (int j = 0; j < ret[i].length; ++j) {
                ret[i][j] = new int[in[i][j].length];
            }
        }
        return ret;
    }

    static int[][] foo(int[][] in) {
        int[][] ret = new int[in.length][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new int[in[i].length];
        }
        return ret;
    }

    public static void createNewTaintArray(String arrayDesc, NeverNullArgAnalyzerAdapter analyzer, MethodVisitor mv, LocalVariableManager lvs) {
        Type arrayType = Type.getType(arrayDesc);
        Label isNull = new Label();
        Label done = new Label();
        Object[] locals1 = TaintAdapter.removeLongsDoubleTopVal(analyzer.locals);
        int localSize1 = locals1.length;
        Object[] stack1 = TaintAdapter.removeLongsDoubleTopVal(analyzer.stack);
        int stackSize1 = stack1.length;
        mv.visitInsn(89);
        mv.visitJumpInsn(198, isNull);
        if (arrayType.getDimensions() == 2) {
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitInsn(190);
            Type toUse = MultiDTaintedArray.getTypeForType(arrayType);
            if (toUse.getSort() == 9) {
                toUse = toUse.getElementType();
            }
            mv.visitMultiANewArrayInsn(toUse.getDescriptor(), 1);
            if (Configuration.MULTI_TAINTING) {
                mv.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create2DTaintArray", "(Ljava/lang/Object;[[Ljava/lang/Object;)[[Ljava/lang/Object;", false);
            } else {
                mv.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create2DTaintArray", "(Ljava/lang/Object;[[I)[[I", false);
            }
            mv.visitInsn(95);
        } else if (arrayType.getDimensions() == 3) {
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitInsn(190);
            Type toUse = MultiDTaintedArray.getTypeForType(arrayType);
            if (toUse.getSort() == 9) {
                toUse = toUse.getElementType();
            }
            mv.visitMultiANewArrayInsn("[" + toUse.getDescriptor(), 1);
            if (Configuration.MULTI_TAINTING) {
                mv.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create3DTaintArray", "(Ljava/lang/Object;[[[Ljava/lang/Object;)[[[Ljava/lang/Object;", false);
            } else {
                mv.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create3DTaintArray", "(Ljava/lang/Object;[[[I)[[[I", false);
            }
            mv.visitInsn(95);
        } else if (arrayType.getDimensions() > 1) {
            int tmp = lvs.getTmpLV(arrayType);
            mv.visitInsn(89);
            mv.visitVarInsn(58, tmp);
            for (int i = 0; i < arrayType.getDimensions(); ++i) {
                mv.visitVarInsn(25, tmp);
                for (int j = 0; j < i; ++j) {
                    mv.visitInsn(3);
                    mv.visitInsn(50);
                }
                mv.visitInsn(190);
            }
            mv.visitMultiANewArrayInsn(arrayDesc.substring(0, arrayDesc.length() - 1) + Configuration.TAINT_TAG_DESC, arrayType.getDimensions());
        } else {
            String shadowDesc = TaintUtils.getShadowTaintType(arrayDesc);
            mv.visitInsn(89);
            mv.visitTypeInsn(187, shadowDesc.substring(1, shadowDesc.length() - 1));
            mv.visitInsn(90);
            mv.visitInsn(95);
            mv.visitMethodInsn(183, shadowDesc.substring(1, shadowDesc.length() - 1), "<init>", "(" + arrayDesc + ")V", false);
            mv.visitInsn(95);
        }
        Object[] locals = TaintAdapter.removeLongsDoubleTopVal(analyzer.locals);
        int localSize = locals.length;
        Object[] stack = TaintAdapter.removeLongsDoubleTopVal(analyzer.stack);
        int stackSize = stack.length;
        mv.visitJumpInsn(167, done);
        mv.visitFrame(201, localSize1, locals1, stackSize1, stack1);
        mv.visitLabel(isNull);
        mv.visitInsn(1);
        mv.visitInsn(95);
        mv.visitLabel(done);
        mv.visitFrame(201, localSize, locals, stackSize, stack);
    }

    public static Type getTypeForStackType(Object obj) {
        if (obj instanceof TaggedValue) {
            obj = ((TaggedValue)obj).v;
        }
        if (obj == Opcodes.INTEGER) {
            return Type.INT_TYPE;
        }
        if (obj == Opcodes.FLOAT) {
            return Type.FLOAT_TYPE;
        }
        if (obj == Opcodes.DOUBLE) {
            return Type.DOUBLE_TYPE;
        }
        if (obj == Opcodes.LONG) {
            return Type.LONG_TYPE;
        }
        if (obj == Opcodes.NULL) {
            return Type.getType("Ljava/lang/Object;");
        }
        if (obj instanceof String) {
            return Type.getObjectType((String)obj);
        }
        if (obj instanceof Label || obj == Opcodes.UNINITIALIZED_THIS) {
            return Type.getType("Luninitialized;");
        }
        throw new IllegalArgumentException("got " + obj + " zzz" + obj.getClass());
    }

    public static boolean isPrimitiveStackType(Object obj) {
        if (obj instanceof String) {
            Type t;
            return ((String)obj).startsWith("[") && (t = Type.getType((String)obj)).getSort() == 9 && t.getElementType().getSort() != 10 && t.getDimensions() == 1;
        }
        return obj == Opcodes.INTEGER || obj == Opcodes.FLOAT || obj == Opcodes.DOUBLE || obj == Opcodes.LONG || obj == Opcodes.TOP;
    }

    public static boolean isPrimitiveType(Type t) {
        if (t == null) {
            return false;
        }
        switch (t.getSort()) {
            case 9: {
                return t.getElementType().getSort() != 10 && t.getDimensions() == 1;
            }
            case 0: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static int getStackElementSize(Object obj) {
        if (obj instanceof TaggedValue) {
            obj = ((TaggedValue)obj).v;
        }
        if (obj == Opcodes.DOUBLE || obj == Opcodes.LONG || obj == Opcodes.TOP) {
            return 2;
        }
        return 1;
    }

    protected void freeLVs(LocalVariableNode[] lvArray) {
        for (LocalVariableNode n : lvArray) {
            this.lvs.freeTmpLV(n.index);
        }
    }

    protected void loadLV(int n, LocalVariableNode[] lvArray) {
        super.visitVarInsn(Type.getType(lvArray[n].desc).getOpcode(21), lvArray[n].index);
        if (lvArray[n].signature != null && lvArray[n].signature.equals("true")) {
            this.analyzer.setTopOfStackTagged();
        }
    }

    protected void DUPN_XU(int n, int u) {
        block0 : switch (n) {
            case 1: {
                switch (u) {
                    case 1: {
                        super.visitInsn(90);
                        break block0;
                    }
                    case 2: {
                        super.visitInsn(91);
                        break block0;
                    }
                    case 3: {
                        LocalVariableNode[] d = this.storeToLocals(4);
                        this.loadLV(0, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 4: {
                        LocalVariableNode[] d = this.storeToLocals(5);
                        this.loadLV(0, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 5: {
                        LocalVariableNode[] d = this.storeToLocals(6);
                        this.loadLV(0, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DUP" + n + "_" + u + " is unimp.");
            }
            case 2: {
                switch (u) {
                    case 1: {
                        LocalVariableNode[] d = this.storeToLocals(3);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 2: {
                        LocalVariableNode[] d = this.storeToLocals(4);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 3: {
                        LocalVariableNode[] d = this.storeToLocals(5);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 4: {
                        LocalVariableNode[] d = this.storeToLocals(6);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DUP" + n + "_" + u + " is unimp.");
            }
            case 3: {
                switch (u) {
                    case 0: {
                        LocalVariableNode[] d = this.storeToLocals(3);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 1: {
                        LocalVariableNode[] d = this.storeToLocals(4);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 2: {
                        LocalVariableNode[] d = this.storeToLocals(5);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 3: {
                        LocalVariableNode[] d = this.storeToLocals(6);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 4: {
                        LocalVariableNode[] d = this.storeToLocals(7);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(6, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DUP" + n + "_" + u + " is unimp.");
            }
            case 4: {
                switch (u) {
                    case 1: {
                        LocalVariableNode[] d = this.storeToLocals(5);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 2: {
                        LocalVariableNode[] d = this.storeToLocals(6);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 3: {
                        LocalVariableNode[] d = this.storeToLocals(7);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(6, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                    case 4: {
                        LocalVariableNode[] d = this.storeToLocals(8);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.loadLV(7, d);
                        this.loadLV(6, d);
                        this.loadLV(5, d);
                        this.loadLV(4, d);
                        this.loadLV(3, d);
                        this.loadLV(2, d);
                        this.loadLV(1, d);
                        this.loadLV(0, d);
                        this.freeLVs(d);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DUP" + n + "_" + u + " is unimp.");
            }
            default: {
                throw new IllegalArgumentException("DUP" + n + "_" + u + " is unimp.");
            }
        }
    }

    private static Object[] asArray(List<Object> l) {
        Object[] objs = new Object[l.size()];
        for (int i = 0; i < objs.length; ++i) {
            Object o = l.get(i);
            if (o instanceof LabelNode) {
                o = ((LabelNode)o).getLabel();
            }
            objs[i] = o;
        }
        return objs;
    }

    public void acceptFn(FrameNode fn) {
        TaintAdapter.acceptFn(fn, this.mv);
    }

    public static void acceptFn(FrameNode fn, MethodVisitor mv) {
        switch (fn.type) {
            case -1: 
            case 0: 
            case 201: {
                mv.visitFrame(fn.type, fn.local.size(), TaintAdapter.asArray(fn.local), fn.stack.size(), TaintAdapter.asArray(fn.stack));
                break;
            }
            case 1: {
                mv.visitFrame(fn.type, fn.local.size(), TaintAdapter.asArray(fn.local), 0, null);
                break;
            }
            case 2: {
                mv.visitFrame(fn.type, fn.local.size(), null, 0, null);
                break;
            }
            case 3: {
                mv.visitFrame(fn.type, 0, null, 0, null);
                break;
            }
            case 4: {
                mv.visitFrame(fn.type, 0, null, 1, TaintAdapter.asArray(fn.stack));
            }
        }
    }

    public FrameNode getCurrentFrameNode() {
        return TaintAdapter.getCurrentFrameNode(this.analyzer);
    }

    public static FrameNode getCurrentFrameNode(NeverNullArgAnalyzerAdapter a) {
        if (a.locals == null || a.stack == null) {
            throw new IllegalArgumentException();
        }
        Object[] locals = TaintAdapter.removeLongsDoubleTopVal(a.locals);
        Object[] stack = TaintAdapter.removeLongsDoubleTopVal(a.stackTagStatus);
        FrameNode ret = new FrameNode(-1, locals.length, locals, stack.length, stack);
        ret.type = 201;
        return ret;
    }

    protected LocalVariableNode[] storeToLocals(int n) {
        LocalVariableNode[] ret = new LocalVariableNode[n];
        for (int i = 0; i < n; ++i) {
            Type elType = null;
            elType = this.analyzer.stack.get(this.analyzer.stack.size() - 1) == Opcodes.TOP ? TaintAdapter.getTypeForStackType(this.analyzer.stack.get(this.analyzer.stack.size() - 2)) : TaintAdapter.getTypeForStackType(this.analyzer.stack.get(this.analyzer.stack.size() - 1));
            Boolean istagged = this.topCarriesTaint();
            ret[i] = new LocalVariableNode(null, elType.getDescriptor(), istagged.toString(), null, null, this.lvs.getTmpLV());
            super.visitVarInsn(elType.getOpcode(54), ret[i].index);
        }
        return ret;
    }

    public void unwrapTaintedInt() {
        super.visitInsn(89);
        this.getTaintFieldOfBoxedType(Configuration.TAINTED_INT_INTERNAL_NAME);
        super.visitInsn(95);
        super.visitFieldInsn(180, Configuration.TAINTED_INT_INTERNAL_NAME, "val", "I");
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            super.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            super.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            super.visitIntInsn(17, value);
        } else {
            super.visitLdcInsn(value);
        }
    }
}

