/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.Instrumenter;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import java.util.HashSet;

public class StringTaintVerifyingMV
extends MethodVisitor
implements Opcodes {
    boolean implementsSerializable;
    NeverNullArgAnalyzerAdapter analyzer;
    HashSet<String> checkedThisFrame = new HashSet();
    private boolean nextLoadIsTainted = false;

    public StringTaintVerifyingMV(MethodVisitor mv, boolean implementsSerializable, NeverNullArgAnalyzerAdapter analyzer) {
        super(Configuration.ASM_VERSION, mv);
        this.analyzer = analyzer;
        this.implementsSerializable = implementsSerializable;
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.checkedThisFrame = new HashSet();
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 204) {
            this.nextLoadIsTainted = true;
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.nextLoadIsTainted = false;
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.nextLoadIsTainted = false;
        super.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.nextLoadIsTainted = false;
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.nextLoadIsTainted = false;
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.nextLoadIsTainted = false;
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.nextLoadIsTainted = false;
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        Type t = Type.getType(desc);
        if (this.nextLoadIsTainted && opcode == 180 && !Instrumenter.isIgnoredClass(owner) && t.getSort() == 9 && !name.endsWith("PHOSPHOR_TAG") && !name.equals("taint") && t.getElementType().getSort() != 10 && t.getDimensions() == 1 && !this.checkedThisFrame.contains(owner + "." + name) && (owner.equals("java/lang/String") || this.implementsSerializable || owner.equals("java/io/BufferedInputStream") || owner.startsWith("java/lang/reflect"))) {
            this.nextLoadIsTainted = false;
            super.visitInsn(95);
            super.visitInsn(87);
            Label isOK = new Label();
            FrameNode fn1 = TaintAdapter.getCurrentFrameNode(this.analyzer);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitJumpInsn(198, isOK);
            super.visitInsn(89);
            String shadowDesc = TaintUtils.getShadowTaintType(desc);
            String shadowObj = Type.getType(shadowDesc).getInternalName();
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", shadowDesc);
            super.visitJumpInsn(199, isOK);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitTypeInsn(187, shadowObj);
            super.visitInsn(90);
            super.visitInsn(95);
            super.visitMethodInsn(183, shadowObj, "<init>", "(" + desc + ")V", false);
            super.visitFieldInsn(181, owner, name + "PHOSPHOR_TAG", shadowDesc);
            super.visitLabel(isOK);
            TaintAdapter.acceptFn(fn1, this);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", shadowDesc);
            super.visitInsn(95);
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (!(opcode != 180 || Instrumenter.isIgnoredClass(owner) || t.getSort() != 9 || name.endsWith("PHOSPHOR_TAG") || name.equals("taint") || t.getElementType().getSort() == 10 || t.getDimensions() != 2 || this.checkedThisFrame.contains(owner + "." + name))) {
            super.visitInsn(95);
            super.visitInsn(87);
            Label isOK = new Label();
            Label doInit = new Label();
            FrameNode fn1 = TaintAdapter.getCurrentFrameNode(this.analyzer);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitJumpInsn(198, isOK);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", "[[I");
            super.visitJumpInsn(198, doInit);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitInsn(190);
            super.visitInsn(95);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", "[[I");
            super.visitInsn(190);
            super.visitJumpInsn(164, isOK);
            super.visitLabel(doInit);
            TaintAdapter.acceptFn(fn1, this);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitInsn(89);
            super.visitInsn(190);
            super.visitMultiANewArrayInsn("[[I", 1);
            super.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create2DTaintArray", "(Ljava/lang/Object;[[I)[[I", false);
            super.visitFieldInsn(181, owner, name + "PHOSPHOR_TAG", "[[I");
            super.visitLabel(isOK);
            TaintAdapter.acceptFn(fn1, this);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", "[[I");
            super.visitInsn(95);
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        if (!(opcode != 180 || Instrumenter.isIgnoredClass(owner) || t.getSort() != 9 || name.endsWith("PHOSPHOR_TAG") || name.equals("taint") || t.getElementType().getSort() == 10 || t.getDimensions() != 3 || this.checkedThisFrame.contains(owner + "." + name))) {
            super.visitInsn(95);
            super.visitInsn(87);
            Label isOK = new Label();
            Label doInit = new Label();
            FrameNode fn1 = TaintAdapter.getCurrentFrameNode(this.analyzer);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitJumpInsn(198, isOK);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", "[[[I");
            super.visitJumpInsn(198, doInit);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitInsn(190);
            super.visitInsn(95);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", "[[[I");
            super.visitInsn(190);
            super.visitJumpInsn(164, isOK);
            super.visitLabel(doInit);
            TaintAdapter.acceptFn(fn1, this);
            super.visitInsn(89);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name, desc);
            super.visitInsn(89);
            super.visitInsn(190);
            super.visitMultiANewArrayInsn("[[[I", 1);
            super.visitMethodInsn(184, Type.getInternalName(TaintUtils.class), "create3DTaintArray", "(Ljava/lang/Object;[[[I)[[[I", false);
            super.visitFieldInsn(181, owner, name + "PHOSPHOR_TAG", "[[[I");
            super.visitLabel(isOK);
            TaintAdapter.acceptFn(fn1, this);
            super.visitInsn(89);
            super.visitFieldInsn(opcode, owner, name + "PHOSPHOR_TAG", "[[[I");
            super.visitInsn(95);
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }
}

