/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.instrumenter.LocalVariableManager;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.TaggedValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.multid.MultiDTaintedArray;

public class SpecialOpcodeRemovingMV
extends MethodVisitor {
    private boolean ignoreFrames;
    private String clazz;
    private boolean fixLdcClass;
    private LocalVariableManager lvs;
    private int localIdxOfControlTag;

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode < 200) {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void setLVS(LocalVariableManager lvs) {
        this.lvs = lvs;
    }

    public SpecialOpcodeRemovingMV(MethodVisitor sup, boolean ignoreFrames, int acc, String clazz, String desc, boolean fixLdcClass) {
        super(Configuration.ASM_VERSION, sup);
        this.ignoreFrames = ignoreFrames;
        this.clazz = clazz;
        this.fixLdcClass = fixLdcClass;
        int n = 0;
        if ((acc & 8) == 0) {
            ++n;
        }
        for (Type t : Type.getArgumentTypes(desc)) {
            if (t.getDescriptor().equals(Type.getDescriptor(ControlTaintTagStack.class))) {
                this.localIdxOfControlTag = n;
            }
            n += t.getSize();
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        switch (opcode) {
            case 203: 
            case 210: 
            case 214: 
            case 215: 
            case 216: {
                break;
            }
            default: {
                super.visitVarInsn(opcode, var);
            }
        }
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        Type descType = Type.getType(desc);
        if (descType.getSort() == 9 && descType.getDimensions() > 1 && descType.getElementType().getSort() != 10) {
            desc = MultiDTaintedArray.getTypeForType(descType).getDescriptor();
        }
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (opcode > 200) {
            return;
        }
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        int i;
        if (type == 201) {
            type = -1;
        }
        Object[] newLocal = new Object[local.length];
        Object[] newStack = new Object[stack.length];
        for (i = 0; i < local.length; ++i) {
            newLocal[i] = local[i] instanceof TaggedValue ? ((TaggedValue)local[i]).v : local[i];
        }
        for (i = 0; i < stack.length; ++i) {
            newStack[i] = stack[i] instanceof TaggedValue ? ((TaggedValue)stack[i]).v : stack[i];
        }
        super.visitFrame(type, nLocal, newLocal, nStack, newStack);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type && this.fixLdcClass) {
            super.visitLdcInsn(((Type)cst).getInternalName().replace("/", "."));
            if (Configuration.IMPLICIT_TRACKING) {
                super.visitInsn(1);
            }
            super.visitInsn(3);
            super.visitLdcInsn(this.clazz.replace("/", "."));
            if (Configuration.IMPLICIT_TRACKING) {
                if (this.localIdxOfControlTag < 0) {
                    this.localIdxOfControlTag = this.lvs.idxOfMasterControlLV;
                }
                super.visitVarInsn(25, this.localIdxOfControlTag);
                super.visitMethodInsn(184, "java/lang/Class", "forName$$PHOSPHORTAGGED", "(Ljava/lang/String;Ledu/columbia/cs/psl/phosphor/struct/ControlTaintTagStack;)Ljava/lang/Class;", false);
                super.visitVarInsn(25, this.localIdxOfControlTag);
                super.visitMethodInsn(182, "java/lang/Class", "getClassLoader$$PHOSPHORTAGGED", "(Ledu/columbia/cs/psl/phosphor/struct/ControlTaintTagStack;)Ljava/lang/ClassLoader;", false);
                super.visitVarInsn(25, this.localIdxOfControlTag);
                super.visitMethodInsn(184, "java/lang/Class", "forName$$PHOSPHORTAGGED", "(Ljava/lang/String;" + Configuration.TAINT_TAG_DESC + "ZLjava/lang/ClassLoader;Ledu/columbia/cs/psl/phosphor/struct/ControlTaintTagStack;)Ljava/lang/Class;", false);
            } else {
                super.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
                super.visitMethodInsn(182, "java/lang/Class", "getClassLoader", "()Ljava/lang/ClassLoader;", false);
                super.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", false);
            }
        } else {
            super.visitLdcInsn(cst);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 211: 
            case 213: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: {
                break;
            }
            default: {
                super.visitInsn(opcode);
            }
        }
    }
}

