/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.SourceSinkManager;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;

public class SourceTaintingMV
extends MethodVisitor
implements Opcodes {
    private static final SourceSinkManager sourceSinkManager = BasicSourceSinkManager.getInstance();
    private final String desc;
    private final Type origReturnType;
    private final boolean isStatic;
    private final Object lbl;
    private final String actualSource;

    public SourceTaintingMV(MethodVisitor mv, int access, String owner, String name, String desc) {
        super(Configuration.ASM_VERSION, mv);
        this.desc = desc;
        this.origReturnType = Type.getReturnType(SourceSinkManager.remapMethodDescToRemoveTaints(desc));
        this.isStatic = (access & 8) != 0;
        this.lbl = sourceSinkManager.getLabel(owner, name, desc);
        this.actualSource = SourceSinkManager.getOriginalMethodSignature(owner, name, desc);
    }

    private void callAutoTaint(int argIndex, String internalName) {
        super.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
        super.visitInsn(95);
        super.visitLdcInsn(this.lbl);
        super.visitLdcInsn(this.actualSource);
        super.visitIntInsn(16, argIndex);
        super.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "autoTaint", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/Object;", false);
        super.visitTypeInsn(192, internalName);
    }

    private void autoTaintArguments() {
        Type[] args = Type.getArgumentTypes(this.desc);
        int idx = this.isStatic ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].getSort() == 10 || args[i].getSort() == 9 && args[i].getElementType().getSort() == 10) {
                super.visitVarInsn(25, idx);
                this.callAutoTaint(i, args[i].getInternalName());
                super.visitVarInsn(58, idx);
            }
            idx += args[i].getSize();
        }
    }

    @Override
    public void visitCode() {
        super.visitCode();
        if (Configuration.MULTI_TAINTING) {
            this.autoTaintArguments();
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (Configuration.MULTI_TAINTING) {
            if (TaintUtils.isReturnOpcode(opcode)) {
                this.autoTaintArguments();
            }
            if (opcode == 176) {
                Type boxedReturnType = Type.getReturnType(this.desc);
                if (this.origReturnType.getSort() != 0) {
                    this.callAutoTaint(-1, boxedReturnType.getInternalName());
                }
            }
        }
        super.visitInsn(opcode);
    }
}

