/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.SinkTaintingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.SourceTaintingMV;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintThroughTaintingMV;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.ClassVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodNode;

public class SourceSinkTaintingClassVisitor
extends ClassVisitor {
    private String className;

    public SourceSinkTaintingClassVisitor(ClassVisitor cv) {
        super(Configuration.ASM_VERSION, cv);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x100) == 0 && (name.contains("$$PHOSPHORTAGGED") || TaintUtils.containsTaintSentinel(desc)) || !SourceSinkTaintingClassVisitor.containsPrimitiveType(desc) && !Configuration.IMPLICIT_TRACKING) {
            if (BasicSourceSinkManager.getInstance().isSink(this.className, name, desc)) {
                final SinkTaintingMV sinkMV = new SinkTaintingMV(mv, access, this.className, name, desc);
                mv = new MethodNode(Configuration.ASM_VERSION, access, name, desc, signature, exceptions){

                    @Override
                    public void visitEnd() {
                        super.visitEnd();
                        sinkMV.setNumberOfTryCatchBlocks(this.tryCatchBlocks.size());
                        this.accept(sinkMV);
                    }
                };
            }
            if (BasicSourceSinkManager.getInstance().isSource(this.className, name, desc)) {
                mv = new SourceTaintingMV(mv, access, this.className, name, desc);
            }
            if (BasicSourceSinkManager.getInstance().isTaintThrough(this.className, name, desc) && (access & 8) == 0) {
                mv = new TaintThroughTaintingMV(mv, access, this.className, name, desc);
            }
        }
        return mv;
    }

    public static boolean isPrimitive(Type t) {
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 9: {
                return SourceSinkTaintingClassVisitor.isPrimitive(t.getElementType());
            }
        }
        return false;
    }

    public static boolean containsPrimitiveType(String desc) {
        Type[] types;
        for (Type type : types = Type.getArgumentTypes(desc)) {
            if (!SourceSinkTaintingClassVisitor.isPrimitive(type)) continue;
            return true;
        }
        return false;
    }
}

