/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.BasicSourceSinkManager;
import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.SourceSinkManager;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.commons.AdviceAdapter;
import edu.columbia.cs.psl.phosphor.runtime.TaintSourceWrapper;

public class SinkTaintingMV
extends AdviceAdapter {
    private final Type[] args;
    private final String baseSink;
    private final String actualSink;
    private final boolean isStatic;
    private int numberOfRemainingTryCatchBlocks = 0;
    private final Label startLabel;
    private final Label endLabel;
    private final boolean skipLastParam;

    public SinkTaintingMV(MethodVisitor mv, int access, String owner, String name, String desc) {
        super(Configuration.ASM_VERSION, mv, access, name, desc);
        Type lastArg;
        this.args = Type.getArgumentTypes(desc);
        this.baseSink = BasicSourceSinkManager.getInstance().getBaseSink(owner, name, desc);
        this.actualSink = SourceSinkManager.getOriginalMethodSignature(owner, name, desc);
        this.isStatic = (access & 8) != 0;
        this.startLabel = new Label();
        this.endLabel = new Label();
        this.skipLastParam = this.args.length > 0 ? TaintUtils.isTaintSentinel(lastArg = this.args[this.args.length - 1]) || lastArg.equals(Type.getReturnType(desc)) && TaintUtils.isTaintedPrimitiveType(lastArg) : false;
    }

    private void callEnteringSink() {
        super.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
        super.visitLdcInsn(this.baseSink);
        super.visitLdcInsn(this.actualSink);
        super.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "enteringSink", "(Ljava/lang/String;Ljava/lang/String;)V", false);
    }

    private void addObject(int arrayIdx, int idx) {
        super.visitInsn(89);
        this.push(arrayIdx);
        super.visitVarInsn(25, idx);
        super.visitInsn(83);
    }

    private void addWrappedPrimitive(int arrayIdx, int tagIdx, int primitiveIdx, Type primitiveType) {
        super.visitInsn(89);
        this.push(arrayIdx);
        Type containerType = TaintUtils.getContainerReturnType(primitiveType);
        super.visitTypeInsn(187, containerType.getInternalName());
        super.visitInsn(89);
        if (Configuration.MULTI_TAINTING) {
            super.visitVarInsn(25, tagIdx);
        } else {
            super.visitVarInsn(21, tagIdx);
        }
        super.visitVarInsn(primitiveType.getOpcode(21), primitiveIdx);
        super.visitMethodInsn(183, containerType.getInternalName(), "<init>", "(" + Configuration.TAINT_TAG_DESC + primitiveType.getDescriptor() + ")V", false);
        super.visitInsn(83);
    }

    private void initializeArgumentArray() {
        int count = this.skipLastParam ? -1 : 0;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].getDescriptor().equals(Configuration.TAINT_TAG_DESC)) {
                ++count;
                ++i;
                continue;
            }
            if (this.args[i].getSort() != 10 && (this.args[i].getSort() != 9 || this.args[i].getElementType().getSort() != 10)) continue;
            ++count;
        }
        super.visitIntInsn(17, count);
        super.visitTypeInsn(189, "java/lang/Object");
    }

    @Override
    protected void onMethodEnter() {
        super.onMethodEnter();
        this.callEnteringSink();
        super.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
        if (this.isStatic) {
            super.visitInsn(1);
        } else {
            this.loadThis();
        }
        this.initializeArgumentArray();
        int arrayIdx = 0;
        int idx = this.isStatic ? 0 : 1;
        for (int i = 0; i < (this.skipLastParam ? this.args.length - 1 : this.args.length); ++i) {
            if (this.args[i].getDescriptor().equals(Configuration.TAINT_TAG_DESC) && i + 1 < this.args.length) {
                this.addWrappedPrimitive(arrayIdx++, idx, idx + this.args[i].getSize(), this.args[i + 1]);
                idx += this.args[i].getSize();
                ++i;
            } else if (this.args[i].getSort() == 10 || this.args[i].getSort() == 9 && this.args[i].getElementType().getSort() == 10) {
                this.addObject(arrayIdx++, idx);
            }
            idx += this.args[i].getSize();
        }
        super.visitLdcInsn(this.baseSink);
        super.visitLdcInsn(this.actualSink);
        super.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "checkTaint", "(Ljava/lang/Object;[Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", false);
        if (this.numberOfRemainingTryCatchBlocks == 0) {
            this.addTryCatchBlockHeader();
        }
    }

    @Override
    protected void onMethodExit(int opcode) {
        this.callExitingSink();
        super.onMethodExit(opcode);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.mark(this.endLabel);
        super.visitFrame(-1, 0, new Object[0], 1, new Object[]{"java/lang/Throwable"});
        super.visitVarInsn(58, 1);
        this.callExitingSink();
        super.visitVarInsn(25, 1);
        super.visitInsn(191);
        super.visitMaxs(maxStack, maxLocals);
    }

    private void callExitingSink() {
        super.visitFieldInsn(178, Type.getInternalName(Configuration.class), "autoTainter", Type.getDescriptor(TaintSourceWrapper.class));
        super.visitLdcInsn(this.baseSink);
        super.visitLdcInsn(this.actualSink);
        super.visitMethodInsn(182, Type.getInternalName(TaintSourceWrapper.class), "exitingSink", "(Ljava/lang/String;Ljava/lang/String;)V", false);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        --this.numberOfRemainingTryCatchBlocks;
        if (this.numberOfRemainingTryCatchBlocks == 0) {
            this.addTryCatchBlockHeader();
        }
    }

    private void addTryCatchBlockHeader() {
        super.visitTryCatchBlock(this.startLabel, this.endLabel, this.endLabel, null);
        super.mark(this.startLabel);
    }

    public void setNumberOfTryCatchBlocks(int num) {
        this.numberOfRemainingTryCatchBlocks = num;
    }
}

