/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.instrumenter.PrimitiveArrayAnalyzer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class SCCAnalyzer {
    PrimitiveArrayAnalyzer.BasicBlock[] graph;
    boolean[] visited;
    Stack<Integer> stack;
    int time;
    int[] lowlink;
    List<List<PrimitiveArrayAnalyzer.BasicBlock>> components;

    public List<List<PrimitiveArrayAnalyzer.BasicBlock>> scc(PrimitiveArrayAnalyzer.BasicBlock[] graph) {
        int n = graph.length;
        this.graph = graph;
        this.visited = new boolean[n];
        this.stack = new Stack();
        this.time = 0;
        this.lowlink = new int[n];
        this.components = new ArrayList<List<PrimitiveArrayAnalyzer.BasicBlock>>();
        for (int u = 0; u < n; ++u) {
            if (this.visited[u]) continue;
            this.dfs(u);
        }
        return this.components;
    }

    void dfs(int u) {
        ++this.time;
        this.visited[u] = true;
        if (this.graph[u] == null) {
            return;
        }
        this.stack.add(u);
        boolean isComponentRoot = true;
        for (PrimitiveArrayAnalyzer.BasicBlock v : this.graph[u].successors) {
            if (!this.visited[v.idx]) {
                this.dfs(v.idx);
            }
            if (this.lowlink[u] <= this.lowlink[v.idx]) continue;
            this.lowlink[u] = this.lowlink[v.idx];
            isComponentRoot = false;
        }
        if (isComponentRoot) {
            int x;
            ArrayList<PrimitiveArrayAnalyzer.BasicBlock> component = new ArrayList<PrimitiveArrayAnalyzer.BasicBlock>();
            do {
                x = this.stack.pop();
                component.add(this.graph[x]);
                this.lowlink[x] = Integer.MAX_VALUE;
            } while (x != u);
            this.components.add(component);
        }
    }
}

