/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.LocalVariableManager;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import edu.columbia.cs.psl.phosphor.runtime.ArrayReflectionMasker;
import edu.columbia.cs.psl.phosphor.runtime.ReflectionMasker;
import edu.columbia.cs.psl.phosphor.runtime.RuntimeReflectionPropogator;
import edu.columbia.cs.psl.phosphor.runtime.RuntimeUnsafePropagator;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;
import edu.columbia.cs.psl.phosphor.struct.MethodInvoke;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedBooleanWithObjTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithIntTag;
import edu.columbia.cs.psl.phosphor.struct.TaintedPrimitiveWithObjTag;

public class ReflectionHidingMV
extends MethodVisitor
implements Opcodes {
    private final String className;
    private final NeverNullArgAnalyzerAdapter analyzer;
    private final String methodName;
    private final boolean disable;
    private final boolean isObjOutputStream;
    private LocalVariableManager lvs;

    public ReflectionHidingMV(MethodVisitor mv, String className, String name, NeverNullArgAnalyzerAdapter analyzer) {
        super(Configuration.ASM_VERSION, mv);
        this.className = className;
        this.analyzer = analyzer;
        this.methodName = name;
        this.disable = ReflectionHidingMV.shouldDisable(className, name);
        this.isObjOutputStream = className.equals("java/io/ObjectOutputStream") && name.startsWith("writeObject0") || className.equals("java/io/InputStream") && name.startsWith("defaultReadFields");
    }

    private static boolean shouldDisable(String className, String methodName) {
        if (className.equals("org/codehaus/groovy/vmplugin/v5/Java5") && methodName.equals("makeInterfaceTypes")) {
            return true;
        }
        return Configuration.TAINT_THROUGH_SERIALIZATION && (className.startsWith("java/io/ObjectStreamClass") || className.equals("java/io/ObjectStreamField"));
    }

    public void setLvs(LocalVariableManager lvs) {
        this.lvs = lvs;
    }

    private void maskMethodInvoke() {
        if (Configuration.IMPLICIT_TRACKING || Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgs", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;" + Type.getDescriptor(ControlTaintTagStack.class) + ")" + Type.getDescriptor(MethodInvoke.class), false);
        } else {
            super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgs", "(Ljava/lang/reflect/Method;Ljava/lang/Object;[Ljava/lang/Object;Z)" + Type.getDescriptor(MethodInvoke.class), false);
        }
        super.visitInsn(89);
        super.visitFieldInsn(180, Type.getInternalName(MethodInvoke.class), "m", "Ljava/lang/reflect/Method;");
        super.visitInsn(95);
        super.visitInsn(89);
        super.visitFieldInsn(180, Type.getInternalName(MethodInvoke.class), "o", "Ljava/lang/Object;");
        super.visitInsn(95);
        super.visitFieldInsn(180, Type.getInternalName(MethodInvoke.class), "a", "[Ljava/lang/Object;");
        if (Configuration.IMPLICIT_TRACKING || Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
            super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
        }
    }

    private void maskConstructorNewInstance() {
        if (Configuration.IMPLICIT_TRACKING || Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
            super.visitInsn(87);
            super.visitInsn(95);
            super.visitInsn(90);
            super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgs", "([Ljava/lang/Object;Ljava/lang/reflect/Constructor;" + Type.getDescriptor(ControlTaintTagStack.class) + ")[Ljava/lang/Object;", false);
            super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
        } else {
            super.visitInsn(95);
            super.visitInsn(90);
            super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "fixAllArgs", "([Ljava/lang/Object;Ljava/lang/reflect/Constructor;Z)[Ljava/lang/Object;", false);
        }
    }

    private void maskGetter(String owner, Type[] args) {
        String desc = String.format("(L%s;Z)L%s;", owner, owner);
        if (args.length == 0) {
            super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", desc, false);
        } else if (args.length == 1) {
            super.visitInsn(95);
            super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", desc, false);
            super.visitInsn(95);
        } else if (args.length == 2) {
            int lv1 = this.lvs.getTmpLV();
            super.visitVarInsn(58, lv1);
            int lv2 = this.lvs.getTmpLV();
            super.visitVarInsn(58, lv2);
            super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getOrigMethod", desc, false);
            super.visitVarInsn(25, lv2);
            super.visitVarInsn(25, lv1);
            this.lvs.freeTmpLV(lv1);
            this.lvs.freeTmpLV(lv2);
        }
    }

    private boolean isUnsafeFieldGetter(int opcode, String owner, String name, Type[] args, String nameWithoutSuffix) {
        if (this.className.equals("sun/misc/Unsafe") || opcode != 182 || !"sun/misc/Unsafe".equals(owner) || !name.endsWith("$$PHOSPHORTAGGED")) {
            return false;
        }
        if (args.length < 1 || !args[0].equals(Type.getType(Object.class))) {
            return false;
        }
        switch (nameWithoutSuffix) {
            case "getBoolean": 
            case "getByte": 
            case "getChar": 
            case "getDouble": 
            case "getFloat": 
            case "getInt": 
            case "getLong": 
            case "getObject": 
            case "getShort": 
            case "getBooleanVolatile": 
            case "getByteVolatile": 
            case "getCharVolatile": 
            case "getDoubleVolatile": 
            case "getFloatVolatile": 
            case "getLongVolatile": 
            case "getIntVolatile": 
            case "getObjectVolatile": 
            case "getShortVolatile": {
                return true;
            }
        }
        return false;
    }

    private void maskUnsafeFieldGetter(Type retType, String nameWithoutSuffix, Type[] args) {
        SinglyLinkedList<Type> argStack = new SinglyLinkedList<Type>();
        for (Type arg : args) {
            argStack.push(arg);
        }
        this.popControlTaintTagStack(argStack);
        if (!TaintUtils.isTaintedPrimitiveType(argStack.peek())) {
            super.visitInsn(1);
            argStack.push(Type.getType(Object.class));
        }
        this.removeOffsetTagAndCastOffset(argStack);
        String name = nameWithoutSuffix.contains("Volatile") ? "getVolatile" : "get";
        super.visitMethodInsn(184, Type.getInternalName(RuntimeUnsafePropagator.class), name, "(Lsun/misc/Unsafe;Ljava/lang/Object;JLjava/lang/Object;)Ljava/lang/Object;", false);
        super.visitTypeInsn(192, retType.getInternalName());
    }

    private boolean isUnsafeFieldSetter(int opcode, String owner, String name, Type[] args, String nameWithoutSuffix) {
        if (this.className.equals("sun/misc/Unsafe") || opcode != 182 || !"sun/misc/Unsafe".equals(owner) || !name.endsWith("$$PHOSPHORTAGGED")) {
            return false;
        }
        if (args.length < 1 || !args[0].equals(Type.getType(Object.class))) {
            return false;
        }
        switch (nameWithoutSuffix) {
            case "putBoolean": 
            case "putByte": 
            case "putChar": 
            case "putDouble": 
            case "putFloat": 
            case "putInt": 
            case "putLong": 
            case "putObject": 
            case "putShort": 
            case "putBooleanVolatile": 
            case "putByteVolatile": 
            case "putCharVolatile": 
            case "putDoubleVolatile": 
            case "putFloatVolatile": 
            case "putIntVolatile": 
            case "putLongVolatile": 
            case "putObjectVolatile": 
            case "putShortVolatile": 
            case "putOrderedInt": 
            case "putOrderedLong": 
            case "putOrderedObject": {
                return true;
            }
        }
        return false;
    }

    private void maskUnsafeFieldSetter(String nameWithoutSuffix, Type[] args) {
        SinglyLinkedList<Type> argStack = new SinglyLinkedList<Type>();
        for (Type arg : args) {
            argStack.push(arg);
        }
        this.popControlTaintTagStack(argStack);
        this.wrapPrimitive(argStack);
        this.removeOffsetTagAndCastOffset(argStack);
        String name = nameWithoutSuffix.contains("Volatile") ? "putVolatile" : (nameWithoutSuffix.contains("Ordered") ? "putOrdered" : "put");
        super.visitMethodInsn(184, Type.getInternalName(RuntimeUnsafePropagator.class), name, "(Lsun/misc/Unsafe;Ljava/lang/Object;JLjava/lang/Object;)V", false);
    }

    private boolean isUnsafeCAS(String owner, String name, String nameWithoutSuffix) {
        if (!"sun/misc/Unsafe".equals(owner) || !name.endsWith("$$PHOSPHORTAGGED") || this.className.equals("sun/misc/Unsafe")) {
            return false;
        }
        return "compareAndSwapInt".equals(nameWithoutSuffix) || "compareAndSwapLong".equals(nameWithoutSuffix) || "compareAndSwapObject".equals(nameWithoutSuffix);
    }

    private void maskUnsafeCAS(Type[] args) {
        SinglyLinkedList<Type> argStack = new SinglyLinkedList<Type>();
        for (Type arg : args) {
            argStack.push(arg);
        }
        this.popControlTaintTagStack(argStack);
        int preallocLV = this.lvs.getTmpLV();
        super.visitVarInsn(58, preallocLV);
        argStack.pop();
        this.wrapPrimitive(argStack);
        int valLV = this.lvs.getTmpLV();
        super.visitVarInsn(58, valLV);
        argStack.pop();
        this.wrapPrimitive(argStack);
        this.removeOffsetTagAndCastOffset(argStack);
        super.visitVarInsn(25, valLV);
        this.lvs.freeTmpLV(valLV);
        super.visitMethodInsn(184, Type.getInternalName(RuntimeUnsafePropagator.class), "compareAndSwap", "(Lsun/misc/Unsafe;Ljava/lang/Object;JLjava/lang/Object;Ljava/lang/Object;)Z", false);
        super.visitVarInsn(25, preallocLV);
        super.visitInsn(95);
        String fieldOwner = Configuration.MULTI_TAINTING ? Type.getInternalName(TaintedBooleanWithObjTag.class) : Type.getInternalName(TaintedBooleanWithIntTag.class);
        super.visitFieldInsn(181, fieldOwner, "val", "Z");
        super.visitVarInsn(25, preallocLV);
        this.lvs.freeTmpLV(preallocLV);
        super.visitInsn(89);
        if (Configuration.MULTI_TAINTING) {
            super.visitInsn(1);
        } else {
            super.visitInsn(3);
        }
        super.visitFieldInsn(181, fieldOwner, "taint", Configuration.TAINT_TAG_DESC);
    }

    private void swap(Type top, Type below) {
        if (top.getSize() == 1) {
            if (below.getSize() == 1) {
                super.visitInsn(95);
            } else {
                super.visitInsn(91);
                super.visitInsn(87);
            }
        } else {
            super.visitInsn(below.getSize() == 1 ? 93 : 94);
            super.visitInsn(88);
        }
    }

    private void popControlTaintTagStack(SinglyLinkedList<Type> argStack) {
        if (!argStack.isEmpty() && argStack.peek().equals(Type.getType(ControlTaintTagStack.class))) {
            super.visitInsn(87);
            argStack.pop();
        } else if (argStack.size() >= 2 && TaintUtils.isTaintedPrimitiveType(argStack.peek())) {
            Type top = argStack.pop();
            if (argStack.peek().equals(Type.getType(ControlTaintTagStack.class))) {
                this.swap(top, argStack.peek());
                super.visitInsn(87);
                argStack.pop();
            }
            argStack.push(top);
        }
    }

    private void wrapPrimitive(SinglyLinkedList<Type> argStack) {
        int sort = argStack.peek().getSort();
        if (sort != 9 && sort != 10) {
            int lv = this.lvs.getTmpLV();
            super.visitVarInsn(argStack.peek().getOpcode(54), lv);
            Type containerType = TaintUtils.getContainerReturnType(argStack.peek());
            super.visitTypeInsn(187, containerType.getInternalName());
            super.visitInsn(90);
            super.visitInsn(90);
            super.visitInsn(87);
            super.visitVarInsn(argStack.peek().getOpcode(21), lv);
            this.lvs.freeTmpLV(lv);
            super.visitMethodInsn(183, containerType.getInternalName(), "<init>", "(" + Configuration.TAINT_TAG_DESC + argStack.peek().getDescriptor() + ")V", false);
            argStack.pop();
            argStack.pop();
            argStack.push(Type.getType(Object.class));
        }
    }

    private void removeOffsetTagAndCastOffset(SinglyLinkedList<Type> argStack) {
        Type top = argStack.pop();
        Type second = argStack.pop();
        this.swap(top, second);
        if (second.getSort() == 5) {
            super.visitInsn(133);
        }
        int lv = this.lvs.getTmpLV();
        super.visitVarInsn(55, lv);
        super.visitInsn(95);
        super.visitInsn(87);
        super.visitVarInsn(22, lv);
        this.lvs.freeTmpLV(lv);
        this.swap(Type.LONG_TYPE, top);
        argStack.pop();
        argStack.push(Type.LONG_TYPE);
        argStack.push(top);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterface) {
        Type[] args = Type.getArgumentTypes(desc);
        String nameWithoutSuffix = name.replace("$$PHOSPHORTAGGED", "");
        Type returnType = Type.getReturnType(desc);
        if (owner.equals("java/lang/Object") && nameWithoutSuffix.equals("getClass") && this.isObjOutputStream) {
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "getClassOOS", "(Ljava/lang/Object;)Ljava/lang/Class;", false);
        } else if ((this.disable || this.className.equals("java/io/ObjectOutputStream") || this.className.equals("java/io/ObjectInputStream")) && owner.equals("java/lang/Class") && !owner.equals(this.className) && name.startsWith("isInstance$$PHOSPHORTAGGED")) {
            String retDesc = "Ledu/columbia/cs/psl/phosphor/struct/TaintedBooleanWith" + (Configuration.MULTI_TAINTING ? "Obj" : "Int") + "Tag;";
            String newDesc = "(Ljava/lang/Class;Ljava/lang/Object;";
            if (Configuration.IMPLICIT_TRACKING || Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
                newDesc = newDesc + Type.getDescriptor(ControlTaintTagStack.class);
            }
            newDesc = newDesc + retDesc + ")" + retDesc;
            super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "isInstance", newDesc, false);
        } else if (this.disable) {
            if (this.methodName.startsWith("setObjFieldValues") && owner.equals("sun/misc/Unsafe") && (name.startsWith("putObject") || name.startsWith("compareAndSwapObject"))) {
                owner = Type.getInternalName(ReflectionMasker.class);
                super.visitMethodInsn(184, owner, name, "(Lsun/misc/Unsafe;" + desc.substring(1), isInterface);
            } else if (this.methodName.startsWith("getObjFieldValues") && owner.equals("sun/misc/Unsafe") && name.startsWith("getObject")) {
                owner = Type.getInternalName(ReflectionMasker.class);
                super.visitMethodInsn(184, owner, name, "(Lsun/misc/Unsafe;" + desc.substring(1), isInterface);
            } else if ((this.methodName.startsWith("getPrimFieldValues") || this.methodName.startsWith("setPrimFieldValues")) && owner.equals("sun/misc/Unsafe") && (name.startsWith("put") || name.startsWith("get"))) {
                name = name + "$$NOUNBOX";
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            }
        } else {
            if ("java/lang/reflect/Method".equals(owner)) {
                if (name.startsWith("invoke")) {
                    this.maskMethodInvoke();
                } else if (name.startsWith("get") && !this.className.equals(owner) && !this.className.startsWith("sun/reflect") && !this.className.startsWith("java/lang/Class")) {
                    this.maskGetter(owner, args);
                }
            } else if ("java/lang/reflect/Constructor".equals(owner)) {
                if (name.startsWith("newInstance")) {
                    this.maskConstructorNewInstance();
                } else if (name.startsWith("get") && !this.className.equals(owner) && !this.className.startsWith("sun/reflect") && !this.className.equals("java/lang/Class")) {
                    this.maskGetter(owner, args);
                }
            } else if ("java/lang/Class".equals(owner)) {
                if (nameWithoutSuffix.equals("getMethod") || nameWithoutSuffix.equals("getDeclaredMethod")) {
                    opcode = 184;
                    owner = Type.getInternalName(ReflectionMasker.class);
                    desc = "(Ljava/lang/Class;" + desc.substring(1);
                    if (!Configuration.IMPLICIT_TRACKING && !Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
                        desc = "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;Z)Ljava/lang/reflect/Method;";
                        super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                    }
                } else if (nameWithoutSuffix.equals("getConstructor") || nameWithoutSuffix.equals("getDeclaredConstructor")) {
                    if (Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
                        super.visitInsn(87);
                    }
                    if (Configuration.IMPLICIT_TRACKING) {
                        super.visitInsn(91);
                        super.visitInsn(87);
                        super.visitInsn(95);
                        super.visitInsn(91);
                        super.visitInsn(95);
                    } else {
                        super.visitInsn(95);
                        super.visitInsn(90);
                        super.visitInsn(95);
                    }
                    super.visitInsn(Configuration.IMPLICIT_TRACKING || Configuration.IMPLICIT_HEADERS_NO_TRACKING ? 4 : 3);
                    super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                    super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "addTypeParams", "(Ljava/lang/Class;[Ljava/lang/Class;ZZ)[Ljava/lang/Class;", false);
                    if (Configuration.IMPLICIT_TRACKING) {
                        super.visitInsn(95);
                    } else if (Configuration.IMPLICIT_HEADERS_NO_TRACKING) {
                        super.visitVarInsn(25, this.lvs.getIdxOfMasterControlLV());
                    }
                }
            }
            if (owner.equals("java/lang/reflect/Array") && !owner.equals(this.className)) {
                owner = Type.getInternalName(ArrayReflectionMasker.class);
            }
            if (owner.equals("java/lang/reflect/Field") && opcode == 182 && (name.equals("get") || name.equals("get$$PHOSPHORTAGGED") || name.equals("set$$PHOSPHORTAGGED") || name.equals("getInt$$PHOSPHORTAGGED") || name.equals("getBoolean$$PHOSPHORTAGGED") || name.equals("getChar$$PHOSPHORTAGGED") || name.equals("getDouble$$PHOSPHORTAGGED") || name.equals("getByte$$PHOSPHORTAGGED") || name.equals("getFloat$$PHOSPHORTAGGED") || name.equals("getLong$$PHOSPHORTAGGED") || name.equals("getShort$$PHOSPHORTAGGED") || name.equals("setAccessible$$PHOSPHORTAGGED") || name.equals("set") || name.equals("setInt$$PHOSPHORTAGGED") || name.equals("setBoolean$$PHOSPHORTAGGED") || name.equals("setChar$$PHOSPHORTAGGED") || name.equals("setDouble$$PHOSPHORTAGGED") || name.equals("setByte$$PHOSPHORTAGGED") || name.equals("setFloat$$PHOSPHORTAGGED") || name.equals("setLong$$PHOSPHORTAGGED") || name.equals("setShort$$PHOSPHORTAGGED") || name.equals("getType") || name.equals("getType$$PHOSPHORTAGGED"))) {
                owner = Type.getInternalName(RuntimeReflectionPropogator.class);
                opcode = 184;
                desc = "(Ljava/lang/reflect/Field;" + desc.substring(1);
                if (name.equals("get")) {
                    desc = "(Ljava/lang/reflect/Field;Ljava/lang/Object;Z)Ljava/lang/Object;";
                    super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                } else if (name.equals("set")) {
                    desc = "(Ljava/lang/reflect/Field;Ljava/lang/Object;Ljava/lang/Object;Z)V";
                    super.visitInsn(Configuration.MULTI_TAINTING ? 4 : 3);
                }
            }
            if (this.isUnsafeFieldGetter(opcode, owner, name, args, nameWithoutSuffix)) {
                this.maskUnsafeFieldGetter(returnType, nameWithoutSuffix, args);
                return;
            }
            if (this.isUnsafeFieldSetter(opcode, owner, name, args, nameWithoutSuffix)) {
                this.maskUnsafeFieldSetter(nameWithoutSuffix, args);
                return;
            }
            if (this.isUnsafeCAS(owner, name, nameWithoutSuffix)) {
                this.maskUnsafeCAS(args);
                return;
            }
            super.visitMethodInsn(opcode, owner, name, desc, isInterface);
            if (owner.equals("java/lang/Class") && desc.endsWith("[Ljava/lang/reflect/Field;") && !this.className.equals("java/lang/Class")) {
                if (!Configuration.WITHOUT_FIELD_HIDING) {
                    super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintFields", "([Ljava/lang/reflect/Field;)[Ljava/lang/reflect/Field;", false);
                }
            } else if (owner.equals("java/lang/Class") && !this.className.equals(owner) && (desc.equals("()[Ljava/lang/reflect/Method;") || desc.equals("(" + Type.getDescriptor(ControlTaintTagStack.class) + ")[Ljava/lang/reflect/Method;"))) {
                super.visitInsn("getMethods".equals(nameWithoutSuffix) ? 3 : 4);
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintMethods", "([Ljava/lang/reflect/Method;Z)[Ljava/lang/reflect/Method;", false);
            } else if (owner.equals("java/lang/Class") && !this.className.equals(owner) && (desc.equals("()[Ljava/lang/reflect/Constructor;") || desc.equals("(" + Type.getDescriptor(ControlTaintTagStack.class) + ")[Ljava/lang/reflect/Constructor;"))) {
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintConstructors", "([Ljava/lang/reflect/Constructor;)[Ljava/lang/reflect/Constructor;", false);
            } else if (owner.equals("java/lang/Class") && name.equals("getInterfaces")) {
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintedInterface", "([Ljava/lang/Class;)[Ljava/lang/Class;", false);
            } else if (owner.equals("java/lang/Throwable") && (name.equals("getOurStackTrace") || name.equals("getStackTrace")) && desc.equals("()[" + Type.getDescriptor(StackTraceElement.class))) {
                String stackTraceElDesc = "[" + Type.getDescriptor(StackTraceElement.class);
                if (this.className.equals("java/lang/Throwable")) {
                    super.visitVarInsn(25, 0);
                    super.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
                } else {
                    super.visitLdcInsn(Type.getObjectType(this.className));
                }
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeExtraStackTraceElements", "(" + stackTraceElDesc + "Ljava/lang/Class;)" + stackTraceElDesc, false);
            } else if (owner.equals("java/lang/Object") && name.equals("getClass") && !this.isObjOutputStream) {
                super.visitMethodInsn(184, Type.getInternalName(ReflectionMasker.class), "removeTaintClass", "(Ljava/lang/Class;)Ljava/lang/Class;", false);
            }
            if ((owner.equals("java/lang/reflect/Method") || owner.equals("java/lang/reflect/Constructor")) && !this.className.equals("java/lang/Class") && (name.equals("invoke") || name.equals("newInstance") || name.equals("invoke$$PHOSPHORTAGGED") || name.equals("newInstance$$PHOSPHORTAGGED"))) {
                FrameNode fn = TaintAdapter.getCurrentFrameNode(this.analyzer);
                fn.type = -1;
                super.visitInsn(89);
                super.visitTypeInsn(193, Type.getInternalName(Configuration.MULTI_TAINTING ? TaintedPrimitiveWithObjTag.class : TaintedPrimitiveWithIntTag.class));
                Label notPrimitive = new Label();
                super.visitJumpInsn(153, notPrimitive);
                FrameNode fn2 = TaintAdapter.getCurrentFrameNode(this.analyzer);
                fn2.type = -1;
                super.visitTypeInsn(192, Type.getInternalName(Configuration.MULTI_TAINTING ? TaintedPrimitiveWithObjTag.class : TaintedPrimitiveWithIntTag.class));
                super.visitMethodInsn(182, Type.getInternalName(Configuration.MULTI_TAINTING ? TaintedPrimitiveWithObjTag.class : TaintedPrimitiveWithIntTag.class), "toPrimitiveType", "()Ljava/lang/Object;", false);
                super.visitLabel(notPrimitive);
                fn2.accept(this);
            }
        }
    }
}

