/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import edu.columbia.cs.psl.phosphor.runtime.TaintSentinel;
import edu.columbia.cs.psl.phosphor.struct.ControlTaintTagStack;

public class PrimitiveBoxingFixer
extends TaintAdapter
implements Opcodes {
    int tmpInt = -1;
    boolean followedByFrame = false;

    public PrimitiveBoxingFixer(int access, String className, String name, String desc, String signature, String[] exceptions, MethodVisitor mv, NeverNullArgAnalyzerAdapter analyzer) {
        super(access, className, name, desc, signature, exceptions, mv, analyzer);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode == 217) {
            this.followedByFrame = true;
        } else if (this.followedByFrame) {
            this.followedByFrame = false;
        }
        super.visitInsn(opcode);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        int nArgs = Type.getArgumentTypes(desc).length;
        boolean argIsStr = false;
        for (Type t : Type.getArgumentTypes(desc)) {
            if (t.getSort() != 10 || !t.getDescriptor().equals("Ljava/lang/String;")) continue;
            argIsStr = true;
        }
        if (Configuration.WITH_ENUM_BY_VAL && opcode == 184 && owner.equals(Type.getInternalName(Enum.class))) {
            super.visitMethodInsn(opcode, Type.getInternalName(TaintUtils.class), "enumValueOf", desc, itfc);
            return;
        }
        if ((owner.equals(Type.getInternalName(Integer.class)) || owner.equals(Type.getInternalName(Long.class)) || owner.equals(Type.getInternalName(Double.class))) && name.equals("valueOf$$PHOSPHORTAGGED") && nArgs == (Configuration.IMPLICIT_TRACKING ? 3 : 2) && !argIsStr) {
            Label makeNew;
            Type argT = Type.getArgumentTypes(desc)[1];
            int argSize = argT.getSize();
            if (argSize == 1) {
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitInsn(87);
                }
                super.visitInsn(95);
                FrameNode fn = this.getCurrentFrameNode();
                super.visitInsn(89);
                makeNew = new Label();
                Label isOK = new Label();
                super.visitJumpInsn(Configuration.MULTI_TAINTING ? 199 : 154, makeNew);
                super.visitInsn(95);
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
                }
                super.visitMethodInsn(opcode, owner, name, desc, itfc);
                super.visitJumpInsn(167, isOK);
                super.visitLabel(makeNew);
                this.acceptFn(fn);
                super.visitInsn(95);
                super.visitTypeInsn(187, owner);
                super.visitInsn(89);
                super.visitInsn(94);
                super.visitInsn(88);
                super.visitInsn(1);
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
                    super.visitInsn(95);
                    super.visitMethodInsn(183, owner, "<init>", "(" + Configuration.TAINT_TAG_DESC + Type.getArgumentTypes(desc)[1].getDescriptor() + Type.getDescriptor(ControlTaintTagStack.class) + Type.getDescriptor(TaintSentinel.class) + ")V", false);
                } else {
                    super.visitMethodInsn(183, owner, "<init>", "(" + Configuration.TAINT_TAG_DESC + Type.getArgumentTypes(desc)[1].getDescriptor() + Type.getDescriptor(TaintSentinel.class) + ")V", false);
                }
                super.visitInsn(89);
                super.visitInsn(89);
                super.visitFieldInsn(180, owner, "valuePHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                super.visitFieldInsn(181, owner, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                FrameNode fn2 = this.getCurrentFrameNode();
                super.visitLabel(isOK);
                if (!this.followedByFrame) {
                    this.acceptFn(fn2);
                }
            } else {
                if (argT.getSort() == 7) {
                    super.visitMethodInsn(184, "edu/columbia/cs/psl/phosphor/runtime/RuntimeBoxUnboxPropogator", "valueOf", desc, false);
                    return;
                }
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitInsn(87);
                }
                super.visitInsn(93);
                super.visitInsn(88);
                FrameNode fn = this.getCurrentFrameNode();
                super.visitInsn(89);
                makeNew = new Label();
                Label isOK = new Label();
                super.visitJumpInsn(Configuration.MULTI_TAINTING ? 199 : 154, makeNew);
                super.visitInsn(91);
                super.visitInsn(87);
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
                }
                super.visitMethodInsn(opcode, owner, name, desc, false);
                super.visitJumpInsn(167, isOK);
                super.visitLabel(makeNew);
                this.acceptFn(fn);
                Type taintType = Type.getType(Configuration.TAINT_TAG_DESC);
                int tmp = this.lvs.getTmpLV(argT);
                int tmpT = this.lvs.getTmpLV(taintType);
                super.visitVarInsn(taintType.getOpcode(54), tmpT);
                super.visitVarInsn(argT.getOpcode(54), tmp);
                super.visitTypeInsn(187, owner);
                super.visitInsn(89);
                super.visitVarInsn(taintType.getOpcode(21), tmpT);
                super.visitVarInsn(argT.getOpcode(21), tmp);
                super.visitInsn(1);
                if (Configuration.IMPLICIT_TRACKING) {
                    super.visitVarInsn(25, this.lvs.idxOfMasterControlLV);
                    super.visitInsn(95);
                    super.visitMethodInsn(183, owner, "<init>", "(" + Configuration.TAINT_TAG_DESC + Type.getArgumentTypes(desc)[1].getDescriptor() + Type.getDescriptor(ControlTaintTagStack.class) + Type.getDescriptor(TaintSentinel.class) + ")V", false);
                } else {
                    super.visitMethodInsn(183, owner, "<init>", "(" + Configuration.TAINT_TAG_DESC + Type.getArgumentTypes(desc)[1].getDescriptor() + Type.getDescriptor(TaintSentinel.class) + ")V", false);
                }
                super.visitInsn(89);
                super.visitInsn(89);
                super.visitFieldInsn(180, owner, "valuePHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                super.visitFieldInsn(181, owner, "PHOSPHOR_TAG", Configuration.TAINT_TAG_DESC);
                this.lvs.freeTmpLV(tmp);
                this.lvs.freeTmpLV(tmpT);
                FrameNode fn2 = this.getCurrentFrameNode();
                super.visitLabel(isOK);
                if (!this.followedByFrame) {
                    this.acceptFn(fn2);
                }
            }
        } else {
            super.visitMethodInsn(opcode, owner, name, desc, itfc);
        }
        if (this.followedByFrame) {
            this.followedByFrame = false;
        }
    }
}

