/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.TaintUtils;
import edu.columbia.cs.psl.phosphor.instrumenter.GraphBasedAnalyzer;
import edu.columbia.cs.psl.phosphor.instrumenter.PhosphorTextifier;
import edu.columbia.cs.psl.phosphor.instrumenter.TaintAdapter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.BasicArrayInterpreter;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.NeverNullArgAnalyzerAdapter;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.MethodVisitor;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Opcodes;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Type;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.AbstractInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FieldInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.FrameNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.IincInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.InsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LabelNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LineNumberNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.LocalVariableNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.MethodNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.TryCatchBlockNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.TypeInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.VarInsnNode;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.Analyzer;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.AnalyzerException;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.BasicValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.Frame;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.tree.analysis.Interpreter;
import edu.columbia.cs.psl.phosphor.struct.Field;
import edu.columbia.cs.psl.phosphor.struct.SinglyLinkedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;

public class PrimitiveArrayAnalyzer
extends MethodVisitor {
    public boolean isEmptyMethod = true;
    static final boolean DEBUG = false;
    public HashSet<Type> wrapperTypesToPreAlloc = new HashSet();
    public int nJumps;
    public MethodNode mn;
    private boolean isImplicitLightTracking;
    NeverNullArgAnalyzerAdapter analyzer;
    public boolean hasFinally;
    public int nTryCatch;
    public int nThrow;
    HashMap<Label, LinkedList<Label>> newLabels = new HashMap();

    private BasicBlock findImmediatePostDominator(BasicBlock block, HashSet<BasicBlock> visited) {
        SinglyLinkedList<BasicBlock> queue = new SinglyLinkedList<BasicBlock>();
        queue.enqueue(block);
        visited.add(block);
        while (!queue.isEmpty()) {
            BasicBlock cur = (BasicBlock)queue.dequeue();
            if (!cur.equals(block) && block.postDominators.contains(cur)) {
                return cur;
            }
            for (BasicBlock successor : cur.successors) {
                if (!visited.add(successor)) continue;
                queue.enqueue(successor);
            }
        }
        return null;
    }

    private boolean isExitInstruction(AbstractInsnNode instruction) {
        switch (instruction.getOpcode()) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    private boolean mightEndBlock(AbstractInsnNode insn) {
        return insn.getType() == 8 || this.isExitInstruction(insn) || insn.getOpcode() == 167;
    }

    static void debug(AbstractInsnNode insn) {
        while (insn != null) {
            if (insn.getType() == 8) {
                System.out.println("LABEL " + ((LabelNode)insn).getLabel());
            }
            if (insn.getOpcode() > 0) {
                if (insn.getOpcode() > PhosphorTextifier.OPCODES.length) {
                    if (insn.getType() == 3) {
                        System.out.println(PhosphorTextifier.TYPE_OR_INT_OPCODES[insn.getOpcode() - 200]);
                    } else {
                        System.out.println(PhosphorTextifier.MORE_OPCODES[insn.getOpcode() - 200]);
                    }
                } else {
                    System.out.println(PhosphorTextifier.OPCODES[insn.getOpcode()]);
                }
            }
            insn = insn.getNext();
        }
    }

    private static boolean isPrimitiveArrayType(BasicValue v) {
        if (v == null || v.getType() == null) {
            return false;
        }
        return v.getType().getSort() == 9 && v.getType().getElementType().getSort() != 10;
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        switch (opcode) {
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("F"));
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("D"));
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("J"));
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("I"));
                break;
            }
            case 46: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("I"));
                break;
            }
            case 51: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("B"));
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("Z"));
                break;
            }
            case 52: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("C"));
                break;
            }
            case 49: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("D"));
                break;
            }
            case 47: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("J"));
                break;
            }
            case 48: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("F"));
                break;
            }
            case 53: {
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("S"));
                break;
            }
            case 146: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("C"));
                break;
            }
            case 145: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("B"));
                break;
            }
            case 135: 
            case 138: 
            case 141: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("D"));
                break;
            }
            case 134: 
            case 137: 
            case 144: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("F"));
                break;
            }
            case 133: 
            case 140: 
            case 143: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("J"));
                break;
            }
            case 147: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("S"));
                break;
            }
            case 136: 
            case 139: 
            case 142: {
                if (!Configuration.PREALLOC_STACK_OPS) break;
                this.wrapperTypesToPreAlloc.add(TaintUtils.getContainerReturnType("I"));
                break;
            }
            case 191: {
                ++this.nThrow;
            }
        }
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itfc) {
        super.visitMethodInsn(opcode, owner, name, desc, itfc);
        Type returnType = Type.getReturnType(desc);
        Type newReturnType = TaintUtils.getContainerReturnType(returnType);
        this.isEmptyMethod = false;
        if (newReturnType != returnType && returnType.getSort() != 9) {
            this.wrapperTypesToPreAlloc.add(newReturnType);
        }
    }

    public PrimitiveArrayAnalyzer(String className, int access, String name, String desc, String signature, String[] exceptions, MethodVisitor cmv, boolean isImplicitLightTracking) {
        super(Configuration.ASM_VERSION);
        this.mn = new PrimitiveArrayAnalyzerMN(access, name, desc, signature, exceptions, className, cmv);
        this.mv = this.mn;
        this.isImplicitLightTracking = isImplicitLightTracking;
    }

    public PrimitiveArrayAnalyzer(Type singleWrapperTypeToAdd) {
        super(Configuration.ASM_VERSION);
        this.mv = new PrimitiveArrayAnalyzerMN(0, null, null, null, null, null, null);
        if (singleWrapperTypeToAdd.getSort() == 10 && singleWrapperTypeToAdd.getInternalName().startsWith("edu/columbia/cs/psl/phosphor/struct/Tainted")) {
            this.wrapperTypesToPreAlloc.add(singleWrapperTypeToAdd);
        }
    }

    public void setAnalyzer(NeverNullArgAnalyzerAdapter preAnalyzer) {
        this.analyzer = preAnalyzer;
    }

    private Label addUniqueLabelFor(Label existing) {
        Label ret = new Label();
        if (!this.newLabels.containsKey(existing)) {
            this.newLabels.put(existing, new LinkedList());
        }
        this.newLabels.get(existing).add(ret);
        return ret;
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        LinkedList<Label> lbls = this.newLabels.remove(label);
        if (lbls != null) {
            for (Label l : lbls) {
                super.visitLabel(l);
            }
        }
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(this.addUniqueLabelFor(start), end, handler, type);
        if (type == null) {
            this.hasFinally = true;
        }
        ++this.nTryCatch;
    }

    static class LVAccess {
        int idx;
        String desc;

        public String toString() {
            return "LVAccess{idx=" + this.idx + ", desc='" + this.desc + '\'' + '}';
        }

        public LVAccess(int idx, String desc) {
            this.idx = idx;
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LVAccess lvAccess = (LVAccess)o;
            return this.idx == lvAccess.idx && Objects.equals(this.desc, lvAccess.desc);
        }

        public int hashCode() {
            return Objects.hash(this.idx, this.desc);
        }

        public VarInsnNode getNewForceCtrlStoreNode() {
            if (this.desc.equals("J") || this.desc.equals("D")) {
                return new VarInsnNode(217, this.idx);
            }
            return new VarInsnNode(216, this.idx);
        }
    }

    static class BasicBlock {
        public BasicBlock handledAt;
        protected int idxOrder;
        public HashSet<BasicBlock> postDominators = new HashSet();
        int idx;
        HashSet<BasicBlock> successorsCompact = new HashSet();
        HashSet<BasicBlock> successors = new HashSet();
        HashSet<BasicBlock> predecessors = new HashSet();
        AbstractInsnNode insn;
        boolean covered;
        boolean visited;
        boolean isTryBlockStart;
        boolean isJump;
        boolean is2ArgJump;
        int ex_count;
        HashSet<String> exceptionsHandled = new HashSet();
        HashSet<String> coveredByTryBlockFor = new HashSet();
        HashSet<BasicBlock> handlerForRegionStartingAt = new HashSet();
        BasicBlock tryBlockEnd;
        HashSet<BasicBlock> resolvedHereBlocks = new HashSet();
        private boolean compactSuccessorsCalculated;
        HashSet<BasicBlock> resolvedBlocks = new HashSet();
        HashSet<BasicBlock> onFalseSideOfJumpFrom = new HashSet();
        HashSet<BasicBlock> onTrueSideOfJumpFrom = new HashSet();
        HashSet<LVAccess> varsWritten = new HashSet();
        HashSet<Field> fieldsWritten = new HashSet();
        HashSet<String> exceptionsThrown = new HashSet();
        HashSet<String> exceptionsThrownTrueSide = new HashSet();
        HashSet<String> exceptionsThrownFalseSide = new HashSet();
        HashSet<LVAccess> varsWrittenTrueSide = new HashSet();
        HashSet<LVAccess> varsWrittenFalseSide = new HashSet();
        HashSet<Field> fieldsWrittenTrueSide = new HashSet();
        HashSet<Field> fieldsWrittenFalseSide = new HashSet();

        BasicBlock() {
        }

        public boolean isInteresting() {
            return this.isJump || this.isTryBlockStart || this.insn instanceof LabelNode;
        }

        public Set<BasicBlock> getSuccessorsOutsideOfRegion(int s, int e, Set<BasicBlock> visited) {
            if (visited.contains(this)) {
                return Collections.emptySet();
            }
            visited.add(this);
            if (this.idx < s || this.idx > e) {
                return Collections.singleton(this);
            }
            HashSet<BasicBlock> ret = new HashSet<BasicBlock>();
            for (BasicBlock suc : this.successors) {
                ret.addAll(suc.getSuccessorsOutsideOfRegion(s, e, visited));
            }
            return ret;
        }

        public AbstractInsnNode getNextNormalBlockAfterGOTO() {
            System.out.println(this + "," + this.successors + " " + this.insn);
            if (this.insn instanceof LineNumberNode) {
                System.out.println("(" + ((LineNumberNode)this.insn).line + ")");
            }
            if (this.insn.getOpcode() == 167) {
                BasicBlock suc = this.successors.iterator().next();
                AbstractInsnNode insn = suc.insn;
                while (insn.getType() == 14 || insn.getType() == 15 || insn.getType() == 8) {
                    insn = insn.getNext();
                }
                return insn;
            }
            if (this.successors.size() > 1) {
                throw new IllegalStateException();
            }
            return this.successors.iterator().next().getNextNormalBlockAfterGOTO();
        }

        public String toString() {
            return "" + this.idx;
        }
    }

    final class PrimitiveArrayAnalyzerMN
    extends MethodNode {
        private final String className;
        private final boolean shouldTrackExceptions;
        private final MethodVisitor cmv;
        boolean[] endsWithGOTO;
        int curLabel;
        HashMap<Integer, Boolean> lvsThatAreArrays;
        ArrayList<FrameNode> inFrames;
        ArrayList<FrameNode> outFrames;
        HashMap<Integer, BasicBlock> implicitAnalysisblocks;

        public PrimitiveArrayAnalyzerMN(int access, String name, String desc, String signature, String[] exceptions, String className, MethodVisitor cmv) {
            super(Configuration.ASM_VERSION, access, name, desc, signature, exceptions);
            this.curLabel = 0;
            this.lvsThatAreArrays = new HashMap();
            this.inFrames = new ArrayList();
            this.outFrames = new ArrayList();
            this.implicitAnalysisblocks = new HashMap();
            this.className = className;
            this.cmv = cmv;
            this.shouldTrackExceptions = Configuration.IMPLICIT_EXCEPTION_FLOW;
        }

        @Override
        protected LabelNode getLabelNode(Label l) {
            if (!Configuration.READ_AND_SAVE_BCI) {
                return super.getLabelNode(l);
            }
            if (!(l.info instanceof LabelNode)) {
                l.info = new LabelNode(l);
            }
            return (LabelNode)l.info;
        }

        @Override
        public void visitCode() {
            Label firstLabel = new Label();
            super.visitCode();
            this.visitLabel(firstLabel);
        }

        private void visitFrameTypes(int n, Object[] types, List<Object> result) {
            for (int i = 0; i < n; ++i) {
                Object type = types[i];
                result.add(type);
                if (type != Opcodes.LONG && type != Opcodes.DOUBLE) continue;
                result.add(Opcodes.TOP);
            }
        }

        FrameNode generateFrameNode(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            FrameNode ret = new FrameNode(type, nLocal, local, nStack, stack);
            ret.local = new ArrayList<Object>();
            ret.stack = new ArrayList<Object>();
            this.visitFrameTypes(nLocal, local, ret.local);
            this.visitFrameTypes(nStack, stack, ret.stack);
            return ret;
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            super.visitFrame(type, nLocal, local, nStack, stack);
            if (this.inFrames.size() == this.curLabel - 1) {
                this.inFrames.add(this.generateFrameNode(type, nLocal, local, nStack, stack));
            } else {
                this.inFrames.set(this.curLabel - 1, this.generateFrameNode(type, nLocal, local, nStack, stack));
            }
        }

        @Override
        public void visitLabel(Label label) {
            if (PrimitiveArrayAnalyzer.this.analyzer.locals == null || PrimitiveArrayAnalyzer.this.analyzer.stack == null) {
                this.inFrames.add(new FrameNode(0, 0, new Object[0], 0, new Object[0]));
            } else {
                this.inFrames.add(new FrameNode(0, PrimitiveArrayAnalyzer.this.analyzer.locals.size(), PrimitiveArrayAnalyzer.this.analyzer.locals.toArray(), PrimitiveArrayAnalyzer.this.analyzer.stack.size(), PrimitiveArrayAnalyzer.this.analyzer.stack.toArray()));
            }
            this.outFrames.add(null);
            if (this.curLabel > 0 && this.outFrames.get(this.curLabel - 1) == null && PrimitiveArrayAnalyzer.this.analyzer.stack != null) {
                this.outFrames.set(this.curLabel - 1, new FrameNode(0, PrimitiveArrayAnalyzer.this.analyzer.locals.size(), PrimitiveArrayAnalyzer.this.analyzer.locals.toArray(), PrimitiveArrayAnalyzer.this.analyzer.stack.size(), PrimitiveArrayAnalyzer.this.analyzer.stack.toArray()));
            }
            super.visitLabel(label);
            ++this.curLabel;
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.outFrames.set(this.curLabel - 1, new FrameNode(0, PrimitiveArrayAnalyzer.this.analyzer.locals.size(), PrimitiveArrayAnalyzer.this.analyzer.locals.toArray(), PrimitiveArrayAnalyzer.this.analyzer.stack.size(), PrimitiveArrayAnalyzer.this.analyzer.stack.toArray()));
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.outFrames.set(this.curLabel - 1, new FrameNode(0, PrimitiveArrayAnalyzer.this.analyzer.locals.size(), PrimitiveArrayAnalyzer.this.analyzer.locals.toArray(), PrimitiveArrayAnalyzer.this.analyzer.stack.size(), PrimitiveArrayAnalyzer.this.analyzer.stack.toArray()));
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitInsn(int opcode) {
            if (opcode == 191 && PrimitiveArrayAnalyzer.this.analyzer.locals != null && PrimitiveArrayAnalyzer.this.analyzer.stack != null) {
                this.outFrames.set(this.curLabel - 1, new FrameNode(0, PrimitiveArrayAnalyzer.this.analyzer.locals.size(), PrimitiveArrayAnalyzer.this.analyzer.locals.toArray(), PrimitiveArrayAnalyzer.this.analyzer.stack.size(), PrimitiveArrayAnalyzer.this.analyzer.stack.toArray()));
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            int nToPop = 0;
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    nToPop = 1;
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    nToPop = 2;
                    break;
                }
                case 167: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            ArrayList<Object> stack = new ArrayList<Object>(PrimitiveArrayAnalyzer.this.analyzer.stack);
            while (nToPop > 0 && !stack.isEmpty()) {
                stack.remove(stack.size() - 1);
                --nToPop;
            }
            this.outFrames.set(this.curLabel - 1, new FrameNode(0, PrimitiveArrayAnalyzer.this.analyzer.locals.size(), PrimitiveArrayAnalyzer.this.analyzer.locals.toArray(), stack.size(), stack.toArray()));
            this.visitLabel(new Label());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitEnd() {
            HashMap neverAutoBoxByFrame = new HashMap();
            final HashMap alwaysAutoBoxByFrame = new HashMap();
            final HashMap outEdges = new HashMap();
            final HashSet insertACHECKCASTBEFORE = new HashSet();
            final HashSet insertACONSTNULLBEFORE = new HashSet();
            Analyzer a = new Analyzer(new BasicArrayInterpreter((this.access & 8) != 0, PrimitiveArrayAnalyzer.this.isImplicitLightTracking)){
                protected int[] insnToLabel;
                HashMap<Integer, LinkedList<Integer>> edges;
                LinkedList<Integer> varsStoredThisInsn;
                HashSet<String> visited;
                int insnIdxOrderVisited;
                {
                    super(x0);
                    this.edges = new HashMap();
                    this.varsStoredThisInsn = new LinkedList();
                    this.visited = new HashSet();
                    this.insnIdxOrderVisited = 0;
                }

                int getLabel(int insn) {
                    int label = -1;
                    for (int j = 0; j <= insn; ++j) {
                        label = this.insnToLabel[j];
                    }
                    return label;
                }

                int getInsnAfterFrameFor(int insn) {
                    int r = 0;
                    for (int i = 0; i < insn; ++i) {
                        if (PrimitiveArrayAnalyzerMN.this.instructions.get(i).getType() != 14) continue;
                        r = i + 1;
                    }
                    return r;
                }

                int getLastInsnByLabel(int label) {
                    int r = 0;
                    for (int j = 0; j < this.insnToLabel.length; ++j) {
                        if (this.insnToLabel[j] != label || PrimitiveArrayAnalyzerMN.this.instructions.get(j).getType() == 14) continue;
                        r = j;
                    }
                    return r;
                }

                int getFirstInsnByLabel(int label) {
                    for (int j = 0; j < this.insnToLabel.length; ++j) {
                        if (this.insnToLabel[j] != label || PrimitiveArrayAnalyzerMN.this.instructions.get(j).getType() == 14 || PrimitiveArrayAnalyzerMN.this.instructions.get(j).getType() == 8 || PrimitiveArrayAnalyzerMN.this.instructions.get(j).getType() == 15) continue;
                        return j;
                    }
                    return -1;
                }

                protected Frame newFrame(int nLocals, int nStack) {
                    return new Frame(nLocals, nStack){

                        public void execute(AbstractInsnNode insn, Interpreter interpreter) throws AnalyzerException {
                            if (insn.getOpcode() > 200) {
                                return;
                            }
                            super.execute(insn, interpreter);
                        }
                    };
                }

                public Frame[] analyze(String owner, MethodNode m) throws AnalyzerException {
                    ListIterator<AbstractInsnNode> insns = m.instructions.iterator();
                    this.insnToLabel = new int[m.instructions.size()];
                    int label = -1;
                    boolean isFirst = true;
                    while (insns.hasNext()) {
                        AbstractInsnNode insn = (AbstractInsnNode)insns.next();
                        int idx = m.instructions.indexOf(insn);
                        if (insn instanceof LabelNode) {
                            ++label;
                        }
                        this.insnToLabel[idx] = isFirst ? 1 : label;
                        isFirst = false;
                    }
                    Frame[] ret = super.analyze(owner, m);
                    if (PrimitiveArrayAnalyzerMN.this.shouldTrackExceptions) {
                        insns = m.instructions.iterator();
                        block5: while (insns.hasNext()) {
                            AbstractInsnNode insn = (AbstractInsnNode)insns.next();
                            int idx = m.instructions.indexOf(insn);
                            if (insn.getOpcode() != 191) continue;
                            for (TryCatchBlockNode each : m.tryCatchBlocks) {
                                try {
                                    Class<?> caught = Class.forName(each.type == null ? "java.lang.Throwable" : each.type.replace('/', '.'), false, PrimitiveArrayAnalyzer.class.getClassLoader());
                                    if (caught == Throwable.class) {
                                        this.newControlFlowEdge(idx, m.instructions.indexOf(each.handler));
                                        continue block5;
                                    }
                                    Class<?> thrown = null;
                                    try {
                                        String onStack = ret[idx].getStack(ret[idx].getStackSize() - 1).toString();
                                        if (!onStack.startsWith("L")) continue;
                                        thrown = Class.forName(Type.getType(ret[idx].getStack(0).toString()).getClassName(), false, PrimitiveArrayAnalyzer.class.getClassLoader());
                                    }
                                    catch (Throwable t) {
                                        continue;
                                    }
                                    if (!caught.isAssignableFrom(thrown)) continue;
                                    this.newControlFlowEdge(idx, m.instructions.indexOf(each.handler));
                                    continue block5;
                                }
                                catch (Throwable throwable) {
                                }
                            }
                        }
                    }
                    for (Map.Entry<Integer, LinkedList<Integer>> edge : this.edges.entrySet()) {
                        Integer successor = edge.getKey();
                        if (edge.getValue().size() <= 1) continue;
                        int labelToSuccessor = this.getLabel(successor);
                        for (Integer toMerge : edge.getValue()) {
                            if (PrimitiveArrayAnalyzerMN.this.shouldTrackExceptions) {
                                BasicBlock b = PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.get(toMerge);
                                if (b.insn.getOpcode() == 191) continue;
                            }
                            int labelToMerge = this.getLabel(toMerge);
                            if (PrimitiveArrayAnalyzerMN.this.inFrames.get(labelToSuccessor) == null || PrimitiveArrayAnalyzerMN.this.outFrames.get(labelToMerge) == null) continue;
                            if (!PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).stack.isEmpty() && !PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).stack.isEmpty()) {
                                Object output1Top = PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).stack.get(PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).stack.size() - 1);
                                Object inputTop = PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).stack.get(PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).stack.size() - 1);
                                if (output1Top == Opcodes.TOP) {
                                    output1Top = PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).stack.get(PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).stack.size() - 2);
                                }
                                if (inputTop == Opcodes.TOP) {
                                    inputTop = PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).stack.get(PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).stack.size() - 2);
                                }
                                if (output1Top != null && output1Top != inputTop) {
                                    Type inputTopType = TaintAdapter.getTypeForStackType(inputTop);
                                    Type outputTopType = TaintAdapter.getTypeForStackType(output1Top);
                                    if (output1Top == Opcodes.NULL && inputTopType.getSort() == 9 && inputTopType.getElementType().getSort() != 10 && inputTopType.getDimensions() == 1) {
                                        insertACONSTNULLBEFORE.add(toMerge);
                                    } else if ((inputTopType.getSort() == 10 || inputTopType.getSort() == 9 && inputTopType.getElementType().getSort() == 10) && outputTopType.getSort() == 9 && outputTopType.getElementType().getSort() != 10 && inputTopType.getDimensions() == 1) {
                                        insertACHECKCASTBEFORE.add(toMerge);
                                    }
                                }
                            }
                            if (PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).local.isEmpty() || PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).local.isEmpty()) continue;
                            for (int i = 0; i < Math.min(PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).local.size(), PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).local.size()); ++i) {
                                Object out = PrimitiveArrayAnalyzerMN.this.outFrames.get((int)labelToMerge).local.get(i);
                                Object in = PrimitiveArrayAnalyzerMN.this.inFrames.get((int)labelToSuccessor).local.get(i);
                                if (!(out instanceof String) || !(in instanceof String)) continue;
                                Type tout = Type.getObjectType((String)out);
                                Type tin = Type.getObjectType((String)in);
                                if (tout.getSort() != 9 || tout.getElementType().getSort() == 10 || tout.getDimensions() != 1 || tin.getSort() != 10) continue;
                                int insnN = this.getLastInsnByLabel(labelToMerge);
                                if (!alwaysAutoBoxByFrame.containsKey(insnN)) {
                                    alwaysAutoBoxByFrame.put(insnN, new LinkedList());
                                }
                                ((LinkedList)alwaysAutoBoxByFrame.get(insnN)).add(i);
                            }
                        }
                    }
                    return ret;
                }

                @Override
                protected boolean newControlFlowExceptionEdge(int insnIndex, int successorIndex) {
                    return true;
                }

                @Override
                protected void newControlFlowEdge(int insn, int successor) {
                    this.newControlFlowEdge(insn, successor, false);
                }

                protected void newControlFlowEdge(int insn, int successor, boolean isExceptionalEdge) {
                    BasicBlock succesorBlock;
                    BasicBlock fromBlock;
                    if (this.visited.contains(insn + "-" + successor)) {
                        return;
                    }
                    this.visited.add(insn + "-" + successor);
                    if (!this.edges.containsKey(successor)) {
                        this.edges.put(successor, new LinkedList());
                    }
                    if (!this.edges.get(successor).contains(insn)) {
                        this.edges.get(successor).add(insn);
                    }
                    if (!outEdges.containsKey(insn)) {
                        outEdges.put(insn, new LinkedList());
                    }
                    if (!((LinkedList)outEdges.get(insn)).contains(successor)) {
                        ((LinkedList)outEdges.get(insn)).add(successor);
                    }
                    if (!PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.containsKey(insn)) {
                        fromBlock = new BasicBlock();
                        fromBlock.idx = insn;
                        fromBlock.insn = PrimitiveArrayAnalyzerMN.this.instructions.get(insn);
                        PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.put(insn, fromBlock);
                    } else {
                        fromBlock = PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.get(insn);
                    }
                    AbstractInsnNode insnN = PrimitiveArrayAnalyzerMN.this.instructions.get(insn);
                    boolean bl = fromBlock.isJump = insnN.getType() == 7 && insnN.getOpcode() != 167 || insnN.getType() == 12 || insnN.getType() == 11;
                    if (fromBlock.isJump && insnN.getType() == 7) {
                        switch (insnN.getOpcode()) {
                            case 159: 
                            case 160: 
                            case 161: 
                            case 162: 
                            case 163: 
                            case 164: 
                            case 165: 
                            case 166: {
                                fromBlock.is2ArgJump = true;
                            }
                        }
                    }
                    if (PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.containsKey(successor)) {
                        succesorBlock = PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.get(successor);
                    } else {
                        succesorBlock = new BasicBlock();
                        succesorBlock.idx = successor;
                        succesorBlock.insn = PrimitiveArrayAnalyzerMN.this.instructions.get(successor);
                        PrimitiveArrayAnalyzerMN.this.implicitAnalysisblocks.put(successor, succesorBlock);
                        if (succesorBlock.insn.getType() == 10) {
                            succesorBlock.varsWritten.add(new LVAccess(((IincInsnNode)succesorBlock.insn).var, "I"));
                        } else if (succesorBlock.insn.getType() == 2) {
                            switch (succesorBlock.insn.getOpcode()) {
                                case 54: {
                                    succesorBlock.varsWritten.add(new LVAccess(((VarInsnNode)succesorBlock.insn).var, "I"));
                                    break;
                                }
                                case 58: {
                                    succesorBlock.varsWritten.add(new LVAccess(((VarInsnNode)succesorBlock.insn).var, "Ljava/lang/Object;"));
                                    break;
                                }
                                case 57: {
                                    succesorBlock.varsWritten.add(new LVAccess(((VarInsnNode)succesorBlock.insn).var, "D"));
                                    break;
                                }
                                case 55: {
                                    succesorBlock.varsWritten.add(new LVAccess(((VarInsnNode)succesorBlock.insn).var, "J"));
                                }
                            }
                        } else if (succesorBlock.insn.getType() == 4) {
                            FieldInsnNode fin = (FieldInsnNode)succesorBlock.insn;
                            if (fin.getOpcode() == 181) {
                                Frame fr = this.getFrames()[successor];
                                if (fr != null && fr.getStack(fr.getStackSize() - 2) == BasicArrayInterpreter.THIS_VALUE) {
                                    succesorBlock.fieldsWritten.add(new Field(false, fin.owner, fin.name, fin.desc));
                                }
                            } else if (fin.getOpcode() == 179) {
                                succesorBlock.fieldsWritten.add(new Field(true, fin.owner, fin.name, fin.desc));
                            }
                        } else if (succesorBlock.insn.getType() == 5) {
                            Frame fr;
                            Type[] desc;
                            MethodInsnNode min = (MethodInsnNode)succesorBlock.insn;
                            if ((min.getOpcode() == 182 || min.getOpcode() == 183) && ((desc = Type.getArgumentTypes(min.desc)).length == 1 && (Type.getReturnType(min.desc).getSort() == 0 || min.desc.equals("Ljava/lang/StringBuilder;")) || desc.length == 2 && Type.getReturnType(min.desc).getSort() == 0 && min.name.startsWith("set")) && (fr = this.getFrames()[successor]) != null && fr.getStack(fr.getStackSize() - 2) instanceof BasicArrayInterpreter.BasicThisFieldValue) {
                                BasicArrayInterpreter.BasicThisFieldValue vv = (BasicArrayInterpreter.BasicThisFieldValue)fr.getStack(fr.getStackSize() - 2);
                                succesorBlock.fieldsWritten.add(vv.getField());
                            }
                        } else if (succesorBlock.insn.getOpcode() == 191) {
                            BasicValue ex = (BasicValue)this.getFrames()[successor].getStack(0);
                            if (PrimitiveArrayAnalyzerMN.this.shouldTrackExceptions && ex != null && ex.getType() != null && (ex.getType().getDescriptor().contains("Exception") || ex.getType().getDescriptor().contains("Error"))) {
                                succesorBlock.exceptionsThrown.add(ex.getType().getInternalName() + "#" + successor);
                            }
                        }
                    }
                    fromBlock.successors.add(succesorBlock);
                    succesorBlock.predecessors.add(fromBlock);
                    if (fromBlock.isJump) {
                        if (fromBlock.covered) {
                            succesorBlock.onTrueSideOfJumpFrom.add(fromBlock);
                        } else {
                            succesorBlock.onFalseSideOfJumpFrom.add(fromBlock);
                            fromBlock.covered = true;
                        }
                    }
                    super.newControlFlowEdge(insn, successor);
                }
            };
            try {
                Frame<V>[] frames = a.analyze(this.className, this);
                for (int i = 0; i < this.instructions.size(); ++i) {
                    if (frames[i] != null) continue;
                    AbstractInsnNode insn = this.instructions.get(i);
                    if (insn.getOpcode() == 191 || insn.getOpcode() == 167 || insn.getOpcode() >= 172 && insn.getOpcode() <= 177) {
                        this.instructions.insertBefore(insn, new InsnNode(191));
                        this.instructions.remove(insn);
                        break;
                    }
                    if (insn instanceof FrameNode) {
                        FrameNode fn = (FrameNode)insn;
                        fn.local = Collections.EMPTY_LIST;
                        fn.stack = Collections.singletonList("java/lang/Throwable");
                        continue;
                    }
                    if (insn instanceof LineNumberNode || insn instanceof LabelNode) continue;
                    this.instructions.insertBefore(insn, new InsnNode(0));
                    this.instructions.remove(insn);
                }
                ArrayList<Object> toAddNullBefore = new ArrayList<Object>();
                toAddNullBefore.addAll(insertACHECKCASTBEFORE);
                toAddNullBefore.addAll(neverAutoBoxByFrame.keySet());
                toAddNullBefore.addAll(alwaysAutoBoxByFrame.keySet());
                Collections.sort(toAddNullBefore);
                HashMap problemLabels = new HashMap();
                HashMap problemVars = new HashMap();
                int nNewNulls = 0;
                for (Integer n : toAddNullBefore) {
                    int j;
                    Iterator iterator;
                    Object insertAfter = this.instructions.get(n + nNewNulls);
                    if (insertACONSTNULLBEFORE.contains(n)) continue;
                    if (insertACHECKCASTBEFORE.contains(n)) {
                        if (((AbstractInsnNode)insertAfter).getOpcode() == 167) {
                            insertAfter = ((AbstractInsnNode)insertAfter).getPrevious();
                        }
                        this.instructions.insert((AbstractInsnNode)insertAfter, new TypeInsnNode(192, Type.getInternalName(Object.class)));
                        ++nNewNulls;
                        continue;
                    }
                    if (neverAutoBoxByFrame.containsKey(n)) {
                        if (((AbstractInsnNode)insertAfter).getOpcode() == 167) {
                            insertAfter = ((AbstractInsnNode)insertAfter).getPrevious();
                        }
                        iterator = ((LinkedList)neverAutoBoxByFrame.get(n)).iterator();
                        while (iterator.hasNext()) {
                            j = (Integer)iterator.next();
                            this.instructions.insert((AbstractInsnNode)insertAfter, new VarInsnNode(209, j));
                            ++nNewNulls;
                        }
                        continue;
                    }
                    if (!alwaysAutoBoxByFrame.containsKey(n)) continue;
                    iterator = ((LinkedList)alwaysAutoBoxByFrame.get(n)).iterator();
                    while (iterator.hasNext()) {
                        void var17_66;
                        j = (Integer)iterator.next();
                        AbstractInsnNode abstractInsnNode = ((AbstractInsnNode)insertAfter).getNext();
                        while (var17_66.getNext() != null && (var17_66.getType() == 8 || var17_66.getType() == 15 || var17_66.getType() == 14 || var17_66.getOpcode() > 200)) {
                            AbstractInsnNode abstractInsnNode2 = var17_66.getNext();
                        }
                        if (var17_66.getOpcode() == 25 && var17_66.getNext().getOpcode() == 195) {
                            insertAfter = var17_66.getNext();
                        }
                        if (var17_66.getType() == 7) {
                            insertAfter = var17_66;
                        }
                        if (((AbstractInsnNode)insertAfter).getType() == 7) {
                            if (((AbstractInsnNode)(insertAfter = ((AbstractInsnNode)insertAfter).getPrevious())).getNext().getOpcode() != 167) {
                                this.instructions.insert((AbstractInsnNode)insertAfter, new VarInsnNode(211, j));
                            } else {
                                this.instructions.insert((AbstractInsnNode)insertAfter, new VarInsnNode(210, j));
                            }
                        } else if (((AbstractInsnNode)insertAfter).getOpcode() == 191) {
                            this.instructions.insertBefore((AbstractInsnNode)var17_66, new VarInsnNode(210, j));
                        } else {
                            this.instructions.insert((AbstractInsnNode)insertAfter, new VarInsnNode(210, j));
                        }
                        ++nNewNulls;
                    }
                }
                boolean hadChanges = true;
                while (hadChanges) {
                    hadChanges = false;
                    HashSet<LocalVariableNode> hashSet = new HashSet<LocalVariableNode>();
                    if (this.localVariables == null) continue;
                    block8: for (Object _lv : this.localVariables) {
                        void var17_71;
                        LocalVariableNode lv = (LocalVariableNode)_lv;
                        LabelNode labelNode = lv.start;
                        LabelNode labelNode2 = lv.end;
                        while (var17_71 != null && var17_71 != lv.end) {
                            if ((var17_71.getOpcode() == 211 || var17_71.getOpcode() == 210) && ((VarInsnNode)var17_71).var == lv.index) {
                                LabelNode labelNode3 = new LabelNode(new Label());
                                LabelNode afterProblem = new LabelNode(new Label());
                                this.instructions.insertBefore((AbstractInsnNode)var17_71, labelNode3);
                                this.instructions.insert(var17_71.getNext(), afterProblem);
                                LocalVariableNode newLV = new LocalVariableNode(lv.name, lv.desc, lv.signature, afterProblem, labelNode2, lv.index);
                                lv.end = labelNode3;
                                hashSet.add(newLV);
                                hadChanges = true;
                                continue block8;
                            }
                            AbstractInsnNode abstractInsnNode = var17_71.getNext();
                        }
                    }
                    this.localVariables.addAll(hashSet);
                }
            }
            catch (Throwable e) {
                System.err.println("While analyzing " + this.className);
                e.printStackTrace();
            }
            if (Configuration.ANNOTATE_LOOPS) {
                GraphBasedAnalyzer.doGraphAnalysis(this, this.implicitAnalysisblocks);
            }
            if (Configuration.IMPLICIT_TRACKING || PrimitiveArrayAnalyzer.this.isImplicitLightTracking) {
                boolean hasJumps = false;
                HashSet<BasicBlock> tryCatchHandlers = new HashSet<BasicBlock>();
                if (this.shouldTrackExceptions && PrimitiveArrayAnalyzer.this.nTryCatch > 0) {
                    int exceptionHandlerCount = 1;
                    hasJumps = true;
                    for (Object o : this.tryCatchBlocks) {
                        void var13_31;
                        TryCatchBlockNode t = (TryCatchBlockNode)o;
                        Object var13_30 = null;
                        BasicBlock handlerBlock = null;
                        BasicBlock endBlock = null;
                        Integer startKey = null;
                        Object var17_74 = null;
                        for (Map.Entry<Integer, BasicBlock> entry : this.implicitAnalysisblocks.entrySet()) {
                            BasicBlock b = entry.getValue();
                            Integer i = entry.getKey();
                            if (b.insn == t.handler) {
                                handlerBlock = b;
                            }
                            if (b.insn == t.start) {
                                BasicBlock basicBlock = b;
                                startKey = i;
                            }
                            if (b.insn == t.end) {
                                endBlock = b;
                                Integer n = i;
                            }
                            if (var13_31 == null || handlerBlock == null || endBlock == null) continue;
                            break;
                        }
                        if (var13_31 == handlerBlock || endBlock == null) continue;
                        if (var13_31 != null && endBlock != null) {
                            void var17_75;
                            void var18_100;
                            int n = startKey;
                            while (var18_100 <= var17_75.intValue()) {
                                if (this.implicitAnalysisblocks.get((int)var18_100) != null) {
                                    this.implicitAnalysisblocks.get((Object)Integer.valueOf((int)var18_100)).coveredByTryBlockFor.add(t.type);
                                }
                                ++var18_100;
                            }
                        }
                        handlerBlock.exceptionsHandled.add(t.type);
                        tryCatchHandlers.add(handlerBlock);
                        var13_31.isTryBlockStart = true;
                        var13_31.exceptionsHandled.add(t.type);
                        handlerBlock.onFalseSideOfJumpFrom.add((BasicBlock)var13_31);
                        handlerBlock.handlerForRegionStartingAt.add((BasicBlock)var13_31);
                        var13_31.successors.add(handlerBlock);
                        var13_31.ex_count = exceptionHandlerCount++;
                        var13_31.tryBlockEnd = endBlock;
                        var13_31.handledAt = handlerBlock;
                        for (BasicBlock basicBlock : var13_31.successors) {
                            if (basicBlock.onFalseSideOfJumpFrom.contains(var13_31)) continue;
                            basicBlock.onTrueSideOfJumpFrom.add((BasicBlock)var13_31);
                        }
                    }
                }
                for (BasicBlock b : this.implicitAnalysisblocks.values()) {
                    if (!b.isJump) continue;
                    hasJumps = true;
                    break;
                }
                if (this.implicitAnalysisblocks.size() > 1 && hasJumps) {
                    void var13_50;
                    HashSet<BasicBlock> visited;
                    Stack<BasicBlock> stack = new Stack<BasicBlock>();
                    boolean changed = true;
                    while (changed) {
                        changed = false;
                        for (BasicBlock b : this.implicitAnalysisblocks.values()) {
                            for (BasicBlock s : b.successors) {
                                if (s.isInteresting()) {
                                    changed |= b.successorsCompact.add(s);
                                    continue;
                                }
                                changed |= b.successorsCompact.addAll(s.successorsCompact);
                            }
                        }
                    }
                    HashSet<BasicBlock> interestingBlocks = new HashSet<BasicBlock>();
                    for (BasicBlock basicBlock : this.implicitAnalysisblocks.values()) {
                        if (!basicBlock.isInteresting()) continue;
                        interestingBlocks.add(basicBlock);
                    }
                    for (BasicBlock basicBlock : this.implicitAnalysisblocks.values()) {
                        if (basicBlock.successorsCompact.size() == 0) {
                            basicBlock.postDominators.add(basicBlock);
                            continue;
                        }
                        basicBlock.postDominators.addAll(interestingBlocks);
                    }
                    changed = true;
                    while (changed) {
                        changed = false;
                        for (BasicBlock basicBlock : this.implicitAnalysisblocks.values()) {
                            if (basicBlock.successorsCompact.size() <= 0 || !basicBlock.isInteresting()) continue;
                            HashSet<BasicBlock> intersectionOfPredecessors = new HashSet<BasicBlock>();
                            Iterator<BasicBlock> iter = basicBlock.successorsCompact.iterator();
                            BasicBlock successor = iter.next();
                            intersectionOfPredecessors.addAll(successor.postDominators);
                            while (iter.hasNext()) {
                                successor = iter.next();
                                intersectionOfPredecessors.retainAll(successor.postDominators);
                            }
                            intersectionOfPredecessors.add(basicBlock);
                            if (basicBlock.postDominators.equals(intersectionOfPredecessors)) continue;
                            changed = true;
                            basicBlock.postDominators = intersectionOfPredecessors;
                        }
                    }
                    for (BasicBlock basicBlock : this.implicitAnalysisblocks.values()) {
                        if (!basicBlock.isJump && !basicBlock.isTryBlockStart) continue;
                        basicBlock.postDominators.remove(basicBlock);
                        visited = new HashSet<BasicBlock>();
                        BasicBlock min = PrimitiveArrayAnalyzer.this.findImmediatePostDominator(basicBlock, visited);
                        if (min != null) {
                            min.resolvedBlocks.add(basicBlock);
                            min.resolvedHereBlocks.add(basicBlock);
                            continue;
                        }
                        for (BasicBlock basicBlock2 : visited) {
                            if (!PrimitiveArrayAnalyzer.this.isExitInstruction(basicBlock2.insn)) continue;
                            basicBlock2.resolvedHereBlocks.add(basicBlock);
                        }
                    }
                    stack.add(this.implicitAnalysisblocks.get(0));
                    while (!stack.isEmpty()) {
                        Iterator<BasicBlock> b = (BasicBlock)stack.pop();
                        if (((BasicBlock)((Object)b)).visited) continue;
                        ((BasicBlock)((Object)b)).visited = true;
                        ((BasicBlock)((Object)b)).onFalseSideOfJumpFrom.removeAll(((BasicBlock)((Object)b)).resolvedBlocks);
                        ((BasicBlock)((Object)b)).onTrueSideOfJumpFrom.removeAll(((BasicBlock)((Object)b)).resolvedBlocks);
                        for (BasicBlock s : ((BasicBlock)((Object)b)).successors) {
                            boolean _changed = false;
                            _changed |= s.onFalseSideOfJumpFrom.addAll(((BasicBlock)((Object)b)).onFalseSideOfJumpFrom);
                            _changed |= s.onTrueSideOfJumpFrom.addAll(((BasicBlock)((Object)b)).onTrueSideOfJumpFrom);
                            _changed |= s.resolvedBlocks.addAll(((BasicBlock)((Object)b)).resolvedBlocks);
                            s.onFalseSideOfJumpFrom.remove(s);
                            s.onTrueSideOfJumpFrom.remove(s);
                            stack.add(s);
                        }
                    }
                    for (BasicBlock basicBlock : this.implicitAnalysisblocks.values()) {
                        basicBlock.visited = false;
                    }
                    for (BasicBlock basicBlock : this.implicitAnalysisblocks.values()) {
                        if (!basicBlock.isJump && !basicBlock.isTryBlockStart) continue;
                        stack = new Stack();
                        stack.addAll(basicBlock.successors);
                        visited = new HashSet();
                        while (!stack.isEmpty()) {
                            BasicBlock b = (BasicBlock)stack.pop();
                            if (!visited.add(b)) continue;
                            if (b.onTrueSideOfJumpFrom.contains(basicBlock)) {
                                basicBlock.varsWrittenTrueSide.addAll(b.varsWritten);
                                basicBlock.fieldsWrittenTrueSide.addAll(b.fieldsWritten);
                                basicBlock.exceptionsThrownTrueSide.addAll(b.exceptionsThrown);
                                stack.addAll(b.successors);
                                continue;
                            }
                            if (!b.onFalseSideOfJumpFrom.contains(basicBlock)) continue;
                            basicBlock.varsWrittenFalseSide.addAll(b.varsWritten);
                            basicBlock.fieldsWrittenFalseSide.addAll(b.fieldsWritten);
                            basicBlock.exceptionsThrownFalseSide.addAll(b.exceptionsThrown);
                            stack.addAll(b.successors);
                        }
                    }
                    HashMap<BasicBlock, Integer> jumpIDs = new HashMap<BasicBlock, Integer>();
                    boolean bl = false;
                    for (BasicBlock r : this.implicitAnalysisblocks.values()) {
                        if (r.isTryBlockStart) {
                            void var19_121;
                            LinkedList<BasicBlock> handlerEndBlock = new LinkedList<BasicBlock>();
                            LinkedList<BasicBlock> linkedList = new LinkedList<BasicBlock>(r.handledAt.successors);
                            HashSet<BasicBlock> hashSet = new HashSet<BasicBlock>();
                            while (!linkedList.isEmpty()) {
                                BasicBlock basicBlock = linkedList.pop();
                                if (!hashSet.add(basicBlock)) continue;
                                if (basicBlock.successors.size() == 0) {
                                    handlerEndBlock.add(basicBlock);
                                    continue;
                                }
                                if (r.postDominators.contains(basicBlock)) {
                                    handlerEndBlock.add(basicBlock);
                                    continue;
                                }
                                linkedList.addAll(basicBlock.successors);
                            }
                            AbstractInsnNode abstractInsnNode = r.tryBlockEnd.insn;
                            while (var19_121.getType() == 14 || var19_121.getType() == 15 || var19_121.getType() == 8) {
                                AbstractInsnNode abstractInsnNode3 = var19_121.getNext();
                            }
                            HashSet<LVAccess> lvsOnlyInHandler = new HashSet<LVAccess>(r.varsWrittenFalseSide);
                            lvsOnlyInHandler.removeAll(r.varsWrittenTrueSide);
                            HashSet<Field> fieldsOnlyInHandler = new HashSet<Field>(r.fieldsWrittenFalseSide);
                            fieldsOnlyInHandler.removeAll(r.fieldsWrittenTrueSide);
                            for (LVAccess i : lvsOnlyInHandler) {
                                this.instructions.insertBefore((AbstractInsnNode)var19_121, i.getNewForceCtrlStoreNode());
                            }
                            for (Field f : fieldsOnlyInHandler) {
                                this.instructions.insertBefore((AbstractInsnNode)var19_121, new FieldInsnNode(f.isStatic ? 217 : 216, f.owner, f.name, f.description));
                            }
                            AbstractInsnNode handledAtInsn = r.handledAt.insn;
                            HashSet<String> handledHereAlready = new HashSet<String>();
                            HashSet<Integer> forceStoreAlready = new HashSet<Integer>();
                            while (handledAtInsn.getType() == 14 || handledAtInsn.getType() == 15 || handledAtInsn.getType() == 8 || handledAtInsn.getOpcode() > 200) {
                                if (handledAtInsn.getOpcode() == 205) {
                                    TypeInsnNode tin = (TypeInsnNode)handledAtInsn;
                                    if (tin.desc != null) {
                                        handledHereAlready.add(tin.desc);
                                    }
                                } else if (handledAtInsn.getOpcode() == 216 && handledAtInsn.getType() == 2) {
                                    VarInsnNode vn = (VarInsnNode)handledAtInsn;
                                    forceStoreAlready.add(vn.var);
                                }
                                handledAtInsn = handledAtInsn.getNext();
                            }
                            HashSet<LVAccess> diff = new HashSet<LVAccess>();
                            diff.addAll(r.varsWrittenTrueSide);
                            diff.removeAll(r.varsWrittenFalseSide);
                            HashSet<Field> diffFields = new HashSet<Field>();
                            diffFields.addAll(r.fieldsWrittenTrueSide);
                            diffFields.removeAll(r.fieldsWrittenFalseSide);
                            for (LVAccess lVAccess : diff) {
                                if (forceStoreAlready.contains(lVAccess.idx)) continue;
                                this.instructions.insertBefore(handledAtInsn, lVAccess.getNewForceCtrlStoreNode());
                            }
                            for (Field field : diffFields) {
                                this.instructions.insertBefore(handledAtInsn, new FieldInsnNode(field.isStatic ? 217 : 216, field.owner, field.name, field.description));
                            }
                            if (handledHereAlready.size() == 0) {
                                this.instructions.insertBefore(handledAtInsn, new TypeInsnNode(205, null));
                            }
                            for (String string : r.exceptionsHandled) {
                                void var28_147;
                                if (string == null) {
                                    String string2 = "java/lang/Throwable";
                                }
                                if (!handledHereAlready.contains(var28_147)) {
                                    this.instructions.insertBefore(handledAtInsn, new TypeInsnNode(205, (String)var28_147));
                                }
                                this.instructions.insertBefore((AbstractInsnNode)var19_121, new TypeInsnNode(206, (String)var28_147));
                            }
                            for (BasicBlock basicBlock : handlerEndBlock) {
                                AbstractInsnNode insn;
                                for (insn = basicBlock.insn; insn != null && insn.getPrevious() != null && PrimitiveArrayAnalyzer.this.mightEndBlock(insn.getPrevious()); insn = insn.getPrevious()) {
                                }
                                if (insn.getType() == 8 || insn.getType() == 15 || insn.getType() == 14) {
                                    insn = basicBlock.insn;
                                }
                                this.instructions.insertBefore(insn, new TypeInsnNode(206, null));
                            }
                            continue;
                        }
                        if (r.isJump) {
                            ++var13_50;
                            HashSet<LVAccess> common = new HashSet<LVAccess>();
                            common.addAll(r.varsWrittenFalseSide);
                            common.retainAll(r.varsWrittenTrueSide);
                            HashSet<LVAccess> hashSet = new HashSet<LVAccess>();
                            hashSet.addAll(r.varsWrittenTrueSide);
                            hashSet.addAll(r.varsWrittenFalseSide);
                            hashSet.removeAll(common);
                            HashSet<Field> hashSet2 = new HashSet<Field>();
                            hashSet2.addAll(r.fieldsWrittenTrueSide);
                            hashSet2.retainAll(r.fieldsWrittenFalseSide);
                            HashSet<Field> hashSet3 = new HashSet<Field>();
                            hashSet3.addAll(r.fieldsWrittenFalseSide);
                            hashSet3.addAll(r.fieldsWrittenTrueSide);
                            hashSet3.removeAll(common);
                            HashSet<String> commonExceptionsThrown = new HashSet<String>();
                            commonExceptionsThrown.addAll(r.exceptionsThrownFalseSide);
                            commonExceptionsThrown.retainAll(r.exceptionsThrownTrueSide);
                            HashSet<String> diffExceptions = new HashSet<String>();
                            diffExceptions.addAll(r.exceptionsThrownTrueSide);
                            diffExceptions.addAll(r.exceptionsThrownFalseSide);
                            diffExceptions.removeAll(commonExceptionsThrown);
                            this.instructions.insertBefore(r.insn, new VarInsnNode(214, (int)var13_50));
                            jumpIDs.put(r, (int)var13_50);
                            if (r.is2ArgJump) {
                                ++var13_50;
                            }
                            for (LVAccess i : hashSet) {
                                this.instructions.insertBefore(r.insn, i.getNewForceCtrlStoreNode());
                            }
                            for (Field f : hashSet3) {
                                this.instructions.insertBefore(r.insn, new FieldInsnNode(f.isStatic ? 217 : 216, f.owner, f.name, f.description));
                            }
                            continue;
                        }
                        if (this.shouldTrackExceptions && r.insn.getOpcode() >= 172 && r.insn.getOpcode() <= 177) {
                            HashSet missedExceptions = new HashSet();
                            for (BasicBlock basicBlock : r.onFalseSideOfJumpFrom) {
                                HashSet<String> hashSet = new HashSet<String>(basicBlock.exceptionsThrownTrueSide);
                                hashSet.removeAll(basicBlock.exceptionsThrownFalseSide);
                                missedExceptions.addAll(hashSet);
                            }
                            for (BasicBlock basicBlock : r.onTrueSideOfJumpFrom) {
                                HashSet<String> hashSet = new HashSet<String>(basicBlock.exceptionsThrownFalseSide);
                                hashSet.removeAll(basicBlock.exceptionsThrownTrueSide);
                                missedExceptions.addAll(hashSet);
                            }
                            HashSet<void> hashSet = new HashSet<void>();
                            Iterator iterator = missedExceptions.iterator();
                            while (iterator.hasNext()) {
                                void var19_130;
                                void var19_128;
                                String string = (String)iterator.next();
                                if (string == null) {
                                    String string3 = "java/lang/Throwable";
                                }
                                if (var19_128.contains("#")) {
                                    String string4 = var19_128.substring(0, var19_128.indexOf(35));
                                }
                                if (!hashSet.add(var19_130)) continue;
                                this.instructions.insertBefore(r.insn, new TypeInsnNode(215, (String)var19_130));
                            }
                            continue;
                        }
                        if (!this.shouldTrackExceptions || r.insn.getType() != 5 && r.insn.getType() != 6) continue;
                        for (String string : r.coveredByTryBlockFor) {
                            void var17_87;
                            if (string == null) {
                                String string5 = "java/lang/Throwable";
                            }
                            this.instructions.insert(r.insn, new TypeInsnNode(214, (String)var17_87));
                        }
                    }
                    for (BasicBlock b : this.implicitAnalysisblocks.values()) {
                        AbstractInsnNode insn = b.insn;
                        while (insn.getType() == 14 || insn.getType() == 15 || insn.getType() == 8) {
                            insn = insn.getNext();
                        }
                        if (b.resolvedHereBlocks.size() == jumpIDs.size()) {
                            this.instructions.insertBefore(insn, new VarInsnNode(215, -1));
                        } else {
                            for (BasicBlock basicBlock : b.resolvedHereBlocks) {
                                if (basicBlock.isTryBlockStart || b.successors.size() <= 0) continue;
                                this.instructions.insertBefore(insn, new VarInsnNode(215, (Integer)jumpIDs.get(basicBlock)));
                                if (!basicBlock.is2ArgJump) continue;
                                this.instructions.insertBefore(insn, new VarInsnNode(215, (Integer)jumpIDs.get(basicBlock) + 1));
                            }
                        }
                        if (b.resolvedHereBlocks.size() > 0) {
                            insn = b.insn;
                            while (insn.getType() == 14 || insn.getType() == 15 || insn.getType() == 8 || insn.getOpcode() > 200) {
                                insn = insn.getNext();
                            }
                            if (insn.getOpcode() == 187) {
                                void var17_94;
                                void var17_91;
                                AbstractInsnNode abstractInsnNode = insn;
                                while (var17_91 != null && var17_91.getType() != 8) {
                                    AbstractInsnNode abstractInsnNode4 = var17_91.getPrevious();
                                }
                                LinkedList<LabelNode> linkedList = new LinkedList<LabelNode>();
                                linkedList.add((LabelNode)var17_91);
                                if (var17_91.getPrevious() != null && var17_91.getPrevious().getType() == 8) {
                                    linkedList.add((LabelNode)var17_91.getPrevious());
                                }
                                LabelNode labelNode = new LabelNode(new Label());
                                this.instructions.insertBefore(insn, labelNode);
                                AbstractInsnNode abstractInsnNode5 = this.instructions.getFirst();
                                while (var17_94 != null) {
                                    if (var17_94 instanceof FrameNode) {
                                        FrameNode fr = (FrameNode)var17_94;
                                        for (int j = 0; j < fr.stack.size(); ++j) {
                                            if (!linkedList.contains(fr.stack.get(j))) continue;
                                            fr.stack.set(j, labelNode.getLabel());
                                        }
                                    }
                                    AbstractInsnNode abstractInsnNode6 = var17_94.getNext();
                                }
                            }
                        }
                        if (!b.successors.isEmpty() || PrimitiveArrayAnalyzer.this.isImplicitLightTracking) continue;
                        this.instructions.insertBefore(b.insn, new InsnNode(216));
                        this.instructions.insertBefore(b.insn, new VarInsnNode(215, -1));
                    }
                    PrimitiveArrayAnalyzer.this.nJumps = var13_50;
                }
            }
            this.maxStack += 100;
            for (AbstractInsnNode insn = this.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                AbstractInsnNode insertBefore;
                if (insn.getType() != 14) continue;
                for (insertBefore = insn; insertBefore != null && (insertBefore.getType() == 14 || insertBefore.getType() == 15 || insertBefore.getType() == 8); insertBefore = insertBefore.getPrevious()) {
                }
                if (insertBefore == null) continue;
                this.instructions.insertBefore(insertBefore, new InsnNode(217));
            }
            this.accept(this.cmv);
        }
    }
}

