/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.psl.phosphor.instrumenter;

import edu.columbia.cs.psl.phosphor.Configuration;
import edu.columbia.cs.psl.phosphor.instrumenter.analyzer.TaggedValue;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.Label;
import edu.columbia.cs.psl.phosphor.org.objectweb.asm.util.Textifier;

public class PhosphorTextifier
extends Textifier {
    static String[] MORE_OPCODES = new String[25];
    static String[] TYPE_OR_INT_OPCODES;

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (opcode > 200) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append(this.tab2).append(TYPE_OR_INT_OPCODES[opcode - 200]).append(' ');
            this.appendDescriptor(0, owner);
            this.stringBuilder.append('.').append(name).append(" : ");
            this.appendDescriptor(1, desc);
            this.stringBuilder.append('\n');
            this.text.add(this.stringBuilder.toString());
        } else {
            super.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public PhosphorTextifier() {
        super(Configuration.ASM_VERSION);
    }

    @Override
    protected Textifier createTextifier() {
        return new PhosphorTextifier();
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        if (opcode > 200) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append(this.tab2).append(MORE_OPCODES[opcode - 200]).append(' ').append(var).append('\n');
            this.text.add(this.stringBuilder.toString());
        } else {
            super.visitVarInsn(opcode, var);
        }
    }

    @Override
    public void visitInsn(int opcode) {
        if (opcode > 200) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append(this.tab2).append(MORE_OPCODES[opcode - 200]).append('\n');
            this.text.add(this.stringBuilder.toString());
        } else {
            super.visitInsn(opcode);
        }
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.stringBuilder.append("FRAME ");
        switch (type) {
            case -1: 
            case 0: {
                this.stringBuilder.append("FULL [");
                this.appendFrameTypes(nLocal, local);
                this.stringBuilder.append("] [");
                this.appendFrameTypes(nStack, stack);
                this.stringBuilder.append(']');
                break;
            }
            case 1: {
                this.stringBuilder.append("APPEND [");
                this.appendFrameTypes(nLocal, local);
                this.stringBuilder.append(']');
                break;
            }
            case 2: {
                this.stringBuilder.append("CHOP ").append(nLocal);
                break;
            }
            case 3: {
                this.stringBuilder.append("SAME");
                break;
            }
            case 4: {
                this.stringBuilder.append("SAME1 ");
                this.appendFrameTypes(1, stack);
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    private void appendFrameTypes(int n, Object[] o) {
        for (int i = 0; i < n; ++i) {
            String desc;
            if (i > 0) {
                this.stringBuilder.append(' ');
            }
            if (o[i] instanceof TaggedValue) {
                this.stringBuilder.append("TAGGED");
                if (((TaggedValue)o[i]).v instanceof String) {
                    desc = (String)((TaggedValue)o[i]).v;
                    if (desc.startsWith("[")) {
                        this.appendDescriptor(1, desc);
                        continue;
                    }
                    this.appendDescriptor(0, desc);
                    continue;
                }
                switch ((Integer)((TaggedValue)o[i]).v) {
                    case 0: {
                        this.appendDescriptor(1, "T");
                        break;
                    }
                    case 1: {
                        this.appendDescriptor(1, "I");
                        break;
                    }
                    case 2: {
                        this.appendDescriptor(1, "F");
                        break;
                    }
                    case 3: {
                        this.appendDescriptor(1, "D");
                        break;
                    }
                    case 4: {
                        this.appendDescriptor(1, "J");
                        break;
                    }
                    case 5: {
                        this.appendDescriptor(1, "N");
                        break;
                    }
                    case 6: {
                        this.appendDescriptor(1, "U");
                    }
                }
                continue;
            }
            if (o[i] instanceof String) {
                desc = (String)o[i];
                if (desc.startsWith("[")) {
                    this.appendDescriptor(1, desc);
                    continue;
                }
                this.appendDescriptor(0, desc);
                continue;
            }
            if (o[i] instanceof Integer) {
                switch ((Integer)o[i]) {
                    case 0: {
                        this.appendDescriptor(1, "T");
                        break;
                    }
                    case 1: {
                        this.appendDescriptor(1, "I");
                        break;
                    }
                    case 2: {
                        this.appendDescriptor(1, "F");
                        break;
                    }
                    case 3: {
                        this.appendDescriptor(1, "D");
                        break;
                    }
                    case 4: {
                        this.appendDescriptor(1, "J");
                        break;
                    }
                    case 5: {
                        this.appendDescriptor(1, "N");
                        break;
                    }
                    case 6: {
                        this.appendDescriptor(1, "U");
                    }
                }
                continue;
            }
            this.appendLabel((Label)o[i]);
        }
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        if (opcode > 200) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append(this.tab2).append(TYPE_OR_INT_OPCODES[opcode - 200]).append(' ').append(opcode == 188 ? TYPES[operand] : Integer.toString(operand)).append('\n');
            this.text.add(this.stringBuilder.toString());
        } else {
            super.visitIntInsn(opcode, operand);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        if (opcode > 200) {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append(this.tab2).append(TYPE_OR_INT_OPCODES[opcode - 200]).append(' ');
            this.appendDescriptor(0, type);
            this.stringBuilder.append('\n');
            this.text.add(this.stringBuilder.toString());
        } else {
            super.visitTypeInsn(opcode, type);
        }
    }

    static {
        PhosphorTextifier.MORE_OPCODES[1] = "RAW_INSN";
        PhosphorTextifier.MORE_OPCODES[2] = "NOSTORE";
        PhosphorTextifier.MORE_OPCODES[3] = "IGNORE";
        PhosphorTextifier.MORE_OPCODES[4] = "NEXT_FORCE_TAINT";
        PhosphorTextifier.MORE_OPCODES[5] = "DUP_TAINT_TO_0";
        PhosphorTextifier.MORE_OPCODES[6] = "DUP_TAINT_TO_1";
        PhosphorTextifier.MORE_OPCODES[7] = "DUP_TAINT_TO_2";
        PhosphorTextifier.MORE_OPCODES[8] = "DUP_TAINT_TO_3";
        PhosphorTextifier.MORE_OPCODES[9] = "NO AUTOBOX";
        PhosphorTextifier.MORE_OPCODES[10] = "AUTOBOX";
        PhosphorTextifier.MORE_OPCODES[11] = "BOX_JMP";
        PhosphorTextifier.MORE_OPCODES[12] = "UNBOX_JMP";
        PhosphorTextifier.MORE_OPCODES[13] = "IS_TMP_STORE";
        PhosphorTextifier.MORE_OPCODES[14] = "BRANCH_START";
        PhosphorTextifier.MORE_OPCODES[15] = "BRANCH_END";
        PhosphorTextifier.MORE_OPCODES[16] = "FORCE_CTRL_STORE";
        PhosphorTextifier.MORE_OPCODES[17] = "FOLLOWED_BY_FRAME";
        PhosphorTextifier.MORE_OPCODES[21] = "LOOP_HEADER";
        TYPE_OR_INT_OPCODES = new String[25];
        System.arraycopy(MORE_OPCODES, 0, TYPE_OR_INT_OPCODES, 0, 25);
        PhosphorTextifier.TYPE_OR_INT_OPCODES[6] = "EXCEPTION_HANDLER_END";
        PhosphorTextifier.TYPE_OR_INT_OPCODES[5] = "EXCEPTION_HANDLER_START";
        PhosphorTextifier.TYPE_OR_INT_OPCODES[15] = "UNTHROWN_EXCEPTION";
        PhosphorTextifier.TYPE_OR_INT_OPCODES[14] = "UNTHROWN_EXCEPTION_CHECK";
        PhosphorTextifier.TYPE_OR_INT_OPCODES[17] = "FORCE_CTRL_STORE_SFIELD";
    }
}

